/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.io.Closeable;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;

public interface MorphiumDriver
extends Closeable {
    public String getName();

    public int getIdleSleepTime();

    public void setIdleSleepTime(int var1);

    public int getMaxBsonObjectSize();

    public void setMaxBsonObjectSize(int var1);

    public int getMaxMessageSize();

    public void setMaxMessageSize(int var1);

    public int getMaxWriteBatchSize();

    public void setMaxWriteBatchSize(int var1);

    public boolean isReplicaSet();

    public void setReplicaSet(boolean var1);

    public boolean getDefaultJ();

    public int getDefaultWriteTimeout();

    public void setDefaultWriteTimeout(int var1);

    public int getMaxWaitTime();

    public void setMaxWaitTime(int var1);

    public String[] getCredentials(String var1);

    public List<String> getHostSeed();

    public void setHostSeed(List<String> var1);

    public void setHostSeed(String ... var1);

    public void setConnectionUrl(String var1) throws MalformedURLException;

    public void connect() throws MorphiumDriverException;

    public void connect(String var1) throws MorphiumDriverException;

    public boolean isConnected();

    public boolean isReplicaset();

    public <T, R> Aggregator<T, R> createAggregator(Morphium var1, Class<? extends T> var2, Class<? extends R> var3);

    public List<String> listDatabases() throws MorphiumDriverException;

    public List<String> listCollections(String var1, String var2) throws MorphiumDriverException;

    public String getReplicaSetName();

    public void setReplicaSetName(String var1);

    public int getRetriesOnNetworkError();

    public MorphiumDriver setRetriesOnNetworkError(int var1);

    public int getSleepBetweenErrorRetries();

    public MorphiumDriver setSleepBetweenErrorRetries(int var1);

    public int getMaxConnections();

    public MorphiumDriver setMaxConnections(int var1);

    public int getMinConnections();

    public MorphiumDriver setMinConnections(int var1);

    public boolean isRetryReads();

    public MorphiumDriver setRetryReads(boolean var1);

    public boolean isRetryWrites();

    public MorphiumDriver setRetryWrites(boolean var1);

    public int getReadTimeout();

    public void setReadTimeout(int var1);

    public int getMinConnectionsPerHost();

    public void setMinConnectionsPerHost(int var1);

    public int getMaxConnectionsPerHost();

    public void setMaxConnectionsPerHost(int var1);

    public void setCredentials(String var1, String var2, String var3);

    public boolean isCapped(String var1, String var2) throws MorphiumDriverException;

    public Map<String, Integer> getNumConnectionsByHost();

    public MorphiumTransactionContext startTransaction(boolean var1);

    public boolean isTransactionInProgress();

    public void commitTransaction() throws MorphiumDriverException;

    public MorphiumTransactionContext getTransactionContext();

    public void setTransactionContext(MorphiumTransactionContext var1);

    public void abortTransaction() throws MorphiumDriverException;

    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException;

    public Map<String, Object> getDBStats(String var1) throws MorphiumDriverException;

    public Map<String, Object> getCollStats(String var1, String var2) throws MorphiumDriverException;

    public int getMaxConnectionLifetime();

    public void setMaxConnectionLifetime(int var1);

    public int getMaxConnectionIdleTime();

    public void setMaxConnectionIdleTime(int var1);

    public int getConnectionTimeout();

    public void setConnectionTimeout(int var1);

    public int getDefaultW();

    public void setDefaultW(int var1);

    public int getHeartbeatFrequency();

    public void setHeartbeatFrequency(int var1);

    public ReadPreference getDefaultReadPreference();

    public void setDefaultReadPreference(ReadPreference var1);

    public int getDefaultBatchSize();

    public void setDefaultBatchSize(int var1);

    public boolean isUseSSL();

    public void setUseSSL(boolean var1);

    public boolean isDefaultJ();

    public void setDefaultJ(boolean var1);

    public void watch(WatchCommand var1) throws MorphiumDriverException;

    public MongoConnection getReadConnection(ReadPreference var1);

    public MongoConnection getPrimaryConnection(WriteConcern var1) throws MorphiumDriverException;

    public void releaseConnection(MongoConnection var1);

    public void closeConnection(MongoConnection var1);

    public boolean exists(String var1, String var2) throws MorphiumDriverException;

    public boolean exists(String var1) throws MorphiumDriverException;

    public BulkRequestContext createBulkContext(Morphium var1, String var2, String var3, boolean var4, WriteConcern var5);

    public Map<DriverStatsKey, Double> getDriverStats();

    public static enum DriverStatsKey {
        CONNECTIONS_OPENED,
        CONNECTIONS_CLOSED,
        CONNECTIONS_BORROWED,
        CONNECTIONS_RELEASED,
        CONNECTIONS_IN_POOL,
        ERRORS,
        FAILOVERS,
        MSG_SENT,
        REPLY_PROCESSED,
        REPLY_IN_MEM,
        REPLY_RECEIVED,
        THREADS_CREATED,
        CONNECTIONS_IN_USE;

    }
}

