/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.changestream;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.changestream.ChangeStreamEvent;
import de.caluga.morphium.changestream.ChangeStreamListener;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.driver.wire.ConnectionType;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.SingleMongoConnectDriver;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeStreamMonitor
implements Runnable,
ShutdownListener {
    private final Collection<ChangeStreamListener> listeners;
    private final Morphium morphium;
    private final Logger log;
    private final String collectionName;
    private final boolean fullDocument;
    private final int maxWait;
    private volatile boolean running;
    private Thread changeStreamThread;
    private final MorphiumObjectMapper mapper;
    private boolean dbOnly;
    private final List<Map<String, Object>> pipeline;
    private MorphiumDriver dedicatedConnection;

    public ChangeStreamMonitor(Morphium m) {
        this(m, null, false, null);
        this.dbOnly = true;
    }

    public ChangeStreamMonitor(Morphium m, List<Map<String, Object>> pipeline) {
        this(m, null, false, pipeline);
        this.dbOnly = true;
    }

    public ChangeStreamMonitor(Morphium m, Class<?> entity) {
        this(m, m.getMapper().getCollectionName(entity), false, null);
    }

    public ChangeStreamMonitor(Morphium m, Class<?> entity, List<Map<String, Object>> pipeline) {
        this(m, m.getMapper().getCollectionName(entity), false, null);
    }

    public ChangeStreamMonitor(Morphium m, String collectionName, boolean fullDocument) {
        this(m, collectionName, fullDocument, null);
    }

    public ChangeStreamMonitor(Morphium m, String collectionName, boolean fullDocument, List<Map<String, Object>> pipeline) {
        this(m, collectionName, fullDocument, m.getConfig().getMaxWaitTime(), pipeline);
    }

    public ChangeStreamMonitor(Morphium m, String collectionName, boolean fullDocument, int maxWait, List<Map<String, Object>> pipeline) {
        block4: {
            this.log = LoggerFactory.getLogger(ChangeStreamMonitor.class);
            this.running = true;
            this.dbOnly = false;
            this.morphium = m;
            try {
                if (m.getDriver() instanceof InMemoryDriver) {
                    this.dedicatedConnection = m.getDriver();
                } else {
                    this.dedicatedConnection = new SingleMongoConnectDriver().setConnectionType(ConnectionType.PRIMARY);
                    this.dedicatedConnection.setDefaultBatchSize(this.morphium.getConfig().getCursorBatchSize());
                    this.dedicatedConnection.setMaxWaitTime(this.morphium.getConfig().getMaxWaitTime());
                    this.dedicatedConnection.setHostSeed(this.morphium.getConfig().getHostSeed());
                    this.dedicatedConnection.setMinConnections(1);
                    this.dedicatedConnection.setMaxConnections(3);
                    this.dedicatedConnection.setCredentials(this.morphium.getConfig().decryptAuthDb(), this.morphium.getConfig().decryptMongoLogin(), this.morphium.getConfig().decryptMongoPassword());
                    this.dedicatedConnection.connect();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                if (e.getMessage().contains("sleep interrupted")) break block4;
                throw new RuntimeException(e);
            }
        }
        this.listeners = new ConcurrentLinkedDeque<ChangeStreamListener>();
        this.morphium.addShutdownListener(this);
        this.pipeline = pipeline;
        this.collectionName = collectionName;
        this.fullDocument = fullDocument;
        this.maxWait = maxWait != 0 ? maxWait : m.getConfig().getMaxWaitTime();
        this.mapper = new ObjectMapperImpl();
        AnnotationAndReflectionHelper hlp = new AnnotationAndReflectionHelper(false);
        this.mapper.setAnnotationHelper(hlp);
    }

    public void addListener(ChangeStreamListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(ChangeStreamListener lst) {
        this.listeners.remove(lst);
    }

    public boolean isFullDocument() {
        return this.fullDocument;
    }

    public void start() {
        if (this.changeStreamThread != null) {
            throw new RuntimeException("Already running!");
        }
        this.changeStreamThread = new Thread(this);
        this.changeStreamThread.setDaemon(true);
        this.changeStreamThread.setName("changeStream");
        this.changeStreamThread.start();
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.running = false;
        try {
            long start = System.currentTimeMillis();
            try {
                this.dedicatedConnection.close();
            }
            catch (Exception e) {
                this.log.warn("Closing mongo connection error", (Object)e.getMessage());
            }
            this.dedicatedConnection = null;
            while (this.changeStreamThread != null && this.changeStreamThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start <= (long)this.morphium.getConfig().getReadTimeout()) continue;
                this.log.debug("Changestream monitor did not finish before max wait time is over! Interrupting");
                this.changeStreamThread.interrupt();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!this.changeStreamThread.isAlive()) break;
                try {
                    this.changeStreamThread.stop();
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                    break;
                }
            }
            this.changeStreamThread = null;
        }
        catch (Exception e1) {
            this.log.warn("Exception when closing changestreamMonitor", (Object)e1.getMessage());
        }
        finally {
            this.listeners.clear();
            this.morphium.removeShutdownListener(this);
        }
    }

    public String getcollectionName() {
        return this.collectionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MongoCommand watch = null;
        while (this.running) {
            try {
                DriverTailableIterationCallback callback = new DriverTailableIterationCallback(){

                    @Override
                    public void incomingData(Map<String, Object> data, long dur) {
                        if (!ChangeStreamMonitor.this.running) {
                            return;
                        }
                        Map obj = (Map)data.get("fullDocument");
                        data.remove("fullDocument");
                        if (data.get("documentKey") instanceof MorphiumId || data.get("documentKey") instanceof ObjectId) {
                            data.put("documentKey", Doc.of("_id", data.get("documentKey")));
                        }
                        ChangeStreamEvent evt = ChangeStreamMonitor.this.mapper.deserialize(ChangeStreamEvent.class, data);
                        evt.setFullDocument(obj);
                        ArrayList<ChangeStreamListener> toRemove = new ArrayList<ChangeStreamListener>();
                        for (ChangeStreamListener lst : ChangeStreamMonitor.this.listeners) {
                            try {
                                if (lst.incomingData(evt)) continue;
                                toRemove.add(lst);
                            }
                            catch (Exception e) {
                                ChangeStreamMonitor.this.log.error("listener threw exception", (Throwable)e);
                            }
                        }
                        ChangeStreamMonitor.this.listeners.removeAll(toRemove);
                    }

                    @Override
                    public boolean isContinued() {
                        return ChangeStreamMonitor.this.running;
                    }
                };
                if (this.dedicatedConnection == null) break;
                MongoConnection con = this.dedicatedConnection.getPrimaryConnection(null);
                watch = ((WatchCommand)new WatchCommand(con).setCb(callback).setDb(this.morphium.getDatabase())).setBatchSize(1).setMaxTimeMS(0).setFullDocument(this.fullDocument ? WatchCommand.FullDocumentEnum.updateLookup : WatchCommand.FullDocumentEnum.defaultValue).setPipeline(this.pipeline);
                if (!this.dbOnly) {
                    watch.setColl(this.collectionName);
                }
                ((WatchCommand)watch).watch();
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    this.log.warn("Restarting changestream", (Throwable)e);
                    continue;
                }
                if (e.getMessage().contains("Network error error: state should be: open")) {
                    this.log.warn("Changstream connection broke - restarting");
                    continue;
                }
                if (e.getMessage().contains("Did not receive OpMsg-Reply in time")) {
                    this.log.debug("changestream iteration");
                    continue;
                }
                if (e.getMessage().contains("closed")) {
                    this.log.error("connection closed!");
                    break;
                }
                this.log.warn("Error in changestream monitor - restarting", (Throwable)e);
            }
            finally {
                if (watch == null) continue;
                watch.releaseConnection();
            }
        }
        try {
            if (this.dedicatedConnection != null && !(this.dedicatedConnection instanceof InMemoryDriver)) {
                this.dedicatedConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log.debug("ChangeStreamMonitor finished gracefully!");
    }

    @Override
    public void onShutdown(Morphium m) {
        this.terminate();
    }
}

