/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.CollectionInfo;
import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.LazyDeReferencingProxy;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.NameProvider;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.ShutdownListener;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.StatisticValue;
import de.caluga.morphium.Statistics;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.Capped;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.annotations.lifecycle.PostLoad;
import de.caluga.morphium.annotations.lifecycle.PostRemove;
import de.caluga.morphium.annotations.lifecycle.PostStore;
import de.caluga.morphium.annotations.lifecycle.PostUpdate;
import de.caluga.morphium.annotations.lifecycle.PreRemove;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.annotations.lifecycle.PreUpdate;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.bulk.MorphiumBulkContext;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.MorphiumCacheImpl;
import de.caluga.morphium.changestream.ChangeStreamEvent;
import de.caluga.morphium.changestream.ChangeStreamListener;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.commands.CreateCommand;
import de.caluga.morphium.driver.commands.DistinctMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.ListDatabasesCommand;
import de.caluga.morphium.driver.commands.ListIndexesCommand;
import de.caluga.morphium.driver.commands.MapReduceCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.StoreMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.SingleMongoConnectDriver;
import de.caluga.morphium.encryption.EncryptionKeyProvider;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.messaging.Msg;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.QueryIterator;
import de.caluga.morphium.replicaset.RSMonitor;
import de.caluga.morphium.validation.JavaxValidationStorageListener;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Morphium
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Morphium.class);
    private final ThreadLocal<Boolean> enableAutoValues = new ThreadLocal();
    private final ThreadLocal<Boolean> enableReadCache = new ThreadLocal();
    private final ThreadLocal<Boolean> disableWriteBuffer = new ThreadLocal();
    private final ThreadLocal<Boolean> disableAsyncWrites = new ThreadLocal();
    private final List<ShutdownListener> shutDownListeners = new CopyOnWriteArrayList<ShutdownListener>();
    private MorphiumConfig config;
    private Map<StatisticKeys, StatisticValue> stats = new ConcurrentHashMap<StatisticKeys, StatisticValue>();
    private List<MorphiumStorageListener<?>> listeners = new CopyOnWriteArrayList();
    private AnnotationAndReflectionHelper annotationHelper;
    private MorphiumObjectMapper objectMapper;
    private EncryptionKeyProvider encryptionKeyProvider;
    private RSMonitor rsMonitor;
    private ThreadPoolExecutor asyncOperationsThreadPool;
    private MorphiumDriver morphiumDriver;
    private JavaxValidationStorageListener lst;
    private ValueEncryptionProvider valueEncryptionProvider;
    private String CREDENTIAL_ENCRYPT_KEY_NAME;

    public Morphium() {
    }

    public Morphium(String host, String db) {
        this();
        MorphiumConfig cfg = new MorphiumConfig(db, 100, 5000, 5000);
        cfg.addHostToSeed(host);
        this.setConfig(cfg);
    }

    public Morphium(String host, int port, String db) {
        this();
        MorphiumConfig cfg = new MorphiumConfig(db, 100, 5000, 5000);
        cfg.addHostToSeed(host, port);
        this.setConfig(cfg);
    }

    public Morphium(MorphiumConfig cfg) {
        this();
        this.setConfig(cfg);
    }

    public MorphiumConfig getConfig() {
        return this.config;
    }

    public void setConfig(MorphiumConfig cfg) {
        if (this.config != null) {
            throw new RuntimeException("Cannot change config!");
        }
        this.config = cfg;
        this.annotationHelper = new AnnotationAndReflectionHelper(cfg.isCamelCaseConversionEnabled());
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(){
            private static final long serialVersionUID = -6903933921423432194L;

            @Override
            public boolean offer(Runnable e) {
                int maximumPoolSize;
                int poolSize = Morphium.this.asyncOperationsThreadPool.getPoolSize();
                if (poolSize >= (maximumPoolSize = Morphium.this.asyncOperationsThreadPool.getMaximumPoolSize()) || poolSize > Morphium.this.asyncOperationsThreadPool.getActiveCount()) {
                    return super.offer(e);
                }
                return false;
            }
        };
        this.asyncOperationsThreadPool = new ThreadPoolExecutor(this.getConfig().getThreadPoolAsyncOpCoreSize(), this.getConfig().getThreadPoolAsyncOpMaxSize(), this.getConfig().getThreadPoolAsyncOpKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue);
        this.asyncOperationsThreadPool.setRejectedExecutionHandler((r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        this.asyncOperationsThreadPool.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread ret = new Thread(r, "asyncOp " + String.valueOf(this.num));
                this.num.set(this.num.get() + 1);
                ret.setDaemon(true);
                return ret;
            }
        });
        this.initializeAndConnect();
    }

    public ThreadPoolExecutor getAsyncOperationsThreadPool() {
        return this.asyncOperationsThreadPool;
    }

    private void initializeAndConnect() {
        Map<Class<?>, List<IndexDescription>> missing;
        if (this.config == null) {
            throw new RuntimeException("Please specify configuration!");
        }
        for (StatisticKeys k : StatisticKeys.values()) {
            this.stats.put(k, new StatisticValue());
        }
        if (this.morphiumDriver == null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    this.setName("shutdown_hook");
                    try {
                        Morphium.this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
                ClassInfoList entities = scanResult.getClassesImplementing(MorphiumDriver.class.getName());
                if (log.isDebugEnabled()) {
                    log.debug("Found " + entities.size() + " drivers in classpath");
                }
                if (this.config.getDriverName() == null) {
                    this.config.setDriverName("SingleMongoConnectDriver");
                    this.morphiumDriver = new SingleMongoConnectDriver();
                } else {
                    for (String cn : entities.getNames()) {
                        try {
                            MorphiumDriver drv;
                            Class<?> c = Class.forName(cn);
                            if (Modifier.isAbstract(c.getModifiers())) continue;
                            List<Field> flds = this.annotationHelper.getAllFields(c);
                            for (Field f : flds) {
                                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !f.getName().equals("driverName")) continue;
                                String dn = (String)f.get(c);
                                log.debug("Found driverName: " + dn);
                                if (!dn.equals(this.config.getDriverName())) break;
                                this.morphiumDriver = (MorphiumDriver)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                break;
                            }
                            if (this.morphiumDriver != null || !(drv = (MorphiumDriver)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getName().equals(this.config.getDriverName())) continue;
                            this.morphiumDriver = drv;
                            break;
                        }
                        catch (Throwable e) {
                            log.error("Could not load driver " + this.config.getDriverName(), e);
                        }
                    }
                }
                if (this.morphiumDriver == null) {
                    this.morphiumDriver = new SingleMongoConnectDriver();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.morphiumDriver.setConnectionTimeout(this.config.getConnectionTimeout());
            this.morphiumDriver.setMaxConnections(this.config.getMaxConnections());
            this.morphiumDriver.setMinConnections(this.config.getMinConnectionsHost());
            this.morphiumDriver.setReadTimeout(this.config.getReadTimeout());
            this.morphiumDriver.setRetryReads(this.config.isRetryReads());
            this.morphiumDriver.setRetryWrites(this.config.isRetryWrites());
            this.morphiumDriver.setHeartbeatFrequency(this.config.getHeartbeatFrequency());
            this.morphiumDriver.setMaxConnectionIdleTime(this.config.getMaxConnectionIdleTime());
            this.morphiumDriver.setMaxConnectionLifetime(this.config.getMaxConnectionLifeTime());
            this.morphiumDriver.setMaxWaitTime(this.config.getMaxWaitTime());
            this.morphiumDriver.setIdleSleepTime(this.config.getIdleSleepTime());
            this.morphiumDriver.setUseSSL(this.config.isUseSSL());
            if (this.config.getHostSeed().isEmpty() && !(this.morphiumDriver instanceof InMemoryDriver)) {
                throw new RuntimeException("Error - no server address specified!");
            }
            this.setValidationSupport();
            try {
                this.objectMapper = new ObjectMapperImpl();
                this.objectMapper.setMorphium(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.encryptionKeyProvider = this.config.getEncryptionKeyProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.config.getCredentialsEncryptionKey() != null) {
                    this.encryptionKeyProvider.setEncryptionKey(this.CREDENTIAL_ENCRYPT_KEY_NAME, this.config.getCredentialsEncryptionKey().getBytes(StandardCharsets.UTF_8));
                }
                if (this.config.getCredentialsDecryptionKey() != null) {
                    this.encryptionKeyProvider.setDecryptionKey(this.CREDENTIAL_ENCRYPT_KEY_NAME, this.config.getCredentialsDecryptionKey().getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                this.valueEncryptionProvider = this.config.getValueEncryptionProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.config.getMongoLogin() != null && this.config.getMongoPassword() != null) {
                if (this.config.getCredentialsEncrypted() != null && this.config.getCredentialsEncrypted().booleanValue()) {
                    byte[] key = this.getEncryptionKeyProvider().getDecryptionKey(this.CREDENTIAL_ENCRYPT_KEY_NAME);
                    this.valueEncryptionProvider.setEncryptionKey(this.getEncryptionKeyProvider().getEncryptionKey(this.CREDENTIAL_ENCRYPT_KEY_NAME));
                    this.valueEncryptionProvider.setDecryptionKey(this.getEncryptionKeyProvider().getDecryptionKey(this.CREDENTIAL_ENCRYPT_KEY_NAME));
                    if (key == null) {
                        throw new RuntimeException("Cannot decrypt - no key for mongodb_crendentials set!");
                    }
                    try {
                        String user = new String(this.getValueEncrpytionProvider().decrypt(Base64.getDecoder().decode(this.config.getMongoLogin())));
                        String passwd = new String(this.getValueEncrpytionProvider().decrypt(Base64.getDecoder().decode(this.config.getMongoPassword())));
                        String authdb = "admin";
                        if (this.config.getMongoAuthDb() != null) {
                            authdb = new String(this.getValueEncrpytionProvider().decrypt(Base64.getDecoder().decode(this.config.getMongoAuthDb())));
                        }
                        this.morphiumDriver.setCredentials(authdb, user, passwd);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Credential decryption failed", e);
                    }
                } else {
                    this.morphiumDriver.setCredentials(this.config.getMongoAuthDb(), this.config.getMongoLogin(), this.config.getMongoPassword());
                }
            }
            String[] seed = new String[this.config.getHostSeed().size()];
            for (int i = 0; i < seed.length; ++i) {
                seed[i] = this.config.getHostSeed().get(i);
            }
            this.morphiumDriver.setHostSeed(seed);
            try {
                this.morphiumDriver.connect(this.config.getRequiredReplicaSetName());
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.config.getWriter() == null) {
            this.config.setWriter(new MorphiumWriterImpl());
        }
        if (this.config.getBufferedWriter() == null) {
            this.config.setBufferedWriter(new BufferedMorphiumWriterImpl());
        }
        this.config.getWriter().setMorphium(this);
        this.config.getWriter().setMaximumQueingTries(this.config.getMaximumRetriesWriter());
        this.config.getWriter().setPauseBetweenTries(this.config.getRetryWaitTimeWriter());
        this.config.getBufferedWriter().setMorphium(this);
        this.config.getBufferedWriter().setMaximumQueingTries(this.config.getMaximumRetriesBufferedWriter());
        this.config.getBufferedWriter().setPauseBetweenTries(this.config.getRetryWaitTimeBufferedWriter());
        this.config.getAsyncWriter().setMorphium(this);
        this.config.getAsyncWriter().setMaximumQueingTries(this.config.getMaximumRetriesAsyncWriter());
        this.config.getAsyncWriter().setPauseBetweenTries(this.config.getRetryWaitTimeAsyncWriter());
        if (this.config.getCache() == null) {
            this.config.setCache(new MorphiumCacheImpl());
        }
        this.config.getCache().setAnnotationAndReflectionHelper(this.getARHelper());
        this.config.getCache().setGlobalCacheTimeout(this.config.getGlobalCacheValidTime());
        this.config.getCache().setHouskeepingIntervalPause(this.config.getHousekeepingTimeout());
        log.debug("Checking for capped collections...");
        Map<Class<?>, Map<String, Integer>> capped = this.checkCapped();
        if (capped != null && !capped.isEmpty()) {
            block40: for (Class<?> cls : capped.keySet()) {
                switch (this.config.getCappedCheck()) {
                    case WARN_ON_STARTUP: {
                        log.warn("Collection for entity " + cls.getName() + " is not capped although configured!");
                        break;
                    }
                    case CONVERT_EXISTING_ON_STARTUP: {
                        try {
                            if (!this.exists(this.getDatabase(), this.getMapper().getCollectionName(cls))) continue block40;
                            log.warn("Existing collection is not capped - ATTENTION!");
                            break;
                        }
                        catch (MorphiumDriverException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case CREATE_ON_STARTUP: {
                        try {
                            if (this.morphiumDriver.exists(this.getDatabase(), this.getMapper().getCollectionName(cls))) continue block40;
                            MongoConnection primaryConnection = null;
                            MongoCommand cmd = null;
                            try {
                                primaryConnection = this.morphiumDriver.getPrimaryConnection(null);
                                cmd = new CreateCommand(primaryConnection);
                                ((CreateCommand)((CreateCommand)cmd.setDb(this.getDatabase())).setColl(this.getMapper().getCollectionName(cls))).setCapped(true).setMax(capped.get(cls).get("max")).setSize(capped.get(cls).get("size"));
                                Map<String, Object> ret = ((CreateCommand)cmd).execute();
                                log.debug("Created capped collection");
                                continue block40;
                            }
                            catch (MorphiumDriverException e) {
                                throw new RuntimeException(e);
                            }
                            finally {
                                if (primaryConnection != null) {
                                    cmd.releaseConnection();
                                }
                                continue block40;
                            }
                        }
                        catch (MorphiumDriverException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case CREATE_ON_WRITE_NEW_COL: 
                    case NO_CHECK: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknow value for cappedcheck " + String.valueOf((Object)this.config.getCappedCheck()));
                    }
                }
            }
        }
        if (!this.config.getIndexCheck().equals((Object)MorphiumConfig.IndexCheck.NO_CHECK) && this.config.getIndexCheck().equals((Object)MorphiumConfig.IndexCheck.CREATE_ON_STARTUP) && (missing = this.checkIndices(classInfo -> !classInfo.getPackageName().startsWith("de.caluga.morphium"))) != null && !missing.isEmpty()) {
            for (Class<?> cls : missing.keySet()) {
                if (missing.get(cls).size() == 0 || Msg.class.isAssignableFrom(cls)) continue;
                try {
                    if (this.config.getIndexCheck().equals((Object)MorphiumConfig.IndexCheck.WARN_ON_STARTUP)) {
                        log.warn("Missing indices for entity " + cls.getName() + ": " + missing.get(cls).size());
                        continue;
                    }
                    if (!this.config.getIndexCheck().equals((Object)MorphiumConfig.IndexCheck.CREATE_ON_STARTUP)) continue;
                    log.warn("Creating missing indices for entity " + cls.getName());
                    this.ensureIndicesFor(cls);
                }
                catch (Exception e) {
                    log.error("Could not process indices for entity " + cls.getName(), (Throwable)e);
                }
            }
        }
        this.getCache().setValidCacheTime(CollectionInfo.class, 15000);
    }

    public ValueEncryptionProvider getValueEncrpytionProvider() {
        return this.valueEncryptionProvider;
    }

    public EncryptionKeyProvider getEncryptionKeyProvider() {
        return this.encryptionKeyProvider;
    }

    public MorphiumCache getCache() {
        return this.config.getCache();
    }

    public boolean isValidationEnabled() {
        return this.lst != null;
    }

    public void disableValidation() {
        if (this.lst == null) {
            return;
        }
        this.listeners.remove(this.lst);
        this.lst = null;
    }

    public void enableValidation() {
        this.setValidationSupport();
        if (this.lst == null) {
            throw new RuntimeException("Validation not possible - javax.validation implementation not in Classpath?");
        }
    }

    private void setValidationSupport() {
        if (this.lst != null) {
            if (!this.listeners.contains(this.lst)) {
                this.listeners.add(this.lst);
            }
            return;
        }
        try {
            this.getClass().getClassLoader().loadClass("javax.validation.ValidatorFactory");
            this.lst = new JavaxValidationStorageListener();
            this.addListener(this.lst);
            log.debug("Adding javax.validation Support...");
        }
        catch (Exception cnf) {
            log.debug("Validation disabled!");
        }
    }

    public List<String> listDatabases() {
        try {
            return this.getDriver().listDatabases();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException("Could not list databases", e);
        }
    }

    public List<String> listCollections() {
        return this.listCollections(null);
    }

    public List<String> listCollections(String pattern) {
        if (this.getCache().isCached(CollectionInfo.class, pattern)) {
            List<CollectionInfo> lst = this.getCache().getFromCache(CollectionInfo.class, pattern);
            ArrayList<String> ret = new ArrayList<String>();
            for (CollectionInfo n : lst) {
                ret.add(n.getName());
            }
            return ret;
        }
        try {
            List<String> result = this.getDriver().listCollections(this.getConfig().getDatabase(), pattern);
            ArrayList<CollectionInfo> lst = new ArrayList<CollectionInfo>();
            for (String r : result) {
                lst.add(new CollectionInfo().setName(r));
            }
            this.getCache().addToCache(pattern, CollectionInfo.class, lst);
            return result;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void reconnectToDb(String db) {
        Properties prop = this.getConfig().asProperties();
        String dec = this.getConfig().getCredentialsDecryptionKey();
        String enc = this.getConfig().getCredentialsEncryptionKey();
        this.close();
        MorphiumConfig cfg = new MorphiumConfig(prop);
        cfg.setCredentialsDecryptionKey(dec);
        cfg.setCredentialsEncryptionKey(enc);
        cfg.setDatabase(db);
        this.setConfig(cfg);
    }

    public void addListener(MorphiumStorageListener<?> lst) {
        ArrayList newList = new ArrayList(this.listeners);
        newList.add(lst);
        this.listeners = newList;
    }

    public void removeListener(MorphiumStorageListener<?> lst) {
        ArrayList newList = new ArrayList(this.listeners);
        newList.remove(lst);
        this.listeners = newList;
    }

    public MorphiumDriver getDriver() {
        return this.morphiumDriver;
    }

    public void setDriver(MorphiumDriver drv) {
        this.morphiumDriver = drv;
    }

    public Query<Map<String, Object>> createMapQuery(String collection) {
        try {
            Query<Map<String, Object>> q = new Query<Map<String, Object>>(this, null, this.getAsyncOperationsThreadPool());
            q.setCollectionName(collection);
            return q;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> Query<T> createQueryByTemplate(T template, String ... fields) {
        Class<?> cls = template.getClass();
        List<String> flds = fields.length > 0 ? new ArrayList<String>(Arrays.asList(fields)) : this.annotationHelper.getFields(cls, new Class[0]);
        Query<?> q = this.createQueryFor(cls);
        for (String f : flds) {
            try {
                q.f(f).eq(this.annotationHelper.getValue(template, f));
            }
            catch (Exception e) {
                log.error("Could not read field " + f + " of object " + cls.getName());
            }
        }
        return q;
    }

    @Deprecated
    public <T> List<T> findByTemplate(T template, String ... fields) {
        return this.createQueryByTemplate(template, fields).asList();
    }

    public <T> void unset(T toSet, Enum<?> field) {
        this.unset(toSet, field.name(), (AsyncOperationCallback)null);
    }

    public <T> void unset(T toSet, String field) {
        this.unset(toSet, field, (AsyncOperationCallback)null);
    }

    public <T> void unset(T toSet, Enum<?> field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, field.name(), callback);
    }

    public <T> void unset(T toSet, String collection, Enum<?> field) {
        this.unset(toSet, collection, field.name(), null);
    }

    public <T> void unset(T toSet, String collection, Enum<?> field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, collection, field.name(), callback);
    }

    public <T> void unset(T toSet, String field, AsyncOperationCallback<T> callback) {
        this.unset(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, callback);
    }

    public <T> void unset(T toSet, String collection, String field, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(toSet.getClass());
        wr.unset(toSet, collection, field, callback);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, null, multiple, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, boolean multiple, String ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, AsyncOperationCallback<T> cb, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, false, field);
    }

    public <T> Map<String, Object> unsetQ(Query<T> q, boolean multiple, AsyncOperationCallback<T> cb, Enum ... field) {
        return this.getWriterForClass(q.getType()).unset(q, cb, multiple, field);
    }

    public List<Map<String, Object>> runCommand(String command, String collection, Map<String, Object> cmdMap) throws MorphiumDriverException {
        GenericCommand cmd = new GenericCommand(this.getDriver().getPrimaryConnection(null));
        cmd.setDb(this.getDatabase());
        cmd.setColl(collection);
        cmd.setCmdData(cmdMap);
        cmd.setCommandName(command);
        int crs = cmd.executeAsync();
        return cmd.getConnection().readAnswerFor(crs);
    }

    public <T> void ensureCapped(Class<T> c) {
        this.ensureCapped(c, null);
    }

    public <T> void ensureCapped(Class<T> c, AsyncOperationCallback<T> callback) {
        Runnable r = () -> {
            String coll = this.getMapper().getCollectionName(c);
            try {
                boolean exists = this.morphiumDriver.exists(this.config.getDatabase(), coll);
                if (exists && this.morphiumDriver.isCapped(this.config.getDatabase(), coll)) {
                    return;
                }
                if (!exists) {
                    if (log.isDebugEnabled()) {
                        log.debug("Collection does not exist - ensuring indices / capped status");
                    }
                    MongoConnection primaryConnection = this.morphiumDriver.getPrimaryConnection(this.getWriteConcernForClass(c));
                    CreateCommand create = new CreateCommand(primaryConnection);
                    ((CreateCommand)create.setColl(this.getMapper().getCollectionName(c))).setDb(this.getDatabase());
                    Capped capped = this.annotationHelper.getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        create.setSize(capped.maxSize()).setCapped(true).setMax(capped.maxEntries());
                    }
                    create.execute();
                    create.releaseConnection();
                } else {
                    Capped capped = this.annotationHelper.getAnnotationFromHierarchy(c, Capped.class);
                    if (capped != null) {
                        log.warn("Collection to be capped already exists! ATTENTION!");
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        };
        if (callback == null) {
            r.run();
        } else {
            this.asyncOperationsThreadPool.execute(r);
        }
    }

    public Map<String, Object> simplifyQueryObject(Map<String, Object> q) {
        if (q.keySet().size() == 1 && q.get("$and") != null) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            List lst = (List)q.get("$and");
            for (Object o : lst) {
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                return q;
            }
            return ret;
        }
        return q;
    }

    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val) {
        return this.set(query, field, val, (AsyncOperationCallback)null);
    }

    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field.name(), val);
        return this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public <T> Map<String, Object> set(Query<T> query, String field, Object val) {
        return this.set(query, field, val, (AsyncOperationCallback)null);
    }

    public <T> Map<String, Object> set(Query<T> query, String field, Object val, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        toSet.put(field, val);
        return this.getWriterForClass(query.getType()).set(query, toSet, false, false, callback);
    }

    public Map<String, Object> setEnum(Query<?> query, Map<Enum, Object> values, boolean upsert, boolean multiple) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> est : values.entrySet()) {
            toSet.put(est.getKey().name(), values.get(est.getValue()));
        }
        return this.set(query, toSet, upsert, multiple);
    }

    public Map<String, Object> push(Query<?> query, Enum<?> field, Object value) {
        return this.push(query, field, value, false, true);
    }

    public Map<String, Object> pull(Query<?> query, Enum<?> field, Object value) {
        return this.pull(query, field.name(), value, false, true);
    }

    public Map<String, Object> push(Query<?> query, String field, Object value) {
        return this.push(query, field, value, false, true);
    }

    public Map<String, Object> pull(Query<?> query, String field, Object value) {
        return this.pull(query, field, value, false, true);
    }

    public Map<String, Object> push(Query<?> query, Enum<?> field, Object value, boolean upsert, boolean multiple) {
        return this.push(query, field.name(), value, upsert, multiple);
    }

    public Map<String, Object> pull(Query<?> query, Enum<?> field, Object value, boolean upsert, boolean multiple) {
        return this.pull(query, field.name(), value, upsert, multiple);
    }

    public Map<String, Object> pushAll(Query<?> query, Enum<?> field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pushAll(query, field.name(), value, upsert, multiple);
    }

    public void push(Object entity, String field, Object value, boolean upsert) {
        this.push(entity, null, field, value, upsert);
    }

    public void push(Object entity, String collection, String field, Object value, boolean upsert) {
        Object id = this.getId(entity);
        if (!upsert || id != null) {
            Query<?> id1 = this.createQueryFor(entity.getClass()).f("_id").eq(id);
            if (collection != null) {
                id1.setCollectionName(collection);
            }
            this.push(id1, field, value, upsert, false);
        }
        Field fld = this.getARHelper().getField(entity.getClass(), field);
        try {
            if (fld.getType().isArray()) {
                Object a = fld.get(entity);
                Object arr = null;
                if (a == null) {
                    arr = Array.newInstance(((Class)fld.getGenericType()).getComponentType(), 1);
                    Array.set(arr, 0, value);
                } else {
                    arr = Array.newInstance(((Class)fld.getGenericType()).getComponentType(), Array.getLength(a) + 1);
                    for (int i = 0; i < Array.getLength(a); ++i) {
                        Array.set(arr, i, Array.get(a, i));
                    }
                    Array.set(arr, Array.getLength(a), value);
                }
                fld.set(entity, arr);
            } else if (Collection.class.isAssignableFrom(fld.getType())) {
                ArrayList<Object> v = null;
                v = (ArrayList<Object>)fld.get(entity);
                if (v == null) {
                    v = new ArrayList<Object>();
                    v.add(value);
                    fld.set(entity, v);
                } else {
                    v.add(value);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not update entity", e);
        }
        if (upsert && id == null) {
            this.store(entity);
        }
    }

    public void push(Object entity, String collection, Enum<?> field, Object value, boolean upsert) {
        this.push(entity, collection, field.name(), value, upsert);
    }

    public void push(Object entity, Enum<?> field, Object value, boolean upsert) {
        this.push(entity, field.name(), value, upsert);
    }

    public Map<String, Object> pullAll(Query<?> query, Enum<?> field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pull(query, field.name(), value, upsert, multiple);
    }

    public <T> Map<String, Object> push(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        return this.push(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> push(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).pushPull(MorphiumStorageListener.UpdateTypes.PUSH, query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value) {
        return this.addToSet(query, field, value, false, false, null);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value, boolean multiple) {
        return this.addToSet(query, field, value, false, multiple, null);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        return this.addToSet(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> addToSet(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new IllegalArgumentException("Cannot update null");
        }
        return this.getWriterForClass(query.getType()).pushPull(MorphiumStorageListener.UpdateTypes.ADD_TO_SET, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pull(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        return this.pull(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> pull(Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPull(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pull(T entity, String field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (entity == null) {
            throw new IllegalArgumentException("Null Entity cannot be pulled...");
        }
        return this.pull(this.createQueryFor(entity.getClass()).f("_id").eq(this.getId(entity)), field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pull(Query<T> query, String field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPull(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public Map<String, Object> pushAll(Query<?> query, String field, List<?> value, boolean upsert, boolean multiple) {
        return this.pushAll(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> pushAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPullAll(MorphiumStorageListener.UpdateTypes.PUSH, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean multiple) {
        return this.addAllToSet(query, field, value, false, multiple, null);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple) {
        return this.addAllToSet(query, field, value, upsert, multiple, null);
    }

    public <T> Map<String, Object> addAllToSet(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback callback) {
        if (query == null || field == null) {
            throw new RuntimeException("Cannot update null!");
        }
        MorphiumWriter wr = this.getWriterForClass(query.getType());
        return wr.pushPullAll(MorphiumStorageListener.UpdateTypes.ADD_TO_SET, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, boolean upsert, boolean multiple) {
        return this.set(query, field.name(), val, upsert, multiple, null);
    }

    public <T> Map<String, Object> set(Query<T> query, Enum<?> field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.set(query, field.name(), val, upsert, multiple, callback);
    }

    public Map<String, Object> pullAll(Query<?> query, String field, List<Object> value, boolean upsert, boolean multiple) {
        return this.pull(query, field, value, upsert, multiple);
    }

    public <T> Map<String, Object> set(Query<T> query, String field, Object val, boolean upsert, boolean multiple) {
        return this.set(query, field, val, upsert, multiple, null);
    }

    public <T> Map<String, Object> set(Query<T> query, String field, Object val, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(field, val);
        return this.set(query, map, upsert, multiple, callback);
    }

    public Map<String, Object> set(Query<?> query, Map<String, Object> map, boolean upsert, boolean multiple) {
        return this.set(query, map, upsert, multiple, null);
    }

    public <T> Map<String, Object> set(Query<T> query, Map<String, Object> map, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).set(query, map, upsert, multiple, callback);
    }

    public <T> Map<String, Object> currentDate(Query<?> query, String field, boolean upsert, boolean multiple) {
        return this.set(query, UtilsMap.of("$currentDate", UtilsMap.of(field, 1)), upsert, multiple);
    }

    public <T> Map<String, Object> currentDate(Query<?> query, Enum field, boolean upsert, boolean multiple) {
        return this.set(query, UtilsMap.of("$currentDate", UtilsMap.of(field.name(), 1)), upsert, multiple);
    }

    public <T> void set(T toSet, Enum<?> field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, callback);
    }

    public <T> void set(T toSet, Enum<?> field, Object value) {
        this.set(toSet, field.name(), value, null);
    }

    public <T> void set(T toSet, String collection, Enum<?> field, Object value) {
        this.set(toSet, collection, field.name(), value, false, null);
    }

    public <T> void set(T toSet, Enum<?> field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, field.name(), value, upserts, callback);
    }

    public <T> void set(T toSet, Map<Enum, Object> values) {
        this.set(toSet, this.getMapper().getCollectionName(toSet.getClass()), false, values, null);
    }

    public <T> void set(String inCollection, Map<Enum, Object> values, T into) {
        this.set(into, inCollection, false, values, null);
    }

    public <T> void set(T toSet, String collection, boolean upserts, Map<Enum, Object> values) {
        this.set(toSet, collection, upserts, values, null);
    }

    public <T> void set(T toSet, String collection, boolean upserts, Map<Enum, Object> values, AsyncOperationCallback<T> callback) {
        HashMap<String, Object> strValues = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : values.entrySet()) {
            strValues.put(e.getKey().name(), e.getValue());
        }
        this.set(toSet, collection, strValues, upserts, callback);
    }

    public <T> void set(T toSet, String field, Object value) {
        this.set(toSet, field, value, null);
    }

    public <T> void set(T toSet, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, value, upserts, callback);
    }

    public <T> void set(Map<String, Object> values, T into) {
        this.set(into, this.getMapper().getCollectionName(into.getClass()), values, false, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values) {
        this.set(toSet, collection, values, false, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values, boolean upserts) {
        this.set(toSet, collection, values, upserts, null);
    }

    public <T> void set(T toSet, String collection, Map<String, Object> values, boolean upserts, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.annotationHelper.callLifecycleMethod(PreUpdate.class, toSet);
        this.getWriterForClass(toSet.getClass()).set(toSet, collection, values, upserts, callback);
        this.annotationHelper.callLifecycleMethod(PostUpdate.class, toSet);
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDriver().getDBStats(db);
    }

    public Map<String, Object> getDbStats() throws MorphiumDriverException {
        return this.getDriver().getDBStats(this.getConfig().getDatabase());
    }

    public Map<String, Object> getCollStats(Class<?> coll) throws MorphiumDriverException {
        return this.getDriver().getCollStats(this.getConfig().getDatabase(), this.getMapper().getCollectionName(coll));
    }

    public Map<String, Object> getCollStats(String coll) throws MorphiumDriverException {
        return this.getDriver().getCollStats(this.getConfig().getDatabase(), coll);
    }

    public <T> void set(T toSet, String collection, Enum field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, collection, UtilsMap.of(field.name(), value), upserts, callback);
    }

    public <T> void set(T toSet, String collection, String field, Object value, boolean upserts, AsyncOperationCallback<T> callback) {
        this.set(toSet, collection, UtilsMap.of(field, value), upserts, callback);
    }

    public <T> void set(T toSet, String field, Object value, AsyncOperationCallback<T> callback) {
        this.set(toSet, field, value, false, callback);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, double amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, long amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, Number amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), amount.doubleValue(), upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, int amount, boolean upsert, boolean multiple) {
        return this.dec(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, double amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, long amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, int amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount, upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, field, -amount.doubleValue(), upsert, multiple);
    }

    public Map<String, Object> dec(Query<?> query, String field, double amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, String field, long amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, String field, int amount) {
        return this.inc((Query)query, field, -amount, false, false, (AsyncOperationCallback)null);
    }

    public Map<String, Object> dec(Query<?> query, String field, Number amount) {
        return this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, double amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, long amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, int amount) {
        return this.inc(query, field, -amount, false, false);
    }

    public Map<String, Object> dec(Query<?> query, Enum<?> field, Number amount) {
        return this.inc(query, field, -amount.doubleValue(), false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, long amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, int amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, Number amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, String field, double amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, double amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, long amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, int amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, Number amount) {
        return this.inc(query, field, amount, false, false);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, double amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, long amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, int amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public Map<String, Object> inc(Query<?> query, Enum<?> field, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, field.name(), amount, upsert, multiple);
    }

    public <T> Map<String, Object> inc(Map<Enum, Number> fieldsToInc, Query<T> matching, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Number> toUpdate = new HashMap<String, Number>();
        for (Map.Entry<Enum, Number> e : fieldsToInc.entrySet()) {
            toUpdate.put(e.getKey().name(), e.getValue());
        }
        return this.inc(matching, toUpdate, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Map<String, Number> toUpdate, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, toUpdate, upsert, multiple, callback);
    }

    public <T> void dec(Map<Enum, Number> fieldsToInc, Query<T> matching, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        HashMap<String, Number> toUpdate = new HashMap<String, Number>();
        for (Map.Entry<Enum, Number> e : fieldsToInc.entrySet()) {
            toUpdate.put(e.getKey().name(), e.getValue());
        }
        this.dec(matching, toUpdate, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Map<String, Number> toUpdate, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, toUpdate, upsert, multiple, callback);
    }

    public Map<String, Object> inc(Query<?> query, String name, long amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, int amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, double amount, boolean upsert, boolean multiple) {
        return this.inc((Query)query, name, amount, upsert, multiple, (AsyncOperationCallback)null);
    }

    public Map<String, Object> inc(Query<?> query, String name, Number amount, boolean upsert, boolean multiple) {
        return this.inc(query, name, amount, upsert, multiple, null);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, Enum<?> field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.inc(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> inc(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, long amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, int amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, double amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, Enum<?> field, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.dec(query, field.name(), amount, upsert, multiple, callback);
    }

    public <T> Map<String, Object> dec(Query<T> query, String name, Number amount, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        if (query == null) {
            throw new RuntimeException("Cannot update null!");
        }
        return this.getWriterForClass(query.getType()).inc(query, name, -amount.doubleValue(), upsert, multiple, callback);
    }

    public MorphiumWriter getWriterForClass(Class<?> cls) {
        if (this.annotationHelper.isBufferedWrite(cls) && this.isWriteBufferEnabledForThread()) {
            return this.config.getBufferedWriter();
        }
        if (this.annotationHelper.isAsyncWrite(cls) && this.isAsyncWritesEnabledForThread()) {
            return this.config.getAsyncWriter();
        }
        return this.config.getWriter();
    }

    public void dec(Object toDec, Enum<?> field, double amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, double amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, int amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, int amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, long amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, long amount) {
        this.inc(toDec, field, -amount);
    }

    public void dec(Object toDec, Enum<?> field, Number amount) {
        this.dec(toDec, field.name(), amount);
    }

    public void dec(Object toDec, String field, Number amount) {
        this.inc(toDec, field, -amount.doubleValue());
    }

    public void inc(Object toSet, Enum<?> field, long i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, long i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, int i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, int i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, double i) {
        this.inc((Object)toSet, field.name(), i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, String field, double i) {
        this.inc((Object)toSet, field, i, (AsyncOperationCallback)null);
    }

    public void inc(Object toSet, Enum<?> field, Number i) {
        this.inc(toSet, field.name(), i, null);
    }

    public void inc(Object toSet, String field, Number i) {
        this.inc(toSet, field, i, null);
    }

    public <T> void inc(T toSet, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, this.getMapper().getCollectionName(toSet.getClass()), field, i, callback);
    }

    public <T> void inc(T toSet, Enum<?> collection, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, double i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, double i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, int i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, int i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, long i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, long i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void inc(T toSet, String collection, Enum<?> field, Number i, AsyncOperationCallback<T> callback) {
        this.inc(toSet, collection, field.name(), i, callback);
    }

    public <T> void inc(T toSet, String collection, String field, Number i, AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.getId(toSet) == null) {
            log.debug("just storing object as it is new...");
            this.store(toSet);
            return;
        }
        this.getWriterForClass(toSet.getClass()).inc(toSet, collection, field, i, callback);
    }

    public <T> void remove(List<T> lst, String forceCollectionName) {
        this.remove((T)lst, forceCollectionName, (AsyncOperationCallback<T>)null);
    }

    @Deprecated
    public <T> void delete(List<T> lst, String forceCollectionName) {
        this.remove((T)lst, forceCollectionName, (AsyncOperationCallback<T>)null);
    }

    @Deprecated
    public <T> void delete(List<T> lst, String forceCollectionName, AsyncOperationCallback<T> callback) {
        this.remove((T)lst, forceCollectionName, callback);
    }

    public <T> void remove(List<T> lst, String forceCollectionName, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (Object o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        for (Object o : bufferedDel) {
            this.config.getBufferedWriter().remove(o, forceCollectionName, callback);
        }
        for (Object o : directDel) {
            this.config.getWriter().remove(o, forceCollectionName, callback);
        }
    }

    public <T> void delete(List<T> lst, AsyncOperationCallback<T> callback) {
        this.remove((T)lst, callback);
    }

    public <T> void remove(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> directDel = new ArrayList<T>();
        ArrayList<T> bufferedDel = new ArrayList<T>();
        for (T o : lst) {
            if (this.annotationHelper.isBufferedWrite(o.getClass())) {
                bufferedDel.add(o);
                continue;
            }
            directDel.add(o);
        }
        this.config.getBufferedWriter().remove(bufferedDel, callback);
        this.config.getWriter().remove(directDel, callback);
    }

    public void inc(StatisticKeys k) {
        this.stats.get((Object)k).inc();
    }

    public void updateUsingFields(Object ent, String ... fields) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fields);
    }

    public void updateUsingFields(Object ent, Enum ... fieldNames) {
        this.updateUsingFields((Object)ent, (AsyncOperationCallback)null, fieldNames);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, Enum ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, AsyncOperationCallback<T> callback, String ... fields) {
        this.updateUsingFields(ent, this.getMapper().getCollectionName(ent.getClass()), callback, fields);
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, Enum ... fields) {
        ArrayList<String> g = new ArrayList<String>();
        for (Enum e : fields) {
            g.add(e.name());
        }
        this.updateUsingFields(ent, collection, callback, g.toArray(new String[0]));
    }

    public <T> void updateUsingFields(T ent, String collection, AsyncOperationCallback<T> callback, String ... fields) {
        if (ent == null) {
            return;
        }
        if (fields.length == 0) {
            return;
        }
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = this.getARHelper().getMongoFieldName(ent.getClass(), fields[idx]);
        }
        this.getWriterForClass(ent.getClass()).updateUsingFields(ent, collection, null, fields);
    }

    public MorphiumObjectMapper getMapper() {
        return this.objectMapper;
    }

    public AnnotationAndReflectionHelper getARHelper() {
        if (this.annotationHelper == null) {
            return new AnnotationAndReflectionHelper(true);
        }
        return this.annotationHelper;
    }

    public <T> T reread(T o) {
        if (o == null) {
            return null;
        }
        return this.reread(o, this.objectMapper.getCollectionName(o.getClass()));
    }

    public <T> T reread(T o, String collection) {
        if (o == null) {
            return null;
        }
        Object id = this.getId(o);
        if (id == null) {
            return null;
        }
        HashMap<String, Object> srch = new HashMap<String, Object>();
        srch.put("_id", id);
        try {
            MongoConnection con = this.morphiumDriver.getReadConnection(this.getReadPreferenceForClass(o.getClass()));
            FindCommand settings = ((FindCommand)((FindCommand)new FindCommand(con).setDb(this.config.getDatabase())).setColl(collection)).setFilter(Doc.of(srch)).setBatchSize(1).setLimit(1);
            List<Map<String, Object>> found = settings.execute();
            settings.releaseConnection();
            if (found != null && !found.isEmpty()) {
                Map<String, Object> dbo = found.get(0);
                Object fromDb = this.objectMapper.deserialize(o.getClass(), dbo);
                if (fromDb == null) {
                    throw new RuntimeException("could not reread from db");
                }
                List<String> flds = this.annotationHelper.getFields(o.getClass(), new Class[0]);
                for (String f : flds) {
                    Field fld = this.annotationHelper.getField(o.getClass(), f);
                    if (Modifier.isStatic(fld.getModifiers())) continue;
                    try {
                        fld.set(o, fld.get(fromDb));
                    }
                    catch (IllegalAccessException e) {
                        log.error("Could not set Value: " + String.valueOf(fld));
                    }
                }
            } else {
                return null;
            }
            this.firePostLoadEvent(o);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public void firePreStore(Object o, boolean isNew) {
        if (o == null) {
            return;
        }
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PreStore.class, o);
    }

    public void firePostStore(Object o, boolean isNew) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postStore(this, o, isNew);
        }
        this.annotationHelper.callLifecycleMethod(PostStore.class, o);
    }

    public void firePreDrop(Class cls) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preDrop(this, cls);
        }
    }

    public <T> void firePostStore(Map<T, Boolean> isNew) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postStore(this, isNew);
        }
        for (MorphiumStorageListener<Object> o : isNew.keySet()) {
            this.annotationHelper.callLifecycleMethod(PostStore.class, o);
        }
    }

    public <T> void firePostRemove(List<T> toRemove) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postRemove(this, toRemove);
        }
        for (MorphiumStorageListener<Object> o : toRemove) {
            this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
        }
    }

    public <T> void firePostLoad(List<T> loaded) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postLoad(this, loaded);
        }
        for (MorphiumStorageListener<Object> o : loaded) {
            this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
        }
    }

    public void firePreStore(Map<Object, Boolean> isNew) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preStore(this, isNew);
        }
        for (Object o : isNew.keySet()) {
            this.annotationHelper.callLifecycleMethod(PreStore.class, o);
        }
    }

    public <T> void firePreRemove(List<T> lst) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preRemove(this, lst);
        }
        for (MorphiumStorageListener<Object> o : lst) {
            this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
        }
    }

    public void firePreRemove(Object o) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PreRemove.class, o);
    }

    public void firePostDropEvent(Class cls) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postDrop(this, cls);
        }
    }

    public void firePostUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postUpdate(this, cls, t);
        }
    }

    public void firePreUpdateEvent(Class cls, MorphiumStorageListener.UpdateTypes t) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preUpdate(this, cls, t);
        }
    }

    public void firePostRemoveEvent(Object o) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postRemove(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostRemove.class, o);
    }

    public void firePostRemoveEvent(Query q) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postRemove(this, q);
        }
    }

    public void firePreRemoveEvent(Query q) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.preRemove(this, q);
        }
    }

    public <T> T deReference(T obj) {
        if (obj instanceof LazyDeReferencingProxy) {
            obj = ((LazyDeReferencingProxy)obj).__getDeref();
        }
        List<Field> flds = this.getARHelper().getAllFields(obj.getClass());
        for (Field fld : flds) {
            fld.setAccessible(true);
            Reference r = fld.getAnnotation(Reference.class);
            if (r == null || !r.lazyLoading()) continue;
            try {
                LazyDeReferencingProxy v = (LazyDeReferencingProxy)fld.get(obj);
                Object value = v.__getDeref();
                fld.set(obj, value);
            }
            catch (IllegalAccessException e) {
                log.error("dereferencing of field " + fld.getName() + " failed", (Throwable)e);
            }
        }
        return obj;
    }

    public void setNameProviderForClass(Class<?> cls, NameProvider pro) {
        this.getMapper().setNameProviderForClass(cls, pro);
    }

    public NameProvider getNameProviderForClass(Class<?> cls) {
        return this.getMapper().getNameProviderForClass(cls);
    }

    public void firePostLoadEvent(Object o) {
        for (MorphiumStorageListener<?> l : this.listeners) {
            l.postLoad(this, o);
        }
        this.annotationHelper.callLifecycleMethod(PostLoad.class, o);
    }

    public boolean isReplicaSet() {
        return this.config.isReplicaset();
    }

    public ReadPreference getReadPreferenceForClass(Class<?> cls) {
        if (cls == null) {
            return this.config.getDefaultReadPreference();
        }
        DefaultReadPreference rp = this.annotationHelper.getAnnotationFromHierarchy(cls, DefaultReadPreference.class);
        if (rp == null) {
            return this.config.getDefaultReadPreference();
        }
        return rp.value().getPref();
    }

    public MorphiumBulkContext createBulkRequestContext(Class<?> type, boolean ordered) {
        return new MorphiumBulkContext(this.getDriver().createBulkContext(this, this.config.getDatabase(), this.getMapper().getCollectionName(type), ordered, this.getWriteConcernForClass(type)));
    }

    public MorphiumBulkContext createBulkRequestContext(String collection, boolean ordered) {
        return new MorphiumBulkContext(this.getDriver().createBulkContext(this, this.config.getDatabase(), collection, ordered, null));
    }

    public WriteConcern getWriteConcernForClass(Class<?> cls) {
        WriteSafety safety = this.annotationHelper.getAnnotationFromHierarchy(cls, WriteSafety.class);
        if (safety == null) {
            return null;
        }
        boolean j = safety.waitForJournalCommit();
        int w = safety.level().getValue();
        long timeout = safety.timeout();
        if (this.isReplicaSet() && w > 2) {
            int activeNodes;
            List<String> hostSeed = this.getDriver().getHostSeed();
            if (log.isDebugEnabled()) {
                log.debug("Active nodes now: " + hostSeed.size());
            }
            if ((activeNodes = hostSeed.size()) > 50) {
                activeNodes = 50;
            }
            long masterOpTime = 0L;
            long maxReplLag = 0L;
            if (timeout < 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting timeout to replication lag*3");
                }
                if (maxReplLag < 0L) {
                    maxReplLag = -maxReplLag;
                }
                if (maxReplLag == 0L) {
                    maxReplLag = 1L;
                }
                timeout = maxReplLag * 3000L;
                if (maxReplLag > 10L) {
                    log.warn("Warning: replication lag too high! timeout set to " + timeout + "ms - replication Lag is " + maxReplLag + "s - write should take place in Background!");
                }
            }
            w = activeNodes;
            if (timeout > 0L && timeout < maxReplLag * 1000L) {
                log.warn("Timeout is set smaller than replication lag - increasing to replication_lag time * 3");
                timeout = maxReplLag * 3000L;
            }
        }
        if (!this.isReplicaSet() && timeout < 0L) {
            timeout = 0L;
        }
        return WriteConcern.getWc(w, j, (int)timeout);
    }

    public void clearCollection(Class<?> cls) {
        this.remove(this.createQueryFor(cls));
    }

    public void clearCollection(Class<?> cls, String colName) {
        Query<?> q = this.createQueryFor(cls);
        q.setCollectionName(colName);
        this.remove(q);
    }

    public void clearCollectionOneByOne(Class<?> cls) {
        this.inc(StatisticKeys.WRITES);
        List<?> lst = this.readAll(cls);
        lst.forEach(this::delete);
        this.getCache().clearCacheIfNecessary(cls);
    }

    public <T> List<T> readAll(Class<? extends T> cls) {
        this.inc(StatisticKeys.READS);
        Query<T> qu = this.createQueryFor(cls);
        return qu.asList();
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type, String usingCollectionName) {
        return this.createQueryFor(type).setCollectionName(usingCollectionName);
    }

    public <T> Query<T> createQueryFor(Class<? extends T> type) {
        Query<T> q = new Query<T>(this, type, this.getAsyncOperationsThreadPool());
        q.setAutoValuesEnabled(this.isAutoValuesEnabledForThread());
        return q;
    }

    public <T> QueryIterator<? extends T> iterateAll(Class<? extends T> type) {
        return this.iterateAll(type, null);
    }

    public <T> QueryIterator<? extends T> iterateAll(Class<? extends T> type, Map<?, ?> sort) {
        this.inc(StatisticKeys.READS);
        LinkedHashMap<String, Object> map = null;
        if (sort != null) {
            map = new LinkedHashMap<String, Object>();
            for (Map.Entry<?, ?> e : sort.entrySet()) {
                map.put(e.getKey().toString(), e.getValue());
            }
        }
        QueryIterator<? extends T> lst = this.createQueryFor(type).setSort(map).asIterable();
        return lst;
    }

    public <T> List<T> readAll(Class<? extends T> type, Map<?, ?> sort) {
        this.inc(StatisticKeys.READS);
        LinkedHashMap<String, Object> map = null;
        if (sort != null) {
            map = new LinkedHashMap<String, Object>();
            for (Map.Entry<?, ?> e : sort.entrySet()) {
                map.put(e.getKey().toString(), e.getValue());
            }
        }
        List<? extends T> lst = this.createQueryFor(type).setSort(map).asList();
        return lst;
    }

    public int getEstimatedCount(Class<?> type) {
        try {
            Map<String, Object> stats = this.getCollStats(this.getMapper().getCollectionName(type));
            if (stats == null || stats.isEmpty()) {
                return 0;
            }
            return (Integer)stats.get("count");
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public long getCount(Class<?> type) {
        return this.createQueryFor(type).countAll();
    }

    @Deprecated
    public <T> List<T> find(Query<T> q) {
        return q.asList();
    }

    public List<Object> distinct(Enum<?> key, Class c) {
        return this.distinct(key.name(), c);
    }

    public List<Object> distinct(Enum<?> key, Query q) {
        return this.distinct(key.name(), q);
    }

    public List<Object> distinct(String key, Query q) {
        MongoConnection con = null;
        MongoCommand settings = null;
        try {
            con = this.getDriver().getPrimaryConnection(null);
            settings = ((DistinctMongoCommand)((DistinctMongoCommand)new DistinctMongoCommand(con).setColl(q.getCollectionName())).setDb(this.config.getDatabase())).setQuery(Doc.of(q.toQueryObject())).setKey(key);
            if (q.getCollation() != null) {
                ((DistinctMongoCommand)settings).setCollation(Doc.of(q.getCollation().toQueryObject()));
            }
            List<Object> list = ((DistinctMongoCommand)settings).execute();
            return list;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (settings != null) {
                settings.releaseConnection();
            }
        }
    }

    public List<Object> distinct(String key, Class cls) {
        return this.distinct(key, cls, null);
    }

    public List<Object> distinct(String key, Class cls, Collation collation) {
        MongoConnection con = null;
        MongoCommand settings = null;
        try {
            con = this.morphiumDriver.getPrimaryConnection(null);
            settings = ((DistinctMongoCommand)((DistinctMongoCommand)new DistinctMongoCommand(con).setColl(this.objectMapper.getCollectionName(cls))).setDb(this.config.getDatabase())).setKey(this.getARHelper().getMongoFieldName(cls, key));
            if (collation != null) {
                ((DistinctMongoCommand)settings).setCollation(Doc.of(collation.toQueryObject()));
            }
            List<Object> list = ((DistinctMongoCommand)settings).execute();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            settings.releaseConnection();
        }
    }

    public List<Object> distinct(String key, String collectionName) {
        return this.distinct(key, collectionName, null);
    }

    public List<Object> distinct(String key, String collectionName, Collation collation) {
        MongoConnection con = null;
        MongoCommand cmd = null;
        try {
            con = this.getDriver().getPrimaryConnection(null);
            cmd = new DistinctMongoCommand(con);
            ((DistinctMongoCommand)((DistinctMongoCommand)cmd.setColl(collectionName)).setDb(this.config.getDatabase())).setKey(key).setCollation(collation.toQueryObject());
            List<Object> list = ((DistinctMongoCommand)cmd).execute();
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            cmd.releaseConnection();
        }
    }

    public <T> T findById(Class<? extends T> type, Object id) {
        return this.findById(type, id, null);
    }

    public <T> void findById(Class<? extends T> type, Object id, String collection, AsyncOperationCallback callback) {
        this.createQueryFor(type).setCollectionName(collection).f(this.getARHelper().getIdFieldName(type)).eq(id).get(callback);
    }

    public <T> T findById(Class<? extends T> type, Object id, String collection) {
        boolean useCache;
        this.inc(StatisticKeys.READS);
        Cache c = this.getARHelper().getAnnotationFromHierarchy(type, Cache.class);
        boolean bl = useCache = c != null && c.readCache() && this.isReadCacheEnabledForThread();
        if (useCache) {
            if (this.getCache().getFromIDCache(type, id) != null) {
                this.inc(StatisticKeys.CHITS);
                return this.getCache().getFromIDCache(type, id);
            }
            this.inc(StatisticKeys.CMISS);
        } else {
            this.inc(StatisticKeys.NO_CACHED_READS);
        }
        List<String> ls = this.annotationHelper.getFields(type, Id.class);
        if (ls.isEmpty()) {
            throw new RuntimeException("Cannot find by ID on non-Entity");
        }
        return this.createQueryFor(type).setCollectionName(collection).f(ls.get(0)).eq(id).get();
    }

    public <T> List<T> findByField(Class<? extends T> cls, String fld, Object val) {
        Query<T> q = this.createQueryFor(cls);
        q = q.f(fld).eq(val);
        return q.asList();
    }

    public <T> List<T> findByField(Class<? extends T> cls, Enum<?> fld, Object val) {
        return this.findByField(cls, fld.name(), val);
    }

    public <T> boolean setAutoValues(T o) throws IllegalAccessException {
        boolean aNew;
        Class<?> type = this.getARHelper().getRealClass(o.getClass());
        Object id = this.getARHelper().getId(o);
        boolean bl = aNew = id == null;
        if (!this.isAutoValuesEnabledForThread()) {
            return aNew;
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(type, CreationTime.class)) {
            Object reread = null;
            CreationTime ct = this.getARHelper().getAnnotationFromHierarchy(o.getClass(), CreationTime.class);
            boolean checkForNew = Objects.requireNonNull(ct).checkForNew() && this.getConfig().isCheckForNew();
            List<String> lst = this.getARHelper().getFields(type, CreationTime.class);
            if (id == null) {
                aNew = true;
            } else if (checkForNew) {
                reread = this.findById(type, id);
                boolean bl2 = aNew = reread == null;
                if (!aNew) {
                    if (lst.isEmpty()) {
                        log.error("Unable to copy @CreationTime - field missing");
                    } else {
                        for (String fld : lst) {
                            Field field = this.getARHelper().getField(type, fld);
                            Object value = field.get(reread);
                            field.set(o, value);
                        }
                    }
                }
            } else {
                aNew = false;
            }
            if (aNew) {
                if (lst.isEmpty()) {
                    log.error("Unable to store creation time as @CreationTime for field is missing");
                } else {
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Object val = null;
                        Field f = this.getARHelper().getField(type, ctf);
                        if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                            val = now;
                        } else if (f.getType().equals(Date.class)) {
                            val = new Date(now);
                        } else if (f.getType().equals(String.class)) {
                            CreationTime ctField = f.getAnnotation(CreationTime.class);
                            SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                            val = df.format(now);
                        }
                        try {
                            f.set(o, val);
                        }
                        catch (IllegalAccessException e) {
                            log.error("Could not set creation time", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(type, LastChange.class)) {
            List<String> lst = this.getARHelper().getFields(type, LastChange.class);
            if (lst != null && !lst.isEmpty()) {
                long now = System.currentTimeMillis();
                for (String ctf : lst) {
                    Object val = null;
                    Field f = this.getARHelper().getField(type, ctf);
                    if (f.getType().equals(Long.TYPE) || f.getType().equals(Long.class)) {
                        val = now;
                    } else if (f.getType().equals(Date.class)) {
                        val = new Date(now);
                    } else if (f.getType().equals(String.class)) {
                        LastChange ctField = f.getAnnotation(LastChange.class);
                        SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                        val = df.format(now);
                    }
                    try {
                        f.set(o, val);
                    }
                    catch (IllegalAccessException e) {
                        log.error("Could not set modification time", (Throwable)e);
                    }
                }
            } else {
                log.warn("Could not store last change - @LastChange missing!");
            }
        }
        return aNew;
    }

    public void clearCachefor(Class<?> cls) {
        this.getCache().clearCachefor(cls);
    }

    public void clearCacheforClassIfNecessary(Class<?> cls) {
        this.getCache().clearCacheIfNecessary(cls);
    }

    public <T> void storeNoCache(T lst) {
        this.storeNoCache(lst, this.getMapper().getCollectionName(lst.getClass()), null);
    }

    public <T> void storeNoCache(T o, AsyncOperationCallback<T> callback) {
        this.storeNoCache(o, this.getMapper().getCollectionName(o.getClass()), callback);
    }

    public <T> void storeNoCache(T o, String collection) {
        this.storeNoCache(o, collection, null);
    }

    public <T> void storeNoCache(T o, String collection, AsyncOperationCallback<T> callback) {
        if (this.getARHelper().getId(o) == null) {
            this.config.getWriter().insert(o, collection, callback);
        } else {
            this.config.getWriter().store(o, collection, callback);
        }
    }

    public <T> void storeBuffered(T lst) {
        this.storeBuffered(lst, null);
    }

    public <T> void storeBuffered(T lst, AsyncOperationCallback<T> callback) {
        this.storeBuffered(lst, this.getMapper().getCollectionName(lst.getClass()), callback);
    }

    public <T> void storeBuffered(T lst, String collection, AsyncOperationCallback<T> callback) {
        this.config.getBufferedWriter().store(lst, collection, callback);
    }

    public void flush() {
        this.config.getBufferedWriter().flush();
        this.config.getWriter().flush();
    }

    public void flush(Class type) {
        this.config.getBufferedWriter().flush(type);
        this.config.getWriter().flush(type);
    }

    public Object getId(Object o) {
        return this.annotationHelper.getId(o);
    }

    public <T> void dropCollection(Class<T> cls, AsyncOperationCallback<T> callback) {
        this.dropCollection(cls, this.getMapper().getCollectionName(cls), callback);
    }

    public <T> void dropCollection(Class<T> cls, String collection, AsyncOperationCallback<T> callback) {
        block4: {
            try {
                this.getWriterForClass(cls).dropCollection(cls, collection, callback);
            }
            catch (Exception e) {
                if (!e.getMessage().endsWith("Error: 26: ns not found")) {
                    if (callback != null) {
                        callback.onOperationError(AsyncOperationType.WRITE, null, 0L, e.getMessage(), e, null, cls);
                    }
                }
                if (callback == null) break block4;
                callback.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, null, null, cls);
            }
        }
    }

    public void dropCollection(Class<?> cls) {
        block2: {
            try {
                this.getWriterForClass(cls).dropCollection(cls, this.getMapper().getCollectionName(cls), null);
            }
            catch (Exception e) {
                if (e.getMessage().endsWith("ns not found")) break block2;
                throw e;
            }
        }
    }

    public <T> void ensureIndicesFor(Class<T> type) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), null);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection) {
        this.ensureIndicesFor(type, onCollection, null);
    }

    public <T> void ensureIndicesFor(Class<T> type, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, this.getMapper().getCollectionName(type), callback);
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback) {
        this.ensureIndicesFor(type, onCollection, callback, this.getWriterForClass(type));
    }

    public <T> void ensureIndicesFor(Class<T> type, String onCollection, AsyncOperationCallback<T> callback, MorphiumWriter wr) {
        List<String> flds;
        Index i;
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, Index.class)) {
            List<Annotation> lst = this.annotationHelper.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                i = (Index)a;
                if (i.value().length <= 0) continue;
                List<Map<String, Object>> options = null;
                if (i.options().length > 0) {
                    options = this.createIndexKeyMapFrom(i.options());
                }
                if (!i.locale().equals("")) {
                    UtilsMap<String, String> collation = UtilsMap.of("locale", i.locale());
                    collation.put("alternate", i.alternate().mongoText);
                    collation.put("backwards", (String)((Object)Boolean.valueOf(i.backwards())));
                    collation.put("caseFirst", i.caseFirst().mongoText);
                    collation.put("caseLevel", (String)((Object)Boolean.valueOf(i.caseLevel())));
                    collation.put("maxVariable", i.maxVariable().mongoText);
                    collation.put("strength", (String)((Object)Integer.valueOf(i.strength().mongoValue)));
                    options.add(UtilsMap.of("collation", collation));
                }
                List<Map<String, Object>> idx = this.createIndexKeyMapFrom(i.value());
                int cnt = 0;
                for (Map<String, Object> m : idx) {
                    Map<String, Object> optionsMap = null;
                    if (options != null && options.size() > cnt) {
                        optionsMap = options.get(cnt);
                    }
                    if (optionsMap != null && optionsMap.containsKey("")) {
                        optionsMap = null;
                    }
                    try {
                        wr.createIndex(type, onCollection, IndexDescription.fromMaps(m, optionsMap), callback);
                    }
                    catch (Exception e) {
                        if (e.getMessage() != null && e.getMessage().contains("already exists")) {
                            log.warn("Index already exists: " + e.getMessage());
                        }
                        throw e;
                    }
                    ++cnt;
                }
            }
        }
        if ((flds = this.annotationHelper.getFields(type, Index.class)) != null && !flds.isEmpty()) {
            for (String f : flds) {
                i = this.annotationHelper.getField(type, f).getAnnotation(Index.class);
                LinkedHashMap<String, Object> idx = new LinkedHashMap<String, Object>();
                if (i.decrement()) {
                    idx.put(f, -1);
                } else {
                    idx.put(f, 1);
                }
                Map<String, Object> optionsMap = null;
                if (this.createIndexKeyMapFrom(i.options()) != null) {
                    optionsMap = this.createIndexKeyMapFrom(i.options()).get(0);
                }
                try {
                    wr.createIndex(type, onCollection, IndexDescription.fromMaps(idx, optionsMap), callback);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("already exists")) {
                        log.warn("Index already exists: " + e.getMessage());
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public void ensureIndex(Class<?> cls, Map<String, Object> index) {
        try {
            this.getWriterForClass(cls).createIndex(cls, this.getMapper().getCollectionName(cls), IndexDescription.fromMaps(index, null), null);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    @Deprecated
    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index, Map<String, Object> options) {
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(index, options), null);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    @Deprecated
    public void ensureIndex(Class<?> cls, String collection, Map<String, Object> index) {
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(index, null), null);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, Enum ... fldStr) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Enum e : fldStr) {
            String f = e.name();
            m.put(f, 1);
        }
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(m, null), callback);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, AsyncOperationCallback<T> callback, String ... fldStr) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), callback, fldStr);
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, String collection, AsyncOperationCallback<T> callback, String ... fldStr) {
        List<Map<String, Object>> m = this.createIndexKeyMapFrom(fldStr);
        for (Map<String, Object> idx : m) {
            try {
                this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(idx, null), callback);
            }
            catch (Exception e) {
                if (e.getMessage().contains("already exists")) {
                    log.warn("Index already exists: " + e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        this.ensureIndex(cls, this.getMapper().getCollectionName(cls), index, callback);
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, Map<String, Object> options, AsyncOperationCallback<T> callback) {
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(index, options), callback);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    @Deprecated
    public <T> void ensureIndex(Class<T> cls, String collection, Map<String, Object> index, AsyncOperationCallback<T> callback) {
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, IndexDescription.fromMaps(index, null), callback);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    public <T> void createIndex(Class<T> cls, String collection, IndexDescription index, AsyncOperationCallback<T> callback) {
        try {
            this.getWriterForClass(cls).createIndex(cls, collection, index, callback);
        }
        catch (Exception e) {
            if (e.getMessage().contains("already exists")) {
                log.warn("Index already exists: " + e.getMessage());
            }
            throw e;
        }
    }

    public List<IndexDescription> getIndexesFromMongo(Class cls) {
        return this.getIndexesFromMongo(this.getMapper().getCollectionName(cls));
    }

    public List<IndexDescription> getIndexesFromMongo(String collection) {
        MongoConnection readConnection = this.getDriver().getReadConnection(this.getConfig().getDefaultReadPreference());
        ListIndexesCommand cmd = new ListIndexesCommand(readConnection);
        ((ListIndexesCommand)cmd.setDb(this.getDatabase())).setColl(collection);
        try {
            List<IndexDescription> list = cmd.execute();
            return list;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            cmd.releaseConnection();
        }
    }

    public <T> List<IndexDescription> getIndexesFromEntity(Class<T> type) {
        List<String> flds;
        Index i;
        ArrayList<IndexDescription> ret = new ArrayList<IndexDescription>();
        if (this.annotationHelper.isAnnotationPresentInHierarchy(type, Index.class)) {
            List<Annotation> lst = this.annotationHelper.getAllAnnotationsFromHierachy(type, Index.class);
            for (Annotation a : lst) {
                i = (Index)a;
                if (i.value().length <= 0) continue;
                List<Map<String, Object>> options = null;
                if (i.options().length > 0) {
                    options = this.createIndexKeyMapFrom(i.options());
                }
                if (!i.locale().equals("")) {
                    UtilsMap<String, String> collation = UtilsMap.of("locale", i.locale());
                    collation.put("alternate", i.alternate().mongoText);
                    collation.put("backwards", (String)((Object)Boolean.valueOf(i.backwards())));
                    collation.put("caseFirst", i.caseFirst().mongoText);
                    collation.put("caseLevel", (String)((Object)Boolean.valueOf(i.caseLevel())));
                    collation.put("maxVariable", i.maxVariable().mongoText);
                    collation.put("strength", (String)((Object)Integer.valueOf(i.strength().mongoValue)));
                    options.add(UtilsMap.of("collation", collation));
                }
                List<Map<String, Object>> idx = this.createIndexKeyMapFrom(i.value());
                int cnt = 0;
                for (Map<String, Object> m : idx) {
                    Map<String, Object> optionsMap = null;
                    if (options != null && options.size() > cnt) {
                        optionsMap = options.get(cnt);
                    }
                    if (optionsMap != null && optionsMap.containsKey("")) {
                        optionsMap = null;
                    }
                    if ((optionsMap == null || !optionsMap.containsKey("weights")) && m.containsValue("text")) {
                        if (optionsMap == null) {
                            optionsMap = new HashMap<String, Object>();
                        }
                        Doc weights = Doc.of();
                        for (String k : m.keySet()) {
                            weights.put(k, 1);
                        }
                        optionsMap.put("weights", weights);
                        optionsMap.put("textIndexVersion", 3);
                    }
                    ret.add(IndexDescription.fromMaps(m, optionsMap));
                    ++cnt;
                }
            }
        }
        if ((flds = this.annotationHelper.getFields(type, Index.class)) != null && !flds.isEmpty()) {
            for (String f : flds) {
                i = this.annotationHelper.getField(type, f).getAnnotation(Index.class);
                LinkedHashMap<String, Object> idx = new LinkedHashMap<String, Object>();
                if (i.decrement()) {
                    idx.put(f, -1);
                } else {
                    idx.put(f, 1);
                }
                Map<String, Object> optionsMap = null;
                if (this.createIndexKeyMapFrom(i.options()) != null) {
                    optionsMap = this.createIndexKeyMapFrom(i.options()).get(0);
                }
                ret.add(IndexDescription.fromMaps(idx, optionsMap));
            }
        }
        return ret;
    }

    public int writeBufferCount() {
        return this.config.getWriter().writeBufferCount() + this.config.getBufferedWriter().writeBufferCount();
    }

    public <T> void store(List<T> lst, String collectionName, AsyncOperationCallback<T> callback) {
        if (lst == null || lst.isEmpty()) {
            return;
        }
        this.getWriterForClass(lst.get(0).getClass()).store(lst, collectionName, callback);
    }

    public List<Map<String, Object>> createIndexKeyMapFrom(String[] fldStr) {
        if (fldStr.length == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        for (String f : fldStr) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            for (String idx : f.split(",")) {
                if (idx.contains(":")) {
                    String[] i = idx.split(":");
                    String value = i[1].replaceAll(" ", "");
                    String key = i[0].replaceAll(" ", "");
                    if (value.matches("^['\"].*['\"]$") || value.equals("2d")) {
                        m.put(key, value);
                        continue;
                    }
                    try {
                        int v = Integer.parseInt(value);
                        m.put(key, v);
                    }
                    catch (NumberFormatException e) {
                        try {
                            long l = Long.parseLong(value);
                            m.put(key, l);
                        }
                        catch (NumberFormatException ex) {
                            try {
                                double d = Double.parseDouble(value);
                                m.put(key, d);
                            }
                            catch (NumberFormatException e1) {
                                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                                    m.put(key, Boolean.parseBoolean(value));
                                    continue;
                                }
                                m.put(key, value);
                            }
                        }
                    }
                    continue;
                }
                if ((idx = idx.replaceAll(" ", "")).startsWith("-")) {
                    m.put(idx.substring(1), -1);
                    continue;
                }
                idx = idx.replaceAll("^\\+", "").replaceAll(" ", "");
                m.put(idx, 1);
            }
            lst.add(m);
        }
        return lst;
    }

    public String getDatabase() {
        if (this.getConfig() == null) {
            return null;
        }
        return this.getConfig().getDatabase();
    }

    public void ensureIndex(Class<?> cls, String ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public void ensureIndex(Class<?> cls, Enum ... fldStr) {
        this.ensureIndex((Class)cls, (AsyncOperationCallback)null, fldStr);
    }

    public <T> void insert(T o) {
        if (o instanceof List) {
            this.insertList((List)o, null);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), null);
        } else {
            this.insert(o, null);
        }
    }

    public <T> void insert(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), callback);
        } else {
            this.insert(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    public <T> void insert(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.insertList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.insertList(new ArrayList((Collection)o), collection, callback);
        } else {
            this.getWriterForClass(o.getClass()).insert(o, collection, callback);
        }
    }

    public <T> void insertList(List lst, String collection, AsyncOperationCallback<T> callback) {
        HashMap writers = new HashMap();
        HashMap values = new HashMap();
        for (Object o : lst) {
            writers.putIfAbsent(o.getClass(), this.getWriterForClass(o.getClass()));
            values.putIfAbsent(o.getClass(), new ArrayList());
            ((List)values.get(o.getClass())).add(o);
        }
        for (Class cls : writers.keySet()) {
            try {
                ((MorphiumWriter)writers.get(cls)).insert((List)values.get(cls), collection, callback);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T> void insertList(List arrayList, AsyncOperationCallback<T> callback) {
        this.insertList(arrayList, null, callback);
    }

    public <T> void insertList(List arrayList) {
        this.insertList(arrayList, null, null);
    }

    public Map<String, Integer> storeMaps(Class type, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.saveMaps(type, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> saveMaps(Class type, List<Map<String, Object>> lst) throws MorphiumDriverException {
        MongoCommand store = null;
        try {
            MongoConnection con = this.getDriver().getPrimaryConnection(null);
            store = ((StoreMongoCommand)((StoreMongoCommand)new StoreMongoCommand(con).setColl(this.getMapper().getCollectionName(type))).setDb(this.getDatabase())).setDocuments(lst);
            ((StoreMongoCommand)store).execute();
            Map<String, Integer> map = null;
            return map;
        }
        finally {
            if (store != null) {
                store.releaseConnection();
            }
        }
    }

    public Map<String, Integer> storeMaps(String collection, List<Map<String, Object>> lst) throws MorphiumDriverException {
        return this.saveMaps(collection, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> saveMaps(String collection, List<Map<String, Object>> lst) throws MorphiumDriverException {
        MongoCommand store = null;
        try {
            MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
            store = ((StoreMongoCommand)((StoreMongoCommand)new StoreMongoCommand(primaryConnection).setColl(collection)).setDb(this.getDatabase())).setDocuments(lst);
            Map<String, Object> ret = ((StoreMongoCommand)store).execute();
            HashMap<String, Integer> res = new HashMap<String, Integer>();
            res.put("stored", (Integer)ret.get("stored"));
            HashMap<String, Integer> hashMap = res;
            return hashMap;
        }
        finally {
            if (store != null) {
                store.releaseConnection();
            }
        }
    }

    public Map<String, Integer> storeMap(String collection, Map<String, Object> m) throws MorphiumDriverException {
        return this.saveMap(collection, m);
    }

    public Map<String, Integer> saveMap(String collection, Map<String, Object> m) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
        StoreMongoCommand settings = ((StoreMongoCommand)((StoreMongoCommand)new StoreMongoCommand(primaryConnection).setDb(this.getDatabase())).setColl(collection)).setDocuments(Arrays.asList(Doc.of(m)));
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        Map<String, Object> result = settings.execute();
        settings.releaseConnection();
        res.put("stored", (Integer)result.get("stored"));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> storeMap(Class type, Map<String, Object> m) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
        StoreMongoCommand settings = ((StoreMongoCommand)((StoreMongoCommand)new StoreMongoCommand(primaryConnection).setDb(this.getDatabase())).setColl(this.getMapper().getCollectionName(type))).setDocuments(Arrays.asList(m));
        try {
            WriteConcern wc = this.getWriteConcernForClass(type);
            if (wc != null) {
                settings.setWriteConcern(wc.asMap());
            }
            Map<String, Object> ret = settings.execute();
            settings.releaseConnection();
            settings = null;
            Map<String, Object> map = ret;
            return map;
        }
        finally {
            if (settings != null) {
                settings.releaseConnection();
            }
        }
    }

    public <T> void store(T o) {
        this.save(o);
    }

    public <T> void save(T o) {
        if (o instanceof List) {
            this.saveList((List)o);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o));
        } else {
            this.save(o, this.getMapper().getCollectionName(o.getClass()), null);
        }
    }

    public <T> void store(T o, AsyncOperationCallback<T> callback) {
        this.save(o, callback);
    }

    public <T> void save(T o, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.saveList((List)o, callback);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o), callback);
        } else {
            this.save(o, this.getMapper().getCollectionName(o.getClass()), callback);
        }
    }

    public <T> void store(T o, String collection, AsyncOperationCallback<T> callback) {
        this.save(o, collection, callback);
    }

    public <T> void save(T o, String collection, AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.saveList((List)o, collection, callback);
        } else if (o instanceof Collection) {
            this.saveList(new ArrayList((Collection)o), collection, callback);
        }
        if (this.getARHelper().getId(o) != null) {
            this.getWriterForClass(o.getClass()).store(o, collection, callback);
        } else {
            this.getWriterForClass(o.getClass()).insert(o, collection, callback);
        }
    }

    public <T> void save(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void store(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void storeList(List<T> lst, String collection) {
        this.saveList(lst, collection, null);
    }

    public <T> void saveList(List<T> lst, String collection) {
        this.saveList(lst, collection, null);
    }

    public <T> void storeList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
        this.saveList(lst, collection, callback);
    }

    public <T> void saveList(List<T> lst, String collection, AsyncOperationCallback<T> callback) {
        HashMap writers = new HashMap();
        HashMap values = new HashMap();
        for (T o : lst) {
            writers.putIfAbsent(o.getClass(), this.getWriterForClass(o.getClass()));
            values.putIfAbsent(o.getClass(), new ArrayList());
            ((List)values.get(o.getClass())).add(o);
        }
        for (Class cls : writers.keySet()) {
            try {
                ((MorphiumWriter)writers.get(cls)).store((List)values.get(cls), collection, callback);
            }
            catch (Exception e) {
                log.error("AWrite failed for " + cls.getName() + " lst of size " + ((List)values.get(cls)).size(), (Throwable)e);
                if (callback == null) continue;
                callback.onOperationError(AsyncOperationType.WRITE, null, 0L, e.getMessage(), e, null, cls);
            }
        }
    }

    public <T> void storeList(List<T> lst) {
        this.saveList(lst);
    }

    public <T> void saveList(List<T> lst) {
        this.saveList(lst, (AsyncOperationCallback)null);
    }

    public <T> void storeList(Set<T> set) {
        this.saveList(set);
    }

    public <T> void saveList(Set<T> set) {
        this.saveList(new ArrayList<T>(set), (AsyncOperationCallback)null);
    }

    public <T> void storeList(List<T> lst, AsyncOperationCallback<T> callback) {
        this.saveList(lst, callback);
    }

    public <T> void saveList(List<T> lst, AsyncOperationCallback<T> callback) {
        ArrayList<T> storeDirect = new ArrayList<T>();
        ArrayList<T> insertDirect = new ArrayList<T>();
        if (this.isWriteBufferEnabledForThread()) {
            ArrayList<T> storeInBg = new ArrayList<T>();
            ArrayList<T> insertInBg = new ArrayList<T>();
            for (T o : lst) {
                if (this.annotationHelper.isBufferedWrite(this.getARHelper().getRealClass(o.getClass()))) {
                    if (this.getARHelper().getId(o) == null) {
                        insertInBg.add(o);
                        continue;
                    }
                    storeInBg.add(o);
                    continue;
                }
                if (this.getARHelper().getId(o) == null) {
                    insertDirect.add(o);
                    continue;
                }
                storeDirect.add(o);
            }
            this.config.getBufferedWriter().store(storeInBg, callback);
            this.config.getWriter().store(storeDirect, callback);
            this.config.getBufferedWriter().insert(insertInBg, callback);
            this.config.getWriter().insert(insertDirect, callback);
        } else {
            for (T o : lst) {
                if (this.getARHelper().getId(o) == null) {
                    insertDirect.add(o);
                    continue;
                }
                storeDirect.add(o);
            }
            this.config.getWriter().store(storeDirect, callback);
            this.config.getWriter().insert(insertDirect, callback);
        }
    }

    public <T> Map<String, Object> delete(Query<T> o) {
        return this.remove(o);
    }

    public <T> Map<String, Object> explainRemove(Query<T> q) {
        return this.config.getWriter().explainRemove(null, q);
    }

    public <T> Map<String, Object> remove(Query<T> o) {
        return this.getWriterForClass(o.getType()).remove(o, null);
    }

    public <T> Map<String, Object> delete(Query<T> o, AsyncOperationCallback<T> callback) {
        return this.remove(o, callback);
    }

    public <T> Map<String, Object> remove(Query<T> o, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(o.getType()).remove(o, callback);
    }

    public <T> Map<String, Object> pushPull(boolean push, Query<T> query, String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPull(push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pushPullAll(boolean push, Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPullAll(push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public <T> Map<String, Object> pullAll(Query<T> query, String field, List<?> value, boolean upsert, boolean multiple, AsyncOperationCallback<T> callback) {
        return this.getWriterForClass(query.getType()).pushPullAll(MorphiumStorageListener.UpdateTypes.PULL, query, field, value, upsert, multiple, callback);
    }

    public void remove(Object o) {
        this.remove(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void delete(Object o) {
        this.remove(o, this.getMapper().getCollectionName(o.getClass()));
    }

    public void remove(Object o, String collection) {
        this.getWriterForClass(o.getClass()).remove(o, collection, null);
    }

    public void delete(Object o, String collection) {
        this.remove(o, collection);
    }

    public <T> void delete(T lo, AsyncOperationCallback<T> callback) {
        this.remove(lo, callback);
    }

    public <T> Map<String, Object> explainRemove(ExplainCommand.ExplainVerbosity verbosity, T o) {
        return this.config.getWriter().explainRemove(verbosity, o, this.getMapper().getCollectionName(o.getClass()));
    }

    public <T> void remove(T lo, AsyncOperationCallback<T> callback) {
        if (lo instanceof Query) {
            this.remove((Query)lo, callback);
            return;
        }
        this.getWriterForClass(lo.getClass()).remove(lo, this.getMapper().getCollectionName(lo.getClass()), callback);
    }

    public <T> void delete(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.remove(lo, collection, callback);
    }

    public <T> void remove(T lo, String collection, AsyncOperationCallback<T> callback) {
        this.getWriterForClass(lo.getClass()).remove(lo, collection, callback);
    }

    public boolean exists(String db) throws MorphiumDriverException {
        MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
        ListDatabasesCommand cmd = new ListDatabasesCommand(primaryConnection);
        List<Map<String, Object>> dbs = cmd.getList();
        cmd.releaseConnection();
        for (Map<String, Object> l : dbs) {
            if (!l.get("name").equals(db)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String db, String col) throws MorphiumDriverException {
        return this.getDriver().listCollections(db, col).size() != 0;
    }

    public boolean exists(Class<?> cls) throws MorphiumDriverException {
        return this.exists(this.getDatabase(), this.getMapper().getCollectionName(cls));
    }

    public Map<String, Double> getStatistics() {
        return new Statistics(this);
    }

    public void resetStatistics() {
        HashMap<StatisticKeys, StatisticValue> s = new HashMap<StatisticKeys, StatisticValue>();
        for (StatisticKeys k : StatisticKeys.values()) {
            s.put(k, new StatisticValue());
        }
        this.stats = s;
    }

    public Map<StatisticKeys, StatisticValue> getStats() {
        return this.stats;
    }

    public List<ShutdownListener> getShutDownListeners() {
        return this.shutDownListeners;
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutDownListeners.add(l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutDownListeners.remove(l);
    }

    @Override
    public void close() {
        if (this.asyncOperationsThreadPool != null) {
            this.asyncOperationsThreadPool.shutdownNow();
        }
        this.asyncOperationsThreadPool = null;
        for (ShutdownListener l : this.shutDownListeners) {
            l.onShutdown(this);
        }
        if (this.rsMonitor != null) {
            this.rsMonitor.terminate();
            this.rsMonitor = null;
        }
        if (this.config != null) {
            this.config.getAsyncWriter().close();
            this.config.getBufferedWriter().close();
            this.config.getWriter().close();
        }
        if (this.morphiumDriver != null) {
            try {
                this.morphiumDriver.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.morphiumDriver = null;
        }
        if (this.config != null) {
            if (this.config.getCache() != null) {
                this.config.getCache().resetCache();
                this.config.getCache().close();
            }
            this.config.setBufferedWriter(null);
            this.config.setAsyncWriter(null);
            this.config.setWriter(null);
            this.config = null;
        }
    }

    public String createCamelCase(String n) {
        return this.annotationHelper.createCamelCase(n, false);
    }

    public <T> Map<String, Object> explainMapReduce(Class<? extends T> type, String map, String reduce, ExplainCommand.ExplainVerbosity verbose) throws MorphiumDriverException {
        MongoConnection readConnection = this.morphiumDriver.getReadConnection(this.getReadPreferenceForClass(type));
        MapReduceCommand mr = ((MapReduceCommand)((MapReduceCommand)new MapReduceCommand(readConnection).setDb(this.getDatabase())).setColl(this.getMapper().getCollectionName(type))).setMap(map).setReduce(reduce);
        mr.releaseConnection();
        return mr.explain(verbose);
    }

    public <T> List<T> mapReduce(Class<? extends T> type, String map, String reduce) throws MorphiumDriverException {
        MongoConnection readConnection = this.morphiumDriver.getReadConnection(this.getReadPreferenceForClass(type));
        MapReduceCommand mr = ((MapReduceCommand)((MapReduceCommand)new MapReduceCommand(readConnection).setDb(this.getDatabase())).setColl(this.getMapper().getCollectionName(type))).setMap(map).setReduce(reduce);
        List<Map<String, Object>> result = mr.execute();
        mr.releaseConnection();
        ArrayList<T> ret = new ArrayList<T>();
        for (Map<String, Object> o : result) {
            ret.add(this.getMapper().deserialize(type, (Map)o.get("value")));
        }
        return ret;
    }

    public <T, R> Aggregator<T, R> createAggregator(Class<? extends T> type, Class<? extends R> resultType) {
        Aggregator<? extends T, ? extends R> aggregator = this.getDriver().createAggregator(this, type, resultType);
        return aggregator;
    }

    public <T> T createLazyLoadedEntity(Class<? extends T> cls, Object id, String collectionName) {
        return (T)Enhancer.create(cls, (Class[])new Class[]{Serializable.class}, new LazyDeReferencingProxy<T>(this, cls, id, collectionName));
    }

    public int getWriteBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount() + this.config.getWriter().writeBufferCount() + this.config.getAsyncWriter().writeBufferCount();
    }

    public int getBufferedWriterBufferCount() {
        return this.config.getBufferedWriter().writeBufferCount();
    }

    public int getAsyncWriterBufferCount() {
        return this.config.getAsyncWriter().writeBufferCount();
    }

    public int getWriterBufferCount() {
        return this.config.getWriter().writeBufferCount();
    }

    public void disableAutoValuesForThread() {
        this.enableAutoValues.set(false);
    }

    public void enableAutoValuesForThread() {
        this.enableAutoValues.set(true);
    }

    public boolean isAutoValuesEnabledForThread() {
        return (this.enableAutoValues.get() == null || this.enableAutoValues.get() != false) && this.config.isAutoValuesEnabled();
    }

    public void disableReadCacheForThread() {
        this.enableReadCache.set(false);
    }

    public void enableReadCacheForThread() {
        this.enableReadCache.set(true);
    }

    public boolean isReadCacheEnabledForThread() {
        return (this.enableReadCache.get() == null || this.enableReadCache.get() != false) && this.config.isReadCacheEnabled();
    }

    public void disableWriteBufferForThread() {
        this.disableWriteBuffer.set(false);
    }

    public void enableWriteBufferForThread() {
        this.disableWriteBuffer.set(true);
    }

    public boolean isWriteBufferEnabledForThread() {
        return (this.disableWriteBuffer.get() == null || this.disableWriteBuffer.get() != false) && this.config.isBufferedWritesEnabled();
    }

    public void disableAsyncWritesForThread() {
        this.disableAsyncWrites.set(false);
    }

    public void enableAsyncWritesForThread() {
        this.disableAsyncWrites.set(true);
    }

    public boolean isAsyncWritesEnabledForThread() {
        return (this.disableAsyncWrites.get() == null || this.disableAsyncWrites.get() != false) && this.config.isAsyncWritesEnabled();
    }

    public void queueTask(Runnable runnable) {
        boolean queued = false;
        do {
            try {
                this.asyncOperationsThreadPool.execute(runnable);
                queued = true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!queued);
    }

    public int getNumberOfAvailableThreads() {
        return this.asyncOperationsThreadPool.getMaximumPoolSize() - this.asyncOperationsThreadPool.getActiveCount();
    }

    public int getActiveThreads() {
        return this.asyncOperationsThreadPool.getActiveCount();
    }

    public void startTransaction() {
        this.getDriver().startTransaction(false);
    }

    public MorphiumTransactionContext getTransaction() {
        return this.getDriver().getTransactionContext();
    }

    public void setTransaction(MorphiumTransactionContext ctx) {
        this.getDriver().setTransactionContext(ctx);
    }

    public void commitTransaction() {
        try {
            this.getDriver().commitTransaction();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void abortTransaction() {
        try {
            this.getDriver().abortTransaction();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void watchAsync(String collectionName, boolean updateFull, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(collectionName, updateFull, null, lst));
    }

    public <T> void watchAsync(String collectionName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(collectionName, updateFull, pipeline, lst));
    }

    public <T> void watchAsync(Class<T> entity, boolean updateFull, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(entity, updateFull, null, lst));
    }

    public <T> void watchAsync(Class<T> entity, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.asyncOperationsThreadPool.execute(() -> this.watch(entity, updateFull, pipeline, lst));
    }

    public <T> void watch(Class<T> entity, boolean updateFull, ChangeStreamListener lst) {
        this.watch(this.getMapper().getCollectionName(entity), updateFull, null, lst);
    }

    public <T> void watch(Class<T> entity, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watch(this.getMapper().getCollectionName(entity), updateFull, pipeline, lst);
    }

    public <T> void watch(String collectionName, boolean updateFull, ChangeStreamListener lst) {
        this.watch(collectionName, this.config.getMaxWaitTime(), updateFull, null, lst);
    }

    public <T> void watch(String collectionName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        this.watch(collectionName, this.config.getMaxWaitTime(), updateFull, pipeline, lst);
    }

    public <T> void watch(String collectionName, int maxWaitTime, boolean updateFull, List<Map<String, Object>> pipeline, final ChangeStreamListener lst) {
        try {
            MongoConnection primaryConnection = this.getDriver().getPrimaryConnection(null);
            WatchCommand settings = ((WatchCommand)((WatchCommand)new WatchCommand(primaryConnection).setDb(this.config.getDatabase())).setColl(collectionName)).setMaxTimeMS(maxWaitTime).setPipeline(pipeline).setFullDocument(updateFull ? WatchCommand.FullDocumentEnum.updateLookup : WatchCommand.FullDocumentEnum.defaultValue).setCb(new DriverTailableIterationCallback(){
                boolean b = true;

                @Override
                public void incomingData(Map<String, Object> data, long dur) {
                    this.b = Morphium.this.processEvent(lst, data);
                }

                @Override
                public boolean isContinued() {
                    return this.b;
                }
            });
            this.getDriver().watch(settings);
            settings.releaseConnection();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean processEvent(ChangeStreamListener lst, Map<String, Object> doc) {
        Map obj = (Map)doc.get("fullDocument");
        doc.remove("fullDocument");
        ChangeStreamEvent evt = this.getMapper().deserialize(ChangeStreamEvent.class, doc);
        evt.setFullDocument(obj);
        return lst.incomingData(evt);
    }

    public <T> AtomicBoolean watchDbAsync(String dbName, boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        AtomicBoolean runningFlag = new AtomicBoolean(true);
        this.asyncOperationsThreadPool.execute(() -> {
            this.watchDb(dbName, updateFull, null, runningFlag, lst);
            log.debug("watch async finished");
        });
        return runningFlag;
    }

    public <T> AtomicBoolean watchDbAsync(boolean updateFull, AtomicBoolean runningFlag, ChangeStreamListener lst) {
        return this.watchDbAsync(this.config.getDatabase(), updateFull, null, lst);
    }

    public <T> AtomicBoolean watchDbAsync(boolean updateFull, List<Map<String, Object>> pipeline, ChangeStreamListener lst) {
        return this.watchDbAsync(this.config.getDatabase(), updateFull, pipeline, lst);
    }

    public <T> void watchDb(boolean updateFull, ChangeStreamListener lst) {
        this.watchDb(this.getConfig().getDatabase(), updateFull, lst);
    }

    public <T> void watchDb(String dbName, boolean updateFull, ChangeStreamListener lst) {
        this.watchDb(dbName, this.getConfig().getMaxWaitTime(), updateFull, null, new AtomicBoolean(true), lst);
    }

    public <T> void watchDb(String dbName, boolean updateFull, List<Map<String, Object>> pipeline, AtomicBoolean runningFlag, ChangeStreamListener lst) {
        this.watchDb(dbName, this.getConfig().getMaxWaitTime(), updateFull, pipeline, runningFlag, lst);
    }

    public <T> void watchDb(String dbName, int maxWaitTime, boolean updateFull, List<Map<String, Object>> pipeline, final AtomicBoolean runningFlag, final ChangeStreamListener lst) {
        MongoCommand cmd = null;
        try {
            MongoConnection con = this.getDriver().getPrimaryConnection(null);
            cmd = ((WatchCommand)new WatchCommand(con).setDb(dbName)).setMaxTimeMS(maxWaitTime).setFullDocument(updateFull ? WatchCommand.FullDocumentEnum.updateLookup : WatchCommand.FullDocumentEnum.defaultValue).setPipeline(pipeline).setCb(new DriverTailableIterationCallback(){

                @Override
                public void incomingData(Map<String, Object> data, long dur) {
                    ChangeStreamEvent evt = Morphium.this.getMapper().deserialize(ChangeStreamEvent.class, data);
                    if (!lst.incomingData(evt)) {
                        runningFlag.set(false);
                    }
                }

                @Override
                public boolean isContinued() {
                    return runningFlag.get();
                }
            });
            ((WatchCommand)cmd).watch();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    public void reset() {
        MorphiumConfig cfg = this.getConfig();
        if (this.lst != null) {
            this.listeners.remove(this.lst);
        }
        this.close();
        this.setConfig(cfg);
        this.initializeAndConnect();
    }

    public List<IndexDescription> getMissingIndicesFor(Class<?> entity) throws MorphiumDriverException {
        return this.getMissingIndicesFor(entity, this.objectMapper.getCollectionName(entity));
    }

    public List<IndexDescription> getMissingIndicesFor(Class<?> entity, String collection) throws MorphiumDriverException {
        ArrayList<IndexDescription> missingIndexDef = new ArrayList<IndexDescription>();
        List<IndexDescription> fromMongo = this.getIndexesFromMongo(collection);
        List<IndexDescription> fromJava = this.getIndexesFromEntity(entity);
        for (IndexDescription idx : fromJava) {
            if (fromMongo.contains(idx)) continue;
            missingIndexDef.add(idx);
        }
        return missingIndexDef;
    }

    public Map<Class<?>, List<IndexDescription>> checkIndices() {
        return this.checkIndices(null);
    }

    public Map<Class<?>, Map<String, Integer>> checkCapped() {
        HashMap uncappedCollections = new HashMap();
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableClassInfo().scan();){
            ClassInfoList entities = scanResult.getClassesWithAnnotation(Capped.class.getName());
            for (String cn : entities.getNames()) {
                try {
                    if (cn.startsWith("sun.") || cn.startsWith("com.sun.") || cn.startsWith("org.assertj.") || cn.startsWith("javax.")) continue;
                    log.debug("Cap-Checking " + cn);
                    Class<?> entity = Class.forName(cn);
                    if (this.annotationHelper.getAnnotationFromHierarchy(entity, Entity.class) == null || !this.annotationHelper.isAnnotationPresentInHierarchy(entity, Capped.class) || this.morphiumDriver.isCapped(this.getConfig().getDatabase(), this.getMapper().getCollectionName(entity))) continue;
                    Capped capped = this.annotationHelper.getAnnotationFromClass(entity, Capped.class);
                    uncappedCollections.put(entity, UtilsMap.of("max", capped.maxEntries(), "size", capped.maxSize()));
                }
                catch (Exception e) {
                    log.error("error", (Throwable)e);
                }
            }
        }
        return uncappedCollections;
    }

    public Map<Class<?>, List<IndexDescription>> checkIndices(ClassInfoList.ClassInfoFilter filter) {
        HashMap missingIndicesByClass = new HashMap();
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableClassInfo().scan();){
            ClassInfoList entities = scanResult.getClassesWithAnnotation(Entity.class.getName());
            if (filter != null) {
                entities = entities.filter(filter);
            }
            for (String cn : entities.getNames()) {
                try {
                    Class<?> entity;
                    if (cn.startsWith("sun.") || cn.startsWith("com.sun.") || cn.startsWith("org.assertj.") || cn.startsWith("javax.") || this.annotationHelper.getAnnotationFromHierarchy(entity = Class.forName(cn), Entity.class) == null) continue;
                    if (this.exists(this.getDatabase(), this.getMapper().getCollectionName(entity))) {
                        List<IndexDescription> missing = this.getMissingIndicesFor(entity);
                        if (missing == null || missing.isEmpty()) continue;
                        missingIndicesByClass.put(entity, missing);
                        continue;
                    }
                    missingIndicesByClass.put(entity, this.getIndexesFromEntity(entity));
                }
                catch (Throwable e) {
                    if (e.getMessage().contains("Error: 26 - ns does not exist:")) continue;
                    log.error("Could not check indices for " + cn, e);
                }
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return missingIndicesByClass;
    }

    public String toString() {
        return "Morphium: Driver " + this.getDriver().getName() + " - " + String.join((CharSequence)",", this.getConfig().getHostSeed());
    }
}

