/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Aliases;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.IgnoreFields;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.LimitToFields;
import de.caluga.morphium.annotations.Property;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.annotations.caching.AsyncWrites;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.driver.MorphiumId;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationAndReflectionHelper {
    private final Logger logger = LoggerFactory.getLogger(AnnotationAndReflectionHelper.class);
    private final Map<Class<?>, Class<?>> realClassCache;
    private final Map<Class<?>, List<Field>> fieldListCache;
    private final ConcurrentHashMap<Class<?>, Map<Class<? extends Annotation>, Annotation>> annotationCache;
    private final Map<Class<?>, Map<String, String>> fieldNameCache;
    private static ConcurrentHashMap<String, String> classNameByType;
    private Map<String, Field> fieldCache;
    private Map<String, List<String>> fieldAnnotationListCache;
    private Map<Class<?>, Map<Class<? extends Annotation>, Method>> lifeCycleMethods;
    private Map<Class<?>, Boolean> hasAdditionalData;
    private final boolean ccc;

    public AnnotationAndReflectionHelper(boolean convertCamelCase) {
        this(convertCamelCase, new HashMap());
    }

    public AnnotationAndReflectionHelper(boolean convertCamelCase, Map<Class<?>, Class<?>> realClassCache) {
        this.ccc = convertCamelCase;
        this.realClassCache = realClassCache;
        this.fieldListCache = new ConcurrentHashMap();
        this.fieldCache = new ConcurrentHashMap<String, Field>();
        this.fieldAnnotationListCache = new ConcurrentHashMap<String, List<String>>();
        this.lifeCycleMethods = new ConcurrentHashMap();
        this.hasAdditionalData = new ConcurrentHashMap();
        this.annotationCache = new ConcurrentHashMap();
        this.fieldNameCache = new ConcurrentHashMap();
        if (classNameByType == null) {
            classNameByType = new ConcurrentHashMap();
            this.init();
        }
    }

    private void init() {
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().scan();){
            ClassInfoList entities = scanResult.getClassesWithAnnotation(Entity.class.getName());
            entities.addAll((Collection)scanResult.getClassesWithAnnotation(Embedded.class.getName()));
            this.logger.info("Found " + entities.size() + " entities in classpath");
            for (String cn : entities.getNames()) {
                ClassInfo ci = scanResult.getClassInfo(cn);
                AnnotationInfoList an = ci.getAnnotationInfo();
                for (AnnotationInfo ai : an) {
                    String name = ai.getName();
                    if (!name.equals(Entity.class.getName()) && !name.equals(Embedded.class.getName())) continue;
                    for (AnnotationParameterValue param : ai.getParameterValues()) {
                        if (param.getName().equals("typeId")) {
                            classNameByType.put(param.getValue().toString(), cn);
                        }
                        classNameByType.put(cn, cn);
                    }
                }
            }
        }
    }

    public String getTypeIdForClassName(String n) throws ClassNotFoundException {
        return this.getTypeIdForClass(Class.forName(n));
    }

    public String getTypeIdForClass(Class cls) {
        cls = this.getRealClass(cls);
        Entity e = cls.getAnnotation(Entity.class);
        Embedded em = cls.getAnnotation(Embedded.class);
        if (e != null && !e.typeId().equals(".")) {
            return e.typeId();
        }
        if (em != null && !em.typeId().equals(".")) {
            return em.typeId();
        }
        return cls.getName();
    }

    public Class getClassForTypeId(String typeId) throws ClassNotFoundException {
        if (classNameByType.containsKey(typeId)) {
            return Class.forName(classNameByType.get(typeId));
        }
        return Class.forName(typeId);
    }

    public <T extends Annotation> boolean isAnnotationPresentInHierarchy(Class<?> aClass, Class<? extends T> annotationClass) {
        return this.getAnnotationFromHierarchy(aClass, annotationClass) != null;
    }

    public boolean isAnnotationOnAnyField(Class<?> aClass, Class<? extends Annotation> annotationClass) {
        for (Field f : this.getAllFields(aClass)) {
            if (f.getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T getAnnotationFromHierarchy(Class<?> superClass, Class<? extends T> annotationClass) {
        if (superClass == null) {
            return null;
        }
        Class<?> aClass = this.getRealClass(superClass);
        Map<Class<? extends Annotation>, Annotation> cacheForClass = this.annotationCache.get(aClass);
        if (cacheForClass != null && cacheForClass.containsKey(annotationClass)) {
            return (T)cacheForClass.get(annotationClass);
        }
        T annotation = aClass.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = this.annotationOfClassHierarchy(aClass, annotationClass);
        }
        this.annotationCache.computeIfAbsent(aClass, k -> new HashMap()).put(annotationClass, annotation);
        return annotation;
    }

    private <T extends Annotation> T annotationOfClassHierarchy(Class<?> aClass, Class<? extends T> annotationClass) {
        T annotation = null;
        Class<?> tmpClass = aClass;
        while (!tmpClass.equals(Object.class)) {
            T t = tmpClass.getAnnotation(annotationClass);
            annotation = t;
            if (t != null) {
                return annotation;
            }
            if ((tmpClass = tmpClass.getSuperclass()) != null) continue;
        }
        ArrayDeque interfaces = new ArrayDeque();
        Collections.addAll(interfaces, aClass.getInterfaces());
        while (!interfaces.isEmpty()) {
            Class anInterface = (Class)interfaces.pollFirst();
            if (anInterface == null) continue;
            T t = anInterface.getAnnotation(annotationClass);
            annotation = t;
            if (t != null) {
                return annotation;
            }
            Collections.addAll(interfaces, anInterface.getInterfaces());
        }
        return null;
    }

    public <T extends Annotation> T getAnnotationFromClass(Class<?> cls, Class<? extends T> annotationClass) {
        Class<?> aClass = this.getRealClass(cls);
        return aClass.getAnnotation(annotationClass);
    }

    public <T> Class<? extends T> getRealClass(Class<? extends T> superClass) {
        Class<Object> realClass = this.realClassCache.get(superClass);
        if (realClass != null) {
            return realClass;
        }
        realClass = this.isProxy(superClass) ? this.realClassOf(superClass) : superClass;
        this.realClassCache.put(superClass, realClass);
        return realClass;
    }

    public boolean isBufferedWrite(Class<?> aClass) {
        WriteBuffer wb = this.getAnnotationFromHierarchy(aClass, WriteBuffer.class);
        return wb != null && wb.value();
    }

    public boolean hasAdditionalData(Class aClass) {
        if (this.hasAdditionalData.get(aClass) == null) {
            List<String> fields = this.getFields(aClass, AdditionalData.class);
            Map<Class<?>, Boolean> m = this.hasAdditionalData;
            m.put(aClass, fields != null && !fields.isEmpty());
            this.hasAdditionalData = m;
        }
        return this.hasAdditionalData.get(aClass);
    }

    public String getMongoFieldName(Class clz, String field) {
        return this.getMongoFieldName(clz, field, this.isAnnotationOnAnyField(clz, AdditionalData.class));
    }

    public String getMongoFieldName(Class clz, String field, boolean ignoreUnknownField) {
        Class cls = this.getRealClass(clz);
        if (field.contains(".") || field.contains("(") || field.contains("$")) {
            return field;
        }
        if (this.fieldNameCache.containsKey(clz) && this.fieldNameCache.get(clz).get(field) != null) {
            return this.fieldNameCache.get(clz).get(field);
        }
        String ret = field;
        List<Class<?>> inf = Arrays.asList(clz.getInterfaces());
        if (!(inf.contains(List.class) || inf.contains(Map.class) || inf.contains(Collection.class) || inf.contains(Set.class) || clz.isArray())) {
            Annotation p;
            Field f = this.getField(cls, field);
            if (f == null && this.hasAdditionalData(clz)) {
                return field;
            }
            if (f == null) {
                if (ignoreUnknownField) {
                    if (this.ccc) {
                        return this.createCamelCase(field, false);
                    }
                    return field;
                }
                throw new AnnotationAndReflectionException("Field not found " + field + " in cls: " + clz.getName());
            }
            if (f.isAnnotationPresent(Property.class) && !(p = f.getAnnotation(Property.class)).fieldName().equals(".")) {
                return p.fieldName();
            }
            if (f.isAnnotationPresent(Reference.class) && !(p = f.getAnnotation(Reference.class)).fieldName().equals(".")) {
                return p.fieldName();
            }
            if (f.isAnnotationPresent(Id.class)) {
                return "_id";
            }
            ret = f.getName();
            Entity ent = this.getAnnotationFromHierarchy(cls, Entity.class);
            Embedded emb = this.getAnnotationFromHierarchy(cls, Embedded.class);
            if (this.ccc && ent != null && ent.translateCamelCase() || this.ccc && emb != null && emb.translateCamelCase()) {
                ret = this.convertCamelCase(ret);
            }
        }
        this.fieldNameCache.computeIfAbsent(cls, k -> new HashMap()).put(field, ret);
        return ret;
    }

    public String createCamelCase(String n, boolean capitalize) {
        n = n.toLowerCase();
        String[] f = n.split("_");
        StringBuilder sb = new StringBuilder(f[0].substring(0, 1).toLowerCase());
        sb.append(f[0].substring(1));
        for (int i = 1; i < f.length; ++i) {
            sb.append(f[i].substring(0, 1).toUpperCase());
            sb.append(f[i].substring(1));
        }
        Object ret = sb.toString();
        if (capitalize) {
            ret = ((String)ret).substring(0, 1).toUpperCase() + ((String)ret).substring(1);
        }
        return ret;
    }

    public String convertCamelCase(String n) {
        if (!this.ccc) {
            return n;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n.length(); ++i) {
            if (Character.isUpperCase(n.charAt(i)) && i > 0) {
                b.append("_");
            }
            b.append(n.substring(i, i + 1).toLowerCase());
        }
        return b.toString();
    }

    public List<Field> getAllFields(Class clz) {
        if (this.fieldListCache.containsKey(clz)) {
            return this.fieldListCache.get(clz);
        }
        Class cls = this.getRealClass(clz);
        ArrayList<Field> ret = new ArrayList<Field>();
        Class sc = cls;
        ArrayList hierachy = new ArrayList();
        while (!sc.equals(Object.class)) {
            hierachy.add(sc);
            sc = sc.getSuperclass();
        }
        Collections.addAll(hierachy, cls.getInterfaces());
        for (Class clazz : hierachy) {
            Field[] declaredFields = clazz.getDeclaredFields();
            if (declaredFields.length <= 0) continue;
            for (Field declaredField : declaredFields) {
                if (declaredField.getName().startsWith("$jacoco")) continue;
                ret.add(declaredField);
            }
        }
        this.fieldListCache.put(clz, ret);
        return ret;
    }

    public Field getField(Class clz, String fld) {
        String key = clz.toString() + "->" + fld;
        Field val = this.fieldCache.get(key);
        if (val != null) {
            return val;
        }
        Map<String, Field> fc = this.fieldCache;
        Class cls = this.getRealClass(clz);
        List<Field> flds = this.getAllFields(cls);
        Field ret = null;
        for (Field f : flds) {
            if (f.isAnnotationPresent(Property.class) && !".".equals(f.getAnnotation(Property.class).fieldName()) && f.getAnnotation(Property.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.isAnnotationPresent(Reference.class) && !".".equals(f.getAnnotation(Reference.class).fieldName()) && f.getAnnotation(Reference.class).fieldName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.isAnnotationPresent(Aliases.class)) {
                String[] v;
                Aliases aliases = f.getAnnotation(Aliases.class);
                for (String field : v = aliases.value()) {
                    if (!field.equals(fld)) continue;
                    f.setAccessible(true);
                    fc.put(key, f);
                    ret = f;
                }
            }
            if (ret == null && fld.equals("_id") && f.isAnnotationPresent(Id.class)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && f.getName().equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null && this.ccc && this.convertCamelCase(f.getName()).equals(fld)) {
                f.setAccessible(true);
                fc.put(key, f);
                ret = f;
            }
            if (ret == null) continue;
            break;
        }
        this.fieldCache = fc;
        return ret;
    }

    public boolean isEntity(Object o) {
        if (o == null) {
            return false;
        }
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        return this.isAnnotationPresentInHierarchy(cls, Entity.class) || this.isAnnotationPresentInHierarchy(cls, Embedded.class);
    }

    public Object getValue(Object o, String fld) {
        if (o == null) {
            return null;
        }
        try {
            Field f = this.getField(o.getClass(), fld);
            if (f == null) {
                return null;
            }
            if (!Modifier.isStatic(f.getModifiers())) {
                o = this.getRealObject(o);
                return f.get(o);
            }
        }
        catch (IllegalAccessException e) {
            this.logger.error("Illegal access to field " + fld + " of type " + o.getClass().getSimpleName());
        }
        return null;
    }

    public void setValue(Object o, Object value, String fld) {
        if (o == null) {
            return;
        }
        try {
            Field field = this.getField(this.getRealClass(o.getClass()), fld);
            if (!Modifier.isStatic(field.getModifiers())) {
                o = this.getRealObject(o);
                try {
                    field.set(o, value);
                }
                catch (Exception e) {
                    if (value != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Setting of value (" + value.getClass().getSimpleName() + ") failed for field " + field.getName() + "- trying type-conversion");
                        }
                        field.set(o, AnnotationAndReflectionHelper.convertType(value, fld, field.getType()));
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Type conversion was successful");
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            this.logger.error("Illegal access to field " + fld + " of toype " + o.getClass().getSimpleName());
        }
    }

    public static Object convertType(Object value, String fieldName, Class<?> fieldType) {
        if (value instanceof Number) {
            Number n = (Number)value;
            if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                return n.intValue();
            }
            if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                return n.longValue();
            }
            if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                return n.doubleValue();
            }
            if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                return Float.valueOf(n.floatValue());
            }
            if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                return n.byteValue();
            }
            if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                return n.shortValue();
            }
            if (fieldType.equals(AtomicInteger.class)) {
                return new AtomicInteger(n.intValue());
            }
            if (fieldType.equals(AtomicLong.class)) {
                return new AtomicLong(n.intValue());
            }
            if (fieldType.equals(Date.class)) {
                return new Date(n.longValue());
            }
            if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                return n.intValue() == 1;
            }
            if (fieldType.equals(String.class)) {
                return n.toString();
            }
            throw AnnotationAndReflectionException.wrongFieldType(fieldName, fieldType.toString(), value.getClass().toString());
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                return b != false ? 1 : 0;
            }
            if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                return b != false ? 1L : 0L;
            }
            if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                return b != false ? 1.0 : 0.0;
            }
            if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                return Float.valueOf(b != false ? 1.0f : 0.0f);
            }
            if (fieldType.equals(Byte.class) || fieldType.equals(Byte.TYPE)) {
                return b != false ? (byte)1 : 0;
            }
            if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
                return b != false ? (short)1 : 0;
            }
            if (fieldType.equals(String.class)) {
                return b != false ? "true" : "false";
            }
            if (fieldType.equals(AtomicBoolean.class)) {
                return new AtomicBoolean(b);
            }
            throw AnnotationAndReflectionException.wrongFieldType(fieldName, fieldType.toString(), value.getClass().toString());
        }
        if (value instanceof Date) {
            Date d = (Date)value;
            if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                return d.getTime();
            }
            if (fieldType.equals(GregorianCalendar.class)) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(d.getTime());
                return cal;
            }
            if (fieldType.equals(String.class)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                return df.format(d);
            }
            if (fieldType.equals(Instant.class)) {
                return d.toInstant();
            }
            if (fieldType.equals(LocalDate.class)) {
                return d.toInstant().atZone(ZoneOffset.UTC).toLocalDate();
            }
            if (fieldType.equals(LocalTime.class)) {
                return d.toInstant().atZone(ZoneOffset.UTC).toLocalTime();
            }
            if (fieldType.equals(LocalDateTime.class)) {
                return d.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
            }
        } else if (value instanceof String) {
            String s = (String)value;
            try {
                if (fieldType.equals(Date.class)) {
                    if (s.length() == 8) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
                        return df.parse(s);
                    }
                    if (s.indexOf(45) > 0) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        return df.parse(s);
                    }
                    if (s.indexOf(46) > 0) {
                        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                        return df.parse(s);
                    }
                    return new Date(Long.parseLong(s));
                }
                if (fieldType.equals(MorphiumId.class)) {
                    return new MorphiumId(s);
                }
            }
            catch (Exception df) {
                // empty catch block
            }
            Method convertMethod = AnnotationAndReflectionHelper.getConvertMethod(fieldType);
            if (convertMethod != null) {
                try {
                    return convertMethod.invoke(null, s);
                }
                catch (Exception exception) {}
            }
        } else {
            if (fieldType.isArray() && value instanceof List) {
                Object arr = Array.newInstance(fieldType, ((List)value).size());
                int idx = 0;
                for (Object io : (List)value) {
                    try {
                        Array.set(arr, idx, io);
                    }
                    catch (Exception e1) {
                        Array.set(arr, idx, ((Integer)io).byteValue());
                    }
                }
                return arr;
            }
            if (value instanceof byte[] && fieldType.equals(UUID.class)) {
                ByteBuffer bb = ByteBuffer.wrap((byte[])value);
                return new UUID(bb.getLong(), bb.getLong());
            }
        }
        throw AnnotationAndReflectionException.wrongFieldType(fieldName, fieldType.toString(), value.getClass().toString());
    }

    public static Method getConvertMethod(Class<?> fieldType) {
        try {
            return fieldType.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                return fieldType.getMethod("valueOf", CharSequence.class);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return fieldType.getMethod("valueOf", Object.class);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        return fieldType.getMethod("parse", String.class);
                    }
                    catch (NoSuchMethodException e3) {
                        try {
                            return fieldType.getMethod("parse", CharSequence.class);
                        }
                        catch (NoSuchMethodException e4) {
                            try {
                                return fieldType.getMethod("parse", Object.class);
                            }
                            catch (NoSuchMethodException e5) {
                                try {
                                    return fieldType.getMethod("fromString", String.class);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    return null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public Object getId(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Field f = this.getIdField(o);
        if (f == null) {
            throw new IllegalArgumentException("Object ID field not found " + o.getClass().getSimpleName());
        }
        try {
            o = this.getRealObject(o);
            if (o != null) {
                return f.get(o);
            }
            this.logger.warn("Illegal reference?");
            return null;
        }
        catch (IllegalAccessException e) {
            throw AnnotationAndReflectionException.of(e);
        }
    }

    public String getIdFieldName(Object o) {
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return flds.get(0);
    }

    public Field getIdField(Object o) {
        Class<Object> cls = o instanceof Class ? this.getRealClass((Class)o) : this.getRealClass(o.getClass());
        List<String> flds = this.getFields(cls, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new IllegalArgumentException("Object has no id defined: " + o.getClass().getSimpleName());
        }
        return this.getField(cls, flds.get(0));
    }

    public List<String> getFields(Class cls, Class<? extends Annotation> ... annotations) {
        return this.getFields(cls, false, annotations);
    }

    public List<String> getFields(Class cls, boolean ignoreEntity, Class<? extends Annotation> ... annotations) {
        if (cls == null) {
            return new ArrayList<String>();
        }
        StringBuilder stringBuilder = new StringBuilder(cls.toString());
        for (Class<? extends Annotation> a : annotations) {
            stringBuilder.append("/");
            stringBuilder.append(a.toString());
        }
        List<String> strings = this.fieldAnnotationListCache.get(stringBuilder.toString());
        if (strings != null) {
            return strings;
        }
        Map<String, List<String>> fa = this.fieldAnnotationListCache;
        ArrayList<String> ret = new ArrayList<String>();
        Class sc = cls;
        sc = this.getRealClass(sc);
        Entity entity = this.getAnnotationFromHierarchy(sc, Entity.class);
        Embedded embedded = this.getAnnotationFromHierarchy(sc, Embedded.class);
        if (embedded != null && entity != null && !ignoreEntity) {
            this.logger.warn("Class " + cls.getName() + " does have both @Entity and @Embedded Annotations - not allowed! Assuming @Entity is right");
        }
        boolean tcc = true;
        if (embedded != null) {
            tcc = embedded.translateCamelCase();
        }
        if (entity != null) {
            tcc = entity.translateCamelCase();
        }
        IgnoreFields ignoreFields = this.getAnnotationFromHierarchy(sc, IgnoreFields.class);
        LimitToFields limitToFields = this.getAnnotationFromHierarchy(sc, LimitToFields.class);
        ArrayList<String> fieldsToIgnore = new ArrayList<String>();
        ArrayList<String> ignoreContains = new ArrayList<String>();
        ArrayList<Pattern> ignoreRexex = new ArrayList<Pattern>();
        if (ignoreFields != null && ignoreFields.value().length != 0) {
            for (String string : ignoreFields.value()) {
                if (string.startsWith("~")) {
                    ignoreContains.add(string.substring(1));
                    continue;
                }
                if (string.startsWith("/") && string.endsWith("/")) {
                    ignoreRexex.add(Pattern.compile(string.substring(1).substring(0, string.length() - 2)));
                    continue;
                }
                fieldsToIgnore.add(string);
            }
        }
        ArrayList<String> fieldsToLimitTo = new ArrayList<String>();
        if (limitToFields != null && limitToFields.value().length != 0) {
            fieldsToLimitTo.addAll(Arrays.asList(limitToFields.value()));
        }
        if (limitToFields != null && !limitToFields.type().equals(Object.class)) {
            List<Field> flds = this.getAllFields(limitToFields.type());
            for (Field field : flds) {
                fieldsToLimitTo.add(this.getMongoFieldName(limitToFields.type(), field.getName()));
            }
        }
        List<Field> fld = this.getAllFields(cls);
        for (Field field : fld) {
            if (annotations.length > 0) {
                boolean found = false;
                for (Class<? extends Annotation> a : annotations) {
                    if (!field.isAnnotationPresent(a)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (field.isAnnotationPresent(Reference.class) && !".".equals(field.getAnnotation(Reference.class).fieldName())) {
                ret.add(field.getAnnotation(Reference.class).fieldName());
                continue;
            }
            if (field.isAnnotationPresent(Property.class) && !".".equals(field.getAnnotation(Property.class).fieldName())) {
                ret.add(field.getAnnotation(Property.class).fieldName());
                continue;
            }
            if (field.isAnnotationPresent(Transient.class)) continue;
            boolean ignore = false;
            String conv = field.getName().replaceAll("\\$", "");
            if (tcc && this.ccc) {
                conv = this.convertCamelCase(field.getName());
            }
            if (fieldsToIgnore.contains(conv) || fieldsToIgnore.contains(field.getName())) {
                ignore = true;
            }
            if (!ignore) {
                for (String ign : ignoreContains) {
                    if (!field.getName().contains(ign) && !conv.contains(ign)) continue;
                    ignore = true;
                    break;
                }
            }
            if (!ignore) {
                for (Pattern reg : ignoreRexex) {
                    if (!reg.matcher(field.getName()).matches() && !reg.matcher(conv).matches()) continue;
                    ignore = true;
                }
            }
            if (!(ignore || fieldsToLimitTo.isEmpty() || fieldsToLimitTo.contains(conv) || fieldsToLimitTo.contains(field.getName()))) {
                ignore = true;
            }
            if (ignore) continue;
            ret.add(conv);
        }
        fa.put(stringBuilder.toString(), ret);
        this.fieldAnnotationListCache = fa;
        return ret;
    }

    public <T> T getRealObject(T o) {
        if (this.isProxy(o.getClass())) {
            try {
                Field f1 = o.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(o);
                Method m = delegate.getClass().getMethod("__getDeref", new Class[0]);
                o = m.invoke(delegate, new Object[0]);
            }
            catch (Exception e) {
                this.logger.error("Exception: ", (Throwable)e);
            }
        }
        return o;
    }

    public final Class getTypeOfField(Class<?> cls, String fld) {
        Field f = this.getField(cls, fld);
        if (f == null) {
            return null;
        }
        return f.getType();
    }

    public boolean storesLastChange(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastChange.class);
    }

    public boolean storesLastAccess(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, LastAccess.class);
    }

    public boolean storesCreation(Class<?> cls) {
        return this.isAnnotationPresentInHierarchy(cls, CreationTime.class);
    }

    public Long getLongValue(Object o, String fld) {
        return (Long)this.getValue(o, fld);
    }

    public String getStringValue(Object o, String fld) {
        return (String)this.getValue(o, fld);
    }

    public Date getDateValue(Object o, String fld) {
        return (Date)this.getValue(o, fld);
    }

    public Double getDoubleValue(Object o, String fld) {
        return (Double)this.getValue(o, fld);
    }

    public List<Annotation> getAllAnnotationsFromHierachy(Class<?> cls, Class<? extends Annotation> ... anCls) {
        cls = this.getRealClass(cls);
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        Class<?> z = cls;
        while (!z.equals(Object.class)) {
            if (z.getAnnotations().length != 0) {
                if (anCls.length == 0) {
                    ret.addAll(Arrays.asList(z.getAnnotations()));
                } else {
                    for (Annotation a : z.getAnnotations()) {
                        for (Class<? extends Annotation> ac : anCls) {
                            if (!a.annotationType().equals(ac)) continue;
                            ret.add(a);
                        }
                    }
                }
            }
            if ((z = z.getSuperclass()) != null) continue;
            break;
        }
        return ret;
    }

    public String getLastChangeField(Class<?> cls) {
        if (!this.storesLastChange(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastChange.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getLastAccessField(Class<?> cls) {
        if (!this.storesLastAccess(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, LastAccess.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getAdditionalDataField(Class<?> cls) {
        List<String> lst = this.getFields(cls, AdditionalData.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public String getCreationTimeField(Class<?> cls) {
        if (!this.storesCreation(cls)) {
            return null;
        }
        List<String> lst = this.getFields(cls, CreationTime.class);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        return lst.get(0);
    }

    public void callLifecycleMethod(Class<? extends Annotation> type, Object on) {
        this.callLifecycleMethod(type, on, new ArrayList());
    }

    private void callLifecycleMethod(Class<? extends Annotation> type, Object on, List calledOn) {
        if (on == null) {
            return;
        }
        if (this.isProxy(on.getClass())) {
            try {
                Field f1 = on.getClass().getDeclaredField("CGLIB$CALLBACK_0");
                f1.setAccessible(true);
                Object delegate = f1.get(on);
                Method m = delegate.getClass().getMethod("__getPureDeref", new Class[0]);
                on = m.invoke(delegate, new Object[0]);
                if (on == null) {
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Exception: ", (Throwable)e);
            }
        }
        if (calledOn.contains(on)) {
            return;
        }
        calledOn.add(on);
        Class<?> cls = on.getClass();
        if (!this.isAnnotationPresentInHierarchy(cls, Lifecycle.class)) {
            return;
        }
        List<String> flds = this.getFields(on.getClass(), new Class[0]);
        for (String string : flds) {
            Field field = this.getField(on.getClass(), string);
            if (!this.isAnnotationPresentInHierarchy(field.getType(), Entity.class) && !this.isAnnotationPresentInHierarchy(field.getType(), Embedded.class) || !this.isAnnotationPresentInHierarchy(field.getType(), Lifecycle.class)) continue;
            field.setAccessible(true);
            try {
                this.callLifecycleMethod(type, field.get(on), calledOn);
            }
            catch (IllegalAccessException e) {
                this.logger.error("Exception: ", (Throwable)e);
            }
        }
        if (this.lifeCycleMethods.get(cls) != null) {
            if (this.lifeCycleMethods.get(cls).get(type) != null) {
                try {
                    this.lifeCycleMethods.get(cls).get(type).invoke(on, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw AnnotationAndReflectionException.of(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause().getClass().equals(MorphiumAccessVetoException.class)) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw AnnotationAndReflectionException.of(e);
                }
            }
            return;
        }
        HashMap<Class<? extends Annotation>, Method> methods = new HashMap<Class<? extends Annotation>, Method>();
        for (Method m : cls.getMethods()) {
            for (Annotation a : m.getAnnotations()) {
                methods.put(a.annotationType(), m);
            }
        }
        Map<Class<?>, Map<Class<Annotation>, Method>> map = this.lifeCycleMethods;
        map.put(cls, methods);
        if (methods.get(type) != null) {
            try {
                ((Method)methods.get(type)).invoke(on, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw AnnotationAndReflectionException.of(e);
            }
        }
        this.lifeCycleMethods = map;
    }

    public boolean isAsyncWrite(Class<?> cls) {
        AsyncWrites wb = this.getAnnotationFromHierarchy(cls, AsyncWrites.class);
        return wb != null && wb.value();
    }

    private <T> boolean isProxy(Class<? extends T> aClass) {
        if (aClass == null) {
            return false;
        }
        return aClass.getName().contains("$$EnhancerByCGLIB$$");
    }

    private <T> Class<?> realClassOf(Class<? extends T> superClass) {
        try {
            return Class.forName(superClass.getName().substring(0, superClass.getName().indexOf("$$")));
        }
        catch (ClassNotFoundException e) {
            throw AnnotationAndReflectionException.of(e);
        }
    }

    private static final class AnnotationAndReflectionException
    extends RuntimeException {
        private AnnotationAndReflectionException(Exception e) {
            super(e);
        }

        private AnnotationAndReflectionException(String message) {
            super(message);
        }

        private static AnnotationAndReflectionException of(Exception e) {
            return new AnnotationAndReflectionException(e);
        }

        private static AnnotationAndReflectionException wrongFieldType(String fieldName, String expectedFieldType, String actualFieldType) {
            String message = String.format("could not set field %s: Field has type %s got type %s", fieldName, expectedFieldType, actualFieldType);
            return new AnnotationAndReflectionException(message);
        }
    }
}

