/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.MongoType;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Reference;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.objectmapping.MorphiumObjectMapper;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.query.geospatial.Geo;
import de.caluga.morphium.query.geospatial.Point;
import de.caluga.morphium.query.geospatial.Polygon;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;

public class MongoFieldImpl<T>
implements MongoField<T> {
    private Query<T> query;
    private MorphiumObjectMapper mapper;
    private String fldStr;
    private boolean not = false;
    private FilterExpression fe;

    public MongoFieldImpl() {
    }

    @Override
    public Query<T> not() {
        this.not = true;
        return this.query;
    }

    public MongoFieldImpl(Query<T> q, MorphiumObjectMapper map) {
        this.query = q;
        this.mapper = map;
    }

    @Override
    public String getFieldString() {
        return this.fldStr;
    }

    @Override
    public void setFieldString(String fldStr) {
        this.fe = new FilterExpression();
        this.fe.setField(fldStr);
        this.fldStr = fldStr;
    }

    @Override
    public MorphiumObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setMapper(MorphiumObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Query<T> all(List<Object> val) {
        this.add("$all", val);
        return this.query;
    }

    @Override
    public Query<T> all(Object ... val) {
        return this.all(Arrays.asList(val));
    }

    @Override
    public Query<T> eq(Object val) {
        val = this.checkValue(val);
        this.addSimple(val);
        return this.query;
    }

    private Object checkValue(Object val) {
        if (val != null) {
            Class<?> cls = val.getClass();
            Field field = this.mapper.getMorphium().getARHelper().getField(this.query.getType(), this.fldStr);
            if ((this.mapper.getMorphium().getARHelper().isAnnotationPresentInHierarchy(cls, Entity.class) || val instanceof MorphiumId) && field.isAnnotationPresent(Reference.class)) {
                Object id;
                if (val instanceof MorphiumId) {
                    id = new ObjectId(val.toString());
                } else if (val instanceof Enum) {
                    id = ((Enum)val).name();
                } else {
                    id = this.mapper.getMorphium().getARHelper().getId(val);
                    if (id instanceof MorphiumId) {
                        id = new ObjectId(id.toString());
                    }
                }
                val = id;
                if (Map.class.isAssignableFrom(field.getType()) || Collection.class.isAssignableFrom(field.getType()) || List.class.isAssignableFrom(field.getType())) {
                    this.fldStr = this.fldStr + ".refid";
                }
            }
            if (field != null) {
                if (val instanceof MorphiumId && field.getType().equals(String.class)) {
                    val = val.toString();
                } else if (val instanceof String && field.getType().equals(MorphiumId.class)) {
                    try {
                        val = new MorphiumId((String)val);
                    }
                    catch (Exception exception) {}
                } else if (val instanceof Enum) {
                    val = ((Enum)val).name();
                }
            }
        }
        return val;
    }

    private void addSimple(Object val) {
        if (this.not) {
            this.fe.setValue(UtilsMap.of("$not", val));
        } else {
            this.fe.setValue(val);
        }
        this.fe.setField(this.mapper.getMorphium().getARHelper().getMongoFieldName(this.query.getType(), this.fldStr));
        this.query.addChild(this.fe);
    }

    private void add(String op, Object value) {
        this.fe.setField(this.mapper.getMorphium().getARHelper().getMongoFieldName(this.query.getType(), this.fldStr));
        FilterExpression child = new FilterExpression();
        child.setField(op);
        if (this.not) {
            child.setValue(UtilsMap.of("$not", value));
        } else {
            child.setValue(value);
        }
        this.fe.addChild(child);
        this.query.addChild(this.fe);
    }

    private void add(List<FilterExpression> expressionList) {
        this.fe.setField(this.mapper.getMorphium().getARHelper().getMongoFieldName(this.query.getType(), this.fldStr));
        this.fe.setChildren(expressionList);
        this.query.addChild(this.fe);
    }

    @Override
    public Query<T> ne(Object val) {
        val = this.checkValue(val);
        this.add("$ne", val);
        return this.query;
    }

    @Override
    public Query<T> size(int val) {
        this.add("$size", val);
        return this.query;
    }

    @Override
    public Query<T> lt(Object val) {
        val = this.checkValue(val);
        this.add("$lt", val);
        return this.query;
    }

    @Override
    public Query<T> lte(Object val) {
        val = this.checkValue(val);
        this.add("$lte", val);
        return this.query;
    }

    @Override
    public Query<T> gt(Object val) {
        val = this.checkValue(val);
        this.add("$gt", val);
        return this.query;
    }

    @Override
    public Query<T> gte(Object val) {
        val = this.checkValue(val);
        this.add("$gte", val);
        return this.query;
    }

    @Override
    public Query<T> exists() {
        this.add("$exists", true);
        return this.query;
    }

    @Override
    public Query<T> notExists() {
        this.add("$exists", false);
        return this.query;
    }

    @Override
    public Query<T> mod(int base, int val) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        lst.add(base);
        lst.add(val);
        this.add("$mod", lst);
        return this.query;
    }

    @Override
    public Query<T> matches(Pattern p) {
        this.add("$regex", p.toString());
        if (p.flags() != 0) {
            Object options = "";
            if ((p.flags() | 2) != 0) {
                options = (String)options + "i";
            } else if ((p.flags() | 8) != 0) {
                options = (String)options + "m";
            }
            if (!((String)options).isEmpty()) {
                this.add("$options", options);
            }
        }
        return this.query;
    }

    @Override
    public Query<T> matches(String ptrn, String options) {
        this.add("$regex", ptrn);
        if (options != null && !options.isEmpty()) {
            this.add("$options", options);
        }
        return this.query;
    }

    @Override
    public Query<T> matches(String ptrn) {
        return this.matches(ptrn, null);
    }

    @Override
    public Query<T> type(MongoType t) {
        this.add("$type", t.getId());
        return this.query;
    }

    @Override
    public Query<T> in(Collection<?> vals) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object v : vals) {
            lst.add(this.checkValue(v));
        }
        this.add("$in", lst);
        return this.query;
    }

    @Override
    public Query<T> nin(Collection<?> vals) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (Object v : vals) {
            lst.add(this.checkValue(v));
        }
        this.add("$nin", lst);
        return this.query;
    }

    private void createGeoWithinFilterExpression(List<Object> lst, String type) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$geoWithin");
        HashMap<String, List<Object>> box = new HashMap<String, List<Object>>();
        box.put(type, lst);
        withinExpression.setValue(box);
        expressionList.add(withinExpression);
        this.add(expressionList);
    }

    @Override
    public Query<T> polygon(double ... p) {
        if (p.length % 2 == 1) {
            throw new IllegalArgumentException("Need a list of coordinates: x,y, x1,y1, x2,y2....");
        }
        ArrayList<Object> lst = new ArrayList<Object>();
        for (int i = 0; i < p.length; i += 2) {
            ArrayList<Double> p1 = new ArrayList<Double>();
            p1.add(p[i]);
            p1.add(p[i + 1]);
            lst.add(p1);
        }
        this.createGeoWithinFilterExpression(lst, "$polygon");
        return this.query;
    }

    @Override
    public Query<T> polygon(Polygon p) {
        this.createGeoWithinFilterExpression((List)p.getCoordinates(), "$polygon");
        return this.query;
    }

    @Override
    public Query<T> geoWithinBox(Double x1, Double y1, Double x2, Double y2) {
        this.createGeoWithinFilterExpression(Arrays.asList(Arrays.asList(x1, y1), Arrays.asList(x2, y2)), "$box");
        return this.query;
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query<T> q) {
        this.query = q;
    }

    @Override
    public Query<T> bitsAllClear(int ... b) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int r : b) {
            lst.add(r);
        }
        this.add("$bitsAllClear", lst);
        return this.query;
    }

    @Override
    public Query<T> bitsAllSet(int ... b) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int r : b) {
            lst.add(r);
        }
        this.add("$bitsAllSet", lst);
        return this.query;
    }

    @Override
    public Query<T> bitsAnyClear(int ... b) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int r : b) {
            lst.add(r);
        }
        this.add("$bitsAnyClear", lst);
        return this.query;
    }

    @Override
    public Query<T> bitsAnySet(int ... b) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        for (int r : b) {
            lst.add(r);
        }
        this.add("$bitsAnySet", lst);
        return this.query;
    }

    @Override
    public Query<T> bitsAllClear(long bitmask) {
        this.add("$bitsAllClear", bitmask);
        return this.query;
    }

    @Override
    public Query<T> bitsAllSet(long bitmask) {
        this.add("$bitsAllSet", bitmask);
        return this.query;
    }

    @Override
    public Query<T> bitsAnyClear(long bitmask) {
        this.add("$bitsAnyClear", bitmask);
        return this.query;
    }

    @Override
    public Query<T> bitsAnySet(long bitmask) {
        this.add("$bitsAnySet", bitmask);
        return this.query;
    }

    @Override
    public Query<T> elemMatch(Map<String, Object> q) {
        this.add("$elemMatch", q);
        return this.query;
    }

    @Override
    public Query<T> elemMatch(Query<?> q) {
        return this.elemMatch(q.toQueryObject());
    }

    @Override
    public Query<T> near(double x, double y) {
        ArrayList<Double> lst = new ArrayList<Double>();
        lst.add(x);
        lst.add(y);
        this.add("$near", lst);
        return this.query;
    }

    @Override
    public Query<T> nearSphere(double x, double y) {
        ArrayList<Double> lst = new ArrayList<Double>();
        lst.add(x);
        lst.add(y);
        this.add("$nearSphere", lst);
        return this.query;
    }

    @Override
    public Query<T> box(double x, double y, double x2, double y2) {
        return this.geoWithinBox(x, y, x2, y2);
    }

    @Override
    public Query<T> center(double x, double y, double r) {
        ArrayList<Serializable> lst = new ArrayList<Serializable>();
        ArrayList<Double> p1 = new ArrayList<Double>();
        p1.add(x);
        p1.add(y);
        lst.add(p1);
        lst.add(Double.valueOf(r));
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$geoWithin");
        HashMap<String, ArrayList<Serializable>> cnt = new HashMap<String, ArrayList<Serializable>>();
        cnt.put("$center", lst);
        withinExpression.setValue(cnt);
        expressionList.add(withinExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> centerSphere(double x, double y, double r) {
        ArrayList<Serializable> lst = new ArrayList<Serializable>();
        ArrayList<Double> p1 = new ArrayList<Double>();
        p1.add(x);
        p1.add(y);
        lst.add(p1);
        lst.add(Double.valueOf(r));
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression withinExpression = new FilterExpression();
        withinExpression.setField("$geoWithin");
        HashMap<String, ArrayList<Serializable>> cnt = new HashMap<String, ArrayList<Serializable>>();
        cnt.put("$centerSphere", lst);
        withinExpression.setValue(cnt);
        expressionList.add(withinExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> nearSphere(double x, double y, double maxDistance) {
        return this.nearSphere(x, y, 0.0, maxDistance);
    }

    @Override
    public Query<T> nearSphere(double x, double y, double minDistance, double maxDistance) {
        ArrayList<Double> location = new ArrayList<Double>();
        location.add(x);
        location.add(y);
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$nearSphere");
        nearExpression.setValue(location);
        expressionList.add(nearExpression);
        FilterExpression maxDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$maxDistance");
        maxDistanceExpression.setValue(maxDistance);
        expressionList.add(maxDistanceExpression);
        FilterExpression minDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$minDistance");
        maxDistanceExpression.setValue(minDistance);
        expressionList.add(maxDistanceExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> nearSpere(Point point, double minDistance, double maxDistance) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$nearSphere");
        UtilsMap<String, Map<String, Object>> val = UtilsMap.of("$geometry", this.mapper.serialize(point));
        val.put("$maxDistance", (Map<String, Object>)maxDistance);
        val.put("$minDistance", (Map<String, Object>)minDistance);
        nearExpression.setValue(val);
        expressionList.add(nearExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> near(double x, double y, double maxDistance) {
        ArrayList<Double> location = new ArrayList<Double>();
        location.add(x);
        location.add(y);
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$near");
        nearExpression.setValue(location);
        expressionList.add(nearExpression);
        FilterExpression maxDistanceExpression = new FilterExpression();
        maxDistanceExpression.setField("$maxDistance");
        maxDistanceExpression.setValue(maxDistance);
        expressionList.add(maxDistanceExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> near(Point point, double minDistance, double maxDistance) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression nearExpression = new FilterExpression();
        nearExpression.setField("$near");
        UtilsMap<String, Map<String, Object>> val = UtilsMap.of("$geometry", this.mapper.serialize(point));
        val.put("$maxDistance", (Map<String, Object>)maxDistance);
        val.put("$minDistance", (Map<String, Object>)minDistance);
        nearExpression.setValue(val);
        expressionList.add(nearExpression);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> geoIntersects(Geo shape) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression expr = new FilterExpression();
        expr.setField("$geoIntersects");
        UtilsMap<String, Map<String, Object>> val = UtilsMap.of("$geometry", this.mapper.serialize(shape));
        expr.setValue(val);
        expressionList.add(expr);
        this.add(expressionList);
        return this.query;
    }

    @Override
    public Query<T> geoWithin(Geo shape) {
        ArrayList<FilterExpression> expressionList = new ArrayList<FilterExpression>();
        FilterExpression expr = new FilterExpression();
        expr.setField("$geoWithin");
        UtilsMap<String, Map<String, Object>> val = UtilsMap.of("$geometry", this.mapper.serialize(shape));
        expr.setValue(val);
        expressionList.add(expr);
        this.add(expressionList);
        return this.query;
    }
}

