/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.bson.BsonDecoder;
import de.caluga.morphium.driver.bson.BsonEncoder;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class OpQuery
extends WireProtocolMessage {
    public static final int TAILABLE_CURSOR_FLAG = 2;
    public static final int SLAVE_OK_FLAG = 4;
    public static final int OPLOG_REPLAY_FLAG = 8;
    public static final int NO_CURSOR_TIMEOUT_FLAG = 16;
    public static final int AWAIT_DATA_FLAG = 32;
    public static final int EXHAUST_FLAG = 64;
    public static final int PARTIAL_FLAG = 128;
    private static final int OP_CODE = 2004;
    private String db;
    private String coll;
    private int skip = 0;
    private int limit = 1;
    private Doc doc;
    private int flags;
    private Doc returnFieldSelector;

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getColl() {
        return this.coll;
    }

    public void setColl(String coll) {
        this.coll = coll;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(this.getOpCode(), out);
        this.writeInt(this.flags, out);
        this.writeString(this.db + "." + this.coll, out);
        this.writeInt(this.skip, out);
        this.writeInt(this.limit, out);
        out.write(BsonEncoder.encodeDocument(this.doc));
        return out.toByteArray();
    }

    @Override
    public int getOpCode() {
        return 2004;
    }

    @Override
    public void parsePayload(byte[] bytes, int offset) {
        this.doc = new Doc();
        this.flags = OpQuery.readInt(bytes, offset);
        this.coll = OpQuery.readString(bytes, offset += 4);
        this.skip = OpQuery.readInt(bytes, offset += this.coll.getBytes(StandardCharsets.UTF_8).length + 1);
        this.limit = OpQuery.readInt(bytes, offset += 4);
        offset += 4;
        try {
            int sz = BsonDecoder.decodeDocumentIn(this.doc, bytes, offset);
            if (sz + offset < bytes.length) {
                this.returnFieldSelector = new Doc();
                BsonDecoder.decodeDocumentIn(this.returnFieldSelector, bytes, offset + sz);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "OpQuery{db='" + this.db + "', coll='" + this.coll + "', skip=" + this.skip + ", limit=" + this.limit + ", doc=" + Utils.toJsonString(this.doc) + ", flags=" + this.flags + ", returnFieldsSelector=" + Utils.toJsonString(this.returnFieldSelector) + "}";
    }
}

