/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import org.xerial.snappy.Snappy;

public class OpCompressed
extends WireProtocolMessage {
    public static final int COMPRESSOR_NOOP = 0;
    public static final int COMPRESSOR_SNAPPY = 1;
    public static final int COMPRESSOR_ZLIB = 2;
    public static final int COMPRESSOR_ZSTD = 3;
    private int originalOpCode;
    private int uncompressedSize;
    private int compressorId;
    private byte[] compressedMessage;

    @Override
    public void parsePayload(byte[] bytes, int offset) throws IOException {
        int idx = 0;
        this.originalOpCode = OpCompressed.readInt(bytes, 0);
        this.uncompressedSize = OpCompressed.readInt(bytes, idx += 4);
        this.compressorId = bytes[idx += 4];
        this.compressedMessage = new byte[bytes.length - ++idx];
        System.arraycopy(bytes, idx, this.compressedMessage, 0, this.compressedMessage.length);
        this.compressedMessage = Snappy.uncompress((byte[])this.compressedMessage);
    }

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(this.originalOpCode, out);
        this.writeInt(this.uncompressedSize, out);
        out.write((byte)this.compressorId);
        if (this.compressorId == 1) {
            out.write(Snappy.compress((byte[])this.compressedMessage));
        } else if (this.compressorId == 2) {
            DeflaterOutputStream zlibOut = new DeflaterOutputStream(out);
            zlibOut.write(this.compressedMessage);
            zlibOut.flush();
        } else {
            if (this.compressorId == 3) {
                throw new IllegalArgumentException("ZSTD compression not supported!");
            }
            throw new IllegalArgumentException("unsupported compression id: " + this.compressorId);
        }
        return out.toByteArray();
    }

    @Override
    public int getOpCode() {
        return WireProtocolMessage.OpCode.OP_COMPRESSED.opCode;
    }

    public int getOriginalOpCode() {
        return this.originalOpCode;
    }

    public void setOriginalOpCode(int originalOpCode) {
        this.originalOpCode = originalOpCode;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(int uncompressedSize) {
        this.uncompressedSize = uncompressedSize;
    }

    public int getCompressorId() {
        return this.compressorId;
    }

    public void setCompressorId(int compressorId) {
        this.compressorId = compressorId;
    }

    public byte[] getCompressedMessage() {
        return this.compressedMessage;
    }

    public void setCompressedMessage(byte[] compressedMessage) {
        this.compressedMessage = compressedMessage;
    }
}

