/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.ListCollectionsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.DriverBase;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import de.caluga.morphium.driver.wire.SingleMongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledDriver
extends DriverBase {
    public static final String driverName = "PooledDriver";
    private final Map<String, BlockingQueue<ConnectionContainer>> connectionPool;
    private final Map<Integer, ConnectionContainer> borrowedConnections;
    private final Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats;
    private long fastestTime = 10000L;
    private int idleSleepTime = 5;
    private String fastestHost = null;
    private final Logger log = LoggerFactory.getLogger(PooledDriver.class);
    private String primaryNode;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){
        private AtomicLong l = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread ret = new Thread(r);
            ret.setName("MCon_" + this.l.incrementAndGet());
            ret.setDaemon(true);
            return ret;
        }
    });
    private final AtomicInteger lastSecondaryNode = new AtomicInteger(0);
    private final Map<String, Thread> hostThreads = new ConcurrentHashMap<String, Thread>();
    private ScheduledFuture<?> heartbeat;
    private final Integer waitCounterSignal = 0;
    private final Map<String, AtomicInteger> waitCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private List<String> lastHostsFromHello = null;

    public PooledDriver() {
        this.connectionPool = new HashMap<String, BlockingQueue<ConnectionContainer>>();
        this.borrowedConnections = Collections.synchronizedMap(new HashMap());
        this.stats = new ConcurrentHashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
        for (MorphiumDriver.DriverStatsKey e : MorphiumDriver.DriverStatsKey.values()) {
            this.stats.put(e, new AtomicDecimal(0));
        }
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        for (String host : this.getHostSeed()) {
            this.connectionPool.put(host, new LinkedBlockingQueue());
        }
        this.setReplicaSet(this.getHostSeed().size() > 1);
        this.startHeartbeat();
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return ReadPreference.nearest();
    }

    @Override
    public synchronized void removeFromHostSeed(String host) {
        super.removeFromHostSeed(host);
        if (this.getNumHostsInSeed() == 0) {
            if (this.lastHostsFromHello == null) {
                this.log.warn("Wanted to remove last host in hostseed, but last hosts is null");
                this.addToHostSeed(host);
            } else {
                this.setHostSeed(this.lastHostsFromHello);
            }
        }
    }

    private String getHost(String hostPort) {
        if (hostPort == null) {
            return "";
        }
        String[] h = hostPort.split(":");
        return h[0];
    }

    private int getPortFromHost(String host) {
        String[] h = host.split(":");
        if (h.length == 1) {
            return 27017;
        }
        return Integer.parseInt(h[1]);
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHelloResult(HelloResult hello, String hostConnected) {
        if (hello == null) {
            return;
        }
        if (hello.getWritablePrimary() != null && hello.getWritablePrimary().booleanValue() && hello.getMe() == null) {
            if (hello.getWritablePrimary().booleanValue() && this.primaryNode == null) {
                this.primaryNode = hostConnected;
            } else if (!hostConnected.equals(this.primaryNode)) {
                this.log.warn("Primary failover? {} -> {}", (Object)this.primaryNode, (Object)hello.getMe());
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.FAILOVERS).incrementAndGet();
                this.primaryNode = hostConnected;
            } else if (!hello.getWritablePrimary().booleanValue() && hostConnected.equals(this.primaryNode)) {
                this.log.error("Primary node is not me {}", (Object)hello.getMe());
                this.primaryNode = null;
            }
        } else if (hello.getWritablePrimary() != null && hello.getMe() != null) {
            if (this.primaryNode == null) {
                this.primaryNode = hello.getMe();
            } else if (hello.getWritablePrimary().booleanValue() && !hello.getMe().equals(this.primaryNode)) {
                this.log.warn("Primary failover? {} -> {}", (Object)this.primaryNode, (Object)hello.getMe());
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.FAILOVERS).incrementAndGet();
                this.primaryNode = hello.getMe();
                if (this.primaryNode == null) {
                    this.primaryNode = hostConnected;
                }
            } else if (!hello.getWritablePrimary().booleanValue() && hello.getMe().equals(this.primaryNode)) {
                this.log.error("Primary node is not me {}", (Object)hello.getMe());
                this.primaryNode = null;
            }
        }
        if (hello.getHosts() != null && !hello.getHosts().isEmpty()) {
            Iterator iterator;
            this.lastHostsFromHello = hello.getHosts();
            for (String hst : hello.getHosts()) {
                iterator = this.connectionPool;
                synchronized (iterator) {
                    if (!this.connectionPool.containsKey(hst)) {
                        this.connectionPool.put(hst, new LinkedBlockingQueue());
                    }
                }
                this.addToHostSeed(hst);
            }
            for (String hst : this.getHostSeed()) {
                if (hello.getHosts().contains(hst)) continue;
                this.removeFromHostSeed(hst);
                iterator = this.waitCounter;
                synchronized (iterator) {
                    this.waitCounter.remove(hst);
                }
            }
            ArrayList<ConnectionContainer> toClose = new ArrayList<ConnectionContainer>();
            Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
            synchronized (map) {
                for (String host : new ArrayList<String>(this.connectionPool.keySet())) {
                    if (hello.getHosts().contains(host)) continue;
                    this.log.warn("Host {} is not part of the replicaset anymore!", (Object)host);
                    this.removeFromHostSeed(host);
                    Map<String, AtomicInteger> map2 = this.waitCounter;
                    synchronized (map2) {
                        this.waitCounter.remove(host);
                    }
                    BlockingQueue<ConnectionContainer> lst = this.connectionPool.remove(host);
                    ArrayList<Integer> toDelete = new ArrayList<Integer>();
                    for (Map.Entry<Integer, ConnectionContainer> e : new ArrayList<Map.Entry<Integer, ConnectionContainer>>(this.borrowedConnections.entrySet())) {
                        if (!e.getValue().getCon().getConnectedToHost().equals(host)) continue;
                        toDelete.add(e.getKey());
                    }
                    for (Integer i : toDelete) {
                        this.borrowedConnections.remove(i);
                    }
                    if (this.fastestHost != null && this.fastestHost.equals(host)) {
                        this.fastestHost = null;
                        this.fastestTime = 10000L;
                    }
                    toClose.addAll(lst);
                }
                for (ConnectionContainer con : toClose) {
                    try {
                        con.getCon().close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    protected synchronized void startHeartbeat() {
        if (this.heartbeat == null) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (PooledDriver.this.heartbeat != null) {
                        try {
                            Integer n = PooledDriver.this.waitCounterSignal;
                            synchronized (n) {
                                PooledDriver.this.waitCounterSignal.wait();
                            }
                            for (String hst : PooledDriver.this.getHostSeed()) {
                                try {
                                    BlockingQueue<ConnectionContainer> queue = null;
                                    Map<String, BlockingQueue<ConnectionContainer>> map = PooledDriver.this.connectionPool;
                                    synchronized (map) {
                                        queue = PooledDriver.this.connectionPool.get(hst);
                                    }
                                    for (int loopCounter = 0; PooledDriver.this.getHostSeed().contains(hst) && queue != null && loopCounter < PooledDriver.this.getMaxConnectionsPerHost() && queue.size() < PooledDriver.this.getWaitCounterForHost(hst) && PooledDriver.this.getTotalConnectionsToHost(hst) < PooledDriver.this.getMaxConnectionsPerHost(); ++loopCounter) {
                                        PooledDriver.this.log.debug("Creating connection to {} - WaitCounter is {}", (Object)hst, (Object)PooledDriver.this.getWaitCounterForHost(hst));
                                        PooledDriver.this.createNewConnection(hst);
                                    }
                                }
                                catch (Exception e) {
                                    PooledDriver.this.log.error("Could not create connection to {}", (Object)hst, (Object)e);
                                    PooledDriver.this.onConnectionError(hst);
                                }
                            }
                        }
                        catch (Exception e) {
                            PooledDriver.this.log.error("error", (Throwable)e);
                            PooledDriver.this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                        }
                    }
                }
            }.start();
            this.heartbeat = this.executor.scheduleWithFixedDelay(() -> {
                for (String hst : this.getHostSeed()) {
                    BlockingQueue<ConnectionContainer> connectionPoolForHost = null;
                    Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                    synchronized (map) {
                        connectionPoolForHost = this.connectionPool.get(hst);
                    }
                    if (connectionPoolForHost != null) {
                        try {
                            ConnectionContainer connection;
                            int len = connectionPoolForHost.size();
                            for (int i = 0; i < len && (connection = connectionPoolForHost.poll(1L, TimeUnit.MILLISECONDS)) != null; ++i) {
                                long now = System.currentTimeMillis();
                                if (connection.getLastUsed() < now - (long)this.getMaxConnectionIdleTime() || connection.getCreated() < now - (long)this.getMaxConnectionLifetime()) {
                                    this.log.debug("connection to host:{} too long idle or just too old -> remove", (Object)connection.getCon().getConnectedToHost());
                                    try {
                                        connection.getCon().close();
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                                connectionPoolForHost.add(connection);
                            }
                        }
                        catch (Exception len) {
                            // empty catch block
                        }
                    }
                    if (this.hostThreads.containsKey(hst)) continue;
                    Thread t = new Thread(() -> {
                        try {
                            this.waitCounter.putIfAbsent(hst, new AtomicInteger());
                            ConnectionContainer container = null;
                            Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                            synchronized (map) {
                                if (this.connectionPool.get(hst) == null) {
                                    this.log.warn("No connectionPool for host {} creating new ConnectionContainer", (Object)hst);
                                    container = new ConnectionContainer(new SingleMongoConnection());
                                } else {
                                    container = this.connectionPool.get(hst).poll(1L, TimeUnit.MILLISECONDS);
                                }
                            }
                            if (container != null) {
                                long start = System.currentTimeMillis();
                                HelloResult result = container.getCon().isConnected() ? container.getCon().getHelloResult(false) : container.getCon().connect(this, this.getHost(hst), this.getPortFromHost(hst));
                                long dur = System.currentTimeMillis() - start;
                                if (dur < this.fastestTime) {
                                    this.fastestTime = dur;
                                    this.fastestHost = hst;
                                }
                                this.handleHelloResult(result, this.getHost(hst) + ":" + this.getPortFromHost(hst));
                                Map<String, BlockingQueue<ConnectionContainer>> map2 = this.connectionPool;
                                synchronized (map2) {
                                    if (this.connectionPool.containsKey(hst) && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost()) {
                                        this.connectionPool.get(hst).add(container);
                                    } else {
                                        container.getCon().close();
                                    }
                                }
                            }
                            BlockingQueue<ConnectionContainer> queue = null;
                            Map<String, BlockingQueue<ConnectionContainer>> map3 = this.connectionPool;
                            synchronized (map3) {
                                queue = this.connectionPool.get(hst);
                            }
                            int wait = this.getWaitCounterForHost(hst);
                            for (int loopCounter = 0; this.getHostSeed().contains(hst) && queue != null && loopCounter < this.getMaxConnectionsPerHost() && (queue.size() < wait && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost() || this.getTotalConnectionsToHost(hst) < this.getMinConnectionsPerHost()); ++loopCounter) {
                                this.createNewConnection(hst);
                            }
                        }
                        catch (Exception e) {
                            this.log.error("Could not create connection to host " + hst, (Throwable)e);
                            this.onConnectionError(hst);
                        }
                        finally {
                            this.hostThreads.remove(hst);
                        }
                    });
                    this.hostThreads.put(hst, t);
                    t.start();
                }
            }, 0L, this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWaitCounterForHost(String hst) {
        Map<String, AtomicInteger> map = this.waitCounter;
        synchronized (map) {
            this.waitCounter.putIfAbsent(hst, new AtomicInteger());
            return this.waitCounter.get(hst).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionError(String host) {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
        BlockingQueue<ConnectionContainer> connectionsList = null;
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            connectionsList = this.connectionPool.remove(host);
        }
        if (host.equals(this.primaryNode)) {
            this.primaryNode = null;
        }
        if (host.equals(this.fastestHost)) {
            this.fastestHost = null;
            this.fastestTime = 10000L;
        }
        if (connectionsList != null) {
            for (ConnectionContainer c : connectionsList) {
                try {
                    c.getCon().close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewConnection(String hst) throws Exception {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            if (!this.connectionPool.containsKey(hst)) {
                return;
            }
        }
        SingleMongoConnection con = new SingleMongoConnection();
        if (this.getAuthDb() != null) {
            con.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
        }
        long start = System.currentTimeMillis();
        HelloResult result = con.connect(this, this.getHost(hst), this.getPortFromHost(hst));
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED).incrementAndGet();
        Map<String, BlockingQueue<ConnectionContainer>> map2 = this.connectionPool;
        synchronized (map2) {
            if (this.connectionPool.containsKey(hst) && (this.connectionPool.get(hst).size() < this.getWaitCounterForHost(hst) && this.getTotalConnectionsToHost(hst) < this.getMaxConnectionsPerHost() || this.getTotalConnectionsToHost(hst) < this.getMinConnectionsPerHost())) {
                ConnectionContainer cont = new ConnectionContainer(con);
                this.connectionPool.get(hst).add(cont);
            } else {
                con.close();
            }
        }
        long dur = System.currentTimeMillis() - start;
        if (dur < this.fastestTime) {
            this.fastestTime = dur;
            this.fastestHost = hst;
        }
        this.handleHelloResult(result, this.getHost(hst) + ":" + this.getPortFromHost(hst));
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            con.watch(settings);
        }
        finally {
            if (con != null) {
                this.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalConnectionsToHost(String h) {
        int borrowed = 0;
        ArrayList<ConnectionContainer> values = new ArrayList<ConnectionContainer>(this.borrowedConnections.values());
        for (ConnectionContainer c : values) {
            if (!c.getCon().getConnectedTo().equals(h)) continue;
            ++borrowed;
        }
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            if (this.connectionPool.get(h) == null) {
                return borrowed;
            }
            return borrowed + this.connectionPool.get(h).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoConnection borrowConnection(String host) throws MorphiumDriverException {
        if (host == null) {
            throw new MorphiumDriverException("Cannot connect to host null!");
        }
        boolean needToDecrement = false;
        try {
            ConnectionContainer bc = null;
            BlockingQueue<ConnectionContainer> queue = null;
            Object object = this.connectionPool;
            synchronized (object) {
                if (!this.connectionPool.containsKey(host)) {
                    this.log.error("No connectionpool for host {}", (Object)host);
                    throw new MorphiumDriverException("No connectionpool for " + host + " available");
                }
                queue = this.connectionPool.get(host);
                if (queue.isEmpty()) {
                    Map<String, AtomicInteger> map = this.waitCounter;
                    synchronized (map) {
                        this.waitCounter.putIfAbsent(host, new AtomicInteger());
                        if (this.getWaitCounterForHost(host) < this.getMaxConnectionsPerHost()) {
                            this.waitCounter.get(host).incrementAndGet();
                            needToDecrement = true;
                        }
                        Integer n = this.waitCounterSignal;
                        synchronized (n) {
                            this.waitCounterSignal.notifyAll();
                        }
                    }
                }
            }
            do {
                if ((bc = queue.poll(this.getMaxWaitTime(), TimeUnit.MILLISECONDS)) == null) {
                    this.log.error("Connection timeout");
                    this.log.error("Connections to {}: {}", (Object)host, (Object)this.getTotalConnectionsToHost(host));
                    this.log.error("WaitingThreads for {}: {}", (Object)host, (Object)this.getWaitCounterForHost(host));
                    throw new MorphiumDriverException("Could not get connection to " + host + " in time " + this.getMaxWaitTime() + "ms");
                }
                if (bc.getCon().getSourcePort() != 0) continue;
                this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
            } while (bc.getCon().getSourcePort() == 0);
            bc.touch();
            this.borrowedConnections.put(bc.getCon().getSourcePort(), bc);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED).incrementAndGet();
            object = bc.getCon();
            return object;
        }
        catch (InterruptedException iex) {
            SingleMongoConnection singleMongoConnection = new SingleMongoConnection();
            return singleMongoConnection;
        }
        finally {
            AtomicInteger atomicInteger;
            if (needToDecrement && this.getWaitCounterForHost(host) > 0 && (atomicInteger = this.waitCounter.get(host)) != null) {
                atomicInteger.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        try {
            if (this.getHostSeed().size() == 1 || !this.isReplicaSet()) {
                if (this.primaryNode == null) {
                    return this.borrowConnection(this.getHostSeed().get(0));
                }
                return this.borrowConnection(this.primaryNode);
            }
            if (rp == null) {
                rp = this.getDefaultReadPreference();
            }
            ReadPreferenceType type = rp.getType();
            if (this.isTransactionInProgress()) {
                type = ReadPreferenceType.PRIMARY;
            }
            switch (type) {
                case PRIMARY: {
                    if (this.primaryNode == null) {
                        throw new MorphiumDriverException("No primary node defined - not connected yet?");
                    }
                    return this.borrowConnection(this.primaryNode);
                }
                case NEAREST: {
                    if (this.fastestHost != null) {
                        try {
                            return this.borrowConnection(this.fastestHost);
                        }
                        catch (MorphiumDriverException e) {
                            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                            this.log.warn("Could not get connection to fastest host, trying primary", (Throwable)e);
                        }
                    }
                }
                case PRIMARY_PREFERRED: {
                    Map<String, BlockingQueue<ConnectionContainer>> e = this.connectionPool;
                    synchronized (e) {
                        if (null != this.connectionPool.get(this.primaryNode) && !this.connectionPool.get(this.primaryNode).isEmpty()) {
                            try {
                                return this.borrowConnection(this.primaryNode);
                            }
                            catch (MorphiumDriverException e2) {
                                this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                                this.log.warn("Could not get connection to {} trying secondary", (Object)this.primaryNode);
                            }
                        }
                    }
                }
                case SECONDARY_PREFERRED: 
                case SECONDARY: {
                    int retry = 0;
                    while (true) {
                        String host = null;
                        AtomicInteger atomicInteger = this.lastSecondaryNode;
                        synchronized (atomicInteger) {
                            this.lastSecondaryNode.incrementAndGet();
                            List<String> hostSeed = this.getHostSeed();
                            if (this.lastSecondaryNode.get() >= hostSeed.size()) {
                                this.lastSecondaryNode.set(0);
                                ++retry;
                            }
                            if (hostSeed.get(this.lastSecondaryNode.get()).equals(this.primaryNode)) {
                                this.lastSecondaryNode.incrementAndGet();
                                if (this.lastSecondaryNode.get() >= hostSeed.size()) {
                                    this.lastSecondaryNode.set(0);
                                    ++retry;
                                }
                            }
                            host = hostSeed.get(this.lastSecondaryNode.get());
                        }
                        try {
                            return this.borrowConnection(host);
                        }
                        catch (MorphiumDriverException e) {
                            if (retry > this.getRetriesOnNetworkError()) {
                                this.log.error("Could not get Connection - abort");
                                this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                                throw e;
                            }
                            this.log.warn("could not get connection to secondary node '{}'- trying other replicaset node", (Object)host, (Object)e);
                            this.onConnectionError(host);
                            try {
                                Thread.sleep(this.getSleepBetweenErrorRetries());
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        break;
                    }
                }
            }
            throw new IllegalArgumentException("Unhandeled Readpreferencetype " + String.valueOf((Object)rp.getType()));
        }
        catch (MorphiumDriverException e) {
            this.log.error("Error getting connection", (Throwable)e);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
            throw new RuntimeException(e);
        }
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) throws MorphiumDriverException {
        if (this.primaryNode == null) {
            throw new MorphiumDriverException("No primary node found - connection not established yet?");
        }
        return this.borrowConnection(this.primaryNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(MongoConnection con) {
        this.releaseConnection(con);
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (String k : this.connectionPool.keySet()) {
                for (ConnectionContainer c : new ArrayList(this.connectionPool.get(k))) {
                    if (c.getCon() != con) continue;
                    this.connectionPool.get(k).remove(c);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ConnectionContainer> getBorrowedConnections() {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            return new HashMap<Integer, ConnectionContainer>(this.borrowedConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(MongoConnection con) {
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED).incrementAndGet();
        if (con == null) {
            return;
        }
        if (this.heartbeat == null) {
            return;
        }
        if (!(con instanceof SingleMongoConnection)) {
            throw new IllegalArgumentException("Got connection of wrong type back!");
        }
        if (con.getSourcePort() != 0) {
            ConnectionContainer c = this.borrowedConnections.remove(con.getSourcePort());
            if (c == null) {
                if (con.isConnected()) {
                    con.close();
                }
                return;
            }
            if (con.getConnectedTo() != null) {
                Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
                synchronized (map) {
                    BlockingQueue<ConnectionContainer> connectionContainer = this.connectionPool.get(con.getConnectedTo());
                    if (null != connectionContainer) {
                        connectionContainer.add(c);
                    }
                }
            }
        } else {
            ArrayList<Integer> sourcePortsToDelete = new ArrayList<Integer>();
            for (int port : new ArrayList<Integer>(this.borrowedConnections.keySet())) {
                ConnectionContainer connectionContainer = this.borrowedConnections.get(port);
                if (connectionContainer != null && connectionContainer.getCon() != null && connectionContainer.getCon().getSourcePort() != 0) continue;
                sourcePortsToDelete.add(port);
            }
            for (int port : sourcePortsToDelete) {
                this.borrowedConnections.remove(port);
            }
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED).incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (String c : this.connectionPool.keySet()) {
                if (this.getTotalConnectionsToHost(c) == 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getIdleSleepTime() {
        return this.idleSleepTime;
    }

    @Override
    public void setIdleSleepTime(int sl) {
        this.idleSleepTime = sl;
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new AggregatorImpl<T, R>(morphium, type, resultType);
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.heartbeat != null) {
            this.heartbeat.cancel(true);
        }
        this.heartbeat = null;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, BlockingQueue<ConnectionContainer>> e : new ArrayList<Map.Entry<String, BlockingQueue<ConnectionContainer>>>(this.connectionPool.entrySet())) {
                for (ConnectionContainer c : new ArrayList(e.getValue())) {
                    try {
                        c.getCon().close();
                    }
                    catch (Exception exception) {}
                }
                this.connectionPool.get(e.getKey()).clear();
            }
        }
    }

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(null).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
    }

    @Override
    public void commitTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot commit");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        MongoConnection con = this.getPrimaryConnection(null);
        CommitTransactionCommand cmd = new CommitTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
        this.releaseConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot abort");
        }
        MongoConnection con = this.getPrimaryConnection(null);
        try {
            MorphiumTransactionContext ctx = this.getTransactionContext();
            AbortTransactionCommand cmd = new AbortTransactionCommand(con).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
            cmd.execute();
        }
        finally {
            this.releaseConnection(con);
            this.clearTransactionContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            ReplicastStatusCommand cmd = new ReplicastStatusCommand(con);
            Map<String, Object> result = cmd.execute();
            List mem = (List)result.get("members");
            if (mem == null) {
                Map<String, Object> map = null;
                return map;
            }
            mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
            Map<String, Object> map = result;
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        MongoConnection con = null;
        try {
            con = this.getPrimaryConnection(null);
            Map<String, Object> map = ((DbStatsCommand)new DbStatsCommand(con).setDb(db)).execute();
            return map;
        }
        finally {
            this.releaseConnection(con);
        }
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        CollStatsCommand cmd = (CollStatsCommand)((CollStatsCommand)new CollStatsCommand(this.getPrimaryConnection(null)).setColl(coll)).setDb(db);
        return cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> currentOp(int threshold) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = ((CurrentOpCommand)new CurrentOpCommand(this.getPrimaryConnection(null)).setColl("admin")).setSecsRunning(threshold);
            List<Map<String, Object>> list = ((CurrentOpCommand)cmd).execute();
            return list;
        }
        finally {
            if (cmd != null) {
                cmd.releaseConnection();
            }
        }
    }

    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    public Map<String, Object> getDbStats(String db, boolean withStorage) throws MorphiumDriverException {
        return (Map)new NetworkCallHelper().doCall(() -> {
            OpMsg msg = new OpMsg();
            msg.setMessageId(this.getNextId());
            Doc v = Doc.of("dbStats", (Object)1, "scale", (Object)1024);
            v.put("$db", db);
            if (withStorage) {
                v.put("freeStorage", 1);
            }
            msg.setFirstDoc(v);
            OpMsg reply = null;
            return reply.getFirstDoc();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        try {
            this.getDBStats(db);
            return true;
        }
        catch (MorphiumDriverException morphiumDriverException) {
            return false;
        }
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDbStats(db, false);
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            MongoConnection con = this.getReadConnection(ReadPreference.primary());
            ListCollectionsCommand cmd = new ListCollectionsCommand(con);
            cmd.setDb(db);
            cmd.setFilter(Doc.of("name", collection));
            return cmd.execute();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (Map.Entry<String, BlockingQueue<ConnectionContainer>> entry : this.connectionPool.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().size());
            }
            for (ConnectionContainer connectionContainer : this.borrowedConnections.values()) {
                ret.put(connectionContainer.getCon().getConnectedTo(), (Integer)ret.get(connectionContainer.getCon().getConnectedTo()) + 1);
            }
        }
        return ret;
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name") != null && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
        }
        return false;
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            public Doc execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InsertMongoCommand settings = new InsertMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((InsertMongoCommand)((InsertMongoCommand)settings.setDb(db)).setColl(collection)).setComment("Bulk insert").setDocuments(((InsertBulkRequest)r).getToInsert());
                            settings.execute();
                            settings.releaseConnection();
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            UpdateMongoCommand upCmd = new UpdateMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((UpdateMongoCommand)((UpdateMongoCommand)upCmd.setColl(collection)).setDb(db)).setUpdates(Arrays.asList(Doc.of("q", up.getQuery(), "u", up.getCmd(), "upsert", (Object)up.isUpsert(), "multi", (Object)up.isMultiple())));
                            upCmd.execute();
                            upCmd.releaseConnection();
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            DeleteBulkRequest dbr = (DeleteBulkRequest)r;
                            DeleteMongoCommand del = new DeleteMongoCommand(PooledDriver.this.getPrimaryConnection(null));
                            ((DeleteMongoCommand)((DeleteMongoCommand)del.setColl(collection)).setDb(db)).setDeletes(Arrays.asList(Doc.of("q", dbr.getQuery(), "limit", (Object)(dbr.isMultiple() ? 0 : 1))));
                            del.execute();
                            del.releaseConnection();
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    PooledDriver.this.log.error("Got exception: ", (Throwable)e);
                    PooledDriver.this.stats.get((Object)MorphiumDriver.DriverStatsKey.ERRORS).incrementAndGet();
                }
                return new Doc();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> m = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : this.stats.entrySet()) {
            m.put(e.getKey(), e.getValue().get());
        }
        Map<String, BlockingQueue<ConnectionContainer>> map = this.connectionPool;
        synchronized (map) {
            for (BlockingQueue<ConnectionContainer> l : this.connectionPool.values()) {
                m.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL, (Double)m.get((Object)MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL) + (double)l.size());
                for (ConnectionContainer con : l) {
                    for (Map.Entry<MorphiumDriver.DriverStatsKey, Double> entry : con.getCon().getStats().entrySet()) {
                        m.put(entry.getKey(), (Double)m.get((Object)entry.getKey()) + entry.getValue());
                    }
                }
            }
        }
        m.put(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_USE, Double.valueOf(this.borrowedConnections.size()));
        int waiting = 0;
        for (String hst : new ArrayList<String>(this.waitCounter.keySet())) {
            waiting += this.getWaitCounterForHost(hst);
        }
        m.put(MorphiumDriver.DriverStatsKey.THREADS_WAITING_FOR_CONNECTION, Double.valueOf(waiting));
        return m;
    }

    private class ConnectionContainer {
        private SingleMongoConnection con;
        private long created;
        private long lastUsed;

        public ConnectionContainer(SingleMongoConnection con) {
            this.con = con;
            this.created = System.currentTimeMillis();
            this.lastUsed = System.currentTimeMillis();
        }

        public void touch() {
            this.lastUsed = System.currentTimeMillis();
        }

        public SingleMongoConnection getCon() {
            return this.con;
        }

        public ConnectionContainer setCon(SingleMongoConnection con) {
            this.con = con;
            return this;
        }

        public long getCreated() {
            return this.created;
        }

        public ConnectionContainer setCreated(long created) {
            this.created = created;
            return this;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public ConnectionContainer setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }
    }
}

