/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import java.util.concurrent.atomic.AtomicInteger;

public final class AtomicDecimal
extends Number {
    private AtomicInteger numerator;
    private AtomicInteger denominator;

    public AtomicDecimal(int numerator) {
        this.numerator = new AtomicInteger(numerator);
        this.denominator = new AtomicInteger(1);
    }

    public AtomicDecimal(int numerator, int denominator) {
        this.numerator = new AtomicInteger(numerator);
        this.denominator = new AtomicInteger(denominator);
    }

    public double get() {
        return this.doubleValue();
    }

    public AtomicDecimal setDenominator(int den) {
        this.denominator.set(den);
        return this;
    }

    public AtomicDecimal setNumerator(int num) {
        this.numerator.set(num);
        return this;
    }

    public double incrementAndGet() {
        this.numerator.incrementAndGet();
        return this.doubleValue();
    }

    public double decrementAndGet() {
        this.numerator.decrementAndGet();
        return this.doubleValue();
    }

    @Override
    public int intValue() {
        return this.numerator.get() / this.denominator.get();
    }

    @Override
    public long longValue() {
        return this.numerator.get() / this.denominator.get();
    }

    @Override
    public float floatValue() {
        return (float)this.numerator.get() / (float)this.denominator.get();
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator.get() / (double)this.denominator.get();
    }
}

