/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.MultiResultCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ReadMongoCommand<T extends MongoCommand>
extends MongoCommand<T>
implements MultiResultCommand,
Iterable<Map<String, Object>> {
    public ReadMongoCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        try {
            return this.executeIterable(this.getConnection().getDriver().getDefaultBatchSize());
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Map<String, Object>> execute() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException("you need to set the connection!");
        }
        return (List)new NetworkCallHelper().doCall(() -> {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            this.setMetaData("server", connection.getConnectedTo());
            long start = System.currentTimeMillis();
            int msg = connection.sendCommand(this);
            MorphiumCursor crs = connection.getAnswerFor(msg, this.getConnection().getDriver().getDefaultBatchSize());
            while (crs.hasNext()) {
                List<Map<String, Object>> batch = crs.getBatch();
                if (batch.size() == 1 && batch.get(0).containsKey("ok") && batch.get(0).get("ok").equals(0.0)) {
                    throw new MorphiumDriverException("Error: " + String.valueOf(batch.get(0).get("code")) + ": " + String.valueOf(batch.get(0).get("errmsg")));
                }
                ret.addAll(batch);
                crs.ahead(batch.size());
            }
            this.setConnection(null);
            long dur = System.currentTimeMillis() - start;
            this.setMetaData("duration", dur);
            return ret;
        }, connection.getDriver().getRetriesOnNetworkError(), connection.getDriver().getSleepBetweenErrorRetries());
    }

    @Override
    public MorphiumCursor executeIterable(int batchsize) throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException("you need to set the connection!");
        }
        ArrayList ret = new ArrayList();
        this.setMetaData("server", connection.getConnectedTo());
        long start = System.currentTimeMillis();
        int msg = connection.sendCommand(this);
        MorphiumCursor crs = connection.getAnswerFor(msg, batchsize);
        long dur = System.currentTimeMillis() - start;
        this.setMetaData("duration", dur);
        return crs;
    }
}

