/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum MongoType {
    DOUBLE("double", 1),
    STRING("string", 2),
    OBJECT("object", 3),
    ARRAY("array", 4),
    BINARY_DATA("binData", 5),
    UNDEFINED("undefined", 6),
    OBJECT_ID("objectId", 7),
    BOOLEAN("bool", 8),
    DATE("date", 9),
    NULL("null", 10),
    REGEX("regex", 11),
    DB_PTR("dbPointer", 12),
    JAVASCRIPT("javascript", 13),
    SYMBOL("symbol", 14),
    JAVASCRIPT_SCOPE("javascriptWithScope", 15),
    INTEGER("int", 16),
    TIMESTAMP("timestamp", 17),
    LONG("long", 18),
    DECIMAL("decimal", 19),
    MIN_KEY("minKey", 255),
    MAX_KEY("maxKey", 127);

    private static final MongoType[] ID_CACHE;
    private static final Map<String, MongoType> NAME_CACHE;
    String txt;
    Integer id;

    private MongoType(String n2, Integer id) {
        this.txt = n2;
        this.id = id;
    }

    public static MongoType findByValue(int value) {
        return ID_CACHE[value & 0xFF];
    }

    public static MongoType findByTxt(String txt) {
        return NAME_CACHE.get(txt);
    }

    public String getTxt() {
        return this.txt;
    }

    public Integer getId() {
        return this.id;
    }

    static {
        ID_CACHE = new MongoType[MIN_KEY.getId() + 1];
        NAME_CACHE = new ConcurrentHashMap<String, MongoType>();
        MongoType[] var0 = MongoType.values();
        int var1 = var0.length;
        for (int var2 = 0; var2 < var1; ++var2) {
            MongoType cur;
            MongoType.ID_CACHE[cur.getId().intValue()] = cur = var0[var2];
            NAME_CACHE.put(cur.getTxt(), cur);
        }
    }
}

