/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.server;

import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.bson.MongoTimestamp;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumServer {
    private static Logger log = LoggerFactory.getLogger(MorphiumServer.class);
    private InMemoryDriver drv;
    private int port;
    private String host;
    private AtomicInteger msgId = new AtomicInteger(1000);
    private AtomicInteger cursorId = new AtomicInteger(1000);
    private ThreadPoolExecutor executor;
    private boolean running = true;
    private ServerSocket serverSocket;

    public MorphiumServer(int port, String host, int maxThreads, int minThreads) {
        this.drv = new InMemoryDriver();
        this.port = port;
        this.host = host;
        this.drv.connect();
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.executor.setMaximumPoolSize(maxThreads);
        this.executor.setCorePoolSize(minThreads);
    }

    public MorphiumServer() {
        this(17017, "localhost", 100, 10);
    }

    public static void main(String[] args) throws Exception {
        int idx = 0;
        log.info("Starting up server... parsing commandline params");
        String host = "localhost";
        int port = 17017;
        int maxThreads = 1000;
        int minThreads = 10;
        block16: while (idx < args.length) {
            switch (args[idx]) {
                case "-p": 
                case "--port": {
                    port = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-mt": 
                case "--maxThreads": {
                    maxThreads = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-mint": 
                case "--minThreads": {
                    minThreads = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-h": 
                case "--host": {
                    host = args[idx + 1];
                    idx += 2;
                    continue block16;
                }
            }
            log.error("unknown parameter " + args[idx]);
            System.exit(1);
        }
        log.info("Starting server...");
        MorphiumServer srv = new MorphiumServer(port, host, maxThreads, minThreads);
        srv.start();
        while (srv.running) {
            log.info("Alive and kickin'");
            Thread.sleep(10000L);
        }
    }

    private HelloResult getHelloResult() {
        HelloResult res = new HelloResult();
        res.setHelloOk(true);
        res.setLocalTime(new Date());
        res.setOk(1.0);
        res.setHosts(Arrays.asList(this.host + ":" + this.port));
        res.setConnectionId(1);
        res.setMaxWireVersion(17);
        res.setMinWireVersion(13);
        res.setMaxMessageSizeBytes(100000);
        res.setMaxBsonObjectSize(10000);
        res.setWritablePrimary(true);
        res.setMe(this.host + ":" + this.port);
        res.setMsg("MorphiumServer V0.1");
        return res;
    }

    public int getConnectionCount() {
        return this.executor.getActiveCount();
    }

    public void start() throws IOException, InterruptedException {
        log.info("Opening port " + this.port);
        this.serverSocket = new ServerSocket(this.port);
        this.drv.setHostSeed(this.host + ":" + this.port);
        this.executor.prestartAllCoreThreads();
        log.info("Port opened, waiting for incoming connections");
        new Thread(() -> {
            while (this.running) {
                Socket s = null;
                try {
                    s = this.serverSocket.accept();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Socket closed")) {
                        log.info("Server socket closed");
                        break;
                    }
                    log.error("Serversocket error", (Throwable)e);
                    this.terminate();
                    break;
                }
                log.info("Incoming connection: " + this.executor.getPoolSize());
                Socket finalS = s;
                this.executor.execute(() -> this.incoming(finalS));
            }
        }).start();
    }

    public void incoming(Socket s) {
        log.info("handling incoming connection...{}", (Object)this.executor.getPoolSize());
        try {
            WireProtocolMessage msg;
            s.setSoTimeout(0);
            s.setTcpNoDelay(true);
            s.setKeepAlive(true);
            InputStream in = s.getInputStream();
            OutputStream out = s.getOutputStream();
            int id = 0;
            Map<String, Object> answer = this.getHelloResult().toMsg();
            while (s.isConnected() && (msg = WireProtocolMessage.parseFromStream(in)) != null) {
                Doc doc = null;
                if (msg instanceof OpQuery) {
                    OpReply r;
                    OpQuery q = (OpQuery)msg;
                    id = q.getMessageId();
                    doc = q.getDoc();
                    if (doc.containsKey("ismaster") || doc.containsKey("isMaster")) {
                        r = new OpReply();
                        r.setFlags(2);
                        r.setMessageId(this.msgId.incrementAndGet());
                        r.setResponseTo(id);
                        r.setNumReturned(1);
                        HelloResult res = this.getHelloResult();
                        OpMsg reply = new OpMsg();
                        reply.setFirstDoc(res.toMsg());
                        r.setDocuments(Arrays.asList(res.toMsg()));
                        out.write(r.bytes());
                        out.flush();
                        continue;
                    }
                    r = new OpReply();
                    Doc d = Doc.of("$err", "OP_QUERY is no longer supported. The client driver may require an upgrade.", "code", (Object)5739101, "ok", (Object)0.0);
                    r.setFlags(2);
                    r.setMessageId(this.msgId.incrementAndGet());
                    r.setResponseTo(id);
                    r.setNumReturned(1);
                    r.setDocuments(Arrays.asList(d));
                    out.write(r.bytes());
                    out.flush();
                    log.info("Sent out error because OPQuery not allowed anymore!");
                    log.info(Utils.toJsonString(doc));
                    continue;
                }
                if (msg instanceof OpMsg) {
                    OpMsg m = (OpMsg)msg;
                    doc = ((OpMsg)msg).getFirstDoc();
                    id = m.getMessageId();
                }
                String cmd = (String)doc.keySet().stream().findFirst().get();
                OpMsg reply = new OpMsg();
                reply.setResponseTo(msg.getMessageId());
                reply.setMessageId(this.msgId.incrementAndGet());
                switch (cmd) {
                    case "getCmdLineOpts": {
                        answer = Doc.of("argv", List.of(), "parsed", Map.of());
                        break;
                    }
                    case "buildInfo": {
                        answer = Doc.of("version", "5.0.0-ALPHA", "buildEnvironment", Doc.of("distarch", "java", "targetarch", "java"));
                        answer.put("ok", 1.0);
                        reply.setFirstDoc(answer);
                        break;
                    }
                    case "ismaster": 
                    case "isMaster": 
                    case "hello": {
                        answer = this.getHelloResult().toMsg();
                        reply.setFirstDoc(answer);
                        break;
                    }
                    case "getFreeMonitoringStatus": {
                        answer = Doc.of("state", "disabled", "message", "", "url", "", "userReminder", "");
                        break;
                    }
                    case "ping": {
                        answer = Doc.of();
                        break;
                    }
                    case "getLog": {
                        if (doc.get(cmd).equals("startupWarnings")) {
                            answer = Doc.of("totalLinesWritten", (Object)0, "log", List.of(), "ok", (Object)1.0);
                            break;
                        }
                        log.warn("Unknown log " + String.valueOf(doc.get(cmd)));
                        answer = Doc.of("ok", (Object)0, "errmsg", "unknown logr");
                        break;
                    }
                    case "getParameter": {
                        if (Integer.valueOf(1).equals(doc.get("featureCompatibilityVersion"))) {
                            answer = Doc.of("version", "5.0", "ok", (Object)1.0);
                            break;
                        }
                        answer = Doc.of("ok", (Object)0, "errmsg", "no such parameter");
                        break;
                    }
                    default: {
                        try {
                            AtomicInteger msgid = new AtomicInteger(0);
                            if (doc.containsKey("pipeline") && ((Map)((List)doc.get("pipeline")).get(0)).containsKey("$changeStream")) {
                                MongoCommand wcmd = new WatchCommand(this.drv).fromMap((Map)doc);
                                int myCursorId = this.cursorId.incrementAndGet();
                                ((WatchCommand)wcmd).setCb(new DriverTailableIterationCallback(){
                                    private boolean first = true;
                                    private String batch = "firstBatch";
                                    final /* synthetic */ WatchCommand val$wcmd;
                                    final /* synthetic */ int val$myCursorId;
                                    final /* synthetic */ OpMsg val$reply;
                                    final /* synthetic */ OutputStream val$out;
                                    {
                                        this.val$wcmd = watchCommand;
                                        this.val$myCursorId = n;
                                        this.val$reply = opMsg;
                                        this.val$out = outputStream;
                                    }

                                    @Override
                                    public void incomingData(Map<String, Object> data, long dur) {
                                        try {
                                            Doc crs = Doc.of(this.batch, List.of(data), "ns", this.val$wcmd.getDb() + "." + this.val$wcmd.getColl(), "id", (Object)this.val$myCursorId);
                                            Doc answer = Doc.of("ok", (Object)1.0);
                                            if (crs != null) {
                                                answer.put("cursor", crs);
                                            }
                                            answer.put("$clusterTime", Doc.of("clusterTime", new MongoTimestamp(System.currentTimeMillis())));
                                            answer.put("operationTime", new MongoTimestamp(System.currentTimeMillis()));
                                            this.val$reply.setFirstDoc(answer);
                                            if (this.first) {
                                                this.first = false;
                                                this.batch = "nextBatch";
                                            }
                                            this.val$out.write(this.val$reply.bytes());
                                            this.val$out.flush();
                                        }
                                        catch (Exception e) {
                                            log.error("Errror during watch", (Throwable)e);
                                        }
                                    }

                                    @Override
                                    public boolean isContinued() {
                                        return true;
                                    }
                                });
                                int mid = this.drv.runCommand((WatchCommand)wcmd);
                                msgid.set(mid);
                            } else {
                                msgid.set(this.drv.runCommand((GenericCommand)new GenericCommand(this.drv).fromMap((Map)doc)));
                            }
                            Map<String, Object> crs = this.drv.readSingleAnswer(msgid.get());
                            answer = Doc.of("ok", (Object)1.0);
                            if (crs == null) break;
                            answer.putAll(crs);
                            break;
                        }
                        catch (Exception e) {
                            answer = Doc.of("ok", (Object)0, "errmsg", "no such command: '" + cmd + "'");
                            log.warn("errror running command " + cmd, (Throwable)e);
                        }
                    }
                }
                answer.put("$clusterTime", Doc.of("clusterTime", new MongoTimestamp(System.currentTimeMillis())));
                answer.put("operationTime", new MongoTimestamp(System.currentTimeMillis()));
                reply.setFirstDoc(answer);
                out.write(reply.bytes());
                out.flush();
            }
            s.close();
            in.close();
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("Thread finished!");
        s = null;
    }

    public void terminate() {
        this.running = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.executor.shutdownNow();
        this.executor = null;
    }
}

