/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.wireprotocol.OpCompressed;
import de.caluga.morphium.driver.wireprotocol.OpDelete;
import de.caluga.morphium.driver.wireprotocol.OpGetMore;
import de.caluga.morphium.driver.wireprotocol.OpInsert;
import de.caluga.morphium.driver.wireprotocol.OpKillCursors;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import de.caluga.morphium.driver.wireprotocol.OpUpdate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public abstract class WireProtocolMessage {
    private int size;
    private int messageId;
    private int responseTo;
    private static Logger log = LoggerFactory.getLogger(WireProtocolMessage.class);

    public static WireProtocolMessage parseFromStream(InputStream in) throws SocketException {
        byte[] inBuffer = new byte[16];
        try {
            if (in == null) {
                return null;
            }
            int numRead = in.read(inBuffer, 0, 16);
            if (numRead == -1) {
                return null;
            }
            while (numRead < 16) {
                numRead += in.read(inBuffer, numRead, 16 - numRead);
            }
            int size = WireProtocolMessage.readInt(inBuffer, 0);
            int offset = 4;
            int messageId = WireProtocolMessage.readInt(inBuffer, offset);
            int responseTo = WireProtocolMessage.readInt(inBuffer, offset += 4);
            int opCode = WireProtocolMessage.readInt(inBuffer, offset += 4);
            offset += 4;
            WireProtocolMessage message = null;
            OpCode c = OpCode.findByCode(opCode);
            if (c == null) {
                throw new RuntimeException("Illegal opcode " + opCode);
            }
            message = c.handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            message.setMessageId(messageId);
            message.setSize(size);
            message.setResponseTo(responseTo);
            byte[] buf = new byte[size - 16];
            for (numRead = in.read(buf, 0, size - 16); numRead < size - 16; numRead += in.read(buf, numRead, size - 16 - numRead)) {
            }
            try {
                if (message.getOpCode() == OpCode.OP_COMPRESSED.opCode) {
                    OpCompressed compressed = new OpCompressed();
                    compressed.setMessageId(messageId);
                    compressed.setSize(compressed.getUncompressedSize());
                    compressed.setResponseTo(responseTo);
                    compressed.parsePayload(buf, 0);
                    c = OpCode.findByCode(compressed.getOriginalOpCode());
                    if (c == null) {
                        throw new RuntimeException("Illegal opcode " + compressed.getOriginalOpCode());
                    }
                    message = c.handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    message.setMessageId(messageId);
                    message.setSize(compressed.getUncompressedSize());
                    message.setResponseTo(responseTo);
                    if (compressed.getCompressorId() == 1) {
                        message.parsePayload(Snappy.uncompress((byte[])compressed.getCompressedMessage()), 0);
                    } else if (compressed.getCompressorId() == 2) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(compressed.getCompressedMessage());
                        InflaterInputStream iis = new InflaterInputStream(bais);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        iis.transferTo(baos);
                        message.parsePayload(baos.toByteArray(), 0);
                    }
                } else {
                    message.parsePayload(buf, 0);
                }
                return message;
            }
            catch (Exception e) {
                throw new MorphiumDriverNetworkException("could not read from socket", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readString(byte[] bytes, int idx) {
        int i = idx;
        while (bytes[i] != 0) {
            ++i;
        }
        return new String(bytes, idx, i - idx);
    }

    public static int strLen(byte[] bytes, int idx) {
        int i = idx;
        while (bytes[i] != 0) {
            ++i;
        }
        return i - idx + 1;
    }

    public static int readInt(byte[] bytes, int idx) {
        return bytes[idx] & 0xFF | (bytes[idx + 1] & 0xFF) << 8 | (bytes[idx + 2] & 0xFF) << 16 | (bytes[idx + 3] & 0xFF) << 24;
    }

    public static long readLong(byte[] bytes, int idx) {
        return (long)(bytes[idx] & 0xFF) | (long)(bytes[idx + 1] & 0xFF) << 8 | (long)(bytes[idx + 2] & 0xFF) << 16 | (long)(bytes[idx + 3] & 0xFF) << 24 | (long)(bytes[idx + 4] & 0xFF) << 32 | (long)(bytes[idx + 5] & 0xFF) << 40 | (long)(bytes[idx + 6] & 0xFF) << 48 | (long)(bytes[idx + 7] & 0xFF) << 56;
    }

    public static void writeLong(long lng, OutputStream out) throws IOException {
        for (int i = 7; i >= 0; --i) {
            out.write((byte)(lng >> (7 - i) * 8 & 0xFFL));
        }
    }

    public abstract void parsePayload(byte[] var1, int var2) throws IOException;

    public abstract byte[] getPayload() throws IOException;

    public abstract int getOpCode();

    public final byte[] bytes() throws IOException {
        byte[] payload = this.getPayload();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.getOpCode() == OpCode.OP_COMPRESSED.opCode) {
            this.writeInt(payload.length + 16, out);
            this.writeInt(this.messageId, out);
            this.writeInt(this.responseTo, out);
            this.writeInt(this.getOpCode(), out);
            out.write(payload);
        } else {
            OpCompressed compressed = new OpCompressed();
            compressed.setResponseTo(this.responseTo);
            compressed.setOriginalOpCode(this.getOpCode());
            compressed.setMessageId(this.messageId);
            compressed.setCompressorId(1);
            compressed.setUncompressedSize(payload.length);
            compressed.setCompressedMessage(Snappy.compress((byte[])payload));
            compressed.setSize(compressed.getCompressedMessage().length + 9);
            this.writeInt(compressed.getSize() + 16, out);
            this.writeInt(this.messageId, out);
            this.writeInt(this.responseTo, out);
            this.writeInt(compressed.getOpCode(), out);
            this.writeInt(this.getOpCode(), out);
            this.writeInt(compressed.getUncompressedSize(), out);
            out.write((byte)compressed.getCompressorId());
            out.write(compressed.getCompressedMessage());
        }
        return out.toByteArray();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public int getResponseTo() {
        return this.responseTo;
    }

    public void setResponseTo(int responseTo) {
        this.responseTo = responseTo;
    }

    public void writeInt(int value, OutputStream to) throws IOException {
        to.write((byte)(value & 0xFF));
        to.write((byte)(value >> 8 & 0xFF));
        to.write((byte)(value >> 16 & 0xFF));
        to.write((byte)(value >> 24 & 0xFF));
    }

    public void writeString(String n, OutputStream to) throws IOException {
        to.write(n.getBytes("UTF-8"));
        to.write(0);
    }

    public static enum OpCode {
        OP_REPLY(1, OpReply.class),
        OP_UPDATE(2001, OpUpdate.class),
        OP_INSERT(2002, OpInsert.class),
        OP_QUERY(2004, OpQuery.class),
        OP_GET_MORE(2005, OpGetMore.class),
        OP_DELETE(2006, OpDelete.class),
        OP_KILL_CURSORS(2007, OpKillCursors.class),
        OP_COMPRESSED(2012, OpCompressed.class),
        OP_MSG(2013, OpMsg.class);

        int opCode;
        Class<? extends WireProtocolMessage> handler;

        private OpCode(int opCode, Class<? extends WireProtocolMessage> handler) {
            this.opCode = opCode;
            this.handler = handler;
        }

        static OpCode findByCode(int c) {
            for (OpCode o : OpCode.values()) {
                if (o.opCode != c) continue;
                return o;
            }
            return null;
        }
    }
}

