/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.wire.DriverBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BulkContext
extends BulkRequestContext {
    private final DriverBase driver;
    private final boolean ordered;
    private final String db;
    private final String collection;
    private final WriteConcern wc;
    private final List<BulkRequest> requests;

    public BulkContext(Morphium m, String db, String collection, DriverBase driver, boolean ordered, int batchSize, WriteConcern wc) {
        super(m);
        this.driver = driver;
        this.ordered = ordered;
        this.db = db;
        this.collection = collection;
        this.wc = wc;
        this.requests = new ArrayList<BulkRequest>();
    }

    public void addRequest(BulkRequest br) {
        this.requests.add(br);
    }

    @Override
    public UpdateBulkRequest addUpdateBulkRequest() {
        UpdateBulkRequest up = new UpdateBulkRequest();
        this.addRequest(up);
        return up;
    }

    @Override
    public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
        InsertBulkRequest in = new InsertBulkRequest(toInsert);
        this.addRequest(in);
        return in;
    }

    @Override
    public DeleteBulkRequest addDeleteBulkRequest() {
        DeleteBulkRequest del = new DeleteBulkRequest();
        this.addRequest(del);
        return del;
    }

    public Doc execute() throws MorphiumDriverException {
        int count = 0;
        ArrayList results = new ArrayList();
        ArrayList<Map<String, Object>> inserts = new ArrayList<Map<String, Object>>();
        ArrayList stores = new ArrayList();
        ArrayList updates = new ArrayList();
        for (BulkRequest br : this.requests) {
            if (br instanceof InsertBulkRequest) {
                inserts.addAll(((InsertBulkRequest)br).getToInsert());
                if (inserts.size() >= this.driver.getMaxWriteBatchSize()) {
                    inserts.clear();
                }
            } else if (!(br instanceof DeleteBulkRequest)) {
                UpdateBulkRequest up = (UpdateBulkRequest)br;
                HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
                cmd.put("q", up.getQuery());
                cmd.put("u", up.getCmd());
                cmd.put("upsert", Boolean.valueOf(up.isUpsert()));
                cmd.put("multi", Boolean.valueOf(up.isMultiple()));
                updates.add(cmd);
                if (updates.size() >= this.driver.getMaxWriteBatchSize()) {
                    updates.clear();
                }
            }
            ++count;
        }
        if (!updates.isEmpty()) {
            Iterator<BulkRequest> iterator = null;
        }
        HashMap res = new HashMap();
        boolean delCount = false;
        boolean matchedCount = false;
        boolean insertCount = false;
        boolean modifiedCount = false;
        boolean upsertCount = false;
        for (Map map : results) {
        }
        return null;
    }
}

