/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.DriverTailableIterationCallback;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WatchCommand
extends MongoCommand<WatchCommand> {
    @Transient
    private DriverTailableIterationCallback cb;
    private Integer batchSize;
    private List<Map<String, Object>> pipeline;
    private Boolean explain;
    private Boolean allowDiskUse;
    private Integer maxTimeMS;
    private Boolean bypassDocumentValidation;
    private Map<String, Object> readConcern;
    private Map<String, Object> collation;
    private Object hint;
    private Doc writeConern;
    private Doc let;
    private Doc cursor;
    private FullDocumentBeforeChangeEnum fullDocumentBeforeChange;
    private FullDocumentEnum fullDocument;
    private Boolean showExpandedEvents;

    public WatchCommand(MongoConnection d) {
        super(d);
    }

    public Boolean getShowExpandedEvents() {
        return this.showExpandedEvents;
    }

    public WatchCommand setShowExpandedEvents(Boolean showExpandedEvents) {
        this.showExpandedEvents = showExpandedEvents;
        return this;
    }

    public FullDocumentBeforeChangeEnum getFullDocumentBeforeChange() {
        return this.fullDocumentBeforeChange;
    }

    public WatchCommand setFullDocumentBeforeChange(FullDocumentBeforeChangeEnum fullDocumentBeforeChange) {
        this.fullDocumentBeforeChange = fullDocumentBeforeChange;
        return this;
    }

    public FullDocumentEnum getFullDocument() {
        return this.fullDocument;
    }

    public WatchCommand setFullDocument(FullDocumentEnum fullDocument) {
        this.fullDocument = fullDocument;
        return this;
    }

    public List<Map<String, Object>> getPipeline() {
        return this.pipeline;
    }

    public WatchCommand setPipeline(List<Map<String, Object>> pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public Boolean getExplain() {
        return this.explain;
    }

    public WatchCommand setExplain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public WatchCommand setAllowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public Integer getMaxTimeMS() {
        return this.maxTimeMS;
    }

    public WatchCommand setMaxTimeMS(Integer maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public WatchCommand setBypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Map<String, Object> getReadConcern() {
        return this.readConcern;
    }

    public WatchCommand setReadConcern(Map<String, Object> readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public Map<String, Object> getCollation() {
        return this.collation;
    }

    public WatchCommand setCollation(Map<String, Object> collation) {
        this.collation = collation;
        return this;
    }

    public Object getHint() {
        return this.hint;
    }

    public WatchCommand setHint(Object hint) {
        this.hint = hint;
        return this;
    }

    public Doc getWriteConern() {
        return this.writeConern;
    }

    public WatchCommand setWriteConern(Doc writeConern) {
        this.writeConern = writeConern;
        return this;
    }

    public Doc getLet() {
        return this.let;
    }

    public WatchCommand setLet(Doc let) {
        this.let = let;
        return this;
    }

    public Doc getCursor() {
        return this.cursor;
    }

    public WatchCommand setCursor(Doc cursor) {
        this.cursor = cursor;
        return this;
    }

    public DriverTailableIterationCallback getCb() {
        return this.cb;
    }

    public WatchCommand setCb(DriverTailableIterationCallback cb) {
        this.cb = cb;
        return this;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public WatchCommand setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public String getCommandName() {
        return "aggregate";
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        throw new IllegalArgumentException("Please use watch()");
    }

    public void watch() throws MorphiumDriverException {
        this.getConnection().watch(this);
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> m = super.asMap();
        m.remove("cb");
        ArrayList<Map<String, Object>> localPipeline = new ArrayList<Map<String, Object>>();
        Doc changeStream = Doc.of();
        localPipeline.add(Doc.of("$changeStream", changeStream));
        if (this.getPipeline() != null && !this.getPipeline().isEmpty()) {
            localPipeline.addAll(this.getPipeline());
        }
        Doc cmd = Doc.of("aggregate", this.getColl() == null ? Integer.valueOf(1) : this.getColl()).add("pipeline", localPipeline);
        if (this.fullDocument != null) {
            m.remove("fullDocument");
            changeStream.put("fullDocument", this.fullDocument.n);
        }
        if (this.fullDocumentBeforeChange != null) {
            m.remove("fullDocumentBeforeChange");
            changeStream.add("fullDocumentBeforeChange", this.fullDocumentBeforeChange.name());
        }
        if (this.showExpandedEvents != null) {
            m.remove("showExpandedEvents");
            changeStream.put("showExpandedEvents", this.showExpandedEvents);
        }
        if (this.cursor == null) {
            cmd.add("cursor", Doc.of("batchSize", (Object)(this.batchSize == null ? this.getConnection().getDriver().getDefaultBatchSize() : this.batchSize.intValue())));
        }
        m.remove("batchSize");
        m.putAll(cmd);
        return m;
    }

    @Override
    public WatchCommand fromMap(Map<String, Object> m) {
        super.fromMap(m);
        this.pipeline = new ArrayList<Map<String, Object>>((List)m.get("pipeline"));
        Map cstr = this.pipeline.remove(0);
        cstr = (Map)cstr.get("$changeStream");
        if (cstr.get("fullDocument") != null) {
            for (FullDocumentEnum fde : FullDocumentEnum.values()) {
                if (!fde.n.equals(cstr.get("fullDocument"))) continue;
                this.fullDocument = fde;
            }
        }
        if (cstr.containsKey("fullDocumentBeforeChange")) {
            this.fullDocumentBeforeChange = FullDocumentBeforeChangeEnum.valueOf((String)cstr.get("fullDocumentBeforeChange"));
        }
        this.showExpandedEvents = cstr.get("showExpandedEvents") instanceof Boolean ? (Boolean)cstr.get("showExpandedEvents") : Boolean.valueOf("true".equals(cstr.get("showExpandedEvents")));
        return this;
    }

    public static enum FullDocumentBeforeChangeEnum {
        whenAvailable,
        required,
        off;

    }

    public static enum FullDocumentEnum {
        updateLookup("updateLookup"),
        defaultValue("default");

        String n;

        private FullDocumentEnum(String name) {
            this.n = name;
        }

        public String toString() {
            return this.n;
        }
    }
}

