/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.AdminMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.util.Map;

public class ShutdownCommand
extends AdminMongoCommand<ShutdownCommand> {
    private Boolean force;
    private Integer timeoutSecs;

    public ShutdownCommand(MongoConnection d) {
        super(d);
    }

    public Boolean getForce() {
        return this.force;
    }

    public ShutdownCommand setForce(Boolean force) {
        this.force = force;
        return this;
    }

    public Integer getTimeoutSecs() {
        return this.timeoutSecs;
    }

    public ShutdownCommand setTimeoutSecs(Integer timeoutSecs) {
        this.timeoutSecs = timeoutSecs;
        return this;
    }

    @Override
    public String getCommandName() {
        return "shutdown";
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> m = super.asMap();
        m.put(this.getCommandName(), 1);
        return m;
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        int msg = this.executeAsync();
        return this.getConnection().readSingleAnswer(msg);
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        return (Integer)new NetworkCallHelper().doCall(() -> {
            MongoConnection connection = this.getConnection();
            this.setMetaData("server", connection.getConnectedTo());
            long start = System.currentTimeMillis();
            int msg = connection.sendCommand(this);
            return msg;
        }, this.getConnection().getDriver().getRetriesOnNetworkError(), this.getConnection().getDriver().getSleepBetweenErrorRetries());
    }
}

