/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.types.ObjectId;
import org.slf4j.LoggerFactory;

public class MorphiumId
implements Comparable<MorphiumId>,
Serializable {
    private static final int THE_MACHINE_ID;
    private static final AtomicInteger COUNT;
    public static ThreadLocal<Short> threadPid;
    private final short pid;
    private final int counter;
    private final int timestamp;
    private final int machineId;

    public MorphiumId() {
        this((Date)null);
    }

    public MorphiumId(Date date) {
        this.pid = MorphiumId.createPID();
        this.counter = COUNT.getAndIncrement() & 0xFFFFFF;
        this.machineId = THE_MACHINE_ID;
        long time = date == null ? System.currentTimeMillis() : date.getTime();
        this.timestamp = (int)(time / 1000L);
    }

    public MorphiumId(String hexString) {
        this(MorphiumId.hexToByte(hexString.toLowerCase()));
    }

    public MorphiumId(ObjectId id) {
        this(id.toByteArray());
    }

    public MorphiumId(byte[] bytes) {
        this(bytes, 0);
    }

    private MorphiumId(short pid, int c, int ts) {
        this.pid = pid;
        this.counter = c;
        this.timestamp = ts;
        this.machineId = THE_MACHINE_ID;
    }

    public MorphiumId(byte[] bytes, int idx) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        if (idx + 12 > bytes.length) {
            throw new IllegalArgumentException("not enough data, 12 bytes needed");
        }
        this.timestamp = this.readInt(bytes, idx, 4);
        this.machineId = this.readInt(bytes, idx + 4, 3);
        this.pid = (short)this.readInt(bytes, idx + 7, 2);
        this.counter = this.readInt(bytes, idx + 9, 3);
    }

    private static byte[] hexToByte(String s) {
        if (s == null || s.length() != 24 || s.matches("[g-zG-Z]")) {
            throw new IllegalArgumentException("no hex string: " + s);
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    private static short createPID() {
        short processId;
        try {
            String pName = ManagementFactory.getRuntimeMXBean().getName();
            processId = pName.contains("@") ? (short)Integer.parseInt(pName.substring(0, pName.indexOf(64))) : (short)pName.hashCode();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(MorphiumId.class).error("could not get processID - using random fallback");
            processId = (short)new SecureRandom().nextInt();
        }
        return processId;
    }

    private static int createMachineId() {
        int machineId = 0;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            StringBuilder b = new StringBuilder();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                byte[] hwAdress = ni.getHardwareAddress();
                if (hwAdress == null) continue;
                ByteBuffer buf = ByteBuffer.wrap(hwAdress);
                try {
                    b.append(buf.getChar());
                    b.append(buf.getChar());
                    b.append(buf.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machineId = b.toString().hashCode();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(MorphiumId.class).error("error accessing nics to create machine identifier... using fallback", t);
        }
        if (machineId == 0) {
            machineId = new SecureRandom().nextInt();
        }
        return machineId &= 0xFFFFFF;
    }

    private int readInt(byte[] bytes, int idx, int len) {
        switch (len) {
            case 4: {
                return bytes[idx] << 24 | (bytes[idx + 1] & 0xFF) << 16 | (bytes[idx + 2] & 0xFF) << 8 | bytes[idx + 3] & 0xFF;
            }
            case 3: {
                return (bytes[idx] & 0xFF) << 16 | (bytes[idx + 1] & 0xFF) << 8 | bytes[idx + 2] & 0xFF;
            }
            case 2: {
                return (bytes[idx] & 0xFF) << 8 | bytes[idx + 1] & 0xFF;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        MorphiumId morphiumId = (MorphiumId)o;
        return this.machineId == morphiumId.machineId && this.pid == morphiumId.pid && this.counter == morphiumId.counter && this.timestamp == morphiumId.timestamp;
    }

    public int hashCode() {
        int result = this.machineId;
        result = 31 * result + this.pid;
        result = 31 * result + this.counter;
        result = 31 * result + this.timestamp;
        return result;
    }

    private void storeInt(byte[] arr, int offset, int val) {
        for (int i = 0; i < 4; ++i) {
            arr[i + offset] = (byte)(val >> (7 - i) * 8 & 0xFF);
        }
    }

    private void storeShort(byte[] arr, int offset, int val) {
        arr[offset] = (byte)(val >> 8 & 0xFF);
        arr[offset + 1] = (byte)(val & 0xFF);
    }

    private void storeInt3Byte(byte[] arr, int offset, int val) {
        arr[offset] = (byte)(val >> 16 & 0xFF);
        arr[offset + 1] = (byte)(val >> 8 & 0xFF);
        arr[offset + 2] = (byte)(val & 0xFF);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[12];
        this.storeInt(bytes, 0, this.timestamp);
        this.storeInt3Byte(bytes, 4, this.machineId);
        this.storeShort(bytes, 7, this.pid);
        this.storeInt3Byte(bytes, 9, this.counter);
        return bytes;
    }

    public long getTime() {
        return (long)this.timestamp * 1000L;
    }

    public short getPid() {
        return this.pid;
    }

    public int getCounter() {
        return this.counter;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public String toString() {
        String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        byte[] b = this.getBytes();
        StringBuilder bld = new StringBuilder();
        for (byte by : b) {
            int idx = by >>> 4 & 0xF;
            bld.append(chars[idx]);
            idx = by & 0xF;
            bld.append(chars[idx]);
        }
        return bld.toString();
    }

    @Override
    public int compareTo(MorphiumId o) {
        if (o == null) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    static {
        COUNT = new AtomicInteger(new SecureRandom().nextInt());
        try {
            THE_MACHINE_ID = MorphiumId.createMachineId();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

