/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheHousekeeper;
import de.caluga.morphium.cache.CacheListener;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.cache.jcache.CacheEntry;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumCacheImpl
implements MorphiumCache {
    private final List<CacheListener> cacheListeners;
    private final Logger logger = LoggerFactory.getLogger(MorphiumCacheImpl.class);
    private final CacheHousekeeper cacheHousekeeper;
    private Map<Class<?>, Map<String, CacheEntry>> cache;
    private final Map<Class<?>, Map<Object, Object>> idCache;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper(false);

    public MorphiumCacheImpl() {
        this.cache = new ConcurrentHashMap();
        this.idCache = new ConcurrentHashMap();
        this.cacheListeners = Collections.synchronizedList(new ArrayList());
        this.cacheHousekeeper = new CacheHousekeeper(this);
        this.cacheHousekeeper.start();
    }

    @Override
    public void setGlobalCacheTimeout(int tm) {
        this.cacheHousekeeper.setGlobalValidCacheTime(tm);
    }

    @Override
    public void setHouskeepingIntervalPause(int p) {
        this.cacheHousekeeper.setHouskeepingPause(p);
    }

    @Override
    public void setAnnotationAndReflectionHelper(AnnotationAndReflectionHelper hlp) {
        this.annotationHelper = hlp;
        this.cacheHousekeeper.setAnnotationHelper(hlp);
    }

    @Override
    public void addCacheListener(CacheListener cl) {
        this.cacheListeners.add(cl);
    }

    @Override
    public boolean isListenerRegistered(CacheListener cl) {
        return this.cacheListeners.contains(cl);
    }

    @Override
    public void removeCacheListener(CacheListener cl) {
        this.cacheListeners.remove(cl);
    }

    @Override
    public <T> void addToCache(String k, Class<? extends T> type, List<T> ret) {
        if (k == null) {
            return;
        }
        CacheEntry<List<Object>> co = new CacheEntry<List<? extends T>>(ret, k);
        co.setKey(k);
        co.setType(type);
        for (CacheListener cl : this.cacheListeners) {
            co = cl.wouldAddToCache(k, co, this.getFromCache(type, k) != null);
            if (co != null) continue;
            return;
        }
        if (!k.endsWith("idlist") && !k.contains("project:")) {
            Map<Class<?>, Map<Object, Object>> idCacheClone = this.idCache;
            for (T record : ret) {
                idCacheClone.putIfAbsent(type, new ConcurrentHashMap());
                idCacheClone.get(type).put(this.annotationHelper.getId(record), record);
            }
        }
        CacheEntry<List<T>> e = new CacheEntry<List<T>>(ret, k);
        e.setLru(System.currentTimeMillis());
        this.cache.putIfAbsent(type, new ConcurrentHashMap());
        this.cache.get(type).put(k, e);
    }

    @Override
    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            this.clearCachefor(cls);
        }
    }

    @Override
    public boolean isCached(Class<?> type, String k) {
        Map<Class<?>, Map<String, CacheEntry>> snapshotCache = this.cache;
        try {
            return snapshotCache.get(type) != null && snapshotCache.get(type).get(k) != null && snapshotCache.get(type).get(k).getResult() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        Map<Class<?>, Map<String, CacheEntry>> snapshotCache = this.cache;
        if (snapshotCache.get(type) == null || snapshotCache.get(type).get(k) == null) {
            return null;
        }
        try {
            CacheEntry CacheEntry2 = snapshotCache.get(type).get(k);
            CacheEntry2.setLru(System.currentTimeMillis());
            return (List)CacheEntry2.getResult();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<Class<?>, Map<String, CacheEntry>> getCache() {
        return this.cache;
    }

    public void setCache(Map<Class<?>, Map<String, CacheEntry>> cache) {
        this.cache = cache;
    }

    @Override
    public <T> T getFromIDCache(Class<? extends T> type, Object id) {
        if (this.idCache.get(type) != null && id != null) {
            return (T)this.idCache.get(type).get(id);
        }
        return null;
    }

    @Override
    public void setValidCacheTime(Class type, int time) {
        this.cacheHousekeeper.setValidCacheTime(type, time);
    }

    @Override
    public void setDefaultCacheTime(Class type) {
        this.cacheHousekeeper.setDefaultValidCacheTime(type);
    }

    @Override
    public String getCacheKey(Class type, Map<String, Object> qo, Map<String, Integer> sort, Map<String, Object> projection, String collection, int skip, int limit) {
        return Utils.getCacheKey(type, qo, sort, projection, collection, skip, limit, this.annotationHelper);
    }

    @Override
    public String getCacheKey(Query q) {
        return this.getCacheKey(q.getType(), q.toQueryObject(), q.getSort(), q.getFieldListForQuery(), q.getCollectionName(), q.getSkip(), q.getLimit());
    }

    @Override
    public void clearCachefor(Class<?> cls) {
        for (CacheListener cl : this.cacheListeners) {
            if (cl.wouldClearCache(cls)) continue;
            this.logger.info("Not clearing cache due to veto of cache listener " + cl.getClass().getName());
            return;
        }
        if (this.cache.get(cls) != null) {
            this.cache.get(cls).clear();
        }
        if (this.idCache.get(cls) != null) {
            this.idCache.get(cls).clear();
        }
    }

    @Override
    public Set<Class<?>> getCachedTypes() {
        return this.idCache.keySet();
    }

    @Override
    public void resetCache() {
        this.setCache(new ConcurrentHashMap());
    }

    @Override
    public void close() {
        this.cacheHousekeeper.end();
        this.resetCache();
    }

    @Override
    public void removeEntryFromIdCache(Class cls, Object id) {
        if (this.idCache.get(cls) != null) {
            this.idCache.get(cls).remove(id);
        }
    }

    @Override
    public void removeEntryFromCache(Class cls, Object id) {
        if (this.idCache.get(cls) != null && this.idCache.get(cls).get(id) != null) {
            for (CacheListener cl : this.cacheListeners) {
                CacheEntry<Object> e;
                if (cl.wouldRemoveEntryFromCache(id, e = new CacheEntry<Object>(this.idCache.get(cls).get(id), id), false)) continue;
                this.logger.info("Not removing from cache due to veto from CacheListener " + cl.getClass().getName());
                return;
            }
        }
        this.idCache.get(cls).remove(id);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.cache.get(cls).keySet()) {
            if (this.cache.get(cls).get(key) != null) {
                for (Object el : (List)this.cache.get(cls).get(key).getResult()) {
                    Object lid = this.annotationHelper.getId(el);
                    if (lid == null) {
                        this.logger.error("Null id in CACHE?");
                        toRemove.add(key);
                    }
                    if (lid == null || !lid.equals(id)) continue;
                    toRemove.add(key);
                }
                continue;
            }
            this.logger.error("Null element in CACHE?");
        }
        for (String k : toRemove) {
            this.cache.get(cls).remove(k);
        }
    }

    @Override
    public Map<String, Integer> getSizes() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (Class<?> type : this.cache.keySet()) {
            this.idCache.putIfAbsent(type, new ConcurrentHashMap());
            this.cache.putIfAbsent(type, new ConcurrentHashMap());
            ret.put("resultCache|" + type.getName(), this.cache.get(type).size());
            ret.put("idCache|" + type.getName(), this.idCache.get(type).size());
        }
        return ret;
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
    }

    @Override
    public CacheManager getCacheManager() {
        return null;
    }
}

