/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.bulk;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumBulkContext<T> {
    private final Logger log = LoggerFactory.getLogger(MorphiumBulkContext.class);
    private final BulkRequestContext ctx;
    private final List<Runnable> preEvents = new ArrayList<Runnable>();
    private final List<Runnable> postEvents = new ArrayList<Runnable>();

    public MorphiumBulkContext(BulkRequestContext ctx) {
        this.ctx = ctx;
    }

    public Map<String, Object> runBulk() {
        Map<String, Object> ret;
        this.firePre();
        try {
            ret = this.ctx.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        this.firePost();
        return ret;
    }

    public int getNumberOfRequests() {
        return this.preEvents.size();
    }

    private void firePre() {
        this.preEvents.forEach(Runnable::run);
    }

    private void firePost() {
        this.postEvents.forEach(Runnable::run);
    }

    private void createUpdateRequest(Query<T> query, String command, Map<String, Object> valuesToSet, boolean upsert, boolean multiple) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : valuesToSet.entrySet()) {
            values.put(this.ctx.getMorphium().getARHelper().getMongoFieldName(query.getType(), e.getKey(), true), e.getValue());
        }
        UpdateBulkRequest up = this.ctx.addUpdateBulkRequest();
        up.setQuery(Doc.of(query.toQueryObject()));
        up.setUpsert(upsert);
        up.setCmd(Doc.of(UtilsMap.of(command, values)));
        up.setMultiple(multiple);
        this.preEvents.add(() -> {
            switch (command) {
                case "$set": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
                    break;
                }
                case "$inc": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
                    break;
                }
                case "$unset": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
                    break;
                }
                case "$min": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MIN);
                    break;
                }
                case "$max": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MAX);
                    break;
                }
                case "$currentDate": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.CURRENTDATE);
                    break;
                }
                case "$pop": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.POP);
                    break;
                }
                case "$push": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    break;
                }
                case "$mul": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MUL);
                    break;
                }
                case "$rename": {
                    this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.RENAME);
                    break;
                }
                default: {
                    this.log.error("Unknown update command " + command);
                }
            }
        });
        this.postEvents.add(() -> {
            switch (command) {
                case "$set": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.SET);
                    break;
                }
                case "$inc": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.INC);
                    break;
                }
                case "$unset": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.UNSET);
                    break;
                }
                case "$min": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MIN);
                    break;
                }
                case "$max": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MAX);
                    break;
                }
                case "$currentDate": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.CURRENTDATE);
                    break;
                }
                case "$pop": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.POP);
                    break;
                }
                case "$push": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    break;
                }
                case "$mul": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.MUL);
                    break;
                }
                case "$rename": {
                    this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.RENAME);
                    break;
                }
                default: {
                    this.log.error("Unknown update command " + command);
                }
            }
        });
    }

    public void addInsertRequest(List<T> toInsert) {
        HashMap<T, Boolean> isNew = new HashMap<T, Boolean>();
        ArrayList<Map<String, Object>> ins = new ArrayList<Map<String, Object>>();
        for (T o : toInsert) {
            Map<String, Object> marshall = this.ctx.getMorphium().getMapper().serialize(o);
            ins.add(Doc.of(marshall));
            isNew.put(o, marshall.get("_id") == null);
        }
        this.ctx.addInsertBulkRequest(ins);
        this.preEvents.add(() -> {
            if (toInsert.size() == 1) {
                this.ctx.getMorphium().firePreStore(toInsert.get(0), this.ctx.getMorphium().getARHelper().getId(toInsert.get(0)) == null);
            } else {
                this.ctx.getMorphium().firePreStore(isNew);
            }
        });
        this.postEvents.add(() -> {
            if (toInsert.size() == 1) {
                this.ctx.getMorphium().firePostStore(toInsert.get(0), this.ctx.getMorphium().getARHelper().getId(toInsert.get(0)) == null);
            } else {
                this.ctx.getMorphium().firePostStore(isNew);
            }
        });
    }

    public void addDeleteRequest(T entity) {
        DeleteBulkRequest del = this.ctx.addDeleteBulkRequest();
        del.setQuery(Doc.of("_id", this.ctx.getMorphium().getARHelper().getId(entity)));
        del.setMultiple(false);
        this.preEvents.add(() -> this.ctx.getMorphium().firePreRemove(entity));
        this.postEvents.add(() -> this.ctx.getMorphium().firePostRemoveEvent(entity));
    }

    public void addDeleteRequest(List<T> entities) {
        entities.forEach(this::addDeleteRequest);
    }

    public void addDeleteRequest(Query<T> q, boolean multiple) {
        DeleteBulkRequest del = this.ctx.addDeleteBulkRequest();
        del.setMultiple(multiple);
        del.setQuery(Doc.of(q.toQueryObject()));
        this.preEvents.add(() -> this.ctx.getMorphium().firePreRemoveEvent(q));
        this.postEvents.add(() -> this.ctx.getMorphium().firePostRemoveEvent(q));
    }

    public void addCustomUpdateRequest(Query<T> query, Map<String, Object> command, boolean upsert, boolean multiple) {
        UpdateBulkRequest up = this.ctx.addUpdateBulkRequest();
        up.setQuery(Doc.of(query.toQueryObject()));
        up.setUpsert(upsert);
        up.setMultiple(multiple);
        up.setCmd(Doc.of(command));
        this.preEvents.add(() -> this.ctx.getMorphium().firePreUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.CUSTOM));
        this.postEvents.add(() -> this.ctx.getMorphium().firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.CUSTOM));
    }

    public void addSetRequest(T obj, String field, Object value, boolean upsert) {
        this.addSetRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addUnSetRequest(T obj, String field, Object value, boolean upsert) {
        Morphium m = this.ctx.getMorphium();
        Query<?> q = m.createQueryFor(obj.getClass());
        q.f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj));
        this.addUnsetRequest(q, field, value, upsert, false);
    }

    public void addSetRequest(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$set", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addUnsetRequest(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$unset", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addIncRequest(Query<T> query, String field, Number value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$inc", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addIncRequest(T obj, String field, Number value, boolean upsert) {
        this.addIncRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addCurrentDateRequest(Query<T> query, boolean upsert, boolean multiple, String ... fld) {
        HashMap<String, Object> toSet = new HashMap<String, Object>();
        for (String f : fld) {
            toSet.put(f, true);
        }
        this.createUpdateRequest(query, "$currentDate", toSet, upsert, multiple);
    }

    public void addCurrentDateRequest(T obj, String field, boolean upsert) {
        this.addCurrentDateRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), upsert, false, field);
    }

    public void addMinRequest(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$min", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addMinRequest(Query<T> query, Map<String, Object> toSet, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$min", toSet, upsert, multiple);
    }

    public void addMinRequest(T obj, String field, Object value, boolean upsert) {
        this.addMinRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addMaxRequest(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$max", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addMaxRequest(Query<T> query, Map<String, Object> toSet, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$max", toSet, upsert, multiple);
    }

    public void addMaxRequest(T obj, String field, Object value, boolean upsert) {
        this.addMaxRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addRenameRequest(Query<T> query, String field, String newName, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$rename", UtilsMap.of(field, newName), upsert, multiple);
    }

    public void addRenameRequest(T obj, String field, String newName, boolean upsert) {
        this.addRenameRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, newName, upsert, false);
    }

    public void addMulRequest(Query<T> query, String field, Number value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$mul", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addMulRequest(T obj, String field, Number value, boolean upsert) {
        this.addMulRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addPopRequest(Query<T> query, String field, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$pop", UtilsMap.of(field, 1), upsert, multiple);
    }

    public void addPopRequest(T obj, String field, boolean upsert) {
        this.addPopRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, upsert, false);
    }

    public void addPushRequest(Query<T> query, String field, Object value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$push", UtilsMap.of(field, value), upsert, multiple);
    }

    public void addPushRequest(T obj, String field, Object value, boolean upsert) {
        this.addPushRequest(this.ctx.getMorphium().createQueryFor(obj.getClass()).f(this.ctx.getMorphium().getARHelper().getIdFieldName(obj)).eq(this.ctx.getMorphium().getARHelper().getId(obj)), field, value, upsert, false);
    }

    public void addSetRequest(Query<T> query, Map<String, Object> toSet, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$set", toSet, upsert, multiple);
    }

    public void addUnsetRequest(Query<T> query, Map<String, Object> toSet, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$unset", toSet, upsert, multiple);
    }

    public void addIncRequest(Query<T> query, Map<String, Number> toInc, boolean upsert, boolean multiple) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Number> e : toInc.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
        this.createUpdateRequest(query, "$inc", m, upsert, multiple);
    }

    public void addPushRequest(Query<T> query, String field, List<Object> value, boolean upsert, boolean multiple) {
        this.createUpdateRequest(query, "$push", UtilsMap.of(field, value), upsert, multiple);
    }
}

