/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class IndexDescription {
    private static AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(false);
    private Map<String, Object> key;
    private String name;
    private Boolean background;
    private Boolean unique;
    private Map<String, Object> partialFilterExpression;
    private Boolean sparse;
    private Integer expireAfterSeconds;
    private Boolean hidden;
    private Map<String, Object> storageEngine;
    private Map<String, Object> weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textIndexVersion;
    private Integer _2dsphereIndexVersion;
    private Integer bits;
    private Integer min;
    private Integer max;
    private Map<String, Object> collation;
    private Map<String, Object> wildcardProjection;

    public static IndexDescription fromMaps(Map<String, Object> key, Map<String, Object> options) {
        Doc idx = Doc.of("key", key);
        if (options != null) {
            idx.putAll(options);
        }
        return IndexDescription.fromMap(idx);
    }

    public static IndexDescription fromMap(Map<String, Object> incoming) {
        if (incoming.get("name") == null || incoming.get("name").equals("")) {
            StringBuilder sb = new StringBuilder();
            Map keymap = (Map)incoming.get("key");
            for (String k : keymap.keySet()) {
                sb.append(k);
                sb.append("_");
                sb.append(keymap.get(k).toString());
                sb.append("_");
            }
            incoming.put("name", sb.toString());
        }
        IndexDescription idx = new IndexDescription();
        for (String n : incoming.keySet()) {
            Field fld = an.getField(IndexDescription.class, n);
            if (fld == null) continue;
            try {
                if (fld.getType().equals(Boolean.class) && incoming != null && incoming.get(n) != null && incoming.get(n).getClass().equals(Integer.class)) {
                    incoming.put(n, incoming.get(n).equals(1));
                }
                fld.set(idx, incoming.get(n));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return idx;
    }

    public Map<String, Object> getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public IndexDescription setName(String name) {
        this.name = name;
        return this;
    }

    public Boolean getBackground() {
        return this.background;
    }

    public IndexDescription setBackground(Boolean background) {
        this.background = background;
        return this;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public IndexDescription setUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    public IndexDescription setKey(Map<String, Object> key) {
        this.key = key;
        return this;
    }

    public Map<String, Object> getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public Boolean getSparse() {
        return this.sparse;
    }

    public IndexDescription setSparse(Boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public IndexDescription setExpireAfterSeconds(Integer expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public IndexDescription setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public IndexDescription setPartialFilterExpression(Map<String, Object> partialFilterExpression) {
        this.partialFilterExpression = partialFilterExpression;
        return this;
    }

    public Map<String, Object> getStorageEngine() {
        return this.storageEngine;
    }

    public IndexDescription setStorageEngine(Map<String, Object> storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public Map<String, Object> getWeights() {
        return this.weights;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexDescription setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexDescription setLanguageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextIndexVersion() {
        return this.textIndexVersion;
    }

    public IndexDescription setTextIndexVersion(Integer textIndexVersion) {
        this.textIndexVersion = textIndexVersion;
        return this;
    }

    public Integer get_2dsphereIndexVersion() {
        return this._2dsphereIndexVersion;
    }

    public IndexDescription set_2dsphereIndexVersion(Integer _2dsphereIndexVersion) {
        this._2dsphereIndexVersion = _2dsphereIndexVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public IndexDescription setBits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Integer getMin() {
        return this.min;
    }

    public IndexDescription setMin(Integer min) {
        this.min = min;
        return this;
    }

    public Integer getMax() {
        return this.max;
    }

    public IndexDescription setMax(Integer max) {
        this.max = max;
        return this;
    }

    public IndexDescription setWeights(Map<String, Object> weights) {
        this.weights = weights;
        return this;
    }

    public Map<String, Object> getCollation() {
        return this.collation;
    }

    public IndexDescription setCollation(Map<String, Object> collation) {
        this.collation = collation;
        return this;
    }

    public Map<String, Object> getWildcardProjection() {
        return this.wildcardProjection;
    }

    public IndexDescription setWildcardProjection(Map<String, Object> wildcardProjection) {
        this.wildcardProjection = wildcardProjection;
        return this;
    }

    public Map<String, Object> asMap() {
        Doc map = new Doc();
        for (Field f : an.getAllFields(this.getClass())) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                Object v = f.get(this);
                if (v == null) continue;
                String fn = f.getName();
                if (fn.startsWith("_")) {
                    fn = fn.substring(1);
                }
                map.put(fn, v);
            }
            catch (IllegalAccessException e) {
                LoggerFactory.getLogger(this.getClass()).error("IllegalAccess", (Throwable)e);
            }
        }
        return map;
    }

    public String toString() {
        return Utils.toJsonString(this.asMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDescription that = (IndexDescription)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.background, that.background) && Objects.equals(this.unique, that.unique) && Objects.equals(this.partialFilterExpression, that.partialFilterExpression) && Objects.equals(this.sparse, that.sparse) && Objects.equals(this.expireAfterSeconds, that.expireAfterSeconds) && Objects.equals(this.hidden, that.hidden) && Objects.equals(this.storageEngine, that.storageEngine) && Objects.equals(this.weights, that.weights) && Objects.equals(this.defaultLanguage, that.defaultLanguage) && Objects.equals(this.languageOverride, that.languageOverride) && Objects.equals(this.textIndexVersion, that.textIndexVersion) && Objects.equals(this._2dsphereIndexVersion, that._2dsphereIndexVersion) && Objects.equals(this.bits, that.bits) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && Objects.equals(this.collation, that.collation) && Objects.equals(this.wildcardProjection, that.wildcardProjection);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.background, this.unique, this.partialFilterExpression, this.sparse, this.expireAfterSeconds, this.hidden, this.storageEngine, this.weights, this.defaultLanguage, this.languageOverride, this.textIndexVersion, this._2dsphereIndexVersion, this.bits, this.min, this.max, this.collation, this.wildcardProjection);
    }
}

