/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.replicaset.ReplicasetStatusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSMonitor {
    private static final Logger logger = LoggerFactory.getLogger(RSMonitor.class);
    private ScheduledThreadPoolExecutor executorService;
    private Morphium morphium;
    private ReplicaSetStatus currentStatus;
    private int nullcounter = 0;
    private final List<ReplicasetStatusListener> listeners = new Vector<ReplicasetStatusListener>();

    public RSMonitor(Morphium morphium) {
    }

    public void start() {
    }

    public void addListener(ReplicasetStatusListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(ReplicasetStatusListener lst) {
        this.listeners.remove(lst);
    }

    public void terminate() {
        this.executorService.shutdownNow();
        while (!this.executorService.isShutdown()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void execute() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting RS-Status...");
            }
            this.currentStatus = this.getReplicaSetStatus(true);
            if (this.currentStatus == null) {
                ++this.nullcounter;
                if (logger.isDebugEnabled()) {
                    logger.debug("RS status is null! Counter " + this.nullcounter);
                }
                for (ReplicasetStatusListener l : this.listeners) {
                    l.onGetStatusFailure(this.morphium, this.nullcounter);
                }
            } else {
                this.nullcounter = 0;
            }
            if (this.nullcounter > 10) {
                logger.error("Getting ReplicasetStatus failed 10 times... will gracefully exit thread");
                this.executorService.shutdownNow();
                for (ReplicasetStatusListener l : this.listeners) {
                    l.onMonitorAbort(this.morphium, this.nullcounter);
                }
            }
            if (this.currentStatus != null) {
                for (ReplicasetStatusListener l : this.listeners) {
                    l.gotNewStatus(this.morphium, this.currentStatus);
                }
                for (ReplicaSetNode n : this.currentStatus.getMembers()) {
                    if (this.morphium.getConfig().getHostSeed().contains(n.getName())) {
                        logger.debug("Found host in config " + n.getName());
                        continue;
                    }
                    this.morphium.getConfig().getHostSeed().add(n.getName());
                }
                ArrayList<String> hostsNotFound = new ArrayList<String>();
                for (String host : this.morphium.getConfig().getHostSeed()) {
                    boolean found = false;
                    for (ReplicaSetNode n : this.currentStatus.getMembers()) {
                        if (!n.getName().equals(host)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    hostsNotFound.add(host);
                }
                if (!hostsNotFound.isEmpty()) {
                    this.morphium.getConfig().getHostSeed().removeAll(hostsNotFound);
                    for (ReplicasetStatusListener l : this.listeners) {
                        l.onHostDown(this.morphium, hostsNotFound, this.morphium.getConfig().getHostSeed());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        return null;
    }

    public ReplicaSetStatus getCurrentStatus() {
        return this.currentStatus;
    }
}

