/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.List;
import java.util.Map;

public class CurrentOpCommand
extends MongoCommand<CurrentOpCommand> {
    private int secsRunning;
    private Map<String, Object> filter;
    @Transient
    private MorphiumDriver drv;

    public CurrentOpCommand(MongoConnection d) {
        super(d);
    }

    public CurrentOpCommand(MorphiumDriver drv) {
        super(null);
        this.drv = drv;
    }

    public int getSecsRunning() {
        return this.secsRunning;
    }

    public CurrentOpCommand setSecsRunning(int secsRunning) {
        this.secsRunning = secsRunning;
        return this;
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        if (this.getConnection() != null) {
            return super.executeAsync();
        }
        MongoConnection con = null;
        con = this.drv.getPrimaryConnection(null);
        this.setConnection(con);
        int ret = super.executeAsync();
        this.setConnection(null);
        return ret;
    }

    public Map<String, Object> getFilter() {
        return this.filter;
    }

    public CurrentOpCommand setFilter(Map<String, Object> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public String getCommandName() {
        return "currentOp";
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> m = super.asMap();
        m.put(this.getCommandName(), "1");
        m.remove("secsRunning");
        if (this.secsRunning != 0) {
            m.put("secs_running", Doc.of("$gt", (Object)this.secsRunning));
        }
        if (this.filter != null) {
            m.putAll(this.filter);
        }
        return m;
    }

    @Override
    public CurrentOpCommand fromMap(Map<String, Object> m) {
        super.fromMap(m);
        this.secsRunning = (Integer)((Map)m.get("secs_running")).get("$gt");
        return this;
    }

    public List<Map<String, Object>> execute() throws MorphiumDriverException {
        int msgid = this.getConnection().sendCommand(this);
        Map<String, Object> res = this.getConnection().readSingleAnswer(msgid);
        return (List)res.get("inprog");
    }
}

