/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache.jcache;

import de.caluga.morphium.cache.jcache.CacheImpl;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;

public class CacheManagerImpl
implements CacheManager {
    private CachingProvider cachingProvider;
    private URI uri;
    private ClassLoader classLoader;
    private Properties properties;
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    public CacheManagerImpl(Properties settings) {
    }

    public void setCachingProvider(CachingProvider cachingProvider) {
        this.cachingProvider = cachingProvider;
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Collection<Cache> getCaches() {
        return this.caches.values();
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        CacheImpl cache = new CacheImpl();
        cache.setCacheManager(this);
        this.caches.put(cacheName, cache);
        cache.setName(cacheName);
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        if (!this.caches.containsKey(cacheName)) {
            this.createCache(cacheName, null);
        }
        return this.caches.get(cacheName);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, Object.class, Object.class);
    }

    public Iterable<String> getCacheNames() {
        return this.caches.keySet();
    }

    public void destroyCache(String cacheName) {
        this.getCache(cacheName).clear();
        this.caches.remove(cacheName);
    }

    public void enableManagement(String cacheName, boolean enabled) {
    }

    public void enableStatistics(String cacheName, boolean enabled) {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this);
    }

    private Class<?> getTypeClass() throws ClassNotFoundException {
        return Class.forName(this.getURI().toString());
    }
}

