/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.driver.MorphiumId;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Expr {
    public abstract Object toQueryObject();

    public abstract Object evaluate(Map<String, Object> var1);

    private static Map parseMap(Map<?, ?> o) {
        HashMap<String, Expr> ret = new HashMap<String, Expr>();
        for (Map.Entry<?, ?> e : o.entrySet()) {
            ret.put((String)e.getKey(), Expr.parse(e.getValue()));
        }
        return ret;
    }

    public static Expr parse(final Object o) {
        Logger log = LoggerFactory.getLogger(Expr.class);
        if (o instanceof Map) {
            String k = (String)((Map)o).keySet().stream().findFirst().get();
            if (!k.startsWith("$")) {
                throw new IllegalArgumentException("no proper operation " + k);
            }
            k = k.replaceAll("\\$", "");
            for (Method m : Expr.class.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers())) continue;
                if (k.equals("toString")) {
                    k = "toStr";
                }
                if (!m.getName().equals(k) && !m.getName().equals(k + "Expr")) continue;
                try {
                    Object p = ((Map)o).get("$" + k);
                    if (p instanceof List) {
                        ArrayList<Expr> l = new ArrayList<Expr>();
                        for (Object param : (List)p) {
                            l.add(Expr.parse(param));
                        }
                        if (m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(List.class)) {
                            p = l;
                        } else {
                            if (l.size() != m.getParameterCount() && !m.getParameterTypes()[0].isArray()) continue;
                            p = l.size() == 1 ? l.get(0) : l.toArray(new Expr[0]);
                        }
                    } else {
                        p = p instanceof Map ? Expr.parseMap((Map)p) : Expr.parse(p);
                    }
                    if (p.getClass().isArray()) {
                        if (!m.getParameterTypes()[0].isArray() && m.getParameterCount() != ((Object[])p).length) {
                            log.debug("Wrong method, maybe... parameter count mismatch");
                            continue;
                        }
                    } else {
                        if (m.getParameterCount() > 1) {
                            log.debug("Wrong method, maybe... method needs more than one param, but we only have one");
                            continue;
                        }
                        if (m.getParameterCount() == 1 && m.getParameterTypes()[0].isArray() && !p.getClass().isArray()) {
                            m.setAccessible(true);
                            return (Expr)m.invoke(null, (Object[])new Expr[]{(Expr)p});
                        }
                    }
                    if (m.getParameterCount() > 1 && p.getClass().isArray()) {
                        m.setAccessible(true);
                        Object[] prm = new Object[m.getParameterCount()];
                        for (int i = 0; i < prm.length; ++i) {
                            prm[i] = ((Object[])p)[i];
                        }
                        return (Expr)m.invoke(null, prm);
                    }
                    m.setAccessible(true);
                    return (Expr)m.invoke(null, p);
                }
                catch (Exception e) {
                    log.error("Error during parsing of expr", (Throwable)e);
                }
            }
            throw new IllegalArgumentException("could not parse operation " + k);
        }
        if (o instanceof List) {
            final ArrayList<Expr> ret = new ArrayList<Expr>();
            for (Object e : (List)o) {
                ret.add(Expr.parse(e));
            }
            return new ValueExpr(){

                @Override
                public Object toQueryObject() {
                    return ret;
                }
            };
        }
        if (o instanceof String && ((String)o).startsWith("$")) {
            return Expr.field((String)o);
        }
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return o;
            }
        };
    }

    public static Expr abs(final Expr e) {
        return new OpExprNoList("abs", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.abs(((Number)e.evaluate(context)).doubleValue());
            }
        };
    }

    public static Expr date(final Date d) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return d;
            }
        };
    }

    public static Expr now() {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return new Date();
            }
        };
    }

    public static Expr field(Enum field) {
        return Expr.field(field.name());
    }

    public static Expr field(Enum name, Class type, Morphium m) {
        return Expr.field(m.getARHelper().getMongoFieldName(type, name.name()));
    }

    public static Expr field(String name) {
        return new FieldExpr(name);
    }

    public static Expr mapExpr(final Map<String, Expr> map) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
                for (Map.Entry e : map.entrySet()) {
                    ret.put((String)e.getKey(), ((Expr)e.getValue()).toQueryObject());
                }
                return ret;
            }
        };
    }

    public static Expr add(final Expr ... expr) {
        return new OpExpr("add", Arrays.asList(expr)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Number sum = 0;
                for (Expr f : expr) {
                    Object v = Expr.eval(f, context);
                    if (v instanceof Number) {
                        sum = ((Number)sum).doubleValue() + ((Number)v).doubleValue();
                        continue;
                    }
                    System.out.println("Cannot evaluate");
                }
                return sum;
            }
        };
    }

    public static Expr doubleExpr(final double d) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return d;
            }
        };
    }

    public static Expr intExpr(final int i) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return i;
            }
        };
    }

    public static Expr bool(final boolean v) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return v;
            }
        };
    }

    public static Expr arrayExpr(Expr ... elem) {
        return new ArrayExpr(elem);
    }

    public static Expr string(final String str) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return str;
            }
        };
    }

    public static Expr ceil(final Expr e) {
        return new OpExprNoList("ceil", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.ceil(((Number)e.evaluate(context)).doubleValue());
            }
        };
    }

    public static Expr divide(final Expr divident, final Expr divisor) {
        return new OpExpr("divide", Arrays.asList(divident, divisor)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((Number)Expr.eval(divident, context)).doubleValue() / ((Number)Expr.eval(divisor, context)).doubleValue();
            }
        };
    }

    public static Expr exp(final Expr e) {
        return new OpExprNoList("exp", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.exp(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr floor(final Expr e) {
        return new OpExprNoList("floor", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.floor(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr ln(final Expr e) {
        return new OpExprNoList("ln", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.log1p(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr log(final Expr num, final Expr base) {
        return new OpExpr("log", Arrays.asList(num, base)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.log(((Number)Expr.eval(num, context)).doubleValue()) / Math.log(((Number)Expr.eval(base, context)).doubleValue());
            }
        };
    }

    public static Expr log10(final Expr e) {
        return new OpExprNoList("log10", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.log10(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr mod(final Expr divident, final Expr divisor) {
        return new OpExpr("mod", Arrays.asList(divident, divisor)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object div = Expr.eval(divident, context);
                Object dis = Expr.eval(divisor, context);
                return ((Number)div).doubleValue() % ((Number)dis).doubleValue();
            }
        };
    }

    private static Object eval(Expr e, Map<String, Object> context) {
        Object r = e.evaluate(context);
        while (r instanceof Expr) {
            r = Expr.eval((Expr)r, context);
        }
        return r;
    }

    public static Expr multiply(final Expr e1, final Expr e2) {
        return new OpExpr("multiply", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((Number)Expr.eval(e1, context)).doubleValue() * ((Number)Expr.eval(e2, context)).doubleValue();
            }
        };
    }

    public static Expr pow(final Expr num, final Expr exponent) {
        return new OpExpr("pow", Arrays.asList(num, exponent)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.pow(((Number)Expr.eval(num, context)).doubleValue(), ((Number)Expr.eval(exponent, context)).doubleValue());
            }
        };
    }

    public static Expr round(final Expr e) {
        return new OpExprNoList("round", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.round(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr sqrt(final Expr e) {
        return new OpExprNoList("sqrt", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.sqrt(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr subtract(final Expr e1, final Expr e2) {
        return new OpExpr("substract", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((Number)Expr.eval(e1, context)).doubleValue() - ((Number)Expr.eval(e2, context)).doubleValue();
            }
        };
    }

    public static Expr trunc(final Expr num, final Expr place) {
        return new OpExpr("trunc", Arrays.asList(num, place)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double n = ((Number)Expr.eval(num, context)).doubleValue();
                double m = 1.0;
                if (Expr.eval(place, context) != null || !Expr.eval(place, context).equals(0)) {
                    m = Math.pow(10.0, ((Number)Expr.eval(place, context)).intValue());
                }
                n = (int)(n * m);
                return n /= m;
            }
        };
    }

    public static Expr arrayElemAt(final Expr array, final Expr index) {
        return new OpExpr("arrayElemAt", Arrays.asList(array, index)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((List)Expr.eval(array, context)).get(((Number)Expr.eval(index, context)).intValue());
            }
        };
    }

    private static Expr arrayElemAt(final List lst) {
        return new OpExpr("arrayElemAt", lst){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((List)Expr.eval((Expr)lst.get(0), context)).get(((Number)Expr.eval((Expr)lst.get(1), context)).intValue());
            }
        };
    }

    public static Expr arrayToObject(Expr array) {
        return new OpExpr("arrayToObject", Collections.singletonList(array)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr concatArrays(final Expr ... arrays) {
        return new OpExpr("concatArrays", Arrays.asList(arrays)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                ArrayList ret = new ArrayList();
                for (Expr e : arrays) {
                    ret.addAll((List)Expr.eval(e, context));
                }
                return ret;
            }
        };
    }

    public static Expr filter(final Expr inputArray, final String as, final Expr cond) {
        UtilsMap<String, Expr> input = UtilsMap.of("input", inputArray);
        input.put("as", Expr.string(as));
        input.put("cond", cond);
        return new MapOpExpr("filter", input){

            @Override
            public Object evaluate(Map<String, Object> context) {
                ArrayList ret = new ArrayList();
                for (Object el : (List)Expr.eval(inputArray, context)) {
                    if (el instanceof Expr) {
                        el = Expr.eval((Expr)el, context);
                    }
                    Map<String, Object> ctx = new ObjectMapperImpl().serialize(el);
                    String fld = as;
                    if (fld == null) {
                        fld = "this";
                    }
                    context.put(fld, el);
                    if (!Expr.eval(cond, context).equals(Boolean.TRUE)) continue;
                    ret.add(el);
                }
                return ret;
            }
        };
    }

    public static Expr first(Expr e) {
        return new OpExprNoList("first", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr in(final Expr elem, final Expr array) {
        return new OpExpr("in", Arrays.asList(elem, array)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object v = Expr.eval(elem, context);
                boolean found = false;
                for (Object o : (List)Expr.eval(array, context)) {
                    if (o instanceof Expr) {
                        o = Expr.eval((Expr)o, context);
                    }
                    if (!o.equals(v)) continue;
                    found = true;
                    break;
                }
                return found;
            }
        };
    }

    public static Expr indexOfArray(final Expr array, final Expr search, final Expr start, final Expr end) {
        return new OpExpr("indexOfArray", Arrays.asList(array, search, start, end)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                int startNum = ((Number)Expr.eval(start, context)).intValue();
                int endNum = ((Number)Expr.eval(end, context)).intValue();
                List lst = (List)Expr.eval(array, context);
                Object o = Expr.eval(search, context);
                return lst.indexOf(o);
            }
        };
    }

    public static Expr isArray(final Expr array) {
        return new OpExpr("isArray", Collections.singletonList(array)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(array, context) instanceof List;
            }
        };
    }

    public static Expr last(Expr e) {
        return new OpExprNoList("last", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr map(Expr inputArray, Expr as, Expr in) {
        return new OpExpr("map", Arrays.asList(inputArray, as, in)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("map not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr objectToArray(final Expr obj) {
        return new OpExprNoList("objectToArray", obj){

            @Override
            public Object evaluate(Map<String, Object> context) {
                ArrayList<Object> ret = new ArrayList<Object>();
                for (Map.Entry e : ((Map)Expr.eval(obj, context)).entrySet()) {
                    ret.add(e.getKey());
                    ret.add(e.getValue());
                }
                return ret;
            }
        };
    }

    public static Expr range(final Expr start, final Expr end, final Expr step) {
        return new OpExpr("range", Arrays.asList(start, end, step)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                int startNum = ((Number)Expr.eval(start, context)).intValue();
                int endNum = ((Number)Expr.eval(end, context)).intValue();
                int stepNum = ((Number)Expr.eval(step, context)).intValue();
                ArrayList<Integer> lst = new ArrayList<Integer>();
                if (endNum < startNum) {
                    if (stepNum > 0) {
                        stepNum = -stepNum;
                    }
                } else if (endNum > startNum && stepNum < 0) {
                    stepNum = -stepNum;
                }
                for (int i = startNum; i < endNum; i += stepNum) {
                    lst.add(i);
                }
                return lst;
            }
        };
    }

    public static Expr reverseArray(final Expr array) {
        return new OpExprNoList("reverseArray", array){

            @Override
            public Object evaluate(Map<String, Object> context) {
                List lst = (List)Expr.eval(array, context);
                Collections.reverse(lst);
                return lst;
            }
        };
    }

    public static Expr size(final Expr array) {
        return new OpExprNoList("size", array){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((List)Expr.eval(array, context)).size();
            }
        };
    }

    public static Expr reduce(Expr inputArray, Expr initValue, Expr in) {
        return new MapOpExpr("reduce", UtilsMap.of("input", inputArray, "initialValue", initValue, "in", in));
    }

    public static Expr slice(final Expr array, final Expr pos, final Expr n) {
        return new OpExpr("slice", Arrays.asList(array, pos, n)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                List lst = (List)Expr.eval(array, context);
                int posN = ((Number)Expr.eval(pos, context)).intValue();
                int len = ((Number)Expr.eval(n, context)).intValue();
                return lst.subList(posN, posN + len);
            }
        };
    }

    public static Expr slice(final Expr array, final Expr n) {
        return new OpExpr("slice", Arrays.asList(array, n)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                List lst = (List)Expr.eval(array, context);
                int len = ((Number)Expr.eval(n, context)).intValue();
                return lst.subList(0, len);
            }
        };
    }

    public static Expr and(final Expr ... expressions) {
        return new OpExpr("and", Arrays.asList(expressions)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                boolean result = true;
                for (int idx = 0; result && idx < expressions.length; ++idx) {
                    result = result && (Boolean)Expr.eval(expressions[idx], context) != false;
                }
                return result;
            }
        };
    }

    public static Expr or(final Expr ... expressions) {
        return new OpExpr("or", Arrays.asList(expressions)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                boolean result = false;
                for (int idx = 0; !result && idx < expressions.length; ++idx) {
                    result = result || (Boolean)Expr.eval(expressions[idx], context) != false;
                }
                return result;
            }
        };
    }

    public static Expr zip(List<Expr> inputs, Expr useLongestLength, Expr defaults) {
        return new MapOpExpr("zip", UtilsMap.of("inputs", new ArrayExpr(inputs.toArray(new Expr[0])), "useLongestLength", useLongestLength, "defaults", defaults));
    }

    public static Expr not(final Expr expression) {
        return new OpExprNoList("not", expression){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object evaluate = Expr.eval(expression, context);
                if (evaluate instanceof Boolean) {
                    return (Boolean)evaluate == false;
                }
                if (evaluate instanceof Number) {
                    return ((Number)evaluate).intValue() != 0;
                }
                if (evaluate instanceof String) {
                    return "true".equalsIgnoreCase((String)evaluate);
                }
                throw new IllegalArgumentException("Wrong type for not: expr is " + String.valueOf(evaluate));
            }
        };
    }

    public static Expr cmp(final Expr e1, final Expr e2) {
        return new OpExpr("cmp", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return ((Comparable)Expr.eval(e1, context)).compareTo(Expr.eval(e2, context));
            }
        };
    }

    public static Expr eq(Expr e1) {
        return new OpExprNoList("eq", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr eq(final Expr e1, final Expr e2) {
        return new OpExpr("eq", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object v1 = Expr.eval(e1, context);
                Object v2 = Expr.eval(e2, context);
                if (v1 == null) {
                    return v2 == null;
                }
                if (v2 == null) {
                    return v1 == null;
                }
                return v1.equals(v2);
            }
        };
    }

    public static Expr ne(Expr e1) {
        return new OpExprNoList("ne", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr ne(final Expr e1, final Expr e2) {
        return new OpExpr("ne", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object v1 = Expr.eval(e1, context);
                Object v2 = Expr.eval(e2, context);
                if (v1 == null) {
                    return v2 != null;
                }
                if (v2 == null) {
                    return v1 != null;
                }
                return !v1.equals(v2);
            }
        };
    }

    public static Expr gt(Expr e1) {
        return new OpExprNoList("gt", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr gt(final Expr e1, final Expr e2) {
        return new OpExpr("gt", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double dv2;
                Object eval1 = Expr.eval(e1, context);
                Object eval2 = Expr.eval(e2, context);
                if (eval1.getClass().equals(eval2.getClass())) {
                    return ((Comparable)eval1).compareTo(eval2) > 0;
                }
                double dv1 = Expr.getDoubleValue(eval1);
                return dv1 > (dv2 = Expr.getDoubleValue(eval2));
            }
        };
    }

    private static double getDoubleValue(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).doubleValue();
        }
        return 0.0;
    }

    public static Expr lt(Expr e1) {
        return new OpExprNoList("lt", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr lt(final Expr e1, final Expr e2) {
        return new OpExpr("lt", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double dv2;
                Object eval1 = Expr.eval(e1, context);
                Object eval2 = Expr.eval(e2, context);
                if (eval1.getClass().equals(eval2.getClass())) {
                    return ((Comparable)eval1).compareTo(eval2) < 0;
                }
                double dv1 = Expr.getDoubleValue(eval1);
                return dv1 < (dv2 = Expr.getDoubleValue(eval2));
            }
        };
    }

    public static Expr gte(Expr e1) {
        return new OpExprNoList("gte", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr gte(final Expr e1, final Expr e2) {
        return new OpExpr("gte", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double dv2;
                Object eval1 = Expr.eval(e1, context);
                Object eval2 = Expr.eval(e2, context);
                if (eval1.getClass().equals(eval2.getClass())) {
                    return ((Comparable)eval1).compareTo(eval2) >= 0;
                }
                double dv1 = Expr.getDoubleValue(eval1);
                return dv1 >= (dv2 = Expr.getDoubleValue(eval2));
            }
        };
    }

    public static Expr lte(Expr e1) {
        return new OpExprNoList("lte", e1){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return true;
            }
        };
    }

    public static Expr lte(final Expr e1, final Expr e2) {
        return new OpExpr("lte", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double dv2;
                Object eval1 = Expr.eval(e1, context);
                Object eval2 = Expr.eval(e2, context);
                if (eval1.getClass().equals(eval2.getClass())) {
                    return ((Comparable)eval1).compareTo(eval2) <= 0;
                }
                double dv1 = Expr.getDoubleValue(eval1);
                return dv1 <= (dv2 = Expr.getDoubleValue(eval2));
            }
        };
    }

    public static Expr cond(Expr condition, Expr caseTrue, Expr caseFalse) {
        return new OpExpr("cond", Arrays.asList(condition, caseTrue, caseFalse)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("cond not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr ifNull(final Expr toCheck, final Expr resultIfNull) {
        return new OpExpr("ifNull", Arrays.asList(toCheck, resultIfNull)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object result = Expr.eval(toCheck, context);
                if (result == null) {
                    return Expr.eval(resultIfNull, context);
                }
                return result;
            }
        };
    }

    public static Expr switchExpr(Map<Expr, Expr> branches, Expr defaultCase) {
        final ArrayList<UtilsMap<String, Object>> branchList = new ArrayList<UtilsMap<String, Object>>();
        for (Map.Entry<Expr, Expr> ex : branches.entrySet()) {
            branchList.add(UtilsMap.of("case", ex.getKey().toQueryObject(), "then", ex.getValue().toQueryObject()));
        }
        UtilsMap<String, Expr> branches1 = UtilsMap.of("branches", new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return branchList;
            }
        });
        branches1.put("default", defaultCase);
        return new MapOpExpr("switch", branches1);
    }

    public static Expr binarySize(Expr e) {
        return new OpExprNoList("binarySize", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("binarySize not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr bsonSize(Expr e) {
        return new OpExprNoList("bsonSize", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("bsonSize not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr function(String code, Expr args) {
        return Expr.function(code, args, null);
    }

    public static Expr function(String code, Expr args, String lang) {
        if (lang == null) {
            lang = "js";
        }
        return new MapOpExpr("function", UtilsMap.of("body", Expr.string(code), "args", args, "lang", Expr.string(lang)));
    }

    public static Expr accumulator(String initCode, String accumulateCode, Expr accArgs, String mergeCode) {
        return Expr.accumulator(initCode, null, accumulateCode, accArgs, mergeCode, null, null);
    }

    public static Expr accumulator(String initCode, Expr initArgs, String accumulateCode, Expr accArgs, String mergeCode) {
        return Expr.accumulator(initCode, initArgs, accumulateCode, accArgs, mergeCode, null, null);
    }

    public static Expr accumulator(String initCode, Expr initArgs, String accumulateCode, Expr accArgs, String mergeCode, String finalizeCode) {
        return Expr.accumulator(initCode, initArgs, accumulateCode, accArgs, mergeCode, finalizeCode, null);
    }

    public static Expr accumulator(String initCode, Expr initArgs, String accumulateCode, Expr accArgs, String mergeCode, String finalizeCode, String lang) {
        if (lang == null) {
            lang = "js";
        }
        UtilsMap<String, Expr> map = UtilsMap.of("init", Expr.string(initCode), "initArgs", initArgs, "accumulate", Expr.string(accumulateCode), "accumulateArgs", accArgs, "merge", Expr.string(mergeCode), "finalize", Expr.string(finalizeCode), "lang", Expr.string(lang));
        return new MapOpExpr("accumulator", map);
    }

    public static Expr dayOfMonth(final Expr date) {
        return new OpExprNoList("dayOfMonth", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(5);
            }
        };
    }

    public static Expr dayOfWeek(final Expr date) {
        return new OpExprNoList("dayOfWeek", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(7);
            }
        };
    }

    public static Expr dateFromParts(Expr year) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year));
    }

    private static Expr dateFromParts(Map m) {
        return new MapOpExpr("dateFromParts", m);
    }

    public static Expr dateFromParts(Expr year, Expr month) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year, "month", month));
    }

    public static Expr dateFromParts(Expr year, Expr month, Expr day, Expr hour) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year, "month", month, "day", day, "hour", hour));
    }

    public static Expr dateFromParts(Expr year, Expr month, Expr day, Expr hour, Expr min, Expr sec) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year, "month", month, "day", day, "hour", hour, "minute", min, "second", sec));
    }

    public static Expr dateFromParts(Expr year, Expr month, Expr day, Expr hour, Expr min, Expr sec, Expr ms) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year, "month", month, "day", day, "hour", hour, "minute", min, "second", sec, "millisecond", ms));
    }

    public static Expr dateFromParts(Expr year, Expr month, Expr day, Expr hour, Expr min, Expr sec, Expr ms, Expr timeZone) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("year", year, "month", month, "day", day, "hour", hour, "minute", min, "second", sec, "millisecond", ms, "timezone", timeZone));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek, Expr hour) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek, "hour", hour));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek, Expr hour, Expr min) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek, "hour", hour, "minute", min));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek, Expr hour, Expr min, Expr sec) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek, "hour", hour, "minute", min, "second", sec));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek, Expr hour, Expr min, Expr sec, Expr ms) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek, "hour", hour, "minute", min, "second", sec, "millisecond", ms));
    }

    public static Expr isoDateFromParts(Expr isoWeekYear, Expr isoWeek, Expr isoDayOfWeek, Expr hour, Expr min, Expr sec, Expr ms, Expr timeZone) {
        return new MapOpExpr("dateFromParts", UtilsMap.of("isoWeekYear", isoWeekYear, "month", isoWeek, "day", isoDayOfWeek, "hour", hour, "minute", min, "second", sec, "millisecond", ms, "timezone", timeZone));
    }

    public static Expr dateFromString(Expr dateString, Expr format, Expr timezone, Expr onError, Expr onNull) {
        return new MapOpExpr("dateFromString", UtilsMap.of("dateString", dateString, "format", format, "timezone", timezone, "onError", onError, "onNull", onNull));
    }

    public static Expr dateToParts(Expr date, Expr timezone, boolean iso8601) {
        return new MapOpExpr("dateToParts", UtilsMap.of("date", date, "timezone", timezone, "iso8601", Expr.bool(iso8601)));
    }

    public static Expr dateToString(Expr date, Expr format, Expr timezone, Expr onNull) {
        return new MapOpExpr("dateToString", UtilsMap.of("dateString", date, "format", format, "timezone", timezone, "onNull", onNull));
    }

    public static Expr dayOfYear(final Expr date) {
        return new OpExprNoList("dayOfYear", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(6);
            }
        };
    }

    public static Expr hour(final Expr date) {
        return new OpExprNoList("hour", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(11);
            }
        };
    }

    public static Expr isoDayOfWeek(final Expr date) {
        return new OpExprNoList("isoDayOfWeek", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(7);
            }
        };
    }

    public static Expr isoWeek(final Expr date) {
        return new OpExprNoList("isoWeek", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(4);
            }
        };
    }

    public static Expr isoWeekYear(final Expr date) {
        return new OpExprNoList("isoWeekYear", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(3);
            }
        };
    }

    public static Expr millisecond(final Expr date) {
        return new OpExprNoList("millisecond", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(14);
            }
        };
    }

    public static Expr minute(final Expr date) {
        return new OpExprNoList("minute", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(12);
            }
        };
    }

    public static Expr month(final Expr date) {
        return new OpExprNoList("month", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(2);
            }
        };
    }

    public static Expr second(final Expr date) {
        return new OpExprNoList("second", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(13);
            }
        };
    }

    public static Expr toDate(Expr e) {
        return new OpExprNoList("toDate", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("toDate not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr week(final Expr date) {
        return new OpExprNoList("week", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(3);
            }
        };
    }

    public static Expr year(final Expr date) {
        return new OpExprNoList("year", date){

            @Override
            public Object evaluate(Map<String, Object> context) {
                GregorianCalendar cal = new GregorianCalendar();
                Object val = Expr.eval(date, context);
                if (val instanceof Date) {
                    cal.setTime((Date)val);
                } else if (val instanceof Number) {
                    cal.setTimeInMillis(((Number)val).longValue());
                } else {
                    throw new IllegalArgumentException("second expr got wrong type: " + String.valueOf(val.getClass()));
                }
                return cal.get(1);
            }
        };
    }

    public static Expr literal(final Expr e) {
        return new OpExprNoList("literal", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context);
            }
        };
    }

    public static Expr mergeObjects(final Expr doc) {
        return new OpExprNoList("mergeObjects", doc){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(doc, context);
            }
        };
    }

    public static Expr mergeObjects(final Expr ... docs) {
        return new OpExpr("mergeObjects", Arrays.asList(docs)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                HashMap res = new HashMap();
                for (Expr e : docs) {
                    Object val = Expr.eval(e, context);
                    if (!(val instanceof Map)) {
                        throw new IllegalArgumentException("cannot merge non documents!");
                    }
                    res.putAll((Map)val);
                }
                return res;
            }
        };
    }

    public static Expr allElementsTrue(final Expr ... e) {
        return new OpExpr("allElementsTrue", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                boolean ret = true;
                for (Expr el : e) {
                    if (Boolean.TRUE.equals(Expr.eval(el, context))) continue;
                    ret = false;
                    break;
                }
                return ret;
            }
        };
    }

    private static Expr allElementsTrue(final List lst) {
        return new OpExpr("alleElementsTrue", lst){

            @Override
            public Object evaluate(Map<String, Object> context) {
                boolean ret = true;
                for (Expr el : lst) {
                    if (Boolean.TRUE.equals(Expr.eval(el, context))) continue;
                    ret = false;
                    break;
                }
                return ret;
            }
        };
    }

    public static Expr anyElementTrue(final Expr ... e) {
        return new OpExpr("anyElementsTrue", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                boolean ret = false;
                for (Expr el : e) {
                    if (!Boolean.TRUE.equals(Expr.eval(el, context))) continue;
                    ret = true;
                    break;
                }
                return ret;
            }
        };
    }

    public static Expr setDifference(Expr e1, Expr e2) {
        return new OpExpr("setDifference", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr setEquals(Expr ... e) {
        return new OpExpr("setEquals", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr setIntersection(Expr ... e) {
        return new OpExpr("setIntersection", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr setIsSubset(Expr e1, Expr e2) {
        return new OpExpr("setIsSubset", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr setUnion(final Expr ... e) {
        return new OpExpr("setUnion", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                HashSet<Object> set = new HashSet<Object>();
                for (Expr el : e) {
                    set.add(Expr.eval(el, context));
                }
                return set;
            }
        };
    }

    public static Expr concat(final Expr ... e) {
        return new OpExpr("concat", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                StringBuilder b = new StringBuilder();
                for (Expr ex : e) {
                    Object evaluate = Expr.eval(ex, context);
                    if (evaluate == null) continue;
                    b.append(evaluate);
                }
                return b.toString();
            }
        };
    }

    public static Expr indexOfBytes(Expr str, Expr substr, Expr start, Expr end) {
        return new OpExpr("indexOfBytes", Arrays.asList(str, substr, start, end)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr indexOfCP(Expr str, Expr substr, Expr start, Expr end) {
        return new OpExpr("indexOfCP", Arrays.asList(str, substr, start, end)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr match(final Expr expr) {
        return new OpExprNoList("$match", expr){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(expr, context);
            }
        };
    }

    public static Expr expr(final Expr expr) {
        return new OpExprNoList("expr", expr){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return Expr.eval(expr, context);
            }
        };
    }

    public static Expr ltrim(Expr str, Expr charsToTrim) {
        return new MapOpExpr("ltrim", UtilsMap.of("input", str, "chars", charsToTrim));
    }

    public static Expr regex(final Expr field, final Expr regex, final Expr options) {
        return new Expr(){

            @Override
            public Object toQueryObject() {
                return UtilsMap.of(field.toQueryObject().toString().substring(1), UtilsMap.of("$regex", regex.toQueryObject(), "$options", options.toQueryObject()));
            }

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr regexFind(Expr input, Expr regex, Expr options) {
        return new MapOpExpr("regexFind", UtilsMap.of("input", input, "regex", regex, "options", options));
    }

    public static Expr regexFindAll(Expr input, Expr regex, Expr options) {
        return new MapOpExpr("regexFindAll", UtilsMap.of("input", input, "regex", regex, "options", options));
    }

    public static Expr project(Map<String, Expr> expr) {
        return new MapOpExpr("$project", expr);
    }

    public static Expr split(final Expr str, final Expr delimiter) {
        return new OpExpr("split", Arrays.asList(str, delimiter)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                String s = Expr.eval(str, context).toString();
                return Arrays.asList(s.split(Expr.eval(delimiter, context).toString()));
            }
        };
    }

    public static Expr strLenBytes(Expr str) {
        return new OpExpr("strLenBytes", Collections.singletonList(str)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr regexMatch(Expr input, Expr regex, Expr options) {
        return new MapOpExpr("regexMatch", UtilsMap.of("input", input, "regex", regex, "options", options));
    }

    public static Expr replaceOne(Expr input, Expr find, Expr replacement) {
        return new MapOpExpr("replaceOne", UtilsMap.of("input", input, "find", find, "replacement", replacement));
    }

    public static Expr replaceAll(Expr input, Expr find, Expr replacement) {
        return new MapOpExpr("replaceAll", UtilsMap.of("input", input, "find", find, "replacement", replacement));
    }

    public static Expr rtrim(Expr str, Expr charsToTrim) {
        return new MapOpExpr("rtrim", UtilsMap.of("input", str, "chars", charsToTrim));
    }

    public static Expr strLenCP(Expr str) {
        return new OpExpr("strLenCP", Collections.singletonList(str)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr strcasecmp(Expr e1, Expr e2) {
        return new OpExpr("strcasecmp", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr substr(final Expr str, final Expr start, final Expr len) {
        return new OpExpr("substr", Arrays.asList(str, start, len)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                String s = (String)Expr.eval(str, context);
                int st = ((Number)Expr.eval(start, context)).intValue();
                int l = ((Number)Expr.eval(len, context)).intValue();
                return s.substring(st, st + l);
            }
        };
    }

    public static Expr substrBytes(Expr str, Expr index, Expr count) {
        return new OpExpr("substrBytes", Arrays.asList(str, index, count)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr substrCP(Expr str, Expr cpIdx, Expr cpCount) {
        return new OpExpr("substrCP", Arrays.asList(str, cpIdx, cpCount)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr toLower(final Expr e) {
        return new OpExprNoList("toLower", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                if (Expr.eval(e, context) == null) {
                    return null;
                }
                return ((String)Expr.eval(e, context)).toLowerCase(Locale.ROOT);
            }
        };
    }

    public static Expr toStr(final Expr e) {
        return new OpExprNoList("toString", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context) != null ? Expr.eval(e, context).toString() : null;
            }
        };
    }

    public static Expr toUpper(final Expr e) {
        return new OpExprNoList("toUpper", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                if (Expr.eval(e, context) == null) {
                    return null;
                }
                return Expr.eval(e, context).toString().toUpperCase();
            }
        };
    }

    public static Expr meta(final String metaDataKeyword) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return UtilsMap.of("$meta", metaDataKeyword);
            }
        };
    }

    public static Expr trim(Expr str, Expr charsToTrim) {
        return new MapOpExpr("trim", UtilsMap.of("input", str, "chars", charsToTrim));
    }

    public static Expr sin(final Expr e) {
        return new OpExprNoList("sin", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.sin(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr cos(final Expr e) {
        return new OpExprNoList("cos", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.cos(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr tan(final Expr e) {
        return new OpExprNoList("tan", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.tan(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr asin(final Expr e) {
        return new OpExprNoList("asin", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.asin(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr acos(final Expr e) {
        return new OpExprNoList("acos", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.acos(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr atan(final Expr e) {
        return new OpExprNoList("atan", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.atan(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr atan2(final Expr e, final Expr e2) {
        return new OpExpr("atan2", Arrays.asList(e, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.atan2(((Number)Expr.eval(e, context)).doubleValue(), ((Number)Expr.eval(e2, context)).doubleValue());
            }
        };
    }

    private static Expr atan2(final List lst) {
        return new OpExpr("atan2", lst){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.atan2(((Number)Expr.eval((Expr)lst.get(0), context)).doubleValue(), ((Number)Expr.eval((Expr)lst.get(1), context)).doubleValue());
            }
        };
    }

    public static Expr asinh(final Expr e) {
        return new OpExprNoList("asinh", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.sinh(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr acosh(Expr e) {
        return new OpExprNoList("acosh", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr atanh(Expr e1, Expr e2) {
        return new OpExpr("atanh", Arrays.asList(e1, e2)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("ATANH not implemented, sorry!");
                return 0;
            }
        };
    }

    private static Expr atanh(List lst) {
        return new OpExpr("atanh", lst){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("ATANH not implemented, sorry!");
                return 0;
            }
        };
    }

    public static Expr degreesToRadian(final Expr e) {
        return new OpExprNoList("degreesToRadian", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.toRadians(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr radiansToDegrees(final Expr e) {
        return new OpExprNoList("radiansToDegrees", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Math.toDegrees(((Number)Expr.eval(e, context)).doubleValue());
            }
        };
    }

    public static Expr convert(final Expr input, Expr to, Expr onError, final Expr onNull) {
        return new MapOpExpr("convert", UtilsMap.of("input", input, "to", to, "onError", onError, "onNull", onNull)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object in = Expr.eval(input, context);
                if (in == null) {
                    return Expr.eval(onNull, context);
                }
                return in;
            }
        };
    }

    private static Expr convert(final Map map) {
        return new MapOpExpr("convert", map){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object in = Expr.eval((Expr)map.get("input"), context);
                if (in == null) {
                    return Expr.eval((Expr)map.get("onNull"), context);
                }
                return in;
            }
        };
    }

    public static Expr isNumber(final Expr e) {
        return new OpExprNoList("isNumber", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context) instanceof Number;
            }
        };
    }

    public static Expr convert(Expr input, Expr to) {
        return Expr.convert(input, to, null, null);
    }

    public static Expr convert(Expr input, Expr to, Expr onError) {
        return Expr.convert(input, to, onError, null);
    }

    public static Expr toBool(final Expr e) {
        return new OpExprNoList("toBool", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Boolean.valueOf(Expr.eval(e, context).toString());
            }
        };
    }

    public static Expr toDecimal(final Expr e) {
        return new OpExprNoList("toDecimal", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Double.valueOf(Expr.eval(e, context).toString());
            }
        };
    }

    public static Expr toDouble(final Expr e) {
        return new OpExprNoList("toDouble", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object res = Expr.eval(e, context);
                if (res instanceof Number) {
                    return ((Number)res).doubleValue();
                }
                if (res instanceof String) {
                    return Integer.valueOf((String)res).doubleValue();
                }
                return 0;
            }
        };
    }

    public static Expr toInt(final Expr e) {
        return new OpExprNoList("toInt", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object res = Expr.eval(e, context);
                if (res instanceof Number) {
                    return ((Number)res).intValue();
                }
                if (res instanceof String) {
                    return (int)Integer.valueOf((String)res);
                }
                return 0;
            }
        };
    }

    public static Expr toLong(final Expr e) {
        return new OpExprNoList("toLong", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object res = Expr.eval(e, context);
                if (res instanceof Number) {
                    return ((Number)res).longValue();
                }
                if (res instanceof String) {
                    return Integer.valueOf((String)res).longValue();
                }
                return 0;
            }
        };
    }

    public static Expr toObjectId(final Expr e) {
        return new OpExprNoList("toObjectId", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object o = Expr.eval(e, context);
                if (o instanceof String) {
                    o = new MorphiumId((String)o);
                } else if (o instanceof ObjectId) {
                    o = new MorphiumId(((ObjectId)o).toHexString());
                }
                return o;
            }
        };
    }

    public static Expr type(Expr e) {
        return new OpExprNoList("type", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return Expr.nullExpr();
            }
        };
    }

    public static Expr nullExpr() {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return null;
            }
        };
    }

    public static Expr addToSet(Expr e) {
        return new OpExprNoList("addToSet", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr avg(final Expr ... e) {
        return new OpExpr("avg", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                double sum = 0.0;
                for (Expr expr : e) {
                    sum += ((Number)Expr.eval(expr, context)).doubleValue();
                }
                return sum / (double)e.length;
            }
        };
    }

    public static Expr avg(final Expr e) {
        return new OpExprNoList("avg", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context);
            }
        };
    }

    public static Expr max(final Expr ... e) {
        return new OpExpr("max", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object max = null;
                for (Expr expr : e) {
                    Object v = Expr.eval(expr, context);
                    if (max == null) {
                        max = v;
                        continue;
                    }
                    if (((Comparable)max).compareTo(v) >= 0) continue;
                    max = v;
                }
                return max;
            }
        };
    }

    public static Expr max(final Expr e) {
        return new OpExprNoList("max", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context);
            }
        };
    }

    public static Expr min(final Expr ... e) {
        return new OpExpr("min", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                Object min = null;
                for (Expr expr : e) {
                    Object v = Expr.eval(expr, context);
                    if (min == null) {
                        min = v;
                        continue;
                    }
                    if (((Comparable)min).compareTo(v) <= 0) continue;
                    min = v;
                }
                return min;
            }
        };
    }

    public static Expr min(final Expr e) {
        return new OpExprNoList("min", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return Expr.eval(e, context);
            }
        };
    }

    public static Expr push(Expr e) {
        return new OpExprNoList("push", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr stdDevPop(Expr e) {
        return new OpExprNoList("stdDevPop", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr stdDevPop(Expr ... e) {
        return new OpExpr("stdDevPop", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr stdDevSamp(Expr e) {
        return new OpExprNoList("stdDevSamp", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr stdDevSamp(Expr ... e) {
        return new OpExpr("stdDevSamp", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr sum(Expr e) {
        return new OpExprNoList("sum", e){

            @Override
            public Object evaluate(Map<String, Object> context) {
                return null;
            }
        };
    }

    public static Expr sum(Expr ... e) {
        return new OpExpr("sum", Arrays.asList(e)){

            @Override
            public Object evaluate(Map<String, Object> context) {
                LoggerFactory.getLogger(Expr.class).error("not implemented yet,sorry");
                return null;
            }
        };
    }

    public static Expr let(final Map<String, Expr> vars, final Expr in) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry e : vars.entrySet()) {
                    map.put((String)e.getKey(), ((Expr)e.getValue()).toQueryObject());
                }
                return UtilsMap.of("$let", UtilsMap.of("vars", map, "in", in.toQueryObject()));
            }

            @Override
            public Object evaluate(Map<String, Object> context) {
                HashMap<String, Object> effectiveContext = new HashMap<String, Object>(context);
                for (String k : vars.keySet()) {
                    effectiveContext.put(k, Expr.eval((Expr)vars.get(k), context));
                }
                return Expr.eval(in, effectiveContext);
            }
        };
    }

    private static Expr let(final Map m) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return m;
            }

            @Override
            public Object evaluate(Map<String, Object> context) {
                HashMap<String, Object> effectiveContext = new HashMap<String, Object>(context);
                for (String k : ((Map)m.get("vars")).keySet()) {
                    effectiveContext.put(k, Expr.eval((Expr)((Map)m.get("vars")).get(k), context));
                }
                return Expr.eval((Expr)m.get("in"), effectiveContext);
            }
        };
    }

    public static Expr doc(final Map<String, Object> document) {
        return new ValueExpr(){

            @Override
            public Object toQueryObject() {
                return document;
            }
        };
    }

    private static class FieldExpr
    extends Expr {
        private final String fieldRef;

        public FieldExpr(String fieldRef) {
            if (!((String)fieldRef).startsWith("$")) {
                fieldRef = "$" + (String)fieldRef;
            }
            this.fieldRef = fieldRef;
        }

        @Override
        public Object evaluate(Map<String, Object> context) {
            if (context == null) {
                return null;
            }
            String p = this.fieldRef.substring(1);
            String[] pth = p.split("\\.");
            if (context.containsKey(pth[0])) {
                Object val = context.get(pth[0]);
                for (int i = 1; i < pth.length; ++i) {
                    if (val == null) {
                        return null;
                    }
                    if (i >= pth.length) continue;
                    if (val instanceof Map) {
                        val = ((Map)val).get(pth[i]);
                        continue;
                    }
                    if (!(val instanceof List)) continue;
                    try {
                        int idx = Integer.parseInt(pth[i]);
                        val = ((List)val).get(idx);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return val;
            }
            AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
            String n = an.convertCamelCase(this.fieldRef.substring(1));
            return context.get(n);
        }

        @Override
        public Object toQueryObject() {
            return this.fieldRef;
        }
    }

    private static class ArrayExpr
    extends ValueExpr {
        private final List<Expr> arr;

        public ArrayExpr(Expr ... vals) {
            this.arr = Arrays.asList(vals);
        }

        @Override
        public Object toQueryObject() {
            return Arrays.asList(this.arr.stream().map(Expr::toQueryObject).toArray());
        }
    }

    private static class MapOpExpr
    extends ValueExpr {
        private final String operation;
        private final Map<String, Expr> params;

        private MapOpExpr(String type, Map<String, Expr> par) {
            if (!((String)type).startsWith("$")) {
                type = "$" + (String)type;
            }
            this.operation = type;
            this.params = par;
        }

        @Override
        public Object toQueryObject() {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            UtilsMap ret = UtilsMap.of(this.operation, m);
            for (Map.Entry<String, Expr> e : this.params.entrySet()) {
                if (e.getValue() == null) continue;
                m.put(e.getKey(), e.getValue().toQueryObject());
            }
            return ret;
        }
    }

    public static abstract class ValueExpr
    extends Expr {
        @Override
        public Object evaluate(Map<String, Object> context) {
            return this.toQueryObject();
        }
    }

    private static abstract class OpExprNoList
    extends Expr {
        private final String operation;
        private final Expr params;

        private OpExprNoList(String type, Expr par) {
            if (!((String)type).startsWith("$")) {
                type = "$" + (String)type;
            }
            this.operation = type;
            this.params = par;
        }

        @Override
        public Object toQueryObject() {
            return UtilsMap.of(this.operation, this.params.toQueryObject());
        }
    }

    private static abstract class OpExpr
    extends Expr {
        private final String operation;
        private final List<Expr> params;

        private OpExpr(String type, List<Expr> par) {
            if (!((String)type).startsWith("$")) {
                type = "$" + (String)type;
            }
            this.operation = type;
            this.params = par;
        }

        @Override
        public Object toQueryObject() {
            ArrayList<Object> p = new ArrayList<Object>();
            for (Expr e : this.params) {
                if (e == null) continue;
                p.add(e.toQueryObject());
            }
            return UtilsMap.of(this.operation, p);
        }
    }
}

