/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.MorphiumConfigResolver;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.ReadPreferenceType;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.encryption.AESEncryptionProvider;
import de.caluga.morphium.encryption.DefaultEncryptionKeyProvider;
import de.caluga.morphium.encryption.EncryptionKeyProvider;
import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.morphium.writer.AsyncWriterImpl;
import de.caluga.morphium.writer.BufferedMorphiumWriterImpl;
import de.caluga.morphium.writer.MorphiumWriter;
import de.caluga.morphium.writer.MorphiumWriterImpl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.json.simple.parser.ParseException;
import org.slf4j.LoggerFactory;

@Embedded
public class MorphiumConfig {
    @AdditionalData(readOnly=false)
    private Map<String, Object> restoreData;
    private int maxConnections = 250;
    private int housekeepingTimeout = 5000;
    private int minConnections = 1;
    private int idleSleepTime = 20;
    private int globalCacheValidTime = 5000;
    private int writeCacheTimeout = 5000;
    private String database;
    @Transient
    private MorphiumWriter writer;
    @Transient
    private MorphiumWriter bufferedWriter;
    @Transient
    private MorphiumWriter asyncWriter;
    private int connectionTimeout = 0;
    private boolean globalFsync = false;
    private boolean globalJ = false;
    private boolean checkForNew = true;
    private boolean replicaset = true;
    private String atlasUrl = null;
    private int maximumRetriesBufferedWriter = 10;
    private int maximumRetriesWriter = 10;
    private int maximumRetriesAsyncWriter = 10;
    private int retryWaitTimeBufferedWriter = 200;
    private int retryWaitTimeWriter = 200;
    private int retryWaitTimeAsyncWriter = 200;
    private int globalW = 1;
    private int maxWaitTime = 2000;
    private int threadConnectionMultiplier = 5;
    private int serverSelectionTimeout = 30000;
    private int writeBufferTime = 1000;
    private int writeBufferTimeGranularity = 100;
    private boolean useSSL = false;
    private SSLContext sslContext = null;
    private boolean sslInvalidHostNameAllowed = false;
    @Transient
    private MorphiumCache cache;
    private int replicaSetMonitoringTimeout = 5000;
    private int retriesOnNetworkError = 1;
    private int sleepBetweenNetworkErrorRetries = 1000;
    private String mongoLogin = null;
    private String mongoPassword = null;
    private String mongoAuthDb = null;
    @Transient
    private String credentialsEncryptionKey;
    @Transient
    private String credentialsDecryptionKey;
    private Boolean credentialsEncrypted;
    private boolean autoValues = true;
    private boolean readCacheEnabled = true;
    private boolean asyncWritesEnabled = true;
    private boolean bufferedWritesEnabled = true;
    private boolean camelCaseConversionEnabled = true;
    private boolean warnOnNoEntitySerialization = false;
    @Transient
    private ReadPreference defaultReadPreference;
    @Transient
    private String defaultReadPreferenceType;
    @Transient
    private Class<? extends EncryptionKeyProvider> encryptionKeyProviderClass = DefaultEncryptionKeyProvider.class;
    @Transient
    private Class<? extends ValueEncryptionProvider> valueEncryptionProviderClass = AESEncryptionProvider.class;
    private String driverName = "PooledDriver";
    private int threadPoolMessagingCoreSize = 0;
    private int threadPoolMessagingMaxSize = 100;
    private long threadPoolMessagingKeepAliveTime = 2000L;
    private int messagingWindowSize = 100;
    private int threadPoolAsyncOpCoreSize = 1;
    private int threadPoolAsyncOpMaxSize = 1000;
    private long threadPoolAsyncOpKeepAliveTime = 1000L;
    private boolean objectSerializationEnabled = true;
    private int heartbeatFrequency = 1000;
    private int localThreshold = 15;
    private int maxConnectionIdleTime = 10000;
    private int maxConnectionLifeTime = 60000;
    private List<String> hostSeed = new ArrayList<String>();
    private String defaultTags;
    private String requiredReplicaSetName = null;
    private int cursorBatchSize = 1000;
    private int readTimeout = 0;
    private boolean retryReads = false;
    private boolean retryWrites = false;
    private String uuidRepresentation;
    private IndexCheck indexCheck = IndexCheck.CREATE_ON_WRITE_NEW_COL;
    private CappedCheck cappedCheck = CappedCheck.CREATE_ON_WRITE_NEW_COL;
    private String messagingStatusInfoListenerName = null;
    private boolean messagingStatusInfoListenerEnabled = true;

    public boolean isMessagingStatusInfoListenerEnabled() {
        return this.messagingStatusInfoListenerEnabled;
    }

    public void setMessagingStatusInfoListenerEnabled(boolean messagingStatusInfoListenerEnabled) {
        this.messagingStatusInfoListenerEnabled = messagingStatusInfoListenerEnabled;
    }

    public MorphiumConfig(Properties prop) {
        this(null, prop);
    }

    public MorphiumConfig(String prefix, Properties prop) {
        this(prefix, prop::get);
    }

    public MorphiumConfig(String prefix, MorphiumConfigResolver resolver) {
        String lst;
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        prefix = prefix != null ? (String)prefix + "." : "";
        for (Field f : flds) {
            String fName = (String)prefix + f.getName();
            Object setting = resolver.resolveSetting(fName);
            if (setting == null) continue;
            f.setAccessible(true);
            try {
                if (f.getType().equals(Integer.TYPE) || f.getType().equals(Integer.class)) {
                    f.set(this, Integer.parseInt((String)setting));
                    continue;
                }
                if (f.getType().isEnum()) {
                    Object value = Enum.valueOf(f.getType(), (String)setting);
                    f.set(this, value);
                    continue;
                }
                if (f.getType().equals(String.class)) {
                    f.set(this, setting);
                    continue;
                }
                if (List.class.isAssignableFrom(f.getType())) {
                    String lst2 = (String)setting;
                    ArrayList l = new ArrayList();
                    lst2 = lst2.replaceAll("[\\[\\]]", "");
                    Collections.addAll(l, lst2.split(","));
                    ArrayList<String> ret = new ArrayList<String>();
                    for (String n : l) {
                        ret.add(n.trim());
                    }
                    f.set(this, ret);
                    continue;
                }
                if (f.getType().equals(Boolean.TYPE) || f.getType().equals(Boolean.class)) {
                    f.set(this, setting.equals("true"));
                    continue;
                }
                if (!f.getType().equals(Long.TYPE) && !f.getType().equals(Long.class)) continue;
                f.set(this, Long.parseLong((String)setting));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (resolver.resolveSetting((String)prefix + "driver_class") != null || resolver.resolveSetting((String)prefix + "driverClass") != null) {
            Object s = resolver.resolveSetting((String)prefix + "driver_class");
            if (s == null) {
                s = resolver.resolveSetting((String)prefix + "driverClass");
            }
            if (s.equals(InMemoryDriver.class.getName())) {
                this.setDriverName("InMemDriver");
            } else {
                LoggerFactory.getLogger(MorphiumConfig.class).error("Cannot set driver class - using default driver instead!");
            }
        }
        if ((this.hostSeed == null || this.hostSeed.isEmpty()) && (lst = (String)resolver.resolveSetting((String)prefix + "hosts")) != null) {
            lst = lst.replaceAll("[\\[\\]]", "");
            for (String s : lst.split(",")) {
                this.addHostToSeed(s);
            }
        }
    }

    public MorphiumConfig() {
        this("test", 10, 60000, 10000);
    }

    public MorphiumConfig(String db, int maxConnections, int globalCacheValidTime, int housekeepingTimeout) {
        this.database = db;
        this.maxConnections = maxConnections;
        this.globalCacheValidTime = globalCacheValidTime;
        this.housekeepingTimeout = housekeepingTimeout;
    }

    public static List<String> getPropertyNames(String prefix) {
        List<String> flds = new AnnotationAndReflectionHelper(true).getFields(MorphiumConfig.class, new Class[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String f : flds) {
            ret.add(prefix + "." + f);
        }
        return ret;
    }

    public static MorphiumConfig createFromJson(String json) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, InstantiationException, ParseException, NoSuchMethodException, InvocationTargetException {
        MorphiumConfig cfg = new ObjectMapperImpl().deserialize(MorphiumConfig.class, json);
        Iterator<String> iterator = cfg.restoreData.keySet().iterator();
        while (iterator.hasNext()) {
            String ko;
            String k = ko = iterator.next();
            String value = cfg.restoreData.get(k).toString();
            if (!k.equals("hosts") && !k.equals("hostSeed")) continue;
            value = value.replaceAll("\\[", "").replaceAll("]", "");
            for (String adr : value.split(",")) {
                String[] a = adr.split(":");
                cfg.addHostToSeed(a[0].trim(), Integer.parseInt(a[1].trim()));
            }
        }
        return cfg;
    }

    public int getMessagingWindowSize() {
        return this.messagingWindowSize;
    }

    public void setMessagingWindowSize(int messagingWindowSize) {
        this.messagingWindowSize = messagingWindowSize;
    }

    public static MorphiumConfig fromProperties(String prefix, Properties p) {
        return new MorphiumConfig(prefix, p);
    }

    public static MorphiumConfig fromProperties(Properties p) {
        return new MorphiumConfig(p);
    }

    public boolean isAtlas() {
        return this.atlasUrl != null;
    }

    public String getAtlasUrl() {
        return this.atlasUrl;
    }

    public void setAtlasUrl(String atlasUrl) {
        this.atlasUrl = atlasUrl;
    }

    public boolean isReplicaset() {
        return this.replicaset;
    }

    public MorphiumConfig setReplicasetMonitoring(boolean replicaset) {
        this.replicaset = replicaset;
        return this;
    }

    public Class<? extends ValueEncryptionProvider> getValueEncryptionProviderClass() {
        return this.valueEncryptionProviderClass;
    }

    public MorphiumConfig setValueEncryptionProviderClass(Class<? extends ValueEncryptionProvider> valueEncryptionProviderClass) {
        this.valueEncryptionProviderClass = valueEncryptionProviderClass;
        return this;
    }

    public Class<? extends EncryptionKeyProvider> getEncryptionKeyProviderClass() {
        return this.encryptionKeyProviderClass;
    }

    public void setEncryptionKeyProviderClass(Class<? extends EncryptionKeyProvider> encryptionKeyProviderClass) {
        this.encryptionKeyProviderClass = encryptionKeyProviderClass;
    }

    public String getCredentialsEncryptionKey() {
        return this.credentialsEncryptionKey;
    }

    public MorphiumConfig setCredentialsEncryptionKey(String credentialsEncryptionKey) {
        this.credentialsEncryptionKey = credentialsEncryptionKey;
        return this;
    }

    public String getCredentialsDecryptionKey() {
        return this.credentialsDecryptionKey;
    }

    public MorphiumConfig setCredentialsDecryptionKey(String credentialsDecryptionKey) {
        this.credentialsDecryptionKey = credentialsDecryptionKey;
        return this;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public MorphiumConfig setDriverName(String driverName) {
        if (driverName != null) {
            this.driverName = driverName;
        }
        return this;
    }

    public MorphiumConfig setDriverClass(String cls) {
        if (!cls.equals(InMemoryDriver.class.getName())) {
            throw new IllegalArgumentException("Cannot set driver class " + cls + " - please use setDriverName with the proper name.");
        }
        this.driverName = "InMemDriver";
        return this;
    }

    public boolean isAutoIndexAndCappedCreationOnWrite() {
        return this.indexCheck.equals((Object)IndexCheck.CREATE_ON_WRITE_NEW_COL);
    }

    public MorphiumConfig setAutoIndexAndCappedCreationOnWrite(boolean autoIndexAndCappedCreationOnWrite) {
        this.indexCheck = autoIndexAndCappedCreationOnWrite ? IndexCheck.CREATE_ON_WRITE_NEW_COL : IndexCheck.NO_CHECK;
        return this;
    }

    public boolean isWarnOnNoEntitySerialization() {
        return this.warnOnNoEntitySerialization;
    }

    public void setWarnOnNoEntitySerialization(boolean warnOnNoEntitySerialization) {
        this.warnOnNoEntitySerialization = warnOnNoEntitySerialization;
    }

    public boolean isCheckForNew() {
        return this.checkForNew;
    }

    public MorphiumConfig setCheckForNew(boolean checkForNew) {
        this.checkForNew = checkForNew;
        return this;
    }

    public int getRetriesOnNetworkError() {
        return this.retriesOnNetworkError;
    }

    public MorphiumConfig setRetriesOnNetworkError(int retriesOnNetworkError) {
        if (retriesOnNetworkError == 0) {
            LoggerFactory.getLogger(MorphiumConfig.class).warn("Cannot set retries on network error to 0 - minimum is 1");
            retriesOnNetworkError = 1;
        }
        this.retriesOnNetworkError = retriesOnNetworkError;
        return this;
    }

    public int getSleepBetweenNetworkErrorRetries() {
        return this.sleepBetweenNetworkErrorRetries;
    }

    public MorphiumConfig setSleepBetweenNetworkErrorRetries(int sleepBetweenNetworkErrorRetries) {
        this.sleepBetweenNetworkErrorRetries = sleepBetweenNetworkErrorRetries;
        return this;
    }

    public int getReplicaSetMonitoringTimeout() {
        return this.replicaSetMonitoringTimeout;
    }

    public MorphiumConfig setReplicaSetMonitoringTimeout(int replicaSetMonitoringTimeout) {
        this.replicaSetMonitoringTimeout = replicaSetMonitoringTimeout;
        return this;
    }

    public int getWriteBufferTimeGranularity() {
        return this.writeBufferTimeGranularity;
    }

    public MorphiumConfig setWriteBufferTimeGranularity(int writeBufferTimeGranularity) {
        this.writeBufferTimeGranularity = writeBufferTimeGranularity;
        return this;
    }

    public MorphiumCache getCache() {
        return this.cache;
    }

    public MorphiumConfig setCache(MorphiumCache cache) {
        this.cache = cache;
        return this;
    }

    public int getWriteBufferTime() {
        return this.writeBufferTime;
    }

    public MorphiumConfig setWriteBufferTime(int writeBufferTime) {
        this.writeBufferTime = writeBufferTime;
        return this;
    }

    public int getGlobalW() {
        return this.globalW;
    }

    public MorphiumConfig setGlobalW(int globalW) {
        this.globalW = globalW;
        return this;
    }

    public int getThreadConnectionMultiplier() {
        return this.threadConnectionMultiplier;
    }

    public void setThreadConnectionMultiplier(int threadConnectionMultiplier) {
        this.threadConnectionMultiplier = threadConnectionMultiplier;
    }

    public boolean isGlobalJ() {
        return this.globalJ;
    }

    public MorphiumConfig setGlobalJ(boolean globalJ) {
        this.globalJ = globalJ;
        return this;
    }

    public boolean isGlobalFsync() {
        return this.globalFsync;
    }

    public MorphiumConfig setGlobalFsync(boolean globalFsync) {
        this.globalFsync = globalFsync;
        return this;
    }

    public MorphiumWriter getBufferedWriter() {
        if (this.bufferedWriter == null) {
            this.bufferedWriter = new BufferedMorphiumWriterImpl();
        }
        return this.bufferedWriter;
    }

    public MorphiumConfig setBufferedWriter(MorphiumWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
        return this;
    }

    public MorphiumWriter getWriter() {
        if (this.writer == null) {
            this.writer = new MorphiumWriterImpl();
        }
        return this.writer;
    }

    public MorphiumConfig setWriter(MorphiumWriter writer) {
        this.writer = writer;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public MorphiumConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public MorphiumConfig setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
        return this;
    }

    public int getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    public MorphiumConfig setServerSelectionTimeout(int serverSelectionTimeout) {
        this.serverSelectionTimeout = serverSelectionTimeout;
        return this;
    }

    public Boolean getCredentialsEncrypted() {
        return this.credentialsEncrypted;
    }

    public MorphiumConfig setCredentialsEncrypted(Boolean credentialsEncrypted) {
        this.credentialsEncrypted = credentialsEncrypted;
        return this;
    }

    public String getMongoAuthDb() {
        return this.mongoAuthDb;
    }

    public String decryptAuthDb() {
        if (this.getCredentialsEncrypted() == null || !this.getCredentialsEncrypted().booleanValue()) {
            return this.getMongoAuthDb();
        }
        try {
            ValueEncryptionProvider ve = this.getValueEncryptionProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ve.setEncryptionKey(this.getCredentialsEncryptionKey().getBytes(StandardCharsets.UTF_8));
            ve.setDecryptionKey(this.getCredentialsDecryptionKey().getBytes(StandardCharsets.UTF_8));
            String authdb = "admin";
            if (this.getMongoAuthDb() != null) {
                authdb = new String(ve.decrypt(Base64.getDecoder().decode(this.getMongoAuthDb())));
            }
            return authdb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decryptMongoLogin() {
        if (this.getCredentialsEncrypted() == null || !this.getCredentialsEncrypted().booleanValue()) {
            return this.getMongoLogin();
        }
        try {
            ValueEncryptionProvider ve = this.getValueEncryptionProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ve.setEncryptionKey(this.getCredentialsEncryptionKey().getBytes(StandardCharsets.UTF_8));
            ve.setDecryptionKey(this.getCredentialsDecryptionKey().getBytes(StandardCharsets.UTF_8));
            return new String(ve.decrypt(Base64.getDecoder().decode(this.getMongoLogin())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decryptMongoPassword() {
        if (this.getCredentialsEncrypted() == null || !this.getCredentialsEncrypted().booleanValue()) {
            return this.getMongoLogin();
        }
        try {
            ValueEncryptionProvider ve = this.getValueEncryptionProviderClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ve.setEncryptionKey(this.getCredentialsEncryptionKey().getBytes(StandardCharsets.UTF_8));
            ve.setDecryptionKey(this.getCredentialsDecryptionKey().getBytes(StandardCharsets.UTF_8));
            return new String(ve.decrypt(Base64.getDecoder().decode(this.getMongoPassword())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MorphiumConfig setMongoAuthDb(String mongoAuthDb) {
        this.mongoAuthDb = mongoAuthDb;
        return this;
    }

    public String getMongoLogin() {
        return this.mongoLogin;
    }

    public MorphiumConfig setMongoLogin(String mongoLogin) {
        this.mongoLogin = mongoLogin;
        return this;
    }

    public String getMongoPassword() {
        return this.mongoPassword;
    }

    public MorphiumConfig setMongoPassword(String mongoPassword) {
        this.mongoPassword = mongoPassword;
        return this;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public MorphiumConfig setDefaultReadPreference(ReadPreference defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
        return this;
    }

    public String getDefaultReadPreferenceType() {
        return this.defaultReadPreferenceType;
    }

    public MorphiumConfig setDefaultReadPreferenceType(String stringDefaultReadPreference) {
        ReadPreferenceType readPreferenceType;
        this.defaultReadPreferenceType = stringDefaultReadPreference;
        try {
            readPreferenceType = ReadPreferenceType.valueOf(stringDefaultReadPreference.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            readPreferenceType = null;
        }
        if (readPreferenceType == null) {
            throw new RuntimeException("Could not set defaultReadPreferenceByString " + stringDefaultReadPreference);
        }
        ReadPreference defaultReadPreference = new ReadPreference();
        defaultReadPreference.setType(readPreferenceType);
        this.defaultReadPreference = defaultReadPreference;
        return this;
    }

    public int getWriteCacheTimeout() {
        return this.writeCacheTimeout;
    }

    public MorphiumConfig setWriteCacheTimeout(int writeCacheTimeout) {
        this.writeCacheTimeout = writeCacheTimeout;
        return this;
    }

    public MorphiumConfig setHostSeed(List<String> str) {
        this.hostSeed = str;
        return this;
    }

    public MorphiumConfig setHostSeed(List<String> str, List<Integer> ports) {
        this.hostSeed.clear();
        for (int i = 0; i < str.size(); ++i) {
            String host = str.get(i).replaceAll(" ", "") + ":" + String.valueOf(ports.get(i));
            this.hostSeed.add(host);
        }
        return this;
    }

    public List<String> getHostSeed() {
        return this.hostSeed;
    }

    public MorphiumConfig setHostSeed(String ... hostPorts) {
        this.hostSeed.clear();
        for (String h : hostPorts) {
            this.addHostToSeed(h);
        }
        return this;
    }

    public MorphiumConfig setHostSeed(String hostPorts) {
        String[] h;
        this.hostSeed.clear();
        for (String host : h = hostPorts.split(",")) {
            this.addHostToSeed(host);
        }
        return this;
    }

    public MorphiumConfig setHostSeed(String hosts, String ports) {
        this.hostSeed.clear();
        hosts = hosts.replaceAll(" ", "");
        ports = ports.replaceAll(" ", "");
        String[] h = hosts.split(",");
        String[] p = ports.split(",");
        for (int i = 0; i < h.length; ++i) {
            if (p.length < i) {
                this.addHostToSeed(h[i], 27017);
                continue;
            }
            this.addHostToSeed(h[i], Integer.parseInt(p[i]));
        }
        return this;
    }

    public MorphiumConfig addHostToSeed(String host, int port) {
        host = ((String)host).replaceAll(" ", "") + ":" + port;
        if (this.hostSeed == null) {
            this.hostSeed = new ArrayList<String>();
        }
        this.hostSeed.add((String)host);
        return this;
    }

    public MorphiumConfig addHostToSeed(String host) {
        if ((host = host.replaceAll(" ", "")).contains(":")) {
            String[] h = host.split(":");
            this.addHostToSeed(h[0], Integer.parseInt(h[1]));
        } else {
            this.addHostToSeed(host, 27017);
        }
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public MorphiumConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public int getGlobalCacheValidTime() {
        return this.globalCacheValidTime;
    }

    public MorphiumConfig setGlobalCacheValidTime(int globalCacheValidTime) {
        this.globalCacheValidTime = globalCacheValidTime;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public MorphiumConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public int getHousekeepingTimeout() {
        return this.housekeepingTimeout;
    }

    public MorphiumConfig setHousekeepingTimeout(int housekeepingTimeout) {
        this.housekeepingTimeout = housekeepingTimeout;
        return this;
    }

    public long getValidTime() {
        return this.globalCacheValidTime;
    }

    public MorphiumConfig setValidTime(int tm) {
        this.globalCacheValidTime = tm;
        return this;
    }

    public String toString() {
        try {
            return Utils.toJsonString(new ObjectMapperImpl().serialize(this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MorphiumWriter getAsyncWriter() {
        if (this.asyncWriter == null) {
            this.asyncWriter = new AsyncWriterImpl();
        }
        return this.asyncWriter;
    }

    public MorphiumConfig setAsyncWriter(MorphiumWriter asyncWriter) {
        this.asyncWriter = asyncWriter;
        return this;
    }

    public int getMaximumRetriesBufferedWriter() {
        return this.maximumRetriesBufferedWriter;
    }

    public MorphiumConfig setMaximumRetriesBufferedWriter(int maximumRetriesBufferedWriter) {
        this.maximumRetriesBufferedWriter = maximumRetriesBufferedWriter;
        return this;
    }

    public int getMaximumRetriesWriter() {
        return this.maximumRetriesWriter;
    }

    public MorphiumConfig setMaximumRetriesWriter(int maximumRetriesWriter) {
        this.maximumRetriesWriter = maximumRetriesWriter;
        return this;
    }

    public int getMaximumRetriesAsyncWriter() {
        return this.maximumRetriesAsyncWriter;
    }

    public MorphiumConfig setMaximumRetriesAsyncWriter(int maximumRetriesAsyncWriter) {
        this.maximumRetriesAsyncWriter = maximumRetriesAsyncWriter;
        return this;
    }

    public int getRetryWaitTimeBufferedWriter() {
        return this.retryWaitTimeBufferedWriter;
    }

    public MorphiumConfig setRetryWaitTimeBufferedWriter(int retryWaitTimeBufferedWriter) {
        this.retryWaitTimeBufferedWriter = retryWaitTimeBufferedWriter;
        return this;
    }

    public int getRetryWaitTimeWriter() {
        return this.retryWaitTimeWriter;
    }

    public MorphiumConfig setRetryWaitTimeWriter(int retryWaitTimeWriter) {
        this.retryWaitTimeWriter = retryWaitTimeWriter;
        return this;
    }

    public int getRetryWaitTimeAsyncWriter() {
        return this.retryWaitTimeAsyncWriter;
    }

    public MorphiumConfig setRetryWaitTimeAsyncWriter(int retryWaitTimeAsyncWriter) {
        this.retryWaitTimeAsyncWriter = retryWaitTimeAsyncWriter;
        return this;
    }

    public Properties asProperties() {
        return this.asProperties(null);
    }

    public Properties asProperties(String prefix) {
        return this.asProperties(prefix, true);
    }

    public Properties asProperties(String prefix, boolean effectiveConfig) {
        prefix = prefix == null ? "" : (String)prefix + ".";
        MorphiumConfig defaults = new MorphiumConfig();
        Properties p = new Properties();
        AnnotationAndReflectionHelper an = new AnnotationAndReflectionHelper(true);
        List<Field> flds = an.getAllFields(MorphiumConfig.class);
        for (Field f : flds) {
            if (f.isAnnotationPresent(Transient.class)) continue;
            f.setAccessible(true);
            try {
                if ((f.get(this) == null || f.get(this).equals(f.get(defaults))) && !f.getName().equals("database")) continue;
                p.put((String)prefix + f.getName(), f.get(this).toString());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (effectiveConfig) {
            Properties sysprop = System.getProperties();
            for (Object sysk : sysprop.keySet()) {
                String k = (String)sysk;
                if (!k.startsWith("morphium.")) continue;
                String value = sysprop.get(k).toString();
                k = k.substring(9);
                p.put((String)prefix + k, value);
            }
        }
        return p;
    }

    public boolean isReadCacheEnabled() {
        return this.readCacheEnabled;
    }

    public MorphiumConfig setReadCacheEnabled(boolean readCacheEnabled) {
        this.readCacheEnabled = readCacheEnabled;
        return this;
    }

    public MorphiumConfig disableReadCache() {
        this.readCacheEnabled = false;
        return this;
    }

    public MorphiumConfig enableReadCache() {
        this.readCacheEnabled = true;
        return this;
    }

    public boolean isAsyncWritesEnabled() {
        return this.asyncWritesEnabled;
    }

    public MorphiumConfig setAsyncWritesEnabled(boolean asyncWritesEnabled) {
        this.asyncWritesEnabled = asyncWritesEnabled;
        return this;
    }

    public MorphiumConfig disableAsyncWrites() {
        this.asyncWritesEnabled = false;
        return this;
    }

    public MorphiumConfig enableAsyncWrites() {
        this.asyncWritesEnabled = true;
        return this;
    }

    public boolean isBufferedWritesEnabled() {
        return this.bufferedWritesEnabled;
    }

    public MorphiumConfig setBufferedWritesEnabled(boolean bufferedWritesEnabled) {
        this.bufferedWritesEnabled = bufferedWritesEnabled;
        return this;
    }

    public MorphiumConfig disableBufferedWrites() {
        this.bufferedWritesEnabled = false;
        return this;
    }

    public MorphiumConfig enableBufferedWrites() {
        this.bufferedWritesEnabled = true;
        return this;
    }

    public boolean isAutoValuesEnabled() {
        return this.autoValues;
    }

    public MorphiumConfig setAutoValuesEnabled(boolean enabled) {
        this.autoValues = enabled;
        return this;
    }

    public MorphiumConfig enableAutoValues() {
        this.autoValues = true;
        return this;
    }

    public MorphiumConfig disableAutoValues() {
        this.autoValues = false;
        return this;
    }

    public boolean isCamelCaseConversionEnabled() {
        return this.camelCaseConversionEnabled;
    }

    public MorphiumConfig setCamelCaseConversionEnabled(boolean camelCaseConversionEnabled) {
        this.camelCaseConversionEnabled = camelCaseConversionEnabled;
        return this;
    }

    public int getThreadPoolMessagingCoreSize() {
        return this.threadPoolMessagingCoreSize;
    }

    public MorphiumConfig setThreadPoolMessagingCoreSize(int threadPoolMessagingCoreSize) {
        this.threadPoolMessagingCoreSize = threadPoolMessagingCoreSize;
        return this;
    }

    public int getThreadPoolMessagingMaxSize() {
        return this.threadPoolMessagingMaxSize;
    }

    public MorphiumConfig setThreadPoolMessagingMaxSize(int threadPoolMessagingMaxSize) {
        this.threadPoolMessagingMaxSize = threadPoolMessagingMaxSize;
        return this;
    }

    public long getThreadPoolMessagingKeepAliveTime() {
        return this.threadPoolMessagingKeepAliveTime;
    }

    public MorphiumConfig setThreadPoolMessagingKeepAliveTime(long threadPoolMessagingKeepAliveTime) {
        this.threadPoolMessagingKeepAliveTime = threadPoolMessagingKeepAliveTime;
        return this;
    }

    public int getThreadPoolAsyncOpCoreSize() {
        return this.threadPoolAsyncOpCoreSize;
    }

    public MorphiumConfig setThreadPoolAsyncOpCoreSize(int threadPoolAsyncOpCoreSize) {
        this.threadPoolAsyncOpCoreSize = threadPoolAsyncOpCoreSize;
        return this;
    }

    public int getThreadPoolAsyncOpMaxSize() {
        return this.threadPoolAsyncOpMaxSize;
    }

    public MorphiumConfig setThreadPoolAsyncOpMaxSize(int threadPoolAsyncOpMaxSize) {
        this.threadPoolAsyncOpMaxSize = threadPoolAsyncOpMaxSize;
        return this;
    }

    public long getThreadPoolAsyncOpKeepAliveTime() {
        return this.threadPoolAsyncOpKeepAliveTime;
    }

    public MorphiumConfig setThreadPoolAsyncOpKeepAliveTime(long threadPoolAsyncOpKeepAliveTime) {
        this.threadPoolAsyncOpKeepAliveTime = threadPoolAsyncOpKeepAliveTime;
        return this;
    }

    public boolean isObjectSerializationEnabled() {
        return this.objectSerializationEnabled;
    }

    public MorphiumConfig setObjectSerializationEnabled(boolean objectSerializationEnabled) {
        this.objectSerializationEnabled = objectSerializationEnabled;
        return this;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public MorphiumConfig setHeartbeatFrequency(int heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
        return this;
    }

    public int getMinConnectionsHost() {
        return this.minConnections;
    }

    public MorphiumConfig setMinConnections(int minConnections) {
        this.minConnections = minConnections;
        return this;
    }

    public int getLocalThreshold() {
        return this.localThreshold;
    }

    public MorphiumConfig setLocalThreshold(int localThreshold) {
        this.localThreshold = localThreshold;
        return this;
    }

    public int getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public MorphiumConfig setMaxConnectionIdleTime(int maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
        return this;
    }

    public int getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    public MorphiumConfig setMaxConnectionLifeTime(int maxConnectionLifeTime) {
        this.maxConnectionLifeTime = maxConnectionLifeTime;
        return this;
    }

    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    public MorphiumConfig setRequiredReplicaSetName(String requiredReplicaSetName) {
        this.requiredReplicaSetName = requiredReplicaSetName;
        return this;
    }

    public String getDefaultTags() {
        return this.defaultTags;
    }

    public MorphiumConfig addDefaultTag(String name, String value) {
        this.defaultTags = this.defaultTags != null ? this.defaultTags + "," : "";
        this.defaultTags = this.defaultTags + name + ":" + value;
        return this;
    }

    public List<Map<String, String>> getDefaultTagSet() {
        if (this.defaultTags == null) {
            return null;
        }
        ArrayList<Map<String, String>> tagList = new ArrayList<Map<String, String>>();
        for (String t : this.defaultTags.split(",")) {
            String[] tag = t.split(":");
            tagList.add(UtilsMap.of(tag[0], tag[1]));
        }
        return tagList;
    }

    public int getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    public MorphiumConfig setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
        return this;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isSslInvalidHostNameAllowed() {
        return this.sslInvalidHostNameAllowed;
    }

    public void setSslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isRetryReads() {
        return this.retryReads;
    }

    public void setRetryReads(boolean retryReads) {
        this.retryReads = retryReads;
    }

    public boolean isRetryWrites() {
        return this.retryWrites;
    }

    public void setRetryWrites(boolean retryWrites) {
        this.retryWrites = retryWrites;
    }

    public String getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    public void setUuidRepresentation(String uuidRepresentation) {
        this.uuidRepresentation = uuidRepresentation;
    }

    public IndexCheck getIndexCheck() {
        return this.indexCheck;
    }

    public void setIndexCheck(IndexCheck indexCheck) {
        this.indexCheck = indexCheck;
    }

    public CappedCheck getCappedCheck() {
        return this.cappedCheck;
    }

    public MorphiumConfig setCappedCheck(CappedCheck cappedCheck) {
        this.cappedCheck = cappedCheck;
        return this;
    }

    public int getIdleSleepTime() {
        return this.idleSleepTime;
    }

    public void setIdleSleepTime(int idleSleepTime) {
        this.idleSleepTime = idleSleepTime;
    }

    public Map<String, Object> getRestoreData() {
        return this.restoreData;
    }

    public void setRestoreData(Map<String, Object> restoreData) {
        this.restoreData = restoreData;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setReplicaset(boolean replicaset) {
        this.replicaset = replicaset;
    }

    public boolean isAutoValues() {
        return this.autoValues;
    }

    public void setAutoValues(boolean autoValues) {
        this.autoValues = autoValues;
    }

    public void setDefaultTags(String defaultTags) {
        this.defaultTags = defaultTags;
    }

    public String getMessagingStatusInfoListenerName() {
        return this.messagingStatusInfoListenerName;
    }

    public void setMessagingStatusInfoListenerName(String messagingStatusInfoListenerName) {
        this.messagingStatusInfoListenerName = messagingStatusInfoListenerName;
    }

    public static enum IndexCheck {
        NO_CHECK,
        WARN_ON_STARTUP,
        CREATE_ON_WRITE_NEW_COL,
        CREATE_ON_STARTUP;

    }

    public static enum CappedCheck {
        NO_CHECK,
        WARN_ON_STARTUP,
        CREATE_ON_STARTUP,
        CREATE_ON_WRITE_NEW_COL,
        CONVERT_EXISTING_ON_STARTUP;

    }
}

