/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumDriverNetworkException;
import de.caluga.morphium.driver.MorphiumDriverOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkCallHelper<T> {
    private final Logger logger = LoggerFactory.getLogger(NetworkCallHelper.class);

    public T doCall(MorphiumDriverOperation r, int maxRetry, int sleep, ErrorCallback err) throws MorphiumDriverException {
        if (maxRetry == 0) {
            this.logger.error("MaxRetry set to 0?!?!?! Does not make sense! defaulting to 1");
            maxRetry = 1;
        }
        for (int i = 0; i < maxRetry; ++i) {
            try {
                return (T)r.execute();
            }
            catch (Exception e) {
                this.handleNetworkError(maxRetry, i, sleep, e, err);
                continue;
            }
        }
        return null;
    }

    public T doCall(MorphiumDriverOperation r, int maxRetry, int sleep) throws MorphiumDriverException {
        return this.doCall(r, maxRetry, sleep, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNetworkError(int max, int i, int sleep, Throwable e, ErrorCallback err) throws MorphiumDriverException {
        this.logger.info("Handling network error..." + e.getClass().getName());
        if (e instanceof MorphiumDriverNetworkException) {
            if (i + 1 < max) {
                this.logger.warn("Retry because of network error: " + e.getMessage());
                try {
                    Thread.sleep(sleep);
                    return;
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
            this.logger.info("no retries left - re-throwing exception");
            if (err == null) throw new MorphiumDriverNetworkException("Network error error", e);
            try {
                err.onError(e);
                throw new MorphiumDriverNetworkException("Network error error", e);
            }
            catch (Exception e1) {
                throw new MorphiumDriverException("error callback failed", e1);
            }
        }
        if (!(e instanceof MorphiumDriverException)) throw new MorphiumDriverException("internal error", e);
        throw (MorphiumDriverException)e;
    }

    public static interface ErrorCallback {
        public void onError(Throwable var1) throws Exception;
    }
}

