/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.Collation;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ObjectMapperImpl;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.AggregationIterator;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.aggregation.Group;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.AggregateMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatorImpl<T, R>
implements Aggregator<T, R> {
    private final List<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
    private final List<Group<T, R>> groups = new ArrayList<Group<T, R>>();
    private Class<? extends T> type;
    private Morphium morphium;
    private Class<? extends R> rType;
    private String collectionName;
    private boolean useDisk = false;
    private boolean explain = false;
    private Collation collation;
    private final Logger log = LoggerFactory.getLogger(AggregatorImpl.class);

    public AggregatorImpl(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        this.morphium = morphium;
        this.setSearchType(type);
        this.setResultType(resultType);
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    @Override
    public boolean isUseDisk() {
        return this.useDisk;
    }

    @Override
    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
    }

    @Override
    public Class<? extends T> getSearchType() {
        return this.type;
    }

    @Override
    public void setSearchType(Class<? extends T> type) {
        this.type = type;
    }

    @Override
    public Class<? extends R> getResultType() {
        return this.rType;
    }

    @Override
    public void setResultType(Class<? extends R> type) {
        this.rType = type;
    }

    @Override
    public Aggregator<T, R> project(Map<String, Object> m) {
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getValue() instanceof Expr) {
                p.put(e.getKey(), ((Expr)e.getValue()).toQueryObject());
                continue;
            }
            p.put(e.getKey(), e.getValue());
        }
        UtilsMap map = UtilsMap.of("$project", p);
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> project(String fld, Expr e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(fld, e.toQueryObject());
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> project(String ... m) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String sm : m) {
            map.put(sm, 1);
        }
        return this.project(map);
    }

    @Override
    public Aggregator<T, R> addFields(Map<String, Object> m) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e.getValue() instanceof Expr) {
                ret.put(e.getKey(), ((Expr)e.getValue()).toQueryObject());
                continue;
            }
            ret.put(e.getKey(), e.getValue());
        }
        UtilsMap o = UtilsMap.of("$addFields", ret);
        this.params.add(o);
        return this;
    }

    @Override
    public Map<String, Object> explain() throws MorphiumDriverException {
        return this.explain(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> explain(ExplainCommand.ExplainVerbosity verbosity) throws MorphiumDriverException {
        AggregateMongoCommand cmd = this.getAggregateCmd();
        try {
            Map<String, Object> map = cmd.explain(verbosity);
            return map;
        }
        finally {
            cmd.releaseConnection();
        }
    }

    @Override
    public Aggregator<T, R> match(Query<T> q) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$match", q.toQueryObject());
        if (this.collectionName == null) {
            this.collectionName = q.getCollectionName();
        }
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> matchSubQuery(Query<?> q) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$match", q.toQueryObject());
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> match(Expr q) {
        this.params.add(UtilsMap.of("$match", UtilsMap.of("$expr", q.toQueryObject())));
        return this;
    }

    @Override
    public Aggregator<T, R> limit(int num) {
        UtilsMap<String, Integer> o = UtilsMap.of("$limit", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> skip(int num) {
        UtilsMap<String, Integer> o = UtilsMap.of("$skip", num);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(Expr listField) {
        UtilsMap<String, Expr> o = UtilsMap.of("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> unwind(String listField) {
        UtilsMap<String, String> o = UtilsMap.of("$unwind", listField);
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(String ... prefixed) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixed;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (i2.startsWith("$") && !(fld = fld.substring(1)).contains(".")) {
                fld = this.morphium.getARHelper().getMongoFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        this.sort(m);
        return this;
    }

    @Override
    public Aggregator<T, R> sort(Map<String, Integer> sort) {
        UtilsMap<String, Map<String, Integer>> o = UtilsMap.of("$sort", sort);
        this.params.add(o);
        return this;
    }

    @Override
    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    @Override
    public Aggregator<T, R> setCollectionName(String cn) {
        this.collectionName = cn;
        return this;
    }

    @Override
    public Group<T, R> group(Map<String, Object> id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(Expr id) {
        return new Group(this, id);
    }

    @Override
    public Group<T, R> group(String id) {
        Group gr = new Group(this, id);
        this.groups.add(gr);
        return gr;
    }

    @Override
    public void addOperator(Map<String, Object> o) {
        this.params.add(o);
    }

    @Override
    public List<R> aggregate() {
        try {
            return this.deserializeList();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getCount() {
        List<Map<String, Object>> pipeline = this.getPipeline();
        pipeline.add(Doc.of("$count", "num"));
        List<Map<String, Object>> res = null;
        AggregateMongoCommand cmd = this.getAggregateCmd();
        try {
            cmd.setPipeline(pipeline);
            res = cmd.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
        }
        if (res.size() == 0) {
            return 0L;
        }
        if (res.get(0).get("num") instanceof Integer) {
            return ((Integer)res.get(0).get("num")).longValue();
        }
        return (Long)res.get(0).get("num");
    }

    @Override
    public MorphiumAggregationIterator<T, R> aggregateIterable() {
        AggregationIterator agg = new AggregationIterator();
        agg.setAggregator(this);
        return agg;
    }

    @Override
    public void aggregate(AsyncOperationCallback<R> callback) {
        if (callback == null) {
            AggregateMongoCommand cmd = this.getAggregateCmd();
            try {
                this.log.warn("Async operation but callback is null!");
                cmd.executeAsync();
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
            }
        } else {
            this.morphium.queueTask(() -> {
                try {
                    long start = System.currentTimeMillis();
                    List<R> result = this.deserializeList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, result, null, this);
                }
                catch (MorphiumDriverException e) {
                    this.log.error("error in queued task", (Throwable)e);
                }
            });
        }
    }

    private List<R> deserializeList() throws MorphiumDriverException {
        AggregateMongoCommand cmd = this.getAggregateCmd();
        List<Map<String, Object>> r = cmd.execute();
        this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
        List<Object> result = new ArrayList();
        if (this.getResultType().equals(Map.class)) {
            result = r;
        } else {
            for (Map<String, Object> dbObj : r) {
                result.add(this.morphium.getMapper().deserialize(this.getResultType(), dbObj));
            }
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> aggregateMap() {
        AggregateMongoCommand cmd = this.getAggregateCmd();
        try {
            Entity.ReadConcernLevel rc = Entity.ReadConcernLevel.majority;
            if (this.collation != null) {
                cmd.setCollation(Doc.of(this.getCollation().toQueryObject()));
            }
            List<Map<String, Object>> list = cmd.execute();
            return list;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
        }
    }

    @Override
    public void aggregateMap(AsyncOperationCallback<Map<String, Object>> callback) {
        if (callback == null) {
            AggregateMongoCommand cmd = this.getAggregateCmd();
            try {
                cmd.execute();
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
            }
        } else {
            this.morphium.queueTask(() -> {
                AggregateMongoCommand cmd = this.getAggregateCmd();
                try {
                    long start = System.currentTimeMillis();
                    List<Map<String, Object>> ret = cmd.execute();
                    callback.onOperationSucceeded(AsyncOperationType.READ, null, System.currentTimeMillis() - start, ret, null, this);
                }
                catch (MorphiumDriverException e) {
                    LoggerFactory.getLogger(AggregatorImpl.class).error("error", (Throwable)e);
                }
                finally {
                    this.getMorphium().getDriver().releaseConnection(cmd.getConnection());
                }
            });
        }
    }

    @Override
    public AggregateMongoCommand getAggregateCmd() {
        MongoConnection readConnection = this.morphium.getDriver().getReadConnection(null);
        AggregateMongoCommand cmd = new AggregateMongoCommand(readConnection);
        ((AggregateMongoCommand)((AggregateMongoCommand)((AggregateMongoCommand)cmd.setDb(this.morphium.getDatabase())).setColl(this.getCollectionName())).setPipeline(this.getPipeline()).setExplain(this.isExplain()).setReadPreference(this.morphium.getReadPreferenceForClass(this.getSearchType()))).setAllowDiskUse(this.isUseDisk());
        if (this.collation != null) {
            cmd.setCollation(Doc.of(this.getCollation().toQueryObject()));
        }
        return cmd;
    }

    @Override
    public List<Map<String, Object>> getPipeline() {
        for (Group<T, R> g : this.groups) {
            g.end();
        }
        this.groups.clear();
        return this.params;
    }

    @Override
    public Aggregator<T, R> count(String fld) {
        this.params.add(UtilsMap.of("$count", fld));
        return this;
    }

    @Override
    public Aggregator<T, R> count(Enum fld) {
        return this.count(fld.name());
    }

    @Override
    public Aggregator<T, R> out(Class<?> type) {
        return this.out(this.morphium.getMapper().getCollectionName(type));
    }

    @Override
    public Aggregator<T, R> bucket(Expr groupBy, List<Expr> boundaries, Expr preset, Map<String, Expr> output) {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Expr> e : output.entrySet()) {
            out.put(e.getKey(), e.getValue().toQueryObject());
        }
        ArrayList bn = new ArrayList();
        boundaries.forEach(x -> bn.add(x.toQueryObject()));
        UtilsMap<String, UtilsMap<String, Map<String, Object>>> m = UtilsMap.of("$bucket", UtilsMap.of("groupBy", groupBy.toQueryObject(), "boundaries", bn, "default", preset.toQueryObject(), "output", Utils.getQueryObjectMap(output)));
        this.params.add(m);
        return this;
    }

    @Override
    public Aggregator<T, R> bucketAuto(Expr groupBy, int numBuckets, Map<String, Expr> output, Aggregator.BucketGranularity granularity) {
        LinkedHashMap<String, Object> out = null;
        if (output != null) {
            out = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Expr> e : output.entrySet()) {
                out.put(e.getKey(), e.getValue().toQueryObject());
            }
        }
        UtilsMap<String, Integer> bucketAuto = UtilsMap.of("groupBy", groupBy.toQueryObject(), "buckets", numBuckets);
        UtilsMap<String, UtilsMap<String, Integer>> map = UtilsMap.of("$bucketAuto", bucketAuto);
        if (out != null) {
            bucketAuto.put("output", (Integer)((Object)out));
        }
        if (granularity != null) {
            bucketAuto.put("granularity", (Integer)((Object)granularity.getValue()));
        }
        this.params.add(map);
        return this;
    }

    @Override
    public Aggregator<T, R> collStats(Boolean latencyHistograms, Double scale, boolean count, boolean queryExecStats) {
        LinkedHashMap m = new LinkedHashMap();
        if (latencyHistograms != null) {
            m.put("latencyStats", UtilsMap.of("histograms", latencyHistograms));
        }
        if (scale != null) {
            m.put("storageStats", UtilsMap.of("scale", scale));
        }
        if (count) {
            m.put("count", new HashMap());
        }
        if (queryExecStats) {
            m.put("queryExecStats", new HashMap());
        }
        this.params.add(UtilsMap.of("$collStats", m));
        return this;
    }

    @Override
    public Aggregator<T, R> currentOp(boolean allUsers, boolean idleConnections, boolean idleCursors, boolean idleSessions, boolean localOps) {
        this.params.add(UtilsMap.of("$currentOp", UtilsMap.of("allUsers", allUsers, "idleConnections", idleConnections, "idleCursors", idleCursors, "idleSessions", idleSessions, "localOps", localOps)));
        return this;
    }

    @Override
    public Aggregator<T, R> facetExpr(Map<String, Expr> facets) {
        Map<String, Object> map = Utils.getQueryObjectMap(facets);
        this.params.add(UtilsMap.of("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> facet(Map<String, Aggregator> facets) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        for (Map.Entry<String, Aggregator> e : facets.entrySet()) {
            map.put(e.getKey(), e.getValue().getPipeline());
        }
        this.params.add(UtilsMap.of("$facet", map));
        return this;
    }

    @Override
    public Aggregator<T, R> geoNear(Map<Aggregator.GeoNearFields, Object> param) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<Aggregator.GeoNearFields, Object> e : param.entrySet()) {
            map.put(e.getKey().name(), ((ObjectMapperImpl)this.morphium.getMapper()).marshallIfNecessary(e.getValue()));
        }
        this.params.add(UtilsMap.of("$geoNear", map));
        return this;
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, Enum connectFromField, Enum connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField.name(), connectToField.name(), as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(Class<?> type, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        return this.graphLookup(this.morphium.getMapper().getCollectionName(type), startWith, connectFromField, connectToField, as, maxDepth, depthField, restrictSearchWithMatch);
    }

    @Override
    public Aggregator<T, R> graphLookup(String fromCollection, Expr startWith, String connectFromField, String connectToField, String as, Integer maxDepth, String depthField, Query restrictSearchWithMatch) {
        UtilsMap<String, String> add = UtilsMap.of("from", fromCollection, "startWith", startWith.toQueryObject(), "connectFromField", connectFromField, "connectToField", connectToField, "as", as);
        this.params.add(UtilsMap.of("$graphLookup", add));
        if (maxDepth != null) {
            add.put("maxDepth", (String)((Object)maxDepth));
        }
        if (depthField != null) {
            add.put("depthField", depthField);
        }
        if (restrictSearchWithMatch != null) {
            add.put("restrictSearchWithMatch", (String)((Object)restrictSearchWithMatch.toQueryObject()));
        }
        return this;
    }

    @Override
    public Aggregator<T, R> indexStats() {
        this.params.add(UtilsMap.of("$indexStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessionsAllUsers() {
        this.params.add(UtilsMap.of("$listLocalSessions", UtilsMap.of("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions() {
        this.params.add(UtilsMap.of("$listLocalSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listLocalSessions(List<String> users, List<String> dbs) {
        ArrayList<UtilsMap<String, String>> usersList = new ArrayList<UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(UtilsMap.of(users.get(i), dbs.get(j)));
        }
        this.params.add(UtilsMap.of("$listLocalSessions", UtilsMap.of("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessionsAllUsers() {
        this.params.add(UtilsMap.of("$listSessions", UtilsMap.of("allUsers", true)));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions() {
        this.params.add(UtilsMap.of("$listSessions", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> listSessions(List<String> users, List<String> dbs) {
        ArrayList<UtilsMap<String, String>> usersList = new ArrayList<UtilsMap<String, String>>();
        for (int i = 0; i < users.size(); ++i) {
            int j = i;
            if (j > dbs.size()) {
                j = dbs.size() - 1;
            }
            usersList.add(UtilsMap.of(users.get(i), dbs.get(j)));
        }
        this.params.add(UtilsMap.of("$listSessions", UtilsMap.of("users", usersList)));
        return this;
    }

    @Override
    public Aggregator<T, R> lookup(Class fromType, Enum localField, Enum foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        return this.lookup(this.getMorphium().getMapper().getCollectionName(fromType), localField.name(), foreignField.name(), outputArray, pipeline, let);
    }

    @Override
    public Aggregator<T, R> lookup(String fromCollection, String localField, String foreignField, String outputArray, List<Expr> pipeline, Map<String, Expr> let) {
        UtilsMap<String, String> m = UtilsMap.of("from", fromCollection);
        if (localField != null) {
            m.put("localField", localField);
        }
        if (foreignField != null) {
            m.put("foreignField", foreignField);
        }
        if (outputArray != null) {
            m.put("as", outputArray);
        }
        if (pipeline != null && pipeline.size() > 0) {
            ArrayList<Object> lst = new ArrayList<Object>();
            for (Expr expr : pipeline) {
                lst.add(expr.toQueryObject());
            }
            m.put("pipeline", (String)((Object)lst));
        }
        if (let != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry entry : let.entrySet()) {
                map.put((String)entry.getKey(), ((Expr)entry.getValue()).toQueryObject());
            }
            m.put("let", (String)((Object)map));
        }
        this.params.add(UtilsMap.of("$lookup", m));
        return this;
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(intoDb, intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection, Map<String, Expr> let, List<Map<String, Expr>> machedPipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), let, machedPipeline, Aggregator.MergeActionWhenMatched.merge, notMatchedAction, onFields);
    }

    @Override
    public Aggregator<T, R> merge(String intoDb, String intoCollection) {
        return this.merge(intoDb, intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(Class<?> intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(intoCollection), null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, Aggregator.MergeActionWhenMatched.merge, Aggregator.MergeActionWhenNotMatched.insert, new String[0]);
    }

    @Override
    public Aggregator<T, R> merge(String intoCollection, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        return this.merge(this.morphium.getConfig().getDatabase(), intoCollection, null, null, matchAction, notMatchedAction, onFields);
    }

    private Aggregator<T, R> merge(String intoDb, String intoCollection, Map<String, Expr> let, List<Map<String, Expr>> pipeline, Aggregator.MergeActionWhenMatched matchAction, Aggregator.MergeActionWhenNotMatched notMatchedAction, String ... onFields) {
        Class<?> entity = this.morphium.getMapper().getClassForCollectionName(intoCollection);
        ArrayList<String> flds = new ArrayList<String>();
        if (entity != null) {
            for (String f : onFields) {
                flds.add(this.morphium.getARHelper().getMongoFieldName(entity, f));
            }
        } else {
            this.log.warn("no entity know for collection " + intoCollection);
            this.log.warn("cannot check field names / properties");
            flds.addAll(Arrays.asList(onFields));
        }
        UtilsMap<String, UtilsMap<String, String>> doc = UtilsMap.of("into", UtilsMap.of("db", intoDb, "coll", intoCollection));
        if (let != null) {
            doc.put("let", (UtilsMap<String, String>)Utils.getNoExprMap(let));
        }
        if (matchAction != null) {
            doc.put("whenMatched", (UtilsMap<String, String>)((Object)matchAction.name()));
        }
        if (notMatchedAction != null) {
            doc.put("whenNotMatched", (UtilsMap<String, String>)((Object)notMatchedAction.name()));
        }
        if (onFields != null && onFields.length != 0) {
            doc.put("on", (UtilsMap<String, String>)((Object)flds));
        }
        if (pipeline != null) {
            doc.put("whenMatched", (UtilsMap<String, String>)((Object)pipeline));
        }
        this.params.add(UtilsMap.of("$merge", doc));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String collectionName) {
        this.params.add(UtilsMap.of("$out", UtilsMap.of("coll", collectionName)));
        return this;
    }

    @Override
    public Aggregator<T, R> out(String db, String collectionName) {
        this.params.add(UtilsMap.of("$out", UtilsMap.of("coll", collectionName, "db", db)));
        return this;
    }

    @Override
    public Aggregator<T, R> planCacheStats(Map<String, Object> param) {
        this.params.add(UtilsMap.of("$planCacheStats", new HashMap()));
        return this;
    }

    @Override
    public Aggregator<T, R> redact(Expr redact) {
        this.params.add(UtilsMap.of("$redact", redact.toQueryObject()));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceRoot(Expr newRoot) {
        this.params.add(UtilsMap.of("$replaceRoot", UtilsMap.of("newRoot", newRoot.toQueryObject())));
        return this;
    }

    @Override
    public Aggregator<T, R> replaceWith(Expr newDoc) {
        this.params.add(UtilsMap.of("$replaceWith", newDoc.toQueryObject()));
        return this;
    }

    @Override
    public Aggregator<T, R> sample(int sampleSize) {
        this.params.add(UtilsMap.of("$sample", UtilsMap.of("size", sampleSize)));
        return this;
    }

    @Override
    public Aggregator<T, R> set(Map<String, Expr> param) {
        UtilsMap<String, Map<String, Object>> o = UtilsMap.of("$set", Utils.getQueryObjectMap(param));
        this.params.add(o);
        return this;
    }

    @Override
    public Aggregator<T, R> sortByCount(Expr sortby) {
        this.params.add(UtilsMap.of("$sortByCount", sortby.toQueryObject()));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(String collection) {
        this.params.add(UtilsMap.of("$unionWith", collection));
        return this;
    }

    @Override
    public Aggregator<T, R> unionWith(Aggregator agg) {
        this.params.add(UtilsMap.of("$unionWith", UtilsMap.of("coll", this.collectionName, "pipeline", agg.getPipeline())));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(List<String> field) {
        this.params.add(UtilsMap.of("$unset", field));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(String ... param) {
        this.params.add(UtilsMap.of("$unset", Arrays.asList(param)));
        return this;
    }

    @Override
    public Aggregator<T, R> unset(Enum ... field) {
        List lst = Arrays.stream(field).map(Enum::name).collect(Collectors.toList());
        this.params.add(UtilsMap.of("$unset", lst));
        return this;
    }

    @Override
    public Aggregator<T, R> genericStage(String stageName, Object param) {
        if (param instanceof Expr) {
            param = ((Expr)param).toQueryObject();
        }
        if (!((String)stageName).startsWith("$")) {
            stageName = "$" + (String)stageName;
        }
        this.params.add(UtilsMap.of(stageName, param));
        return this;
    }

    @Override
    public Aggregator<T, R> collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

