/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.server;

import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.bson.MongoTimestamp;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.inmem.InMemoryDriver;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumServer {
    private static Logger log = LoggerFactory.getLogger(MorphiumServer.class);
    private InMemoryDriver drv;
    private int port;
    private String host;
    private AtomicInteger msgId = new AtomicInteger(1000);
    private ThreadPoolExecutor executor;

    public MorphiumServer(int port, String host, int maxThreads, int minThreads) {
        this.drv = new InMemoryDriver();
        this.port = port;
        this.host = host;
        this.drv.connect();
        this.executor = new ThreadPoolExecutor(minThreads, maxThreads, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxThreads));
    }

    public MorphiumServer() {
        this(17017, "localhost", 100, 10);
    }

    public static void main(String[] args) throws Exception {
        int idx = 0;
        log.info("Starting up server... parsing commandline params");
        String host = "localhost";
        int port = 17017;
        int maxThreads = 1000;
        int minThreads = 10;
        block16: while (idx < args.length) {
            switch (args[idx]) {
                case "-p": 
                case "--port": {
                    port = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-mt": 
                case "--maxThreads": {
                    maxThreads = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-mint": 
                case "--minThreads": {
                    minThreads = Integer.parseInt(args[idx + 1]);
                    idx += 2;
                    continue block16;
                }
                case "-h": 
                case "--host": {
                    host = args[idx + 1];
                    idx += 2;
                    continue block16;
                }
            }
            log.error("unknown parameter " + args[idx]);
            System.exit(1);
        }
        log.info("Starting server...");
        MorphiumServer srv = new MorphiumServer(port, host, maxThreads, minThreads);
        srv.start();
    }

    private HelloResult getHelloResult() {
        HelloResult res = new HelloResult();
        res.setHelloOk(true);
        res.setLocalTime(new Date());
        res.setOk(1.0);
        res.setHosts(Arrays.asList(this.host + ":" + this.port));
        res.setConnectionId(1);
        res.setMaxWireVersion(17);
        res.setMinWireVersion(13);
        res.setMaxMessageSizeBytes(100000);
        res.setMaxBsonObjectSize(10000);
        res.setWritablePrimary(true);
        res.setMe(this.host + ":" + this.port);
        res.setMsg("ok");
        return res;
    }

    public void start() throws IOException, InterruptedException {
        log.info("Opening port " + this.port);
        ServerSocket ssoc = new ServerSocket(this.port);
        this.drv.setHostSeed(this.host + ":" + this.port);
        this.executor.prestartAllCoreThreads();
        log.info("Port opened, waiting for incoming connections");
        while (true) {
            Socket s = ssoc.accept();
            log.info("Incoming connection");
            this.executor.execute(() -> this.incoming(s));
        }
    }

    public void incoming(Socket s) {
        try {
            InputStream in = s.getInputStream();
            OutputStream out = s.getOutputStream();
            while (true) {
                Map<String, Object> answer;
                WireProtocolMessage msg = WireProtocolMessage.parseFromStream(in);
                log.info("got incoming msg: " + msg.getClass().getSimpleName());
                Map<String, Object> doc = null;
                int id = 0;
                if (msg instanceof OpQuery) {
                    OpReply r;
                    OpQuery q = (OpQuery)msg;
                    id = q.getMessageId();
                    doc = q.getDoc();
                    if (doc.containsKey("ismaster") || doc.containsKey("isMaster")) {
                        log.info("OpMsg->isMaster");
                        r = new OpReply();
                        r.setFlags(2);
                        r.setMessageId(this.msgId.incrementAndGet());
                        r.setResponseTo(id);
                        r.setNumReturned(1);
                        HelloResult res = this.getHelloResult();
                        r.setDocuments(Arrays.asList(res.toMsg()));
                        out.write(r.bytes());
                        out.flush();
                        log.info("Sent hello result");
                        continue;
                    }
                    r = new OpReply();
                    Doc d = Doc.of("$err", "OP_QUERY is no longer supported. The client driver may require an upgrade.", "code", (Object)5739101, "ok", (Object)0.0);
                    r.setFlags(2);
                    r.setMessageId(this.msgId.incrementAndGet());
                    r.setResponseTo(id);
                    r.setNumReturned(1);
                    r.setDocuments(Arrays.asList(d));
                    out.write(r.bytes());
                    out.flush();
                    log.info("Sent out error because OPQuery not allowed anymore!");
                    log.info(Utils.toJsonString(doc));
                    continue;
                }
                if (msg instanceof OpMsg) {
                    OpMsg m = (OpMsg)msg;
                    doc = ((OpMsg)msg).getFirstDoc();
                    log.info("Message flags: " + m.getFlags());
                    id = m.getMessageId();
                }
                log.info("Incoming " + Utils.toJsonString(doc));
                String cmd = (String)doc.keySet().stream().findFirst().get();
                log.info("Handling command " + cmd);
                OpMsg reply = new OpMsg();
                reply.setResponseTo(msg.getMessageId());
                reply.setMessageId(this.msgId.incrementAndGet());
                switch (cmd) {
                    case "getCmdLineOpts": {
                        answer = Doc.of("argv", List.of(), "parsed", Map.of());
                        break;
                    }
                    case "buildInfo": {
                        answer = Doc.of("version", "5.0.0-ALPHA", "buildEnvironment", Doc.of("distarch", "java", "targetarch", "java"));
                        answer.put("ok", 1.0);
                        reply.setFirstDoc(answer);
                        break;
                    }
                    case "ismaster": 
                    case "isMaster": 
                    case "hello": {
                        answer = this.getHelloResult().toMsg();
                        reply.setFirstDoc(answer);
                        break;
                    }
                    case "getFreeMonitoringStatus": {
                        answer = Doc.of("state", "disabled", "message", "", "url", "", "userReminder", "");
                        break;
                    }
                    case "ping": {
                        answer = Doc.of();
                        break;
                    }
                    case "getLog": {
                        if (doc.get(cmd).equals("startupWarnings")) {
                            answer = Doc.of("totalLinesWritten", (Object)0, "log", List.of(), "ok", (Object)1.0);
                            break;
                        }
                        log.warn("Unknown log " + String.valueOf(doc.get(cmd)));
                        answer = Doc.of("ok", (Object)0, "errmsg", "unknown logr");
                        break;
                    }
                    case "getParameter": {
                        if (Integer.valueOf(1).equals(doc.get("featureCompatibilityVersion"))) {
                            answer = Doc.of("version", "5.0", "ok", (Object)1.0);
                            break;
                        }
                        answer = Doc.of("ok", (Object)0, "errmsg", "no such parameter");
                        break;
                    }
                    default: {
                        try {
                            int msgid = this.drv.runCommand((GenericCommand)new GenericCommand(this.drv).fromMap((Map)doc));
                            Map<String, Object> crs = this.drv.getAnswer(msgid);
                            answer = Doc.of("ok", (Object)1.0);
                            answer.putAll(crs);
                            break;
                        }
                        catch (Exception e) {
                            answer = Doc.of("ok", (Object)0, "errmsg", "no such command: '" + cmd + "'");
                            log.warn("errror running command " + cmd, (Throwable)e);
                        }
                    }
                }
                answer.put("$clusterTime", Doc.of("clusterTime", new MongoTimestamp(System.currentTimeMillis())));
                answer.put("operationTime", new MongoTimestamp(System.currentTimeMillis()));
                reply.setFirstDoc(answer);
                out.write(reply.bytes());
                out.flush();
                log.info("Sent answer!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

