/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.Utils;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Transient;
import de.caluga.morphium.objectmapping.ObjectMapperImpl;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Embedded(translateCamelCase=false)
public class ReplicaSetStatus {
    private String set;
    private int myState;
    private String syncSourceHost;
    private Date date;
    private int term;
    private int syncSourceId;
    private long heartbeatIntervalMillis;
    private int majorityVoteCount;
    private int writeMajorityCount;
    private int votingMembersCount;
    private int writableVotingMembersCount;
    private long lastStableRecoveryTimestamp;
    private List<ReplicaSetNode> members;
    private Map<String, Object> optimes;
    private Map<String, Object> electionCandidateMetrics;
    @Transient
    private ReplicaSetConf config;

    public String getSet() {
        return this.set;
    }

    public int getMyState() {
        return this.myState;
    }

    public Date getDate() {
        return this.date;
    }

    public List<ReplicaSetNode> getMembers() {
        return this.members;
    }

    public void setMembers(List<ReplicaSetNode> members) {
        this.members = members;
    }

    public ReplicaSetConf getConfig() {
        return this.config;
    }

    public void setConfig(ReplicaSetConf config) {
        this.config = config;
    }

    public String getSyncSourceHost() {
        return this.syncSourceHost;
    }

    public int getTerm() {
        return this.term;
    }

    public int getSyncSourceId() {
        return this.syncSourceId;
    }

    public long getHeartbeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public int getMajorityVoteCount() {
        return this.majorityVoteCount;
    }

    public int getWriteMajorityCount() {
        return this.writeMajorityCount;
    }

    public int getVotingMembersCount() {
        return this.votingMembersCount;
    }

    public int getWritableVotingMembersCount() {
        return this.writableVotingMembersCount;
    }

    public long getLastStableRecoveryTimestamp() {
        return this.lastStableRecoveryTimestamp;
    }

    public Map<String, Object> getOptimes() {
        return this.optimes;
    }

    public Map<String, Object> getElectionCandidateMetrics() {
        return this.electionCandidateMetrics;
    }

    public int getActiveNodes() {
        if (this.members == null) {
            return 0;
        }
        int up = 0;
        for (ReplicaSetNode n : this.members) {
            if (n.getState() > 2) continue;
            boolean ignore = false;
            for (ConfNode c : this.config.getMembers()) {
                if (c.getId() != n.getId() || c.getHidden() == null || !c.getHidden().booleanValue()) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            ++up;
        }
        return up;
    }

    public String toString() {
        return Utils.toJsonString(new ObjectMapperImpl().serialize(this));
    }
}

