/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Collation;
import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumAccessVetoException;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Expr;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.Aliases;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.commands.CountMongoCommand;
import de.caluga.morphium.driver.commands.DistinctMongoCommand;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.FindAndModifyMongoCommand;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.GetMoreMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MongoFieldImpl;
import de.caluga.morphium.query.QueryIterator;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query<T>
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    private String where;
    private Map<String, Object> rawQuery;
    private Class<? extends T> type;
    private List<FilterExpression> andExpr;
    private List<Query<T>> orQueries;
    private List<Query<T>> norQueries;
    private ReadPreferenceLevel readPreferenceLevel;
    private boolean additionalDataPresent = false;
    private int limit = 0;
    private int skip = 0;
    private Map<String, Object> sort;
    private Morphium morphium;
    private ThreadPoolExecutor executor;
    private String collectionName;
    private String srv = null;
    private Object hint;
    private Map<String, Object> fieldList;
    private boolean autoValuesEnabled = true;
    private String tags;
    private AnnotationAndReflectionHelper arHelper;
    private String overrideDB;
    private Collation collation;
    private int batchSize = 0;
    private UtilsMap<String, UtilsMap<String, String>> additionalFields;

    public Query(Morphium m, Class<? extends T> type, ThreadPoolExecutor executor) {
        this(m);
        this.setType(type);
        this.executor = executor;
        if (m != null && m.getConfig().getDefaultTagSet() != null) {
            this.tags = m.getConfig().getDefaultTags();
        }
    }

    public Query(Morphium m) {
        this.setMorphium(m);
    }

    public Object getHint() {
        return this.hint;
    }

    public Query<T> setHintString(String h) {
        this.hint = h;
        return this;
    }

    public Query<T> setHintMap(Map<String, Object> h) {
        this.hint = h;
        return this;
    }

    public int getBatchSize() {
        if (this.batchSize == 0) {
            return this.morphium.getDriver().getDefaultBatchSize();
        }
        return this.batchSize;
    }

    public Query<T> setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public Query<T> setCollation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public String getDB() {
        if (this.overrideDB == null) {
            return this.morphium.getConfig().getDatabase();
        }
        return this.overrideDB;
    }

    public void overrideDB(String overrideDB) {
        this.overrideDB = overrideDB;
    }

    public String[] getTags() {
        if (this.tags == null) {
            return new String[0];
        }
        return this.tags.split(",");
    }

    public Query<T> addTag(String name, String value) {
        this.tags = this.tags != null ? this.tags + "," : "";
        this.tags = this.tags + name + ":" + value;
        return this;
    }

    public Query<T> disableAutoValues() {
        this.autoValuesEnabled = false;
        return this;
    }

    public Query<T> enableAutoValues() {
        this.autoValuesEnabled = true;
        return this;
    }

    public boolean isAutoValuesEnabled() {
        return this.autoValuesEnabled;
    }

    public Query<T> setAutoValuesEnabled(boolean autoValuesEnabled) {
        this.autoValuesEnabled = autoValuesEnabled;
        return this;
    }

    public String getServer() {
        return this.srv;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public Query<T> setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public Morphium getMorphium() {
        return this.morphium;
    }

    public Query<T> setMorphium(Morphium m) {
        this.morphium = m;
        this.andExpr = new ArrayList<FilterExpression>();
        this.orQueries = new ArrayList<Query<T>>();
        this.norQueries = new ArrayList<Query<T>>();
        if (m == null) {
            return this;
        }
        this.setARHelper(m.getARHelper());
        return this;
    }

    public ReadPreferenceLevel getReadPreferenceLevel() {
        return this.readPreferenceLevel;
    }

    public Query<T> setReadPreferenceLevel(ReadPreferenceLevel readPreferenceLevel) {
        this.readPreferenceLevel = readPreferenceLevel;
        return this;
    }

    public Query<T> q() {
        Query<T> q = new Query<T>(this.morphium, this.type, this.executor);
        q.setCollectionName(this.getCollectionName());
        return q;
    }

    @Deprecated
    public List<T> complexQuery(Map<String, Object> query) {
        return this.complexQuery(query, (String)null, 0, 0);
    }

    public List<T> complexQuery(Map<String, Object> query, String sort, int skip, int limit) {
        LinkedHashMap<String, Integer> srt = new LinkedHashMap<String, Integer>();
        if (sort != null) {
            String[] tok;
            for (String t : tok = sort.split(",")) {
                if (t.startsWith("-")) {
                    srt.put(t.substring(1), -1);
                    continue;
                }
                if (t.startsWith("+")) {
                    srt.put(t.substring(1), 1);
                    continue;
                }
                srt.put(t, 1);
            }
        }
        return this.complexQuery(query, srt, skip, limit);
    }

    public Map<String, Object> explain() throws MorphiumDriverException {
        return this.explain(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> explain(ExplainCommand.ExplainVerbosity verbosity) throws MorphiumDriverException {
        FindCommand cmd = null;
        try {
            cmd = this.getFindCmd();
            Map<String, Object> map = cmd.explain(verbosity);
            return map;
        }
        finally {
            if (cmd != null) {
                cmd.getConnection().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findOneAndDelete() {
        ArrayList<T> lst;
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst2 = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst2 == null || lst2.isEmpty()) {
                    return null;
                }
                this.morphium.delete(lst2.get(0));
                return lst2.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> ret = null;
        MongoConnection con = null;
        try {
            con = this.morphium.getDriver().getPrimaryConnection(null);
            FindAndModifyMongoCommand settings = (FindAndModifyMongoCommand)((FindAndModifyMongoCommand)new FindAndModifyMongoCommand(con).setQuery(this.toQueryObject()).setRemove(true).setSort(new Doc((Map<? extends String, ?>)this.getSort())).setColl(this.getCollectionName())).setDb(this.getDB());
            if (this.collation != null) {
                settings.setCollation(Doc.of(this.collation.toQueryObject()));
            }
            ret = settings.execute();
        }
        catch (MorphiumDriverException e) {
            e.printStackTrace();
        }
        finally {
            con.release();
        }
        if (ret == null) {
            lst = new ArrayList<T>(0);
            if (useCache) {
                this.morphium.getCache().addToCache(ck, this.type, lst);
            }
            return null;
        }
        lst = new ArrayList(1);
        long dur = System.currentTimeMillis() - start;
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().deserialize(this.type, ret);
            if (unmarshall != null) {
                this.morphium.firePostLoadEvent(unmarshall);
                this.updateLastAccess(unmarshall);
                lst.add(unmarshall);
                if (useCache) {
                    this.morphium.getCache().addToCache(ck, this.type, lst);
                }
            }
            return unmarshall;
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findOneAndUpdate(Map<String, Object> update) {
        ArrayList<T> lst;
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst2 = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst2 == null || lst2.isEmpty()) {
                    return null;
                }
                this.morphium.delete(lst2.get(0));
                return lst2.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> ret = null;
        MongoConnection con = null;
        try {
            con = this.morphium.getDriver().getPrimaryConnection(this.getMorphium().getWriteConcernForClass(this.getType()));
            FindAndModifyMongoCommand settings = ((FindAndModifyMongoCommand)((FindAndModifyMongoCommand)new FindAndModifyMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName())).setQuery(Doc.of(this.toQueryObject())).setUpdate(Doc.of(update));
            if (this.collation != null) {
                settings.setCollation(Doc.of(this.collation.toQueryObject()));
            }
            ret = settings.execute();
        }
        catch (MorphiumDriverException e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
        if (ret == null) {
            lst = new ArrayList<T>(0);
            if (useCache) {
                this.morphium.getCache().addToCache(ck, this.type, lst);
            }
            return null;
        }
        lst = new ArrayList(1);
        long dur = System.currentTimeMillis() - start;
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().deserialize(this.type, ret);
            if (unmarshall != null) {
                this.morphium.firePostLoadEvent(unmarshall);
                this.updateLastAccess(unmarshall);
                lst.add(unmarshall);
                if (useCache) {
                    this.morphium.getCache().addToCache(ck, this.type, lst);
                }
            }
            return unmarshall;
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    public T findOneAndUpdateEnums(Map<Enum, Object> update) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : update.entrySet()) {
            updates.put(e.getKey().name(), e.getValue());
        }
        return this.findOneAndUpdate(updates);
    }

    public AnnotationAndReflectionHelper getARHelper() {
        if (this.arHelper == null) {
            this.arHelper = this.morphium.getARHelper();
        }
        return this.arHelper;
    }

    public Query<T> setARHelper(AnnotationAndReflectionHelper ar) {
        this.arHelper = ar;
        return this;
    }

    public long complexQueryCount(Map<String, Object> query) {
        long ret = 0L;
        MongoConnection con = this.morphium.getDriver().getReadConnection(this.getRP());
        CountMongoCommand cmd = ((CountMongoCommand)((CountMongoCommand)new CountMongoCommand(con).setColl(this.collectionName)).setDb(this.getDB())).setQuery(Doc.of(query));
        Entity et = this.getARHelper().getAnnotationFromClass(this.getType(), Entity.class);
        if (et != null) {
            cmd.setReadConcern(Doc.of("level", et.readConcernLevel().name()));
        }
        try {
            ret = cmd.getCount();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            con.release();
        }
        return ret;
    }

    public Query<T> rawQuery(Map<String, Object> query) {
        if (this.orQueries != null && !this.orQueries.isEmpty() || this.norQueries != null && !this.norQueries.isEmpty() || this.andExpr != null && !this.andExpr.isEmpty() || this.where != null) {
            throw new IllegalArgumentException("Cannot add raw query, when standard query already set!");
        }
        this.rawQuery = query;
        return this;
    }

    @Deprecated
    public List<T> complexQuery(Map<String, Object> query, Map<String, Integer> sort, int skip, int limit) {
        Cache ca = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = ca != null && ca.readCache() && this.morphium.isReadCacheEnabledForThread();
        Map<String, Object> lst = this.getFieldListForQuery();
        String ck = this.morphium.getCache().getCacheKey(this.type, query, sort, lst, this.getCollectionName(), skip, limit);
        if (useCache && this.morphium.getCache().isCached(this.type, ck)) {
            return this.morphium.getCache().getFromCache(this.type, ck);
        }
        long start = System.currentTimeMillis();
        ArrayList<T> ret = new ArrayList<T>();
        List<Map<String, Object>> obj = null;
        HashMap findMetaData = new HashMap();
        FindCommand settings = this.getFindCmd();
        try {
            settings.setFilter(query).setSkip(skip).setSort(new LinkedHashMap<String, Object>(sort)).setLimit(limit);
            if (this.collation != null) {
                settings.setCollation(this.getCollation().toQueryObject());
            }
            obj = settings.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.morphium.getDriver().releaseConnection(settings.getConnection());
        }
        for (Map<String, Object> in : obj) {
            T unmarshall = this.morphium.getMapper().deserialize(this.type, in);
            if (unmarshall == null) continue;
            ret.add(unmarshall);
        }
        this.srv = (String)findMetaData.get("server");
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    public Map<String, Object> getFieldListForQuery() {
        Entity e;
        List<Field> fldlst = null;
        if (this.type != null) {
            fldlst = this.getARHelper().getAllFields(this.type);
        }
        HashMap<String, Object> lst = new HashMap<String, Object>();
        if (this.type != null && (e = this.getARHelper().getAnnotationFromHierarchy(this.type, Entity.class)).polymorph()) {
            return new HashMap<String, Object>();
        }
        lst.put("_id", 1);
        if (this.fieldList != null) {
            lst.putAll(this.fieldList);
            boolean negative = true;
            for (Object object : this.fieldList.values()) {
                if (object.equals(0)) continue;
                negative = false;
                break;
            }
            boolean positive = true;
            for (Object v : this.fieldList.values()) {
                if (!v.equals(0)) continue;
                positive = false;
                break;
            }
            if (negative && positive) {
                throw new RuntimeException("Projection cannot add _and_ remove fields!");
            }
            if (negative) {
                lst.remove("_id");
            }
        } else if (fldlst != null) {
            for (Field f : fldlst) {
                String string;
                if (f.isAnnotationPresent(AdditionalData.class)) {
                    lst = new HashMap();
                    break;
                }
                if (f.isAnnotationPresent(Aliases.class)) {
                    for (String n2 : f.getAnnotation(Aliases.class).value()) {
                        lst.put(n2, 1);
                    }
                }
                if ((string = this.getARHelper().getMongoFieldName(this.type, f.getName())).startsWith("$jacoco")) continue;
                lst.put(string, 1);
            }
        } else {
            lst = new HashMap();
        }
        return lst;
    }

    public Map<String, Object> explainDistinct(String field, ExplainCommand.ExplainVerbosity verbosity) {
        MongoConnection con = null;
        try {
            con = this.morphium.getDriver().getPrimaryConnection(null);
            DistinctMongoCommand cmd = ((DistinctMongoCommand)((DistinctMongoCommand)new DistinctMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName())).setKey(field).setQuery(Doc.of(this.toQueryObject()));
            if (this.getCollation() != null) {
                cmd.setCollation(this.getCollation().toQueryObject());
            }
            Map<String, Object> map = cmd.explain(verbosity);
            return map;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
    }

    public List<?> distinct(String field) {
        MongoConnection con = null;
        try {
            con = this.morphium.getDriver().getPrimaryConnection(null);
            DistinctMongoCommand cmd = ((DistinctMongoCommand)((DistinctMongoCommand)new DistinctMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName())).setKey(field).setQuery(Doc.of(this.toQueryObject()));
            if (this.getCollation() != null) {
                cmd.setCollation(this.getCollation().toQueryObject());
            }
            List<Object> list = cmd.execute();
            return list;
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
    }

    public T complexQueryOne(Map<String, Object> query) {
        return this.complexQueryOne(query, null, 0);
    }

    public T complexQueryOne(Map<String, Object> query, Map<String, Integer> sort, int skip) {
        List<T> ret = this.complexQuery(query, sort, skip, 1);
        if (ret != null && !ret.isEmpty()) {
            return ret.get(0);
        }
        return null;
    }

    public T complexQueryOne(Map<String, Object> query, Map<String, Integer> sort) {
        return this.complexQueryOne(query, sort, 0);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public Map<String, Object> getSort() {
        return this.sort;
    }

    public Query<T> addChild(FilterExpression ex) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add child expression when raw query is defined!");
        }
        this.andExpr.add(ex);
        return this;
    }

    public Query<T> where(String wh) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add where when raw query is defined!");
        }
        FilterExpression w = new FilterExpression();
        w.setField("$where");
        w.setValue(wh);
        this.andExpr.add(w);
        this.where = wh;
        return this;
    }

    public MongoField<T> f(Enum f) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add field query when raw query is defined!");
        }
        return this.f(f.name());
    }

    public MongoField<T> f(String ... f) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add field query when raw query is defined!");
        }
        StringBuilder b = new StringBuilder();
        for (String e : f) {
            b.append(e);
            b.append(".");
        }
        b.deleteCharAt(b.length() - 1);
        return this.f(b.toString());
    }

    public MongoField<T> f(Enum ... f) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add field query when raw query is defined!");
        }
        StringBuilder b = new StringBuilder();
        for (Enum e : f) {
            b.append(e.name());
            b.append(".");
        }
        b.deleteCharAt(b.length() - 1);
        return this.f(b.toString());
    }

    public MongoField<T> f(String f) {
        String cf;
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add field query when raw query is defined!");
        }
        StringBuilder fieldPath = new StringBuilder();
        Class<Object> clz = this.type;
        if (this.additionalDataPresent) {
            MongoFieldImpl fld = new MongoFieldImpl();
            fld.setFieldString(f);
            fld.setMapper(this.morphium.getMapper());
            fld.setQuery(this);
            log.debug("Not checking field name, additionalData is present");
            return fld;
        }
        if (f.contains(".") && !this.additionalDataPresent) {
            String[] fieldNames;
            for (String fieldName : fieldNames = f.split("\\.")) {
                String fieldNameInstance = this.getARHelper().getMongoFieldName(clz, fieldName);
                Field field = this.getARHelper().getField(clz, fieldNameInstance);
                if (field == null) {
                    log.warn("Field " + fieldNameInstance + " not found!");
                    continue;
                }
                fieldPath.append(fieldNameInstance);
                fieldPath.append('.');
                clz = field.getType();
                if (List.class.isAssignableFrom(clz) || Collection.class.isAssignableFrom(clz) || Array.class.isAssignableFrom(clz) || Set.class.isAssignableFrom(clz) || Map.class.isAssignableFrom(clz)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cannot check fields in generic lists or maps");
                    }
                    clz = Object.class;
                }
                if (clz.equals(Object.class)) break;
            }
            cf = clz.equals(Object.class) ? f : fieldPath.substring(0, fieldPath.length() - 1);
        } else {
            cf = this.getARHelper().getMongoFieldName(clz, f);
        }
        MongoFieldImpl fld = new MongoFieldImpl();
        fld.setFieldString(cf);
        fld.setMapper(this.morphium.getMapper());
        fld.setQuery(this);
        return fld;
    }

    @SafeVarargs
    public final Query<T> or(Query<T> ... qs) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add or queries when raw query is defined!");
        }
        this.orQueries.addAll(Arrays.asList(qs));
        return this;
    }

    public Query<T> or(List<Query<T>> qs) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add or queries when raw query is defined!");
        }
        this.orQueries.addAll(qs);
        return this;
    }

    private Query<T> getClone() {
        return this.clone();
    }

    @SafeVarargs
    public final Query<T> nor(Query<T> ... qs) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add nor queries when raw query is defined!");
        }
        this.norQueries.addAll(Arrays.asList(qs));
        return this;
    }

    public Query<T> limit(int i) {
        this.limit = i;
        return this;
    }

    public Query<T> skip(int i) {
        this.skip = i;
        return this;
    }

    public Query<T> sort(Map<String, Integer> n) {
        this.sort = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Integer> e : n.entrySet()) {
            this.sort.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public Query<T> sortEnum(Map<Enum, Integer> n) {
        this.sort = new HashMap<String, Object>();
        for (Map.Entry<Enum, Integer> e : n.entrySet()) {
            this.sort.put(this.morphium.getARHelper().getMongoFieldName(this.getType(), e.getKey().name()), e.getValue());
        }
        return this;
    }

    public Query<T> sort(String ... prefixedString) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] stringArray = prefixedString;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String i2;
            String fld = i2 = stringArray[i];
            int val = 1;
            if (i2.startsWith("-")) {
                fld = i2.substring(1);
                val = -1;
            } else if (i2.startsWith("+")) {
                fld = i2.substring(1);
                val = 1;
            }
            if (!fld.contains(".") && !fld.startsWith("$")) {
                fld = this.getARHelper().getMongoFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        return this.sort(m);
    }

    public Query<T> sort(Enum ... naturalOrder) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        for (Enum i : naturalOrder) {
            String fld = this.getARHelper().getMongoFieldName(this.type, i.name());
            m.put(fld, 1);
        }
        return this.sort(m);
    }

    public void countAll(AsyncOperationCallback<T> c) {
        if (c == null) {
            throw new IllegalArgumentException("Not really useful to read from db and not use the result");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                long ret = this.countAll();
                c.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, null, null, ret);
            }
            catch (Exception e) {
                c.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> explainCount(ExplainCommand.ExplainVerbosity verbosity) throws MorphiumDriverException {
        MongoCommand cmd = null;
        try {
            cmd = this.getCountCommand(this.getMorphium().getDriver().getReadConnection(this.getRP()));
            Map<String, Object> map = ((CountMongoCommand)cmd).explain(verbosity);
            return map;
        }
        finally {
            if (cmd != null && cmd.getConnection() != null) {
                cmd.getConnection().release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countAll() {
        this.morphium.inc(StatisticKeys.READS);
        long start = System.currentTimeMillis();
        long ret = 0L;
        if (this.where != null) {
            log.warn("efficient counting with $where is not possible... need to iterate!");
            int lim = this.limit;
            int sk = this.skip;
            this.skip = 0;
            this.limit = 0;
            Map<String, Object> fld = this.fieldList;
            this.fieldList = null;
            this.addProjection("_id");
            int count = 0;
            for (T elem : this.asIterable()) {
                ++count;
            }
            this.limit = lim;
            this.skip = sk;
            this.fieldList = fld;
            return count;
        }
        MongoConnection con = this.getMorphium().getDriver().getReadConnection(this.getRP());
        try {
            CountMongoCommand cmd = this.getCountCommand(con);
            ret = cmd.getCount();
        }
        catch (MorphiumDriverException e) {
            log.error("Error counting", (Throwable)e);
        }
        finally {
            con.release();
        }
        return ret;
    }

    private CountMongoCommand getCountCommand(MongoConnection con) {
        if (this.andExpr.isEmpty() && this.orQueries.isEmpty() && this.norQueries.isEmpty() && this.rawQuery == null) {
            CountMongoCommand settings = (CountMongoCommand)((CountMongoCommand)new CountMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName());
            if (this.getCollation() != null) {
                settings.setCollation(this.getCollation().toQueryObject());
            }
            return settings;
        }
        CountMongoCommand cmd = ((CountMongoCommand)((CountMongoCommand)new CountMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName())).setQuery(Doc.of(this.toQueryObject()));
        if (this.getCollation() != null) {
            cmd.setCollation(this.getCollation().toQueryObject());
        }
        return cmd;
    }

    private ReadPreference getRP() {
        if (this.readPreferenceLevel == null) {
            ReadPreference t = this.morphium.getReadPreferenceForClass(this.getType());
            return t;
        }
        switch (this.readPreferenceLevel) {
            case PRIMARY: {
                return ReadPreference.primary();
            }
            case PRIMARY_PREFERRED: {
                return ReadPreference.primaryPreferred();
            }
            case SECONDARY: {
                return ReadPreference.secondary();
            }
            case SECONDARY_PREFERRED: {
                return ReadPreference.secondaryPreferred();
            }
            case NEAREST: {
                return ReadPreference.nearest();
            }
        }
        return null;
    }

    public Map<String, Object> toQueryObject() {
        boolean onlyAnd;
        if (this.rawQuery != null) {
            return this.rawQuery;
        }
        LinkedHashMap<String, Object> o = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> lst = new ArrayList<Map<String, Object>>();
        boolean bl = onlyAnd = this.orQueries.isEmpty() && this.norQueries.isEmpty();
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.isEmpty() && onlyAnd) {
            return o;
        }
        if (!this.andExpr.isEmpty()) {
            for (FilterExpression filterExpression : this.andExpr) {
                lst.add(filterExpression.dbObject());
            }
            o.put("$and", lst);
            lst = new ArrayList();
        }
        if (!this.orQueries.isEmpty()) {
            for (Query query : this.orQueries) {
                lst.add(query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((List)o.get("$and")).add(UtilsMap.of("$or", lst));
            } else {
                o.put("$or", lst);
            }
        }
        if (!this.norQueries.isEmpty()) {
            for (Query query : this.norQueries) {
                lst.add(query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((List)o.get("$and")).add(UtilsMap.of("$nor", lst));
            } else {
                o.put("$nor", lst);
            }
        }
        return o;
    }

    public Query<T> expr(Expr exp) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add filter expression when raw query is defined!");
        }
        FilterExpression fe = new FilterExpression();
        fe.setField("$expr");
        fe.setValue(exp.toQueryObject());
        this.andExpr.add(fe);
        return this;
    }

    public Query<T> matchesJsonSchema(Map<String, Object> schemaDef) {
        if (this.rawQuery != null) {
            throw new IllegalArgumentException("Cannot add jason schema match when raw query is defined!");
        }
        FilterExpression fe = new FilterExpression();
        fe.setField("$jsonSchema");
        fe.setValue(schemaDef);
        this.andExpr.add(fe);
        return this;
    }

    public Query<T> matchesJsonSchema(String schemaDef) throws ParseException {
        JSONParser jsonParser = new JSONParser();
        Map map = (Map)jsonParser.parse(schemaDef, new ContainerFactory(){

            public Map createObjectContainer() {
                return new HashMap();
            }

            public List creatArrayContainer() {
                return new ArrayList();
            }
        });
        return this.matchesJsonSchema(map);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public Query<T> setType(Class<? extends T> type) {
        List<String> fields;
        this.type = type;
        if (this.morphium == null) {
            return this;
        }
        DefaultReadPreference pr = this.getARHelper().getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            this.setReadPreferenceLevel(pr.value());
        }
        this.additionalDataPresent = (fields = this.getARHelper().getFields(type, AdditionalData.class)) != null && !fields.isEmpty();
        return this;
    }

    public void asList(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                List<T> lst = this.asList();
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, lst, null, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    public List<Map<String, Object>> asMapList() {
        this.morphium.inc(StatisticKeys.READS);
        if (this.type != null) {
            Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
            boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
            Class<Map> type = Map.class;
            String ck = this.morphium.getCache().getCacheKey(this);
            if (useCache) {
                if (this.morphium.getCache().isCached(type, ck)) {
                    this.morphium.inc(StatisticKeys.CHITS);
                    return this.morphium.getCache().getFromCache(type, ck);
                }
                this.morphium.inc(StatisticKeys.CMISS);
            } else {
                this.morphium.inc(StatisticKeys.NO_CACHED_READS);
            }
            long start = System.currentTimeMillis();
            Map<String, Object> lst = this.getFieldListForQuery();
            List<Object> ret = new ArrayList();
            FindCommand fnd = this.getFindCmd();
            try {
                ret = fnd.execute();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                fnd.releaseConnection();
            }
            if (useCache) {
                this.morphium.getCache().addToCache(ck, type, ret);
            }
            this.morphium.firePostLoad(ret);
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Map map : ret) {
                result.add(new HashMap(map));
            }
            return result;
        }
        this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        long start = System.currentTimeMillis();
        Map<String, Object> lst = this.getFieldListForQuery();
        List<Object> ret = new ArrayList();
        FindCommand settings = this.getFindCmd();
        try {
            ret = settings.execute();
            this.srv = (String)settings.getMetaData().get("server");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            settings.releaseConnection();
        }
        return new ArrayList<Map<String, Object>>(ret);
    }

    public QueryIterator<Map<String, Object>> asMapIterable() {
        QueryIterator<Map<String, Object>> it = new QueryIterator<Map<String, Object>>();
        it.setQuery(this);
        return it;
    }

    public List<T> asList() {
        if (this.type == null) {
            return this.asMapList();
        }
        this.morphium.inc(StatisticKeys.READS);
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> lst = this.getFieldListForQuery();
        ArrayList<T> ret = new ArrayList<T>();
        ret.clear();
        FindCommand cmd = this.getFindCmd();
        try {
            Map<String, Object> queryObject = this.toQueryObject();
            if (queryObject != null) {
                cmd.setFilter(Doc.of(queryObject));
            }
            if (this.collation != null) {
                cmd.setCollation(Doc.of(this.collation.toQueryObject()));
            }
            if (this.sort != null) {
                cmd.setSort(new Doc((Map<? extends String, ?>)this.sort));
            }
            List<Map<String, Object>> query = cmd.execute();
            this.srv = (String)cmd.getMetaData().get("server");
            for (Map<String, Object> o : query) {
                T unmarshall = this.morphium.getMapper().deserialize(this.type, o);
                if (unmarshall == null) continue;
                ret.add(unmarshall);
                this.updateLastAccess(unmarshall);
                this.morphium.firePostLoadEvent(unmarshall);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (cmd != null && cmd.getConnection() != null) {
                cmd.getConnection().release();
            }
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        this.morphium.firePostLoad(ret);
        return ret;
    }

    public QueryIterator<T> asIterable() {
        QueryIterator it = new QueryIterator();
        it.setQuery(this);
        return it;
    }

    public QueryIterator<T> asIterable(int windowSize) {
        QueryIterator it = new QueryIterator();
        it.setWindowSize(windowSize);
        it.setQuery(this);
        return it;
    }

    public QueryIterator<T> asIterable(QueryIterator<T> ret) {
        try {
            ret.setQuery(this);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MorphiumCursor getCursor() throws MorphiumDriverException {
        FindCommand fnd = this.getFindCmd();
        try {
            MorphiumCursor morphiumCursor = fnd.executeIterable(this.getBatchSize());
            return morphiumCursor;
        }
        finally {
            fnd.releaseConnection();
        }
    }

    public QueryIterator<T> asIterable(int windowSize, Class<? extends QueryIterator<T>> it) {
        try {
            QueryIterator<T> ret = it.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.asIterable(ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateLastAccess(T unmarshall) {
        if (!this.autoValuesEnabled) {
            return;
        }
        if (!this.morphium.isAutoValuesEnabledForThread()) {
            return;
        }
        if (this.getARHelper().isAnnotationPresentInHierarchy(this.type, LastAccess.class)) {
            List<String> lst = this.getARHelper().getFields(this.type, LastAccess.class);
            for (String ctf : lst) {
                Field f = this.getARHelper().getField(this.type, ctf);
                if (f == null) continue;
                MongoConnection con = null;
                try {
                    con = this.getMorphium().getDriver().getPrimaryConnection(this.morphium.getWriteConcernForClass(this.getType()));
                    long currentTime = System.currentTimeMillis();
                    if (f.getType().equals(Date.class)) {
                        f.set(unmarshall, new Date());
                    } else if (f.getType().equals(String.class)) {
                        LastAccess ctField = f.getAnnotation(LastAccess.class);
                        SimpleDateFormat df = new SimpleDateFormat(ctField.dateFormat());
                        f.set(unmarshall, df.format(currentTime));
                    } else {
                        f.set(unmarshall, currentTime);
                    }
                    Object id = this.getARHelper().getId(unmarshall);
                    UpdateMongoCommand settings = ((UpdateMongoCommand)((UpdateMongoCommand)new UpdateMongoCommand(con).setDb(this.getDB())).setColl(this.getCollectionName())).setUpdates(Arrays.asList(Doc.of("q", Doc.of("_id", id), "u", Doc.of("$set", Doc.of(ctf, (Object)currentTime)), "multi", (Object)false, "collation", this.collation != null ? Doc.of(this.collation.toQueryObject()) : null)));
                    settings.execute();
                }
                catch (Exception e) {
                    log.error("Could not set modification time");
                    throw new RuntimeException(e);
                }
                finally {
                    if (con != null) {
                        con.release();
                    }
                }
            }
        }
    }

    @Deprecated
    public void getById(Object id, AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable c = () -> {
            long start = System.currentTimeMillis();
            try {
                T res = this.getById(id);
                ArrayList<T> result = new ArrayList<T>();
                result.add(res);
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, result, res, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(c);
    }

    @Deprecated
    public T getById(Object id) {
        List<String> flds = this.getARHelper().getFields(this.type, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new RuntimeException("Type does not have an ID-Field? " + this.type.getSimpleName());
        }
        String f = flds.get(0);
        Query<T> q = this.q().f(f).eq(id);
        return q.get();
    }

    public void get(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                ArrayList<T> ret = new ArrayList<T>();
                T ent = this.get();
                ret.add(ent);
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, ret, ent, new Object[0]);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    public T get() {
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst == null || lst.isEmpty()) {
                    return null;
                }
                return lst.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        Map<String, Object> fl = this.getFieldListForQuery();
        HashMap findMetaData = new HashMap();
        List<Map<String, Object>> srch = null;
        int lim = this.getLimit();
        this.limit(1);
        FindCommand settings = null;
        try {
            settings = this.getFindCmd();
            srch = settings.execute();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            settings.getConnection().release();
        }
        this.limit(lim);
        if (srch.isEmpty()) {
            ArrayList lst = new ArrayList(0);
            if (useCache) {
                this.morphium.getCache().addToCache(ck, this.type, lst);
            }
            return null;
        }
        Map<String, Object> ret = srch.get(0);
        this.srv = (String)findMetaData.get("server");
        ArrayList<T> lst = new ArrayList<T>(1);
        long dur = System.currentTimeMillis() - start;
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().deserialize(this.type, ret);
            if (unmarshall != null) {
                this.morphium.firePostLoadEvent(unmarshall);
                this.updateLastAccess(unmarshall);
                lst.add(unmarshall);
                if (useCache) {
                    this.morphium.getCache().addToCache(ck, this.type, lst);
                }
            }
            return unmarshall;
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    public void idList(AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callable is null?");
        }
        Runnable r = () -> {
            long start = System.currentTimeMillis();
            try {
                List ret = this.idList();
                callback.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, null, null, ret);
            }
            catch (Exception e) {
                callback.onOperationError(AsyncOperationType.READ, this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
            }
        };
        this.getExecutor().submit(r);
    }

    public <R> List<R> idList() {
        List<Map<String, Object>> query;
        Cache c = this.getARHelper().getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache() && this.morphium.isReadCacheEnabledForThread();
        Object ck = this.morphium.getCache().getCacheKey(this);
        ck = (String)ck + " idlist";
        this.morphium.inc(StatisticKeys.READS);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, (String)ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, (String)ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        FindCommand settings = null;
        try {
            settings = this.getFindCmd();
            settings.setProjection(Doc.of("_id", (Object)1));
            query = settings.execute();
            this.srv = (String)settings.getMetaData().get("server");
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (settings != null) {
                settings.getConnection().release();
            }
        }
        List ret = query.stream().map(o -> o.get("_id")).collect(Collectors.toList());
        long dur = System.currentTimeMillis() - start;
        if (useCache) {
            this.morphium.getCache().addToCache((String)ck, this.type, ret);
        }
        return ret;
    }

    public Query<T> clone() {
        try {
            Query ret = (Query)super.clone();
            if (this.andExpr != null) {
                ret.andExpr = new ArrayList<FilterExpression>();
                ret.andExpr.addAll(this.andExpr);
            }
            if (this.norQueries != null) {
                ret.norQueries = new ArrayList<Query<T>>();
                ret.norQueries.addAll(this.norQueries);
            }
            if (this.sort != null) {
                ret.sort = new LinkedHashMap<String, Object>();
                ret.sort.putAll(this.sort);
            }
            if (this.orQueries != null) {
                ret.orQueries = new ArrayList<Query<T>>();
                ret.orQueries.addAll(this.orQueries);
            }
            if (this.readPreferenceLevel != null) {
                ret.readPreferenceLevel = this.readPreferenceLevel;
            }
            if (this.where != null) {
                ret.where = this.where;
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> remove() {
        return this.morphium.remove(this);
    }

    public Map<String, Object> delete() {
        return this.morphium.delete(this);
    }

    public Map<String, Object> set(String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> set(Enum field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> setEnum(Map<Enum, Object> map, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : map.entrySet()) {
            m.put(e.getKey().name(), e.getValue());
        }
        return this.set(m, upsert, multiple, cb);
    }

    public Map<String, Object> set(Map<String, Object> map, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, map, upsert, multiple, cb);
    }

    public Map<String, Object> set(String field, Object value, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, field, value, cb);
    }

    public Map<String, Object> set(Enum field, Object value, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, field, value, cb);
    }

    public Map<String, Object> setEnum(Map<Enum, Object> map, AsyncOperationCallback<T> cb) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : map.entrySet()) {
            m.put(e.getKey().name(), e.getValue());
        }
        return this.set(m, false, false, cb);
    }

    public Map<String, Object> set(Map<String, Object> map, AsyncOperationCallback<T> cb) {
        return this.morphium.set(this, map, false, false, cb);
    }

    public Map<String, Object> set(String field, Object value, boolean upsert, boolean multiple) {
        return this.morphium.set(this, field, value, upsert, multiple);
    }

    public Map<String, Object> set(Enum field, Object value, boolean upsert, boolean multiple) {
        return this.morphium.set(this, field, value, upsert, multiple);
    }

    public Map<String, Object> setEnum(Map<Enum, Object> map, boolean upsert, boolean multiple) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : map.entrySet()) {
            m.put(e.getKey().name(), e.getValue());
        }
        return this.set(m, upsert, multiple, null);
    }

    public Map<String, Object> set(Map<String, Object> map, boolean upsert, boolean multiple) {
        return this.morphium.set(this, map, upsert, multiple);
    }

    public Map<String, Object> set(String field, Object value) {
        return this.morphium.set(this, field, value);
    }

    public Map<String, Object> set(Enum field, Object value) {
        return this.morphium.set(this, field, value);
    }

    public Map<String, Object> setEnum(Map<Enum, Object> map) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Map.Entry<Enum, Object> e : map.entrySet()) {
            m.put(e.getKey().name(), e.getValue());
        }
        return this.set(m, false, false, null);
    }

    public Map<String, Object> set(Map<String, Object> map) {
        return this.morphium.set(this, map, false, false);
    }

    public Map<String, Object> unset(boolean multiple, Enum ... field) {
        return this.morphium.unsetQ(this, multiple, field);
    }

    public Map<String, Object> unset(boolean multiple, String ... field) {
        return this.morphium.unsetQ(this, multiple, field);
    }

    public Map<String, Object> unset(Enum ... fields) {
        return this.morphium.unsetQ(this, fields);
    }

    public Map<String, Object> unset(String ... fields) {
        return this.morphium.unsetQ(this, fields);
    }

    public Map<String, Object> push(String field, Object value) {
        return this.morphium.push(this, field, value);
    }

    public Map<String, Object> push(Enum field, Object value) {
        return this.morphium.push(this, field, value);
    }

    public Map<String, Object> push(String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.push(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> push(Enum field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.push(this, field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> pushAll(String field, List value) {
        return this.morphium.pushAll(this, field, value, false, false);
    }

    public Map<String, Object> pushAll(Enum field, List value) {
        return this.morphium.pushAll(this, field.name(), value, false, false);
    }

    public Map<String, Object> pushAll(String field, List value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pushAll(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> pushAll(Enum field, List value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pushAll(this, field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> pullAll(String field, List value) {
        return this.morphium.pullAll(this, field, (List<Object>)value, false, false);
    }

    public Map<String, Object> pullAll(Enum field, List value) {
        return this.morphium.pullAll(this, field.name(), (List<Object>)value, false, false);
    }

    public Map<String, Object> pullAll(String field, List value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pullAll(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> pullAll(Enum field, List value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pullAll(this, field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> pull(String field, Object value) {
        return this.morphium.pull(this, field, value);
    }

    public Map<String, Object> pull(Enum field, Object value) {
        return this.morphium.pull(this, field, value);
    }

    public Map<String, Object> pull(String field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pull(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> pull(Enum field, Object value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pull(this, field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> pull(Enum field, Expr value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.pull(this, field.name(), value.toQueryObject(), upsert, multiple, cb);
    }

    public Map<String, Object> pull(Enum field, Expr value, boolean upsert, boolean multiple) {
        return this.pull(field, value, upsert, multiple, null);
    }

    public Map<String, Object> pull(Enum field, Expr value) {
        return this.pull(field, value, false, false, null);
    }

    public Map<String, Object> inc(String field, Integer value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(String field, Integer value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(Enum field, Integer value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(String field, Integer value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(Enum field, Integer value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(String field, Double value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(String field, Double value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(Enum field, Double value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(String field, Double value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(Enum field, Double value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(Enum field, Number value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.inc(field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(Enum field, Integer value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.inc(field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(Enum field, Double value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.inc(field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(Enum field, Long value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.inc(field.name(), value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(String field, Long value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(String field, Long value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(Enum field, Long value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> inc(String field, Long value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(Enum field, Long value) {
        return this.morphium.inc(this, field, (Number)value);
    }

    public Map<String, Object> inc(String field, Number value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.inc(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> inc(String field, Number value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, value, upsert, multiple);
    }

    public Map<String, Object> inc(Enum field, Number value, boolean upsert, boolean multiple) {
        return this.morphium.inc(this, field, value, upsert, multiple);
    }

    public Map<String, Object> inc(String field, Number value) {
        return this.morphium.inc(this, field, value);
    }

    public Map<String, Object> inc(Enum field, Number value) {
        return this.morphium.inc(this, field, value);
    }

    public Map<String, Object> dec(String field, Integer value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(Enum field, Integer value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(String field, Integer value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(Enum field, Integer value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(Enum field, Integer value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(String field, Integer value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(Enum field, Double value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(String field, Double value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(Enum field, Long value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(String field, Long value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(Enum field, Number value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(String field, Number value, boolean upsert, boolean multiple, AsyncOperationCallback<T> cb) {
        return this.morphium.dec(this, field, value, upsert, multiple, cb);
    }

    public Map<String, Object> dec(String field, Double value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(Enum field, Double value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(String field, Double value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(Enum field, Double value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(String field, Long value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(Enum field, Long value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, (Number)value, upsert, multiple);
    }

    public Map<String, Object> dec(String field, Long value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(Enum field, Long value) {
        return this.morphium.dec(this, field, (Number)value);
    }

    public Map<String, Object> dec(String field, Number value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, value, upsert, multiple);
    }

    public Map<String, Object> dec(Enum field, Number value, boolean upsert, boolean multiple) {
        return this.morphium.dec(this, field, value, upsert, multiple);
    }

    public Map<String, Object> dec(String field, Number value) {
        return this.morphium.dec(this, field, value);
    }

    public Map<String, Object> dec(Enum field, Number value) {
        return this.morphium.dec(this, field, value);
    }

    public int getNumberOfPendingRequests() {
        return this.getExecutor().getActiveCount();
    }

    public String getCollectionName() {
        if (this.collectionName == null) {
            this.collectionName = this.morphium.getMapper().getCollectionName(this.type);
        }
        return this.collectionName;
    }

    public Query<T> setCollectionName(String n) {
        this.collectionName = n;
        return this;
    }

    public Query<T> text(String ... text) {
        return this.text((String)null, (TextSearchLanguages)null, text);
    }

    public Query<T> text(TextSearchLanguages lang, String ... text) {
        return this.text(null, lang, text);
    }

    public Query<T> text(TextSearchLanguages lang, boolean caseSensitive, boolean diacriticSensitive, String ... text) {
        return this.text(null, lang, caseSensitive, diacriticSensitive, text);
    }

    public Query<T> text(String metaScoreField, TextSearchLanguages lang, boolean caseSensitive, boolean diacriticSensitive, String ... text) {
        FilterExpression f = new FilterExpression();
        f.setField("$text");
        StringBuilder b = new StringBuilder();
        for (String t : text) {
            b.append(t);
            b.append(" ");
        }
        UtilsMap<String, String> srch = UtilsMap.of("$search", b.toString());
        srch.put("$caseSensitive", (String)((Object)Boolean.valueOf(caseSensitive)));
        srch.put("$diacriticSensitive", (String)((Object)Boolean.valueOf(diacriticSensitive)));
        f.setValue(srch);
        if (lang != null) {
            ((Map)f.getValue()).put("$language", lang.toString());
        }
        this.addChild(f);
        if (metaScoreField != null) {
            this.additionalFields = UtilsMap.of(metaScoreField, UtilsMap.of("$meta", "textScore"));
        }
        return this;
    }

    public Query<T> text(String metaScoreField, TextSearchLanguages lang, String ... text) {
        return this.text(metaScoreField, lang, true, true, text);
    }

    @Deprecated
    public List<T> textSearch(String ... texts) {
        return this.textSearch(TextSearchLanguages.mongo_default, texts);
    }

    @Deprecated
    public List<T> textSearch(TextSearchLanguages lang, String ... texts) {
        if (texts.length == 0) {
            return new ArrayList();
        }
        HashMap<String, Object> txt = new HashMap<String, Object>();
        txt.put("text", this.getCollectionName());
        StringBuilder b = new StringBuilder();
        for (String t : texts) {
            b.append(t);
            b.append(" ");
        }
        txt.put("search", b.toString());
        txt.put("filter", this.toQueryObject());
        if (this.getLimit() > 0) {
            txt.put("limit", this.limit);
        }
        if (!lang.equals((Object)TextSearchLanguages.mongo_default)) {
            txt.put("language", lang.name());
        }
        Map<String, Object> result = null;
        try {
            GenericCommand cmd = new GenericCommand(this.morphium.getDriver().getPrimaryConnection(null));
            cmd.setDb(this.getDB());
            cmd.setCmdData(Doc.of(txt));
            result = cmd.getConnection().readSingleAnswer(cmd.executeAsync());
            cmd.getConnection().release();
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
        List lst = (List)result.get("results");
        ArrayList<T> ret = new ArrayList<T>();
        for (Object o : lst) {
            Map obj = (Map)o;
            T unmarshall = this.morphium.getMapper().deserialize(this.getType(), obj);
            if (unmarshall == null) continue;
            ret.add(unmarshall);
        }
        return ret;
    }

    public Query<T> setProjection(Enum ... fl) {
        for (Enum f : fl) {
            this.addProjection(f);
        }
        return this;
    }

    public Query<T> setProjection(String ... fl) {
        this.fieldList = new LinkedHashMap<String, Object>();
        for (String f : fl) {
            this.addProjection(f);
        }
        return this;
    }

    public Query<T> addProjection(Enum f, String projectOperator) {
        this.addProjection(f.name(), projectOperator);
        return this;
    }

    public Query<T> addProjection(Enum f) {
        this.addProjection(f.name());
        return this;
    }

    public Query<T> addProjection(String f) {
        if (this.fieldList == null) {
            this.fieldList = new LinkedHashMap<String, Object>();
        }
        int v = 1;
        if (f.startsWith("-")) {
            f = f.substring(1);
            v = 0;
        }
        String n = this.getARHelper().getMongoFieldName(this.type, f);
        this.fieldList.put(n, v);
        return this;
    }

    public Query<T> addProjection(String f, String projectOperator) {
        if (this.fieldList == null) {
            this.fieldList = new LinkedHashMap<String, Object>();
        }
        String n = this.getARHelper().getMongoFieldName(this.type, f);
        this.fieldList.put(n, projectOperator);
        return this;
    }

    public Query<T> hideFieldInProjection(String f) {
        if (this.fieldList == null || this.fieldList.isEmpty()) {
            this.fieldList = new LinkedHashMap<String, Object>();
        }
        this.fieldList.put(this.getARHelper().getMongoFieldName(this.type, f), 0);
        return this;
    }

    public void tail(int batchSize, int maxWait, AsyncOperationCallback<T> cb) {
        MongoConnection con = this.morphium.getDriver().getReadConnection(this.morphium.getReadPreferenceForClass(this.type));
        boolean running = true;
        if (maxWait == 0) {
            maxWait = Integer.MAX_VALUE;
        }
        try {
            FindCommand cmd = (FindCommand)((FindCommand)new FindCommand(con).setTailable(true).setFilter(this.toQueryObject()).setSort(this.getSort()).setHint(this.hint).setLimit(this.getLimit()).setBatchSize(batchSize).setMaxTimeMS(maxWait).setDb(this.morphium.getDatabase())).setColl(this.getCollectionName());
            if (this.collation != null) {
                cmd.setCollation(this.collation.toQueryObject());
            }
            long start = System.currentTimeMillis();
            int msgId = cmd.executeAsync();
            long cursorId = 0L;
            while (running) {
                OpMsg answer = con.getReplyFor(msgId, maxWait);
                List batch = null;
                Map cursor = (Map)answer.getFirstDoc().get("cursor");
                if (cursor == null) {
                    log.warn("No cursor in result");
                    break;
                }
                batch = cursor.containsKey("firstBatch") ? (ArrayList)cursor.get("firstBatch") : (cursor.containsKey("nextBatch") ? (List)cursor.get("nextBatch") : new ArrayList());
                for (Map doc : batch) {
                    try {
                        cb.onOperationSucceeded(AsyncOperationType.READ, this, System.currentTimeMillis() - start, null, this.morphium.getMapper().deserialize(this.type, doc), new Object[0]);
                    }
                    catch (MorphiumAccessVetoException ex) {
                        running = false;
                        break;
                    }
                }
                cursorId = ((Number)cursor.get("id")).longValue();
                GetMoreMongoCommand more = ((GetMoreMongoCommand)((GetMoreMongoCommand)new GetMoreMongoCommand(con).setBatchSize(batchSize).setColl(this.getCollectionName())).setDb(cmd.getDb())).setCursorId(cursorId);
                msgId = more.executeAsync();
            }
            if (cursorId != 0L) {
                KillCursorsCommand kill = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(con).setCursorIds(cursorId).setColl(cmd.getColl())).setDb(cmd.getDb());
                kill.execute();
            }
            log.debug("Tail ended!");
        }
        catch (Exception e) {
            throw new RuntimeException("Error running command", e);
        }
        finally {
            con.release();
        }
    }

    public Query<T> hideFieldInProjection(Enum f) {
        return this.hideFieldInProjection(f.name());
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var4_12;
        StringBuilder and = new StringBuilder();
        if (this.andExpr != null && !this.andExpr.isEmpty()) {
            and.append("[");
            for (FilterExpression filterExpression : this.andExpr) {
                and.append(filterExpression.toString());
                and.append(", ");
            }
            and.deleteCharAt(and.length() - 1);
            and.deleteCharAt(and.length() - 1);
            and.append(" ]");
        }
        StringBuilder ors = new StringBuilder();
        if (this.orQueries != null && !this.orQueries.isEmpty()) {
            ors.append("[ ");
            for (Query<T> query : this.orQueries) {
                ors.append(query.toString());
                ors.append(", ");
            }
            ors.deleteCharAt(ors.length() - 1);
            ors.deleteCharAt(ors.length() - 1);
            ors.append(" ]");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.norQueries != null && !this.norQueries.isEmpty()) {
            stringBuilder.append("[ ");
            for (Query<T> query : this.norQueries) {
                stringBuilder.append(query.toString());
                stringBuilder.append(", ");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(" ]");
        }
        String string = "Query{ collectionName='" + this.collectionName + "', type=" + this.type.getName() + ", skip=" + this.skip + ", limit=" + this.limit + ", andExpr=" + String.valueOf(and) + ", orQueries=" + String.valueOf(ors) + ", norQueries=" + String.valueOf(stringBuilder) + ", sort=" + String.valueOf(this.sort) + ", readPreferenceLevel=" + String.valueOf((Object)this.readPreferenceLevel) + ", additionalDataPresent=" + this.additionalDataPresent + ", where='" + this.where + "'}";
        if (this.fieldList != null) {
            String string2 = string + " Fields " + String.valueOf(this.fieldList);
        }
        return var4_12;
    }

    public FindCommand getFindCmd() {
        MongoConnection con = this.getMorphium().getDriver().getReadConnection(this.getRP());
        FindCommand settings = (FindCommand)((FindCommand)((FindCommand)new FindCommand(con).setDb(this.getMorphium().getConfig().getDatabase())).setColl(this.getCollectionName())).setFilter(this.toQueryObject()).setSort(this.getSort()).setProjection(this.getFieldListForQuery()).setSkip(this.getSkip()).setLimit(this.getLimit()).setHint(this.hint).setReadPreference(this.getMorphium().getReadPreferenceForClass(this.getType()));
        settings.setBatchSize(this.getBatchSize());
        return settings;
    }

    public static Logger getLog() {
        return log;
    }

    public Query<T> setWhere(String where) {
        this.where = where;
        return this;
    }

    public Map<String, Object> getRawQuery() {
        return this.rawQuery;
    }

    public Query<T> setRawQuery(Map<String, Object> rawQuery) {
        this.rawQuery = rawQuery;
        return this;
    }

    public List<FilterExpression> getAndExpr() {
        return this.andExpr;
    }

    public Query<T> setAndExpr(List<FilterExpression> andExpr) {
        this.andExpr = andExpr;
        return this;
    }

    public List<Query<T>> getOrQueries() {
        return this.orQueries;
    }

    public Query<T> setOrQueries(List<Query<T>> orQueries) {
        this.orQueries = orQueries;
        return this;
    }

    public List<Query<T>> getNorQueries() {
        return this.norQueries;
    }

    public Query<T> setNorQueries(List<Query<T>> norQueries) {
        this.norQueries = norQueries;
        return this;
    }

    public boolean isAdditionalDataPresent() {
        return this.additionalDataPresent;
    }

    public Query<T> setAdditionalDataPresent(boolean additionalDataPresent) {
        this.additionalDataPresent = additionalDataPresent;
        return this;
    }

    public Query<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Query<T> setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public Query<T> setSort(Map<String, Object> sort) {
        this.sort = sort;
        return this;
    }

    public String getSrv() {
        return this.srv;
    }

    public Query<T> setSrv(String srv) {
        this.srv = srv;
        return this;
    }

    public Map<String, Object> getFieldList() {
        return this.fieldList;
    }

    public Query<T> setFieldList(Map<String, Object> fieldList) {
        this.fieldList = fieldList;
        return this;
    }

    public Query<T> setTags(String tags) {
        this.tags = tags;
        return this;
    }

    public AnnotationAndReflectionHelper getArHelper() {
        return this.arHelper;
    }

    public Query<T> setArHelper(AnnotationAndReflectionHelper arHelper) {
        this.arHelper = arHelper;
        return this;
    }

    public String getOverrideDB() {
        return this.overrideDB;
    }

    public Query<T> setOverrideDB(String overrideDB) {
        this.overrideDB = overrideDB;
        return this;
    }

    public UtilsMap<String, UtilsMap<String, String>> getAdditionalFields() {
        return this.additionalFields;
    }

    public Query<T> setAdditionalFields(UtilsMap<String, UtilsMap<String, String>> additionalFields) {
        this.additionalFields = additionalFields;
        return this;
    }

    public static enum TextSearchLanguages {
        danish,
        dutch,
        english,
        finnish,
        french,
        german,
        hungarian,
        italian,
        norwegian,
        portuguese,
        romanian,
        russian,
        spanish,
        swedish,
        turkish,
        mongo_default,
        none;

    }
}

