/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.Msg;
import java.util.HashMap;

public class StatusInfoListener
implements MessageListener<Msg> {
    public static final String messagingThreadpoolstatsKey = "messaging_threadpoolstats";
    public static final String messageListenersbyNameKey = "message_listeners_by_name";
    public static final String globalListenersKey = "global_listeners";
    public static final String morphiumCachestatsKey = "morphium.cachestats";
    public static final String morphiumConfigKey = "morphium.config";

    @Override
    public Msg onMessage(Messaging msg, Msg m) {
        if (m.isAnswer()) {
            return null;
        }
        Msg answer = m.createAnswerMsg();
        answer.setMapValue(new HashMap<String, Object>());
        StatusInfoLevel level = StatusInfoLevel.MESSAGING_ONLY;
        if (m.getValue() != null) {
            for (StatusInfoLevel l : StatusInfoLevel.values()) {
                if (!l.name().equals(m.getValue())) continue;
                level = StatusInfoLevel.valueOf(m.getValue());
                break;
            }
        }
        if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MESSAGING_ONLY)) {
            if (msg.isMultithreadded()) {
                answer.getMapValue().put(messagingThreadpoolstatsKey, msg.getThreadPoolStats());
            }
            answer.getMapValue().put(messageListenersbyNameKey, msg.getListenerNames());
            answer.getMapValue().put(globalListenersKey, msg.getGlobalListeners());
        }
        if (level.equals((Object)StatusInfoLevel.ALL) || level.equals((Object)StatusInfoLevel.MORPHIUM_ONLY)) {
            answer.getMapValue().put(morphiumCachestatsKey, msg.getMorphium().getStatistics());
            answer.getMapValue().put(morphiumConfigKey, msg.getMorphium().getConfig().asProperties());
        }
        return answer;
    }

    @Override
    public boolean markAsProcessedBeforeExec() {
        return true;
    }

    public static enum StatusInfoLevel {
        ALL,
        MESSAGING_ONLY,
        MORPHIUM_ONLY,
        PING;

    }
}

