/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.messaging.Msg;
import java.util.Date;

@Entity
@DefaultReadPreference(value=ReadPreferenceLevel.PRIMARY)
public class MsgLock {
    @Id
    private MorphiumId id;
    @Index(value={"expireAfterSeconds:0"})
    private Date deleteAt;
    @Index
    private String lockId;

    public MsgLock(Msg m) {
        this.id = m.getMsgId();
        if (m.isTimingOut()) {
            this.deleteAt = new Date(System.currentTimeMillis() + m.getTtl());
        }
    }

    public MsgLock(MorphiumId id, Date deleteAt) {
        this.id = id;
        this.deleteAt = deleteAt;
    }

    public MsgLock(MorphiumId id) {
        this.id = id;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public MorphiumId getId() {
        return this.id;
    }

    public void setId(MorphiumId id) {
        this.id = id;
    }

    public Date getDeleteAt() {
        return this.deleteAt;
    }

    public void setDeleteAt(Date deleteAt) {
        this.deleteAt = deleteAt;
    }

    public static enum Fields {
        id,
        deleteAt,
        lockId;

    }
}

