/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging;

import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.Index;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.SafetyLevel;
import de.caluga.morphium.annotations.WriteSafety;
import de.caluga.morphium.annotations.caching.NoCache;
import de.caluga.morphium.annotations.lifecycle.Lifecycle;
import de.caluga.morphium.annotations.lifecycle.PreStore;
import de.caluga.morphium.driver.MorphiumId;
import de.caluga.morphium.messaging.Messaging;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.LoggerFactory;

@Entity(polymorph=true, typeId="msg")
@NoCache
@WriteSafety(level=SafetyLevel.MAJORITY)
@DefaultReadPreference(value=ReadPreferenceLevel.PRIMARY)
@Lifecycle
@Index(value={"sender,processed_by,in_answer_to", "sender,processed_by", "msgId,sender,processed_by,name,priority,timestamp", "msgId,processed_by,name", "processed_by,priority,timestamp"})
public class Msg {
    @Index
    private List<String> processedBy;
    @Id
    private MorphiumId msgId;
    @Index
    private long ttl;
    private String sender;
    private String senderHost;
    private List<String> recipients;
    private MorphiumId inAnswerTo;
    @Index
    private String name;
    private String msg;
    private List<Object> additional;
    private Map<String, Object> mapValue;
    private String value;
    @Index
    private long timestamp;
    @Index(options={"expireAfterSeconds:0"})
    private Date deleteAt;
    private boolean timingOut = true;
    private boolean deleteAfterProcessing = false;
    private int deleteAfterProcessingTime = 0;
    private int priority = 1000;
    private Boolean exclusive = false;

    public Msg() {
    }

    public Msg(String name, String msg, String value) {
        this(name, msg, value, 30000L, false);
    }

    public Msg(String name, String msg, String value, long ttl) {
        this(name, msg, value, ttl, false);
    }

    public Msg(String name, String msg, String value, long ttl, boolean exclusive) {
        this();
        this.name = name;
        this.msg = msg;
        this.value = value;
        this.ttl = ttl;
        this.setExclusive(exclusive);
    }

    public boolean isTimingOut() {
        return this.timingOut;
    }

    public Msg setTimingOut(boolean tm) {
        this.timingOut = tm;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public Msg setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getDeleteAfterProcessingTime() {
        return this.deleteAfterProcessingTime;
    }

    public Msg setDeleteAfterProcessingTime(int deleteAfterProcessingTime) {
        this.deleteAfterProcessingTime = deleteAfterProcessingTime;
        return this;
    }

    public boolean isDeleteAfterProcessing() {
        return this.deleteAfterProcessing;
    }

    public Msg setDeleteAfterProcessing(boolean deleteAfterProcessing) {
        this.deleteAfterProcessing = deleteAfterProcessing;
        return this;
    }

    public boolean isExclusive() {
        if (this.exclusive == null) {
            return false;
        }
        return this.exclusive;
    }

    public Msg setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public String getSenderHost() {
        return this.senderHost;
    }

    public Msg setSenderHost(String senderHost) {
        this.senderHost = senderHost;
        return this;
    }

    public Date getDeleteAt() {
        return this.deleteAt;
    }

    public Msg setDeleteAt(Date deleteAt) {
        this.deleteAt = deleteAt;
        return this;
    }

    public Msg addRecipient(String id) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<String>();
        }
        if (!this.recipients.contains(id)) {
            this.recipients.add(id);
        }
        return this;
    }

    public Msg removeRecipient(String id) {
        if (this.recipients != null) {
            this.recipients.remove(id);
        }
        return this;
    }

    public Msg addValue(String key, Object value) {
        if (this.mapValue == null) {
            this.mapValue = new HashMap<String, Object>();
        }
        this.mapValue.put(key, value);
        return this;
    }

    public Msg removeValue(String key) {
        if (this.mapValue == null) {
            return this;
        }
        this.mapValue.remove(key);
        return this;
    }

    public Map<String, Object> getMapValue() {
        return this.mapValue;
    }

    public Msg setMapValue(Map<String, Object> mapValue) {
        this.mapValue = mapValue;
        return this;
    }

    public List<String> getTo() {
        return this.recipients;
    }

    public Msg setTo(List<String> to) {
        this.recipients = to;
        return this;
    }

    public MorphiumId getInAnswerTo() {
        return this.inAnswerTo;
    }

    public Msg setInAnswerTo(MorphiumId inAnswerTo) {
        this.inAnswerTo = inAnswerTo;
        return this;
    }

    public MorphiumId getMsgId() {
        return this.msgId;
    }

    public Msg setMsgId(MorphiumId msgId) {
        this.msgId = msgId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Msg setName(String name) {
        this.name = name;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Msg setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public List<String> getProcessedBy() {
        if (this.processedBy == null) {
            this.processedBy = new ArrayList<String>();
        }
        return this.processedBy;
    }

    public Msg setProcessedBy(List<String> processedBy) {
        this.processedBy = processedBy;
        return this;
    }

    public Msg addProcessedId(String id) {
        this.getProcessedBy().add(id);
        return this;
    }

    public String getSender() {
        return this.sender;
    }

    public Msg setSender(String sender) {
        this.sender = sender;
        return this;
    }

    public long getTtl() {
        return this.ttl;
    }

    public Msg setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public Msg setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public List<Object> getAdditional() {
        return this.additional;
    }

    public void setAdditional(List<Object> additional) {
        this.additional = additional;
    }

    public void addAdditional(String value) {
        if (this.additional == null) {
            this.additional = new ArrayList<Object>();
        }
        this.additional.add(value);
    }

    public void removeAdditional(String value) {
        if (this.additional == null) {
            return;
        }
        this.additional.remove(value);
    }

    public String getValue() {
        return this.value;
    }

    public Msg setValue(String value) {
        this.value = value;
        return this;
    }

    public String toString() {
        return "Msg{ msgId='" + String.valueOf(this.msgId) + "', inAnswerTo='" + String.valueOf(this.inAnswerTo) + "', exclusive='" + this.exclusive + "', ttl=" + this.ttl + ", sender='" + this.sender + "', name='" + this.name + "', msg='" + this.msg + "', value='" + this.value + "', timestamp=" + this.timestamp + ", additional='" + String.valueOf(this.additional) + "', mapValue='" + String.valueOf(this.mapValue) + "', recipient='" + String.valueOf(this.recipients) + "', processedBy=" + String.valueOf(this.processedBy) + "}";
    }

    @PreStore
    public void preStore() {
        if (this.sender == null) {
            throw new RuntimeException("Cannot send msg anonymously - set Sender first!");
        }
        if (this.name == null) {
            throw new RuntimeException("Cannot send a message without name!");
        }
        if (this.timingOut) {
            if (this.ttl == 0L) {
                LoggerFactory.getLogger(Msg.class).debug("Defaulting msg ttl to 30sec");
                this.ttl = 30000L;
            }
            if (this.deleteAt == null) {
                this.deleteAt = new Date(System.currentTimeMillis() + this.ttl);
            }
        } else {
            this.deleteAt = null;
            this.ttl = 0L;
        }
        if (!this.timingOut && !this.deleteAfterProcessing) {
            LoggerFactory.getLogger(Msg.class).warn("This message will never be deleted! this is not recommended!");
        }
        if (this.getProcessedBy().size() == 0) {
            this.processedBy = null;
        }
        this.timestamp = System.currentTimeMillis();
    }

    public boolean isAnswer() {
        return this.inAnswerTo != null;
    }

    public Msg createAnswerMsg() {
        Msg ret = new Msg(this.name, this.msg, this.value, this.ttl);
        ret.setInAnswerTo(this.msgId);
        ret.addRecipient(this.sender);
        ret.setPriority(this.priority);
        return ret;
    }

    public void sendAnswer(Messaging messaging, Msg m) {
        m.setInAnswerTo(this.msgId);
        m.addRecipient(this.getSender());
        m.setDeleteAt(new Date(System.currentTimeMillis() + m.getTtl()));
        m.setMsgId(new MorphiumId());
        messaging.sendMessage(m);
    }

    public Msg setRecipient(String id) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<String>();
        }
        this.recipients.clear();
        this.recipients.add(id);
        return this;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Msg)) {
            return false;
        }
        Msg msg = (Msg)o;
        return Objects.equals(this.getMsgId(), msg.getMsgId());
    }

    public int hashCode() {
        return Objects.hash(this.getMsgId());
    }

    public static enum Fields {
        msgId,
        exclusive,
        ttl,
        sender,
        senderHost,
        recipients,
        to,
        inAnswerTo,
        name,
        msg,
        additional,
        mapValue,
        value,
        timestamp,
        deleteAt,
        priority,
        processedBy;

    }
}

