/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.SingleBatchCursor;
import de.caluga.morphium.driver.SingleElementCursor;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.commands.auth.SaslAuthCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.SingleMongoConnectionCursor;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMongoConnection
implements MongoConnection {
    private final Logger log = LoggerFactory.getLogger(SingleMongoConnection.class);
    private Socket s;
    private OutputStream out;
    private InputStream in;
    private AtomicInteger msgId = new AtomicInteger(1000);
    private Thread readerThread = null;
    private Map<Integer, OpMsg> incoming = new HashMap<Integer, OpMsg>();
    private Map<Integer, Long> incomingTimes = new ConcurrentHashMap<Integer, Long>();
    private boolean running = true;
    private Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
    private String connectedTo;
    private int connectedToPort;
    private boolean connected;
    private MorphiumDriver driver;
    private String authDb = null;
    private String user = null;
    private String password = null;

    public SingleMongoConnection() {
        this.stats.put(MorphiumDriver.DriverStatsKey.MSG_SENT, new AtomicDecimal(0));
        this.stats.put(MorphiumDriver.DriverStatsKey.REPLY_PROCESSED, new AtomicDecimal(0));
        this.stats.put(MorphiumDriver.DriverStatsKey.REPLY_RECEIVED, new AtomicDecimal(0));
    }

    @Override
    public void setCredentials(String authDb, String userName, String password) {
        this.authDb = authDb;
        this.user = userName;
        this.password = password;
    }

    @Override
    public HelloResult connect(MorphiumDriver drv, String host, int port) throws MorphiumDriverException {
        this.driver = drv;
        try {
            this.s = new Socket(host, port);
            this.s.setKeepAlive(true);
            this.out = this.s.getOutputStream();
            this.in = this.s.getInputStream();
        }
        catch (IOException e) {
            throw new MorphiumDriverException("Connection failed: " + host + ":" + port, e);
        }
        this.startReaderThread();
        HelloCommand cmd = new HelloCommand(null);
        if (this.authDb != null) {
            cmd.setAuthDb(this.authDb);
            cmd.setUser(this.user);
        }
        cmd.setLoadBalanced(true);
        OpMsg msg = new OpMsg();
        msg.setMessageId(this.msgId.incrementAndGet());
        msg.setFirstDoc(cmd.asMap());
        OpMsg result = this.sendAndWaitForReply(msg);
        Map<String, Object> firstDoc = result.getFirstDoc();
        HelloResult hello = HelloResult.fromMsg(firstDoc);
        if (this.authDb != null) {
            SaslAuthCommand auth = new SaslAuthCommand(this);
            auth.setDb("admin");
            if (hello.getSaslSupportedMechs() == null || hello.getSaslSupportedMechs().isEmpty()) {
                throw new MorphiumDriverException("Authentication failed - no mechanisms offered!");
            }
            ((SaslAuthCommand)auth.setUser(this.user).setDb(this.authDb)).setPassword(this.password);
            if (hello.getSaslSupportedMechs().contains("SCRAM-SHA-256")) {
                auth.setMechanism("SCRAM-SHA-256");
            } else {
                auth.setMechanism("SCRAM-SHA-1");
            }
            try {
                auth.execute();
            }
            catch (Exception e) {
                throw new MorphiumDriverException("Error Authenticating", e);
            }
        }
        this.connectedTo = host;
        this.connectedToPort = port;
        this.connected = true;
        return hello;
    }

    @Override
    public MorphiumDriver getDriver() {
        return this.driver;
    }

    public SingleMongoConnection setDriver(MorphiumDriver d) {
        this.driver = d;
        return this;
    }

    public Map<MorphiumDriver.DriverStatsKey, Double> getStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> ret = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal> s = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>(this.stats);
        for (Map.Entry<MorphiumDriver.DriverStatsKey, AtomicDecimal> e : s.entrySet()) {
            ret.put(e.getKey(), e.getValue().get());
        }
        ret.put(MorphiumDriver.DriverStatsKey.THREADS_CREATED, 1.0);
        ret.put(MorphiumDriver.DriverStatsKey.REPLY_IN_MEM, Double.valueOf(this.incoming.size()));
        return ret;
    }

    @Override
    public String getConnectedTo() {
        return this.connectedTo + ":" + this.connectedToPort;
    }

    @Override
    public String getConnectedToHost() {
        return this.connectedTo;
    }

    @Override
    public int getConnectedToPort() {
        return this.connectedToPort;
    }

    @Override
    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    @Override
    public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return null;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(this).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
        this.log.debug("killed cursor");
        return ret;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private void startReaderThread() {
        this.running = true;
        this.readerThread = new Thread(() -> {
            while (true) {
                if (!this.running) {
                    Map<Integer, OpMsg> map = this.incoming;
                    synchronized (map) {
                        this.incoming.notifyAll();
                        return;
                    }
                }
                try {
                    if (!this.s.isConnected() || this.s.isClosed()) {
                        this.log.error("Connection died!");
                        this.close();
                        return;
                    }
                    if (this.in.available() > 0) {
                        OpMsg msg = (OpMsg)WireProtocolMessage.parseFromStream(this.in);
                        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_RECEIVED).incrementAndGet();
                        this.incoming.put(msg.getResponseTo(), msg);
                        Map<Integer, OpMsg> map = this.incomingTimes;
                        synchronized (map) {
                            this.incomingTimes.put(msg.getResponseTo(), System.currentTimeMillis());
                        }
                        map = this.incoming;
                        synchronized (map) {
                            this.incoming.notifyAll();
                        }
                    }
                    HashSet<Integer> s = new HashSet<Integer>(this.incomingTimes.keySet());
                    for (Integer k : s) {
                        Map<Integer, Long> map = this.incomingTimes;
                        synchronized (map) {
                            if (this.incomingTimes.get(k) == null) {
                                continue;
                            }
                            if (System.currentTimeMillis() - this.incomingTimes.get(k) > (long)this.getDriver().getMaxWaitTime()) {
                                this.incoming.remove(k);
                                this.incomingTimes.remove(k);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log.error("Reader-Thread error", (Throwable)e);
                }
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        this.readerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.running = false;
        Map<Integer, OpMsg> map = this.incoming;
        synchronized (map) {
            this.incoming.notifyAll();
        }
        while (this.readerThread.isAlive()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.connected = false;
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.s != null) {
                this.s.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.s = null;
    }

    @Override
    public void release() {
        this.driver.releaseConnection(this);
    }

    @Override
    public boolean replyAvailableFor(int msgId) {
        return this.incoming.containsKey(msgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpMsg getReplyFor(int msgid, long timeout) throws MorphiumDriverException {
        Map<Integer, Object> map;
        long start = System.currentTimeMillis();
        while (!this.incoming.containsKey(msgid)) {
            try {
                map = this.incoming;
                synchronized (map) {
                    this.incoming.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.running) {
                return null;
            }
            if (System.currentTimeMillis() - start <= 2L * timeout) continue;
            throw new MorphiumDriverException("server did not answer in time: " + timeout + "ms");
        }
        map = this.incomingTimes;
        synchronized (map) {
            this.incomingTimes.remove(msgid);
        }
        if (!this.incoming.containsKey(msgid)) {
            this.log.warn("Did not get reply within " + timeout + "ms");
        }
        this.stats.get((Object)MorphiumDriver.DriverStatsKey.REPLY_PROCESSED).incrementAndGet();
        return this.incoming.remove(msgid);
    }

    public void sendQuery(OpMsg q) throws MorphiumDriverException {
        if (this.driver.getTransactionContext() != null) {
            q.getFirstDoc().put("lsid", Doc.of("id", this.driver.getTransactionContext().getLsid()));
            q.getFirstDoc().put("txnNumber", this.driver.getTransactionContext().getTxnNumber());
            if (!this.driver.getTransactionContext().isStarted()) {
                q.getFirstDoc().put("startTransaction", true);
                this.driver.getTransactionContext().setStarted(true);
            }
            q.getFirstDoc().putIfAbsent("autocommit", this.driver.getTransactionContext().getAutoCommit());
            q.getFirstDoc().remove("writeConcern");
        }
        try {
            if (this.out == null) {
                this.close();
                throw new MorphiumDriverException("closed");
            }
            this.stats.get((Object)MorphiumDriver.DriverStatsKey.MSG_SENT).incrementAndGet();
            this.out.write(q.bytes());
            this.out.flush();
        }
        catch (MorphiumDriverException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new MorphiumDriverException("Error sending Request: ", e);
        }
    }

    public OpMsg sendAndWaitForReply(OpMsg q) throws MorphiumDriverException {
        this.sendQuery(q);
        return this.getReplyFor(q.getMessageId(), this.driver.getMaxWaitTime());
    }

    @Override
    public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
        OpMsg reply = this.getReplyFor(id, this.driver.getMaxWaitTime());
        if (reply == null) {
            return null;
        }
        if (reply.hasCursor()) {
            return this.getSingleDocAndKillCursor(reply);
        }
        if (reply.getFirstDoc().get("ok").equals(0.0)) {
            throw new MorphiumDriverException((String)reply.getFirstDoc().get("errmsg"));
        }
        return reply.getFirstDoc();
    }

    @Override
    public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
        OpMsg q = new OpMsg();
        q.setMessageId(this.msgId.incrementAndGet());
        q.setFirstDoc(Doc.of(cmd.asMap()));
        this.sendQuery(q);
        return q.getMessageId();
    }

    @Override
    public int getSourcePort() {
        if (this.s == null) {
            return 0;
        }
        return this.s.getLocalPort();
    }

    @Override
    public void watch(WatchCommand command) throws MorphiumDriverException {
        String coll;
        long cursorId;
        int maxWait = command.getMaxTimeMS();
        if (command.getDb() == null) {
            command.setDb("1");
        }
        if (command.getMaxTimeMS() == null || command.getMaxTimeMS() <= 0) {
            maxWait = this.driver.getReadTimeout();
        }
        OpMsg startMsg = new OpMsg();
        int batchSize = command.getBatchSize() == null ? this.driver.getDefaultBatchSize() : command.getBatchSize().intValue();
        startMsg.setMessageId(this.msgId.incrementAndGet());
        startMsg.setFirstDoc(command.asMap());
        long start = System.currentTimeMillis();
        this.sendQuery(startMsg);
        OpMsg msg = startMsg;
        command.setMetaData("server", this.getConnectedTo());
        long docsProcessed = 0L;
        while (true) {
            OpMsg reply = null;
            try {
                reply = this.getReplyFor(msg.getMessageId(), command.getMaxTimeMS().intValue());
            }
            catch (MorphiumDriverException e) {
                if (e.getMessage().contains("server did not answer in time: ")) {
                    this.log.debug("timeout in watch - restarting");
                    msg.setMessageId(this.msgId.incrementAndGet());
                    this.sendQuery(msg);
                    continue;
                }
                throw e;
            }
            this.checkForError(reply);
            Map cursor = (Map)reply.getFirstDoc().get("cursor");
            if (cursor == null) {
                throw new MorphiumDriverException("Could not watch - cursor is null");
            }
            cursorId = Long.parseLong(cursor.get("id").toString());
            command.setMetaData("cursor", cursorId);
            List result = (List)cursor.get("firstBatch");
            if (result == null) {
                result = (List)cursor.get("nextBatch");
            }
            if (result != null && !result.isEmpty()) {
                for (Map o : result) {
                    command.getCb().incomingData(o, System.currentTimeMillis() - start);
                    ++docsProcessed;
                }
            }
            if (!command.getCb().isContinued()) {
                coll = command.getColl();
                if (coll == null) {
                    coll = "1";
                }
                break;
            }
            if (cursorId != 0L) {
                msg = new OpMsg();
                msg.setMessageId(this.msgId.incrementAndGet());
                String[] ns = cursor.get("ns").toString().split("\\.");
                String db = ns[0];
                Object col = ns[1];
                if (ns.length > 2) {
                    for (int i = 2; i < ns.length; ++i) {
                        col = (String)col + "." + ns[i];
                    }
                }
                Doc doc = new Doc();
                doc.put("getMore", cursorId);
                doc.put("collection", col);
                doc.put("batchSize", batchSize);
                doc.put("maxTimeMS", maxWait);
                doc.put("$db", db);
                msg.setFirstDoc(doc);
                this.sendQuery(msg);
                continue;
            }
            this.log.debug("Cursor exhausted, restarting");
            msg = startMsg;
            msg.setMessageId(this.msgId.incrementAndGet());
            this.sendQuery(msg);
        }
        this.killCursors(command.getDb(), coll, cursorId);
        command.setMetaData("duration", System.currentTimeMillis() - start);
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
        return this.readAnswerFor(this.getAnswerFor(queryId, this.driver.getDefaultBatchSize()));
    }

    @Override
    public MorphiumCursor getAnswerFor(int queryId, int batchSize) throws MorphiumDriverException {
        OpMsg reply = this.getReplyFor(queryId, this.driver.getMaxWaitTime());
        this.checkForError(reply);
        if (reply == null) {
            return new SingleBatchCursor(List.of());
        }
        if (reply.hasCursor()) {
            return new SingleMongoConnectionCursor(this, batchSize, true, reply).setServer(this.connectedTo);
        }
        if (reply.getFirstDoc().containsKey("results")) {
            return new SingleBatchCursor((List)reply.getFirstDoc().get("results"));
        }
        return new SingleElementCursor(reply.getFirstDoc());
    }

    private void checkForError(OpMsg msg) throws MorphiumDriverException {
        if (msg == null || msg.getFirstDoc() == null) {
            return;
        }
        if (msg.getFirstDoc().containsKey("ok") && !msg.getFirstDoc().get("ok").equals(1.0)) {
            throw new MorphiumDriverException("Error: " + String.valueOf(msg.getFirstDoc().get("code")) + " - " + String.valueOf(msg.getFirstDoc().get("errmsg")));
        }
    }

    @Override
    public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        while (crs.hasNext()) {
            ret.addAll(crs.getBatch());
            crs.ahead(crs.getBatch().size());
        }
        return ret;
    }

    private Map<String, Object> getSingleDocAndKillCursor(OpMsg msg) throws MorphiumDriverException {
        if (!msg.hasCursor()) {
            return null;
        }
        Map cursor = (Map)msg.getFirstDoc().get("cursor");
        Map ret = null;
        ret = cursor.containsKey("firstBatch") ? (Map)cursor.get("firstBatch") : (Map)cursor.get("nextBatch");
        String[] namespace = cursor.get("ns").toString().split("\\.");
        this.killCursors(namespace[0], namespace[1], (Long)cursor.get("id"));
        return ret;
    }
}

