/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateCommand
extends MongoCommand<CreateCommand> {
    private Boolean capped;
    private Map<String, String> timeseries;
    private Integer expireAfterSeconds;
    private Integer size;
    private Integer max;
    private Map<String, Object> storageEngine;
    private Map<String, Object> validator;
    private String validationLevel;
    private String validationAction;
    private Map<String, Object> indexOptionDefaults;
    private String viewOn;
    private List<Map<String, Object>> pipeline;
    private Map<String, Object> collation;
    private Map<String, Object> writeConcern;

    public CreateCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public String getCommandName() {
        return "create";
    }

    public Boolean getCapped() {
        return this.capped;
    }

    public CreateCommand setCapped(Boolean capped) {
        this.capped = capped;
        return this;
    }

    public Map<String, String> getTimeseries() {
        return this.timeseries;
    }

    public CreateCommand setTimeseries(Map<String, String> timeseries) {
        this.timeseries = timeseries;
        return this;
    }

    public CreateCommand setTimeseriesTimeField(String field) {
        if (this.timeseries == null) {
            this.timeseries = new HashMap<String, String>();
        }
        this.timeseries.put("timeField", field);
        return this;
    }

    public CreateCommand setTimeseriesMetaField(String field) {
        if (this.timeseries == null) {
            this.timeseries = new HashMap<String, String>();
        }
        this.timeseries.put("metaField", field);
        return this;
    }

    public CreateCommand setTimeseriesGranularity(Granularity g) {
        if (this.timeseries == null) {
            this.timeseries = new HashMap<String, String>();
        }
        this.timeseries.put("granularity", g.name());
        return this;
    }

    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public CreateCommand setExpireAfterSeconds(Integer expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public CreateCommand setSize(Integer size) {
        this.size = size;
        return this;
    }

    public Integer getMax() {
        return this.max;
    }

    public CreateCommand setMax(Integer max) {
        this.max = max;
        return this;
    }

    public Map<String, Object> getStorageEngine() {
        return this.storageEngine;
    }

    public CreateCommand setStorageEngine(Map<String, Object> storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public Map<String, Object> getValidator() {
        return this.validator;
    }

    public CreateCommand setValidator(Map<String, Object> validator) {
        this.validator = validator;
        return this;
    }

    public String getValidationLevel() {
        return this.validationLevel;
    }

    public CreateCommand setValidationLevel(String validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public String getValidationAction() {
        return this.validationAction;
    }

    public CreateCommand setValidationAction(String validationAction) {
        this.validationAction = validationAction;
        return this;
    }

    public Map<String, Object> getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCommand setIndexOptionDefaults(Map<String, Object> indexOptionDefaults) {
        this.indexOptionDefaults = indexOptionDefaults;
        return this;
    }

    public String getViewOn() {
        return this.viewOn;
    }

    public CreateCommand setViewOn(String viewOn) {
        this.viewOn = viewOn;
        return this;
    }

    public List<Map<String, Object>> getPipeline() {
        return this.pipeline;
    }

    public CreateCommand setPipeline(List<Map<String, Object>> pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public Map<String, Object> getCollation() {
        return this.collation;
    }

    public CreateCommand setCollation(Map<String, Object> collation) {
        this.collation = collation;
        return this;
    }

    public Map<String, Object> getWriteConcern() {
        return this.writeConcern;
    }

    public CreateCommand setWriteConcern(Map<String, Object> writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public Map<String, Object> execute() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        this.setMetaData("server", connection.getConnectedTo());
        long start = System.currentTimeMillis();
        int msg = connection.sendCommand(this);
        MorphiumCursor crs = connection.getAnswerFor(msg, connection.getDriver().getDefaultBatchSize());
        long dur = System.currentTimeMillis() - start;
        this.setMetaData("duration", dur);
        return crs.next();
    }

    public static enum Granularity {
        seconds,
        minutes,
        hours;

    }
}

