/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.ExplainCommand;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.SingleResultCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.Map;

public class CountMongoCommand
extends MongoCommand<CountMongoCommand>
implements SingleResultCommand {
    private Map<String, Object> query;
    private Integer limit;
    private Integer skip;
    private Object hint;
    private Map<String, Object> readConcern;
    private Map<String, Object> collation;

    public CountMongoCommand(MongoConnection d) {
        super(d);
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public CountMongoCommand setQuery(Map<String, Object> query) {
        this.query = query;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public CountMongoCommand setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public CountMongoCommand setSkip(Integer skip) {
        this.skip = skip;
        return this;
    }

    public Object getHint() {
        return this.hint;
    }

    public CountMongoCommand setHint(Object hint) {
        this.hint = hint;
        return this;
    }

    public Map<String, Object> getReadConcern() {
        return this.readConcern;
    }

    public CountMongoCommand setReadConcern(Map<String, Object> readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    public Map<String, Object> getCollation() {
        return this.collation;
    }

    public CountMongoCommand setCollation(Map<String, Object> collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public String getCommandName() {
        return "count";
    }

    public Map<String, Object> explain() throws MorphiumDriverException {
        return this.explain(null);
    }

    public Map<String, Object> explain(ExplainCommand.ExplainVerbosity verbosity) throws MorphiumDriverException {
        ExplainCommand explainCommand = new ExplainCommand(this.getConnection());
        explainCommand.setVerbosity(verbosity);
        Map<String, Object> m = this.asMap();
        m.remove("$db");
        m.remove("coll");
        explainCommand.setCommand(m);
        ((ExplainCommand)explainCommand.setDb(this.getDb())).setColl(this.getColl());
        int msg = explainCommand.executeAsync();
        return explainCommand.getConnection().readSingleAnswer(msg);
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        if (this.getConnection().getDriver().isTransactionInProgress()) {
            FindCommand fs = new FindCommand(this.getConnection());
            fs.setMetaData(this.getMetaData());
            fs.setDb(this.getDb());
            fs.setColl(this.getColl());
            fs.setFilter(this.getQuery());
            fs.setProjection(Doc.of("_id", (Object)1));
            fs.setCollation(this.getCollation());
            return Doc.of("n", (Object)fs.execute().size());
        }
        int id = this.executeAsync();
        return this.getConnection().readSingleAnswer(id);
    }

    public int getCount() throws MorphiumDriverException {
        Map<String, Object> ret = this.execute();
        if (ret == null) {
            return 0;
        }
        return (Integer)ret.get("n");
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        if (this.getConnection().getDriver().isTransactionInProgress()) {
            throw new MorphiumDriverException("Count during transaction is not allowed");
        }
        return super.executeAsync();
    }
}

