/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.SingleResultCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import java.util.Map;

public abstract class AdminMongoCommand<T extends MongoCommand>
extends MongoCommand<T>
implements SingleResultCommand {
    public AdminMongoCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> m = super.asMap();
        m.put("$db", "admin");
        return m;
    }

    @Override
    public Map<String, Object> execute() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        this.setMetaData("server", connection.getConnectedTo());
        long start = System.currentTimeMillis();
        int msg = connection.sendCommand(this);
        Map<String, Object> crs = connection.readSingleAnswer(msg);
        long dur = System.currentTimeMillis() - start;
        this.setMetaData("duration", dur);
        return crs;
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        MongoConnection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException("you need to set the connection!");
        }
        return (Integer)new NetworkCallHelper().doCall(() -> {
            this.setMetaData("server", connection.getConnectedTo());
            int id = connection.sendCommand(this);
            this.setMetaData("duration", 0);
            return id;
        }, connection.getDriver().getRetriesOnNetworkError(), connection.getDriver().getSleepBetweenErrorRetries());
    }
}

