/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Sequence;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.query.Query;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator {
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);
    private int inc;
    private long startValue;
    private Morphium morphium;
    private String id;
    private String name;

    public SequenceGenerator(Morphium m, String n) {
        this(m, n, 1, 1L);
    }

    public SequenceGenerator(Morphium mrph, String name, int inc, long startValue) {
        this.inc = inc;
        if (inc == 0) {
            throw new IllegalArgumentException("Cannot use increment value 0!");
        }
        this.name = name;
        this.startValue = startValue;
        this.morphium = mrph;
        this.id = UUID.randomUUID().toString();
        try {
            if (!this.morphium.getDriver().exists(this.morphium.getConfig().getDatabase(), this.morphium.getMapper().getCollectionName(Sequence.class)) || this.morphium.createQueryFor(Sequence.class).f("_id").eq(name).countAll() == 0L) {
                if (log.isDebugEnabled()) {
                    log.debug("Sequence does not exist yet... inserting");
                }
                Sequence s = new Sequence();
                s.setCurrentValue(startValue - (long)inc);
                s.setName(name);
                this.morphium.ensureIndicesFor(Sequence.class);
                this.morphium.storeNoCache(s);
            }
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    public long getCurrentValue() {
        Sequence s = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name).get();
        if (s == null || s.getCurrentValue() == null) {
            return this.getNextValue();
        }
        return s.getCurrentValue();
    }

    public long getNextValue() {
        long start = System.currentTimeMillis();
        Sequence.SeqLock lock = new Sequence.SeqLock();
        lock.setName(this.name);
        lock.setLockedAt(new Date());
        lock.setLockedBy(this.id);
        while (true) {
            if (System.currentTimeMillis() - start > 30000L) {
                throw new RuntimeException(String.format("Getting lock on seqence %s failed!", this.name));
            }
            try {
                this.morphium.insert(lock);
            }
            catch (Exception e) {
                try {
                    Thread.sleep((long)(100.0 * Math.random() + 10.0));
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        Query<Sequence> seq = this.morphium.createQueryFor(Sequence.class).f("_id").eq(this.name);
        Sequence val = seq.get();
        this.morphium.inc((Object)val, "current_value", this.inc);
        this.morphium.delete(lock);
        return val.getCurrentValue();
    }

    public int getInc() {
        return this.inc;
    }

    public void setInc(int inc) {
        this.inc = inc;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Morphium getMorphium() {
        return this.morphium;
    }

    public void setMorphium(Morphium morphium) {
        this.morphium = morphium;
    }
}

