/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.messaging.MessageListener;
import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.jms.JMSMessage;
import de.caluga.morphium.messaging.jms.JMSQueue;
import de.caluga.morphium.messaging.jms.JMSTopic;
import java.util.Stack;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer
implements JMSConsumer,
MessageListener<JMSMessage> {
    private final String selector;
    private final Messaging messaging;
    private javax.jms.MessageListener listener;
    private final Stack<JMSMessage> incomingQueue;
    private final Logger log;

    public Consumer(Messaging messaging, Destination dst) {
        block4: {
            this.incomingQueue = new Stack();
            this.log = LoggerFactory.getLogger(Consumer.class);
            this.messaging = messaging;
            try {
                if (dst instanceof JMSTopic) {
                    this.selector = ((JMSTopic)dst).getTopicName();
                    break block4;
                }
                if (dst instanceof JMSQueue) {
                    this.selector = ((JMSQueue)dst).getQueueName();
                    break block4;
                }
                throw new IllegalArgumentException("Wrong type of destination");
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        messaging.addListenerForMessageNamed(this.selector, this);
    }

    public String getMessageSelector() {
        return this.selector;
    }

    public javax.jms.MessageListener getMessageListener() throws JMSRuntimeException {
        return this.listener;
    }

    public void setMessageListener(javax.jms.MessageListener listener) throws JMSRuntimeException {
        this.listener = listener;
    }

    public Message receive() {
        return this.receive(0L);
    }

    public Message receive(long timeout) {
        if (this.getMessageListener() != null) {
            throw new RuntimeException("calling synchronous receive not allowed when async listener is set");
        }
        long start = System.currentTimeMillis();
        while (this.incomingQueue.size() == 0) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (timeout <= 0L || System.currentTimeMillis() - start <= timeout) continue;
            this.log.warn("Did not receive message in time!");
            return null;
        }
        JMSMessage msg = this.incomingQueue.pop();
        this.ack(msg);
        return msg;
    }

    public Message receiveNoWait() {
        return this.receive(1L);
    }

    public void close() {
        this.messaging.removeListenerForMessageNamed(this.selector, this);
    }

    public <T> T receiveBody(Class<T> c) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public <T> T receiveBody(Class<T> c, long timeout) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    public <T> T receiveBodyNoWait(Class<T> c) {
        throw new IllegalArgumentException("not implemented yet, sorry");
    }

    @Override
    public JMSMessage onMessage(Messaging msg, JMSMessage m) throws InterruptedException {
        this.log.info("Incoming message...");
        if (this.getMessageListener() != null) {
            this.getMessageListener().onMessage((Message)m);
        }
        this.incomingQueue.push(m);
        return this.getAckMessage(m);
    }

    private JMSMessage getAckMessage(JMSMessage m) {
        JMSMessage ans = new JMSMessage();
        ans.setName("ack");
        ans.setInAnswerTo(m.getMsgId());
        ans.setMsg("ack");
        ans.addRecipient(m.getSender());
        return ans;
    }

    private void ack(JMSMessage m) {
        this.log.info("Sending ack...");
        this.messaging.sendMessage(this.getAckMessage(m));
    }
}

