/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wireprotocol;

import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpKillCursors
extends WireProtocolMessage {
    private List<Long> cursorIds;

    public List<Long> getCursorIds() {
        return this.cursorIds;
    }

    public void setCursorIds(List<Long> cursorIds) {
        this.cursorIds = cursorIds;
    }

    public void addCursorId(Long id) {
        if (this.cursorIds == null) {
            this.cursorIds = new ArrayList<Long>();
        }
        this.cursorIds.add(id);
    }

    @Override
    public void parsePayload(byte[] bytes, int offset) throws IOException {
        int zero = OpKillCursors.readInt(bytes, offset);
        assert (zero == 0);
        int numberOfIds = OpKillCursors.readInt(bytes, offset + 4);
        int idx = offset + 8;
        for (int i = 0; i < numberOfIds; ++i) {
            this.addCursorId(OpKillCursors.readLong(bytes, idx));
            idx += 8;
        }
    }

    @Override
    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(0, out);
        this.writeInt(this.cursorIds.size(), out);
        for (Long id : this.cursorIds) {
            OpKillCursors.writeLong(id, out);
        }
        return out.toByteArray();
    }

    @Override
    public int getOpCode() {
        return WireProtocolMessage.OpCode.OP_KILL_CURSORS.opCode;
    }
}

