/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands;

import de.caluga.morphium.IndexDescription;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.commands.WriteMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateIndexesCommand
extends WriteMongoCommand<CreateIndexesCommand> {
    private List<Map<String, Object>> indexes;
    private String commitQuorum;

    public CreateIndexesCommand(MongoConnection d) {
        super(d);
    }

    @Override
    public String getCommandName() {
        return "createIndexes";
    }

    public List<Map<String, Object>> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<Map<String, Object>>();
        }
        return this.indexes;
    }

    public CreateIndexesCommand setIndexes(List<Map<String, Object>> indexes) {
        this.indexes = indexes;
        return this;
    }

    public CreateIndexesCommand addIndex(Map<String, Object> index, Map<String, Object> options) {
        Doc idx = Doc.of("key", index);
        if (options != null) {
            idx.putAll(options);
        }
        if (!idx.containsKey("name")) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Object> s : index.entrySet()) {
                b.append(s.getKey());
                b.append("_" + s.getValue());
            }
            idx.put("name", b.toString());
        }
        this.getIndexes().add(idx);
        return this;
    }

    public String getCommitQuorum() {
        return this.commitQuorum;
    }

    public CreateIndexesCommand setCommitQuorum(String commitQuorum) {
        this.commitQuorum = commitQuorum;
        return this;
    }

    public CreateIndexesCommand addIndex(IndexDescription idx) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<Map<String, Object>>();
        }
        this.indexes.add(idx.asMap());
        return this;
    }
}

