/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.messaging.jms;

import de.caluga.morphium.messaging.Messaging;
import de.caluga.morphium.messaging.jms.JMSMessage;
import de.caluga.morphium.messaging.jms.JMSQueue;
import de.caluga.morphium.messaging.jms.JMSTextMessage;
import de.caluga.morphium.messaging.jms.JMSTopic;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer
implements JMSProducer {
    private final Messaging messaging;
    private final Map<String, Object> properties;
    private long ttl = 30000L;
    private int priority = 500;
    private int deliveryMode;
    private boolean disableTimestamp;
    private boolean disableId;
    private final Vector<Object> waitingForAck;
    private CompletionListener completionListener;
    private final Logger log = LoggerFactory.getLogger(Producer.class);

    public Producer(Messaging messaging) {
        this.messaging = messaging;
        messaging.start();
        this.properties = new ConcurrentHashMap<String, Object>();
        this.waitingForAck = new Vector();
        messaging.addListenerForMessageNamed("ack", (msg, m) -> {
            if (this.waitingForAck.contains(m.getInAnswerTo())) {
                this.completionListener.onCompletion((Message)m);
                this.waitingForAck.remove(m.getInAnswerTo());
            } else if (m.getInAnswerTo() == null) {
                this.log.debug("Got broadcasted ack-Message?!?!?");
            } else {
                this.log.debug("Got answer for an unknown yet message " + String.valueOf(m.getInAnswerTo()));
            }
            return null;
        });
    }

    public JMSProducer send(Destination destination, Message message) {
        JMSMessage jmsMessage;
        block10: {
            if (!(message instanceof JMSMessage)) {
                throw new IllegalArgumentException("Invalid message type!");
            }
            jmsMessage = null;
            try {
                jmsMessage = (JMSMessage)message;
                jmsMessage.setPriority(this.priority);
                jmsMessage.setTtl(this.ttl);
                if (destination instanceof JMSTopic) {
                    jmsMessage.setExclusive(true);
                    jmsMessage.setName(((JMSTopic)destination).getTopicName());
                    break block10;
                }
                if (destination instanceof JMSQueue) {
                    jmsMessage.setExclusive(false);
                    jmsMessage.setName(((JMSQueue)destination).getQueueName());
                    break block10;
                }
                throw new IllegalArgumentException("Destination has invalid type!");
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAsync() != null) {
            this.messaging.sendMessage(jmsMessage);
            this.waitingForAck.add(jmsMessage.getMsgId());
        } else {
            try {
                this.messaging.sendAndAwaitFirstAnswer(jmsMessage, 8000L);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message " + String.valueOf(jmsMessage.getMsgId()) + " acknowledged");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("message " + String.valueOf(jmsMessage.getMsgId()) + " was not acknowledged", e);
            }
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        try {
            JMSTextMessage txt = new JMSTextMessage();
            txt.setText(body);
            for (String k : this.properties.keySet()) {
                txt.setObjectProperty(k, this.properties.get(k));
            }
            this.send(destination, txt);
        }
        catch (JMSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        return this;
    }

    public JMSProducer send(Destination destination, byte[] body) {
        return this;
    }

    public JMSProducer send(Destination destination, Serializable body) {
        return this;
    }

    public JMSProducer setDisableMessageID(boolean value) {
        this.disableId = value;
        return this;
    }

    public boolean getDisableMessageID() {
        return this.disableId;
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        this.disableTimestamp = value;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableTimestamp;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
        return this;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public JMSProducer setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.ttl = timeToLive;
        return this;
    }

    public long getTimeToLive() {
        return this.ttl;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        return this;
    }

    public long getDeliveryDelay() {
        return 0L;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, byte value) {
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        return this;
    }

    public JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        this.properties.containsKey(name);
        return false;
    }

    public boolean getBooleanProperty(String name) {
        return false;
    }

    public byte getByteProperty(String name) {
        return 0;
    }

    public short getShortProperty(String name) {
        return 0;
    }

    public int getIntProperty(String name) {
        return 0;
    }

    public long getLongProperty(String name) {
        return 0L;
    }

    public float getFloatProperty(String name) {
        return 0.0f;
    }

    public double getDoubleProperty(String name) {
        return 0.0;
    }

    public String getStringProperty(String name) {
        return null;
    }

    public Object getObjectProperty(String name) {
        return null;
    }

    public Set<String> getPropertyNames() {
        return null;
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.messaging.setSenderId(new String(correlationID));
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        return this.messaging.getSenderId().getBytes();
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.messaging.setSenderId(correlationID);
        return this;
    }

    public String getJMSCorrelationID() {
        return this.messaging.getSenderId();
    }

    public JMSProducer setJMSType(String type) {
        return this;
    }

    public String getJMSType() {
        return null;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        return this;
    }

    public Destination getJMSReplyTo() {
        return null;
    }
}

