/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.encryption;

import de.caluga.morphium.encryption.ValueEncryptionProvider;
import de.caluga.rsa.RSA;
import java.util.Base64;

public class RSAEncryptionProvider
implements ValueEncryptionProvider {
    private byte[] encKey;
    private byte[] decKey;

    @Override
    public void setEncryptionKey(byte[] key) {
        this.encKey = key;
    }

    @Override
    public void setEncryptionKeyBase64(String key) {
        this.encKey = Base64.getDecoder().decode(key);
    }

    @Override
    public void setDecryptionKey(byte[] key) {
        this.decKey = key;
    }

    @Override
    public void sedDecryptionKeyBase64(String key) {
        this.decKey = Base64.getDecoder().decode(key);
    }

    @Override
    public byte[] encrypt(byte[] input) {
        RSA rsa = new RSA();
        rsa.setPublicKeyBytes(this.encKey);
        return rsa.encrypt(input);
    }

    @Override
    public byte[] decrypt(byte[] input) {
        RSA rsa = new RSA();
        rsa.setPrivateKeyBytes(this.decKey);
        return rsa.decrypt(input);
    }
}

