/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.commands.auth;

import com.ongres.scram.client.ScramClient;
import com.ongres.scram.client.ScramSession;
import com.ongres.scram.common.ScramMechanism;
import com.ongres.scram.common.ScramMechanisms;
import com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.ongres.scram.common.exception.ScramParseException;
import com.ongres.scram.common.exception.ScramServerErrorException;
import com.ongres.scram.common.stringprep.StringPreparation;
import com.ongres.scram.common.stringprep.StringPreparations;
import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.GenericCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthCommand
extends MongoCommand<SaslAuthCommand> {
    private String user;
    private String password;
    private String mechanism;
    private Logger log = LoggerFactory.getLogger(SaslAuthCommand.class);

    public SaslAuthCommand(MongoConnection c) {
        super(c);
    }

    @Override
    public String getCommandName() {
        return "saslStart";
    }

    @Override
    public int executeAsync() throws MorphiumDriverException {
        throw new RuntimeException("cannot authenticate asynchronously!");
    }

    public String getUser() {
        return this.user;
    }

    public SaslAuthCommand setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SaslAuthCommand setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getMechanism() {
        return this.mechanism;
    }

    public SaslAuthCommand setMechanism(String mechanism) {
        this.mechanism = mechanism;
        return this;
    }

    public void execute() throws MorphiumDriverException, ScramParseException, NoSuchAlgorithmException, ScramInvalidServerSignatureException, ScramServerErrorException {
        ScramClient scramClient = null;
        if (this.mechanism == null) {
            this.mechanism = "SCRAM-SHA-256";
        }
        Object pwd = "";
        if (this.mechanism.equals("SCRAM-SHA-1")) {
            scramClient = ScramClient.channelBinding((ScramClient.ChannelBinding)ScramClient.ChannelBinding.NO).stringPreparation((StringPreparation)StringPreparations.NO_PREPARATION).selectClientMechanism((ScramMechanism)ScramMechanisms.SCRAM_SHA_1).setup();
            pwd = this.user + ":mongo:" + this.password;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(((String)pwd).getBytes(StandardCharsets.UTF_8));
            byte[] md5 = md.digest();
            StringBuilder hex = new StringBuilder();
            for (byte b : md5) {
                hex.append(Utils.getHex(b).toLowerCase());
            }
            pwd = hex.toString();
        } else if (this.mechanism.equals("SCRAM-SHA-256")) {
            scramClient = ScramClient.channelBinding((ScramClient.ChannelBinding)ScramClient.ChannelBinding.NO).stringPreparation((StringPreparation)StringPreparations.SASL_PREPARATION).selectClientMechanism((ScramMechanism)ScramMechanisms.SCRAM_SHA_256).setup();
            pwd = this.password;
        } else {
            throw new MorphiumDriverException("Unsupported SCRAM mechanism " + this.mechanism);
        }
        ScramSession scramSession = scramClient.scramSession(this.user);
        String msg = scramSession.clientFirstMessage();
        GenericCommand cmd = new GenericCommand(this.getConnection());
        cmd.setCommandName("saslStart");
        cmd.setCmdData(Doc.of("saslStart", (Object)1, "mechanism", this.mechanism, "payload", msg.getBytes(StandardCharsets.UTF_8), "options", Doc.of("skipEmptyExchange", (Object)true)));
        cmd.setDb(this.getDb());
        int id = this.getConnection().sendCommand(cmd);
        Map<String, Object> answer = this.getConnection().readSingleAnswer(id);
        if (!answer.containsKey("conversationId")) {
            throw new MorphiumDriverException("Error authentication: " + answer.get("errmsg"));
        }
        int conversationId = (Integer)answer.get("conversationId");
        String payload = new String((byte[])answer.get("payload"));
        ScramSession.ServerFirstProcessor serverFirstProcessor = scramSession.receiveServerFirstMessage(payload);
        ScramSession.ClientFinalProcessor clientFinalProcessor = serverFirstProcessor.clientFinalProcessor((String)pwd);
        String s1 = clientFinalProcessor.clientFinalMessage();
        cmd = new GenericCommand(this.getConnection());
        cmd.setCommandName("saslContinue");
        cmd.setCmdData(Doc.of("saslContinue", (Object)1, "conversationId", (Object)conversationId, "payload", s1.getBytes(StandardCharsets.UTF_8)));
        cmd.setDb(this.getDb());
        id = this.getConnection().sendCommand(cmd);
        answer = this.getConnection().readSingleAnswer(id);
        if (!answer.get("ok").equals(1.0)) {
            throw new MorphiumDriverException((String)answer.get("errmsg"));
        }
        payload = new String((byte[])answer.get("payload"));
        clientFinalProcessor.receiveServerFinalMessage(payload);
    }
}

