/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SingleBatchCursor
extends MorphiumCursor {
    private Iterator<Map<String, Object>> iterator;
    private int idx = 0;

    public SingleBatchCursor(List<Map<String, Object>> batch) {
        super.setBatch(batch);
        this.iterator = batch.iterator();
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public synchronized Map<String, Object> next() {
        ++this.idx;
        return this.iterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.getBatch().size() - this.getCursor();
    }

    @Override
    public List<Map<String, Object>> getAll() throws MorphiumDriverException {
        return this.getBatch();
    }

    @Override
    public synchronized void ahead(int skip) throws MorphiumDriverException {
        if (this.getBatch() == null) {
            throw new IllegalArgumentException("cannot jump that far");
        }
        if (skip + this.idx > this.getBatch().size()) {
            throw new IllegalArgumentException("cannot jump that far");
        }
        for (int i = 0; i < skip; ++i) {
            this.next();
        }
    }

    @Override
    public synchronized void back(int jump) throws MorphiumDriverException {
        throw new IllegalArgumentException("cannot jump back");
    }

    @Override
    public int getCursor() {
        return this.idx;
    }

    @Override
    public MongoConnection getConnection() {
        return null;
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return this;
    }
}

