/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterator<T>
implements MorphiumIterator<T>,
Iterator<T>,
Iterable<T> {
    private final Logger log = LoggerFactory.getLogger(QueryIterator.class);
    private Query<T> query;
    private MorphiumCursor cursor = null;
    private int windowSize = 0;

    public int getWindowSize() {
        return this.windowSize;
    }

    public QueryIterator<T> setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public Query<T> getQuery() {
        return this.query;
    }

    public void setQuery(Query<T> q) {
        this.query = q.clone();
    }

    public long getCount() {
        return this.query.countAll();
    }

    @Override
    public void ahead(int jump) {
        try {
            this.getMongoCursor().ahead(jump);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void back(int jump) {
        try {
            this.getMongoCursor().back(jump);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int available() {
        return this.getMongoCursor().available();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.getMongoCursor().hasNext();
    }

    @Override
    public Map<String, Object> nextMap() {
        return this.getMongoCursor().next();
    }

    @Override
    public T next() {
        if (this.query.getType() == null) {
            return (T)this.getMongoCursor().next();
        }
        return this.query.getMorphium().getMapper().deserialize(this.query.getType(), (Map<String, Object>)this.getMongoCursor().next());
    }

    @Override
    public List<T> getCurrentBuffer() {
        ArrayList<T> ret = new ArrayList<T>();
        for (Map<String, Object> o : this.getMongoCursor().getBatch()) {
            ret.add(this.query.getMorphium().getMapper().deserialize(this.query.getType(), o));
        }
        return ret;
    }

    @Override
    public void close() {
        this.getMongoCursor().close();
    }

    @Override
    public int getCursor() {
        return this.getMongoCursor().getCursor();
    }

    public MorphiumCursor getMongoCursor() {
        if (this.cursor == null) {
            try {
                FindCommand cmd = this.query.getFindCmd();
                if (this.windowSize != 0) {
                    cmd.setBatchSize(this.windowSize);
                }
                this.cursor = cmd.executeIterable(this.windowSize);
                cmd.getConnection().release();
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cursor;
    }
}

