/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.driver.wire;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.Utils;
import de.caluga.morphium.UtilsMap;
import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.AggregatorImpl;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriver;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.MorphiumTransactionContext;
import de.caluga.morphium.driver.ReadPreference;
import de.caluga.morphium.driver.WriteConcern;
import de.caluga.morphium.driver.bulk.BulkRequest;
import de.caluga.morphium.driver.bulk.BulkRequestContext;
import de.caluga.morphium.driver.bulk.DeleteBulkRequest;
import de.caluga.morphium.driver.bulk.InsertBulkRequest;
import de.caluga.morphium.driver.bulk.UpdateBulkRequest;
import de.caluga.morphium.driver.commands.AbortTransactionCommand;
import de.caluga.morphium.driver.commands.CollStatsCommand;
import de.caluga.morphium.driver.commands.CommitTransactionCommand;
import de.caluga.morphium.driver.commands.CurrentOpCommand;
import de.caluga.morphium.driver.commands.DbStatsCommand;
import de.caluga.morphium.driver.commands.DeleteMongoCommand;
import de.caluga.morphium.driver.commands.HelloCommand;
import de.caluga.morphium.driver.commands.InsertMongoCommand;
import de.caluga.morphium.driver.commands.KillCursorsCommand;
import de.caluga.morphium.driver.commands.MongoCommand;
import de.caluga.morphium.driver.commands.ReplicastStatusCommand;
import de.caluga.morphium.driver.commands.UpdateMongoCommand;
import de.caluga.morphium.driver.commands.WatchCommand;
import de.caluga.morphium.driver.wire.AtomicDecimal;
import de.caluga.morphium.driver.wire.ConnectionType;
import de.caluga.morphium.driver.wire.DriverBase;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wire.MongoConnection;
import de.caluga.morphium.driver.wire.NetworkCallHelper;
import de.caluga.morphium.driver.wire.SingleMongoConnection;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleMongoConnectDriver
extends DriverBase {
    private final Logger log = LoggerFactory.getLogger(SingleMongoConnectDriver.class);
    private SingleMongoConnection connection;
    private ConnectionType connectionType = ConnectionType.PRIMARY;
    private Map<MorphiumDriver.DriverStatsKey, AtomicDecimal> stats = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>();
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread ret = new Thread(r);
            ret.setName("MCon_" + SingleMongoConnectDriver.this.stats.get((Object)MorphiumDriver.DriverStatsKey.THREADS_CREATED).incrementAndGet());
            ret.setDaemon(true);
            return ret;
        }
    });
    private ScheduledFuture<?> heartbeat;
    public static final String driverName = "SingleMongoConnectDriver";

    public SingleMongoConnectDriver() {
        for (MorphiumDriver.DriverStatsKey e : MorphiumDriver.DriverStatsKey.values()) {
            this.stats.put(e, new AtomicDecimal(0));
        }
    }

    @Override
    public <T, R> Aggregator<T, R> createAggregator(Morphium morphium, Class<? extends T> type, Class<? extends R> resultType) {
        return new AggregatorImpl<T, R>(morphium, type, resultType);
    }

    @Override
    public Map<MorphiumDriver.DriverStatsKey, Double> getDriverStats() {
        HashMap<MorphiumDriver.DriverStatsKey, Double> ret = new HashMap<MorphiumDriver.DriverStatsKey, Double>();
        HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal> hashMap = new HashMap<MorphiumDriver.DriverStatsKey, AtomicDecimal>(this.stats);
        for (Map.Entry entry : hashMap.entrySet()) {
            ret.put((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), ((AtomicDecimal)entry.getValue()).get());
        }
        if (this.connection != null) {
            for (Map.Entry<Object, Object> entry : this.connection.getStats().entrySet()) {
                ret.putIfAbsent((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), 0.0);
                ret.put((MorphiumDriver.DriverStatsKey)((Object)entry.getKey()), (Double)ret.get(entry.getKey()) + (Double)entry.getValue());
            }
        }
        return ret;
    }

    public MongoConnection getConnection() {
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_BORROWED);
        return new ConnectionWrapper(this.connection);
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public SingleMongoConnectDriver setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    private String getHost(int hostSeedIndex) {
        return this.getHost(this.getHostSeed().get(hostSeedIndex));
    }

    private String getHost(String hostPort) {
        String[] h = hostPort.split(":");
        return h[0];
    }

    private int getPortFromHost(int hostSeedIdx) {
        return this.getPortFromHost(this.getHostSeed().get(hostSeedIdx));
    }

    private int getPortFromHost(String host) {
        String[] h = host.split(":");
        if (h.length == 1) {
            return 27017;
        }
        return Integer.parseInt(h[1]);
    }

    @Override
    public void connect() throws MorphiumDriverException {
        this.connect(null);
    }

    private double decStat(MorphiumDriver.DriverStatsKey k) {
        return this.stats.get((Object)k).decrementAndGet();
    }

    private double incStat(MorphiumDriver.DriverStatsKey k) {
        return this.stats.get((Object)k).incrementAndGet();
    }

    @Override
    public void connect(String replSet) throws MorphiumDriverException {
        int connectToIdx = 0;
        while (true) {
            try {
                HelloResult hello;
                while (true) {
                    this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_OPENED);
                    String host = this.getHostSeed().get(connectToIdx);
                    String[] h = host.split(":");
                    int port = 27017;
                    if (h.length > 1) {
                        port = Integer.parseInt(h[1]);
                    }
                    this.connection = new SingleMongoConnection();
                    if (this.getAuthDb() != null) {
                        this.connection.setCredentials(this.getAuthDb(), this.getUser(), this.getPassword());
                    }
                    if ((hello = this.connection.connect(this, h[0], port)).getHosts() != null) {
                        for (String s : hello.getHosts()) {
                            if (this.getHostSeed().contains(s)) continue;
                            this.getHostSeed().add(s);
                        }
                    }
                    if (hello.getPrimary() != null && !this.getHostSeed().contains(hello.getPrimary())) {
                        this.getHostSeed().add(hello.getPrimary());
                    }
                    if (this.connectionType.equals((Object)ConnectionType.PRIMARY) && !Boolean.TRUE.equals(hello.getWritablePrimary())) {
                        this.log.debug("want primary connection, got secondary, retrying");
                        this.connection.close();
                        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                        this.connection = null;
                        Thread.sleep(1000L);
                        if (hello.getPrimary() != null) {
                            connectToIdx = this.getHostSeed().indexOf(hello.getPrimary());
                            continue;
                        }
                        if (++connectToIdx < this.getHostSeed().size()) continue;
                        this.log.debug("End of hostseed, starting over");
                        connectToIdx = 0;
                        continue;
                    }
                    if (!this.connectionType.equals((Object)ConnectionType.SECONDARY) || Boolean.TRUE.equals(hello.getSecondary())) break;
                    this.log.debug("want secondary connection, got other - retrying");
                    this.connection.close();
                    this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                    this.connection = null;
                    Thread.sleep(1000L);
                    if (++connectToIdx < this.getHostSeed().size()) continue;
                    this.log.debug("End of hostseed, starting over");
                    connectToIdx = 0;
                }
                this.setMaxBsonObjectSize(hello.getMaxBsonObjectSize());
                this.setMaxMessageSize(hello.getMaxMessageSizeBytes());
                this.setMaxWriteBatchSize(hello.getMaxWriteBatchSize());
                this.startHeartbeat();
            }
            catch (Exception e) {
                this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                this.log.error("connection failed", (Throwable)e);
                if (++connectToIdx <= this.getHostSeed().size()) continue;
                connectToIdx = 0;
                continue;
            }
            break;
        }
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
    }

    protected synchronized void startHeartbeat() {
        if (this.heartbeat == null) {
            this.heartbeat = this.executor.scheduleWithFixedDelay(() -> {
                try {
                    HelloCommand cmd = new HelloCommand(this.connection).setHelloOk(true).setIncludeClient(false);
                    HelloResult hello = cmd.execute();
                    if (this.connectionType.equals((Object)ConnectionType.PRIMARY) && !Boolean.TRUE.equals(hello.getWritablePrimary())) {
                        this.log.warn("wanted primary connection, changed to secondary, retrying");
                        this.incStat(MorphiumDriver.DriverStatsKey.FAILOVERS);
                        this.connection.close();
                        this.decStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
                        this.connection = null;
                        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                        Thread.sleep(1000L);
                        this.connect(this.getReplicaSetName());
                    } else if (this.connectionType.equals((Object)ConnectionType.SECONDARY) && !Boolean.TRUE.equals(hello.getSecondary())) {
                        this.log.warn("state changed, wanted secondary, got something differnt now -reconnecting");
                        this.connection.close();
                        this.decStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
                        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
                        this.connection = null;
                        this.incStat(MorphiumDriver.DriverStatsKey.FAILOVERS);
                        Thread.sleep(1000L);
                        this.connect(this.getReplicaSetName());
                    }
                }
                catch (MorphiumDriverException e) {
                    this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                    this.log.error("Connection error", (Throwable)e);
                    this.log.warn("Trying reconnect");
                    try {
                        this.close();
                    }
                    catch (Exception hello) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException hello) {
                        // empty catch block
                    }
                    try {
                        this.connect();
                    }
                    catch (MorphiumDriverException ex) {
                        this.log.error("Could not reconnect", (Throwable)ex);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    this.incStat(MorphiumDriver.DriverStatsKey.ERRORS);
                    e.printStackTrace();
                }
            }, this.getHeartbeatFrequency(), this.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        } else {
            this.log.debug("Heartbeat already scheduled...");
        }
    }

    @Override
    public void watch(WatchCommand settings) throws MorphiumDriverException {
        this.connection.watch(settings);
    }

    @Override
    public void releaseConnection(MongoConnection con) {
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_RELEASED);
        if (con instanceof ConnectionWrapper) {
            ((ConnectionWrapper)con).setDelegate(null);
        }
    }

    @Override
    public MongoConnection getReadConnection(ReadPreference rp) {
        return this.getConnection();
    }

    @Override
    public MongoConnection getPrimaryConnection(WriteConcern wc) {
        return this.getConnection();
    }

    @Override
    public void close() {
        this.incStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_CLOSED);
        this.decStat(MorphiumDriver.DriverStatsKey.CONNECTIONS_IN_POOL);
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.heartbeat != null) {
            this.heartbeat.cancel(true);
        }
        this.heartbeat = null;
    }

    @Override
    public String getName() {
        return driverName;
    }

    @Override
    public void setConnectionUrl(String connectionUrl) {
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void commitTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot commit");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        CommitTransactionCommand cmd = new CommitTransactionCommand(this.connection).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
    }

    @Override
    public void abortTransaction() throws MorphiumDriverException {
        if (this.getTransactionContext() == null) {
            throw new IllegalArgumentException("No transaction in progress, cannot abort");
        }
        MorphiumTransactionContext ctx = this.getTransactionContext();
        AbortTransactionCommand cmd = new AbortTransactionCommand(this.connection).setTxnNumber(ctx.getTxnNumber()).setAutocommit(false).setLsid(ctx.getLsid());
        cmd.execute();
        this.clearTransactionContext();
    }

    @Override
    public Map<String, Object> getCollStats(String db, String coll) throws MorphiumDriverException {
        CollStatsCommand cmd = new CollStatsCommand(this.connection);
        return cmd.execute();
    }

    @Override
    public Map<String, Object> getReplsetStatus() throws MorphiumDriverException {
        ReplicastStatusCommand cmd = new ReplicastStatusCommand(this.getPrimaryConnection(null));
        Map<String, Object> result = cmd.execute();
        List mem = (List)result.get("members");
        if (mem == null) {
            return null;
        }
        mem.stream().filter(d -> d.get("optime") instanceof Map).forEach(d -> d.put("optime", ((Map)d.get("optime")).get("ts")));
        return result;
    }

    @Override
    public Map<String, Object> getDBStats(String db) throws MorphiumDriverException {
        return ((DbStatsCommand)new DbStatsCommand(this.getPrimaryConnection(null)).setDb(db)).execute();
    }

    public List<Map<String, Object>> currentOp(int threshold) throws MorphiumDriverException {
        CurrentOpCommand cmd = ((CurrentOpCommand)new CurrentOpCommand(this.connection).setColl("admin")).setSecsRunning(threshold);
        return cmd.execute();
    }

    @Override
    public BulkRequestContext createBulkContext(Morphium m, final String db, final String collection, boolean ordered, WriteConcern wc) {
        return new BulkRequestContext(m){
            private final List<BulkRequest> requests;
            {
                super(m);
                this.requests = new ArrayList<BulkRequest>();
            }

            public Doc execute() {
                try {
                    for (BulkRequest r : this.requests) {
                        if (r instanceof InsertBulkRequest) {
                            InsertMongoCommand settings = new InsertMongoCommand(SingleMongoConnectDriver.this.connection);
                            ((InsertMongoCommand)((InsertMongoCommand)settings.setDb(db)).setColl(collection)).setComment("Bulk insert").setDocuments(((InsertBulkRequest)r).getToInsert());
                            settings.execute();
                            continue;
                        }
                        if (r instanceof UpdateBulkRequest) {
                            UpdateBulkRequest up = (UpdateBulkRequest)r;
                            UpdateMongoCommand upCmd = new UpdateMongoCommand(SingleMongoConnectDriver.this.connection);
                            ((UpdateMongoCommand)((UpdateMongoCommand)upCmd.setColl(collection)).setDb(db)).setUpdates(Arrays.asList(Doc.of("q", up.getQuery(), "u", up.getCmd(), "upsert", (Object)up.isUpsert(), "multi", (Object)up.isMultiple())));
                            upCmd.execute();
                            continue;
                        }
                        if (r instanceof DeleteBulkRequest) {
                            DeleteBulkRequest dbr = (DeleteBulkRequest)r;
                            DeleteMongoCommand del = new DeleteMongoCommand(SingleMongoConnectDriver.this.connection);
                            ((DeleteMongoCommand)((DeleteMongoCommand)del.setColl(collection)).setDb(db)).setDeletes(Arrays.asList(Doc.of("q", dbr.getQuery(), "limit", (Object)(dbr.isMultiple() ? 0 : 1))));
                            del.execute();
                            continue;
                        }
                        throw new RuntimeException("Unknown operation " + r.getClass().getName());
                    }
                }
                catch (MorphiumDriverException e) {
                    SingleMongoConnectDriver.this.log.error("Got exception: ", (Throwable)e);
                }
                return new Doc();
            }

            @Override
            public UpdateBulkRequest addUpdateBulkRequest() {
                UpdateBulkRequest up = new UpdateBulkRequest();
                this.requests.add(up);
                return up;
            }

            @Override
            public InsertBulkRequest addInsertBulkRequest(List<Map<String, Object>> toInsert) {
                InsertBulkRequest in = new InsertBulkRequest(toInsert);
                this.requests.add(in);
                return in;
            }

            @Override
            public DeleteBulkRequest addDeleteBulkRequest() {
                DeleteBulkRequest del = new DeleteBulkRequest();
                this.requests.add(del);
                return del;
            }
        };
    }

    public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
        if (crs == null) {
            return;
        }
        this.killCursors(crs.getDb(), crs.getCollection(), crs.getCursorId());
    }

    protected void killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
        ArrayList<Long> cursorIds = new ArrayList<Long>();
        for (long l : ids) {
            if (l == 0L) continue;
            cursorIds.add(l);
        }
        if (cursorIds.isEmpty()) {
            return;
        }
        KillCursorsCommand k = (KillCursorsCommand)((KillCursorsCommand)new KillCursorsCommand(this.connection).setCursors(cursorIds).setDb(db)).setColl(coll);
        Map<String, Object> ret = k.execute();
        this.log.debug("killed cursor");
    }

    private List<Map<String, Object>> readBatches(int waitingfor, int batchSize) throws MorphiumDriverException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        String db = null;
        String coll = null;
        while (true) {
            OpMsg reply;
            if ((reply = this.connection.getReplyFor(waitingfor, this.getMaxWaitTime())).getResponseTo() != waitingfor) {
                this.log.error("Wrong answer - waiting for " + waitingfor + " but got " + reply.getResponseTo());
                this.log.error("Document: " + Utils.toJsonString(reply.getFirstDoc()));
                continue;
            }
            Map cursor = (Map)reply.getFirstDoc().get("cursor");
            if (cursor == null) {
                if (reply.getFirstDoc().get("result") != null) {
                    return (List)reply.getFirstDoc().get("result");
                }
                if (reply.getFirstDoc().containsKey("results")) {
                    return (List)reply.getFirstDoc().get("results");
                }
                throw new MorphiumDriverException("Mongo Error: " + reply.getFirstDoc().get("codeName") + " - " + reply.getFirstDoc().get("errmsg"));
            }
            if (db == null) {
                String[] namespace = cursor.get("ns").toString().split("\\.");
                db = namespace[0];
                if (namespace.length > 1) {
                    coll = namespace[1];
                }
            }
            if (cursor.get("firstBatch") != null) {
                ret.addAll((List)cursor.get("firstBatch"));
            } else if (cursor.get("nextBatch") != null) {
                ret.addAll((List)cursor.get("nextBatch"));
            }
            if ((Long)cursor.get("id") == 0L) break;
            OpMsg q = new OpMsg();
            q.setFirstDoc(Doc.of("getMore", cursor.get("id")).add("$db", db).add("batchSize", batchSize));
            if (coll != null) {
                q.getFirstDoc().put("collection", coll);
            }
            q.setMessageId(this.getNextId());
            waitingfor = q.getMessageId();
            this.connection.sendQuery(q);
        }
        return ret;
    }

    @Override
    public boolean exists(String db) throws MorphiumDriverException {
        try {
            this.getDBStats(db);
            return true;
        }
        catch (MorphiumDriverException morphiumDriverException) {
            return false;
        }
    }

    public Map<String, Object> getDbStats(String db) throws MorphiumDriverException {
        return this.getDbStats(db, false);
    }

    public Map<String, Object> getDbStats(String db, boolean withStorage) throws MorphiumDriverException {
        return (Map)new NetworkCallHelper().doCall(() -> {
            OpMsg msg = new OpMsg();
            msg.setMessageId(this.getNextId());
            Doc v = Doc.of("dbStats", (Object)1, "scale", (Object)1024);
            v.put("$db", db);
            if (withStorage) {
                v.put("freeStorage", 1);
            }
            msg.setFirstDoc(v);
            this.connection.sendQuery(msg);
            OpMsg reply = this.connection.getReplyFor(msg.getMessageId(), this.getMaxWaitTime());
            return reply.getFirstDoc();
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    private List<Map<String, Object>> getCollectionInfo(String db, String collection) throws MorphiumDriverException {
        return (List)new NetworkCallHelper().doCall(() -> {
            Doc cmd = new Doc();
            cmd.put("listCollections", 1);
            OpMsg q = new OpMsg();
            q.setMessageId(this.getNextId());
            if (collection != null) {
                cmd.put("filter", Doc.of("name", collection));
            }
            cmd.put("$db", db);
            q.setFirstDoc(cmd);
            q.setFlags(0);
            q.setResponseTo(0);
            this.connection.sendQuery(q);
            List<Map<String, Object>> ret = this.readBatches(q.getMessageId(), this.getMaxWriteBatchSize());
            return ret;
        }, this.getRetriesOnNetworkError(), this.getSleepBetweenErrorRetries());
    }

    @Override
    public boolean isCapped(String db, String coll) throws MorphiumDriverException {
        List<Map<String, Object>> lst = this.getCollectionInfo(db, coll);
        try {
            if (!lst.isEmpty() && lst.get(0).get("name").equals(coll)) {
                Object capped = ((Map)lst.get(0).get("options")).get("capped");
                return capped != null && capped.equals(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error", (Throwable)e);
        }
        return false;
    }

    @Override
    public Map<String, Integer> getNumConnectionsByHost() {
        return UtilsMap.of(this.connection.getConnectedTo(), 1);
    }

    private class ConnectionWrapper
    implements MongoConnection {
        private MongoConnection delegate;

        public MongoConnection getDelegate() {
            if (this.delegate == null) {
                throw new RuntimeException("Connection released!");
            }
            return this.delegate;
        }

        public ConnectionWrapper(MongoConnection con) {
            this.delegate = con;
        }

        public void setDelegate(MongoConnection con) {
            this.delegate = con;
        }

        @Override
        public MorphiumDriver getDriver() {
            return SingleMongoConnectDriver.this;
        }

        @Override
        public int getSourcePort() {
            return 0;
        }

        @Override
        public void setCredentials(String authDb, String userName, String password) {
            this.delegate.setCredentials(authDb, userName, password);
        }

        @Override
        public HelloResult connect(MorphiumDriver drv, String host, int port) throws IOException, MorphiumDriverException {
            return this.getDelegate().connect(drv, host, port);
        }

        @Override
        public void close() {
            this.release();
            this.getDelegate().close();
        }

        @Override
        public boolean isConnected() {
            return this.getDelegate().isConnected();
        }

        @Override
        public String getConnectedTo() {
            return this.getDelegate().getConnectedTo();
        }

        @Override
        public String getConnectedToHost() {
            return this.getDelegate().getConnectedToHost();
        }

        @Override
        public int getConnectedToPort() {
            return this.getDelegate().getConnectedToPort();
        }

        @Override
        public void closeIteration(MorphiumCursor crs) throws MorphiumDriverException {
            this.getDelegate().closeIteration(crs);
        }

        @Override
        public Map<String, Object> killCursors(String db, String coll, long ... ids) throws MorphiumDriverException {
            return this.getDelegate().killCursors(db, coll, ids);
        }

        @Override
        public boolean replyAvailableFor(int msgId) {
            return this.getDelegate().replyAvailableFor(msgId);
        }

        @Override
        public OpMsg getReplyFor(int msgid, long timeout) throws MorphiumDriverException {
            return this.getDelegate().getReplyFor(msgid, timeout);
        }

        @Override
        public Map<String, Object> readSingleAnswer(int id) throws MorphiumDriverException {
            return this.getDelegate().readSingleAnswer(id);
        }

        @Override
        public void watch(WatchCommand settings) throws MorphiumDriverException {
            this.getDelegate().watch(settings);
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(int queryId) throws MorphiumDriverException {
            return this.getDelegate().readAnswerFor(queryId);
        }

        @Override
        public MorphiumCursor getAnswerFor(int queryId, int batchsize) throws MorphiumDriverException {
            return this.getDelegate().getAnswerFor(queryId, batchsize);
        }

        @Override
        public List<Map<String, Object>> readAnswerFor(MorphiumCursor crs) throws MorphiumDriverException {
            return this.getDelegate().readAnswerFor(crs);
        }

        @Override
        public int sendCommand(MongoCommand cmd) throws MorphiumDriverException {
            return this.getDelegate().sendCommand(cmd);
        }

        @Override
        public void release() {
            this.getDriver().releaseConnection(this);
        }
    }
}

