/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.aggregation;

import de.caluga.morphium.aggregation.Aggregator;
import de.caluga.morphium.aggregation.MorphiumAggregationIterator;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.MorphiumCursor;
import de.caluga.morphium.driver.MorphiumDriverException;
import de.caluga.morphium.driver.commands.AggregateMongoCommand;
import de.caluga.morphium.driver.wire.MongoConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationIterator<T, R>
implements MorphiumAggregationIterator<T, R> {
    private final Logger log = LoggerFactory.getLogger(AggregationIterator.class);
    private boolean multithreadded;
    private Aggregator<T, R> aggregator;
    private MorphiumCursor cursor = null;

    @Override
    public void ahead(int jump) {
        try {
            this.getMongoCursor().ahead(jump);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void back(int jump) {
        try {
            this.getMongoCursor().back(jump);
        }
        catch (MorphiumDriverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int available() {
        return this.getMongoCursor().available();
    }

    @Override
    public Iterator<R> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.getMongoCursor().hasNext();
    }

    @Override
    public Map<String, Object> nextMap() {
        return this.getMongoCursor().next();
    }

    @Override
    public R next() {
        if (Map.class.isAssignableFrom(this.aggregator.getResultType())) {
            return (R)this.getMongoCursor().next();
        }
        return this.aggregator.getMorphium().getMapper().deserialize(this.aggregator.getResultType(), (Map<String, Object>)this.getMongoCursor().next());
    }

    @Override
    public List<R> getCurrentBuffer() {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> o : this.getMongoCursor().getBatch()) {
            if (Map.class.isAssignableFrom(this.aggregator.getResultType())) {
                ret.add(o);
                continue;
            }
            ret.add((Map<String, Object>)this.aggregator.getMorphium().getMapper().deserialize(this.aggregator.getResultType(), o));
        }
        return ret;
    }

    @Override
    public void close() {
        this.getMongoCursor().close();
    }

    @Override
    public int getCursor() {
        return this.getMongoCursor().getCursor();
    }

    private AggregateMongoCommand getAggregateCmd() {
        MongoConnection readConnection = this.aggregator.getMorphium().getDriver().getReadConnection(null);
        AggregateMongoCommand settings = new AggregateMongoCommand(readConnection);
        ((AggregateMongoCommand)((AggregateMongoCommand)((AggregateMongoCommand)settings.setDb(this.aggregator.getMorphium().getConfig().getDatabase())).setColl(this.aggregator.getCollectionName())).setPipeline(this.aggregator.getPipeline()).setExplain(this.aggregator.isExplain()).setReadPreference(this.aggregator.getMorphium().getReadPreferenceForClass(this.aggregator.getSearchType()))).setAllowDiskUse(this.aggregator.isUseDisk());
        if (this.aggregator.getCollation() != null) {
            settings.setCollation(Doc.of(this.aggregator.getCollation().toQueryObject()));
        }
        this.aggregator.getMorphium().getDriver().releaseConnection(readConnection);
        return settings;
    }

    @Override
    public Aggregator<T, R> getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setAggregator(Aggregator<T, R> aggregator) {
        this.aggregator = aggregator;
    }

    private MorphiumCursor getMongoCursor() {
        if (this.cursor == null) {
            try {
                this.cursor = this.aggregator.getAggregateCmd().executeIterable(this.aggregator.getMorphium().getConfig().getCursorBatchSize());
            }
            catch (MorphiumDriverException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cursor;
    }
}

