/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.server;

import de.caluga.morphium.Utils;
import de.caluga.morphium.driver.Doc;
import de.caluga.morphium.driver.wire.HelloResult;
import de.caluga.morphium.driver.wireprotocol.OpMsg;
import de.caluga.morphium.driver.wireprotocol.OpQuery;
import de.caluga.morphium.driver.wireprotocol.OpReply;
import de.caluga.morphium.driver.wireprotocol.WireProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphiumServer {
    Logger log = LoggerFactory.getLogger(MorphiumServer.class);

    public void start(int port) throws IOException, InterruptedException {
        this.log.info("Opening port " + port);
        ServerSocket ssoc = new ServerSocket(port);
        while (true) {
            Socket s = ssoc.accept();
            this.log.info("Incoming connection");
            InputStream in = s.getInputStream();
            OutputStream out = s.getOutputStream();
            AtomicInteger msgId = new AtomicInteger(1000);
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    while (true) {
                        if (in.available() == 0) {
                            if (!s.isConnected() || s.isClosed()) break;
                            Thread.yield();
                            continue;
                        }
                        WireProtocolMessage msg = WireProtocolMessage.parseFromStream(in);
                        this.log.info("got incoming msg: " + msg.getClass().getSimpleName());
                        Map<String, Object> doc = null;
                        int id = 0;
                        if (msg instanceof OpQuery) {
                            OpQuery q = (OpQuery)msg;
                            id = q.getMessageId();
                            doc = q.getDoc();
                            OpReply r = new OpReply();
                            Doc d = Doc.of("$err", "OP_QUERY is no longer supported. The client driver may require an upgrade.", "code", (Object)5739101, "ok", (Object)0.0);
                            r.setFlags(2);
                            r.setMessageId(msgId.incrementAndGet());
                            r.setResponseTo(id);
                            r.setNumReturned(1);
                            r.setDocuments(Arrays.asList(d));
                            out.write(r.bytes());
                            out.flush();
                            this.log.info("Sent out error because OPQuery not allowed anymore!");
                            Thread.sleep(1000L);
                            continue;
                        }
                        if (msg instanceof OpMsg) {
                            OpMsg m = (OpMsg)msg;
                            doc = ((OpMsg)msg).getFirstDoc();
                            id = m.getMessageId();
                        }
                        this.log.info("Incoming: " + Utils.toJsonString(doc));
                        HelloResult res = new HelloResult();
                        res.setWritablePrimary(true);
                        res.setConnectionId(1);
                        res.setOk(1.0);
                        res.setMaxWireVersion(17);
                        res.setMinWireVersion(0);
                        res.setHelloOk(true);
                        res.setMaxBsonObjectSize(0x1000000);
                        res.setMaxMessageSizeBytes(480000000);
                        res.setLocalTime(new Date());
                        res.setReadOnly(false);
                        Map<String, Object> firstDoc = res.toMsg();
                        firstDoc.put("logicalSessionTimeoutMinutes", 30);
                        OpReply reply = new OpReply();
                        reply.setDocuments(Arrays.asList(firstDoc));
                        reply.setNumReturned(1);
                        reply.setMessageId(msgId.incrementAndGet());
                        reply.setResponseTo(id);
                        out.write(reply.bytes());
                        out.flush();
                        Thread.sleep(100L);
                        if (in.available() != 0) {
                            msg = OpMsg.parseFromStream(in);
                        } else {
                            this.log.info("Nothing incoming");
                        }
                        Thread.sleep(15000L);
                    }
                    this.log.info("Thread finished!");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).start();
        }
    }
}

