/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import de.caluga.morphium.Morphium;
import de.caluga.morphium.driver.commands.FindCommand;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import de.caluga.morphium.replicaset.ReplicasetStatusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSMonitor {
    private static final Logger logger = LoggerFactory.getLogger(RSMonitor.class);
    private final ScheduledThreadPoolExecutor executorService;
    private final Morphium morphium;
    private ReplicaSetStatus currentStatus;
    private int nullcounter = 0;
    private final List<ReplicasetStatusListener> listeners = new Vector<ReplicasetStatusListener>();

    public RSMonitor(Morphium morphium) {
        this.morphium = morphium;
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.executorService.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread ret = new Thread(r, "rsMonitor " + this.num);
                this.num.set(this.num.get() + 1);
                ret.setDaemon(true);
                return ret;
            }
        });
    }

    public void start() {
        this.executorService.scheduleWithFixedDelay(this::execute, 1000L, this.morphium.getConfig().getReplicaSetMonitoringTimeout(), TimeUnit.MILLISECONDS);
        this.execute();
    }

    public void addListener(ReplicasetStatusListener lst) {
        this.listeners.add(lst);
    }

    public void removeListener(ReplicasetStatusListener lst) {
        this.listeners.remove(lst);
    }

    public void terminate() {
        this.executorService.shutdownNow();
        while (!this.executorService.isShutdown()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void execute() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting RS-Status...");
            }
            this.currentStatus = this.getReplicaSetStatus(true);
            if (this.currentStatus == null) {
                ++this.nullcounter;
                if (logger.isDebugEnabled()) {
                    logger.debug("RS status is null! Counter " + this.nullcounter);
                }
                for (ReplicasetStatusListener l : this.listeners) {
                    l.onGetStatusFailure(this.morphium, this.nullcounter);
                }
            } else {
                this.nullcounter = 0;
            }
            if (this.nullcounter > 10) {
                logger.error("Getting ReplicasetStatus failed 10 times... will gracefully exit thread");
                this.executorService.shutdownNow();
                for (ReplicasetStatusListener l : this.listeners) {
                    l.onMonitorAbort(this.morphium, this.nullcounter);
                }
            }
            if (this.currentStatus != null) {
                for (ReplicasetStatusListener l : this.listeners) {
                    l.gotNewStatus(this.morphium, this.currentStatus);
                }
                for (ReplicaSetNode n : this.currentStatus.getMembers()) {
                    if (this.morphium.getConfig().getHostSeed().contains(n.getName())) {
                        logger.debug("Found host in config " + n.getName());
                        continue;
                    }
                    this.morphium.getConfig().getHostSeed().add(n.getName());
                }
                ArrayList<String> hostsNotFound = new ArrayList<String>();
                for (String host : this.morphium.getConfig().getHostSeed()) {
                    boolean found = false;
                    for (ReplicaSetNode n : this.currentStatus.getMembers()) {
                        if (!n.getName().equals(host)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    hostsNotFound.add(host);
                }
                if (!hostsNotFound.isEmpty()) {
                    this.morphium.getConfig().getHostSeed().removeAll(hostsNotFound);
                    for (ReplicasetStatusListener l : this.listeners) {
                        l.onHostDown(this.morphium, hostsNotFound, this.morphium.getConfig().getHostSeed());
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.morphium.isReplicaSet()) {
            try {
                Map<String, Object> res = this.morphium.getDriver().getReplsetStatus();
                ReplicaSetStatus status = this.morphium.getMapper().deserialize(ReplicaSetStatus.class, res);
                if (full) {
                    FindCommand settings = ((FindCommand)((FindCommand)new FindCommand(this.morphium.getDriver().getPrimaryConnection(null)).setDb("local")).setColl("system.replset")).setBatchSize(10).setLimit(10);
                    List<Map<String, Object>> stats = settings.execute();
                    if (stats == null || stats.isEmpty()) {
                        logger.debug("could not get replicaset status");
                    } else {
                        Map<String, Object> stat = stats.get(0);
                        ReplicaSetConf cfg = this.morphium.getMapper().deserialize(ReplicaSetConf.class, stat);
                        status.setConfig(cfg);
                    }
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                if (lst != null) {
                    Iterator<ReplicaSetNode> iterator = lst.iterator();
                    while (iterator.hasNext()) {
                        ReplicaSetNode l;
                        ReplicaSetNode n = l = iterator.next();
                        members.add(n);
                    }
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                if (e.getMessage().contains(" 'not running with --replSet'")) {
                    logger.warn("Mongo not configured for replicaset! Disabling monitoring for now");
                    this.morphium.getConfig().setReplicasetMonitoring(false);
                    this.terminate();
                }
                if (e.getMessage().contains("user is not allowed to do action")) {
                    logger.warn("permission denied for replicaset status! Disabling monitoring for now");
                    this.morphium.getConfig().setReplicasetMonitoring(false);
                    this.terminate();
                }
                if (e.getMessage().contains("replSetGetStatus is not supported")) {
                    logger.warn("Replicaset check not possible - not supported!");
                    this.morphium.getConfig().setReplicasetMonitoring(false);
                    this.terminate();
                }
                logger.warn("Could not get Replicaset status: " + e.getMessage(), (Throwable)e);
                logger.warn("Tried connection to: ");
                for (String adr : this.morphium.getConfig().getHostSeed()) {
                    logger.warn("   " + adr);
                }
            }
        }
        return null;
    }

    public ReplicaSetStatus getCurrentStatus() {
        return this.currentStatus;
    }
}

